/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.discovery.process;

import com.google.common.collect.ImmutableList;
import com.huawei.ism.cbb.base.poll.IPoller;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.application.adapter.sdk.service.IApplicationManager;
import com.huawei.ism.drm.application.manager.proxy.ApplicationAdapterProxy;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.service.group.refinement.QueryProtectGroupRefineService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class OracleAllFlashAdgCheckPoller
implements IPoller {
    private static final Log LOGGER = LogFactory.getInstance(OracleAllFlashAdgCheckPoller.class);
    private static final Long ADMIN_USER_ID = 1L;
    private static final List<Integer> NORMAL_STATUS_LIST = ImmutableList.of((Object)DrmEnumDefine.PROTECT_GROUP_STATUS.NORMAL.getStatus(), (Object)DrmEnumDefine.PROTECT_GROUP_STATUS.INVALID.getStatus());
    private final String uuid;
    private final String pollerType;

    public OracleAllFlashAdgCheckPoller(String uuid, String pollerType) {
        this.uuid = uuid;
        this.pollerType = pollerType;
    }

    public String getPollerID() {
        return this.uuid;
    }

    public String getPollerType() {
        return this.pollerType;
    }

    public void run() {
        List protectGroups = QueryProtectGroupRefineService.getInstance().queryProtectGroups(ADMIN_USER_ID);
        if (VerifyUtil.isEmpty((Collection)protectGroups)) {
            return;
        }
        protectGroups.removeIf(protectGroup -> protectGroup.getTemplate().getType() != 47);
        if (VerifyUtil.isEmpty((Collection)protectGroups)) {
            LOGGER.debug((Object)"ProtectGroups are empty.");
            return;
        }
        protectGroups.forEach(protectGroup -> {
            if (!NORMAL_STATUS_LIST.contains(protectGroup.getStatus())) {
                return;
            }
            String[] params = new String[]{(String)protectGroup.getProps().get("DB_NAMES"), protectGroup.getName()};
            LOGGER.debug((Object)"Begin check adg status at %s", new Object[]{this.getClass().getSimpleName()});
            try {
                this.checkAdgStatus((ProtectGroup)protectGroup);
                AlarmReporter.restoreAlarm((String)"0x3230099", (String[])params);
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)"Fail to check adg status at: %s", new Object[]{protectGroup.getName()});
                AlarmReporter.sendAlarm((String)"0x3230099", (String)protectGroup.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])params);
            }
            LOGGER.debug((Object)"End check adg status at %s", new Object[]{this.getClass().getSimpleName()});
        });
    }

    private void checkAdgStatus(ProtectGroup protectGroup) {
        Set polist = protectGroup.getPolist();
        polist.forEach(po -> {
            po.getProps().put("QUERY_TYPE", "0");
            IApplicationManager applicationManager = ApplicationAdapterProxy.getInstance().getAppManager(po.getPoType());
            applicationManager.checkEnvStatus(po);
        });
    }
}

