/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.handler.impl;

import com.huawei.ism.cbb.base.sdk.constant.DmEnumDefine;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnectionManager;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.storage.handler.IStorageHyperCDPConsistencyGroupHandler;
import com.huawei.ism.drm.storage.hvs.handler.impl.StorageLunConsistencyGroupHandlerImpl;
import com.huawei.ism.drm.storage.sdk.model.HyperCDPConsistencyGroup;
import com.huawei.ism.drm.storage.sdk.model.SecureSnapParam;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StorageHyperCDPConsistencyGroupHandlerImpl
implements IStorageHyperCDPConsistencyGroupHandler {
    private static final Log logger = LogFactory.getInstance(StorageLunConsistencyGroupHandlerImpl.class);
    private RestConnectionManager connMgr = RestConnectionManager.getInstance();

    public HyperCDPConsistencyGroup create(String devSn, String lunConsistentGroupId) {
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{devSn, lunConsistentGroupId});
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("PARENTID", lunConsistentGroupId);
            map.put("NAME", "HyperCDP_" + lunConsistentGroupId + "_" + System.currentTimeMillis());
            return this.createAndTransitionHyperCDPConsis(devSn, map);
        }
        catch (LegoCheckedException le) {
            logger.error((Object)"create HyperCDPConsistencyGroup error, lunConsistentGroupId: %s", new Object[]{lunConsistentGroupId, le});
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)"create HyperCDPConsistencyGroup failed, lunConsistentGroupId: %s", new Object[]{lunConsistentGroupId, e});
            throw new LegoCheckedException("create HyperCDPConsistencyGroup failed.", (Throwable)e);
        }
    }

    public HyperCDPConsistencyGroup createSecureSnapshotWithCg(String devSn, String lunConsistentGroupId, SecureSnapParam secureSnapParam) {
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{devSn, lunConsistentGroupId});
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("PARENTID", lunConsistentGroupId);
        map.put("NAME", "HyperCDP_" + lunConsistentGroupId + "_" + System.currentTimeMillis());
        map.put("SECURESNAPENABLED", "1");
        map.put("PROTECTPERIOD", String.valueOf(secureSnapParam.getProtectPeriod()));
        map.put("PROTECTPERIODUNIT", String.valueOf(secureSnapParam.getUnitType().getType()));
        map.put("AUTODELETEENABLED", secureSnapParam.isAutoDeleteEnabled() ? "1" : "0");
        try {
            return this.createAndTransitionHyperCDPConsis(devSn, map);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"create HyperCDPConsistencyGroup secure snapshot error, lunConsistentGroupId: %s", new Object[]{lunConsistentGroupId, e});
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"create HyperCDPConsistencyGroup secure snapshot failed, lunConsistentGroupId: %s", new Object[]{lunConsistentGroupId, e});
            throw new LegoCheckedException("create secure snapshot HyperCDPConsistencyGroup failed.", (Throwable)e);
        }
    }

    private HyperCDPConsistencyGroup createAndTransitionHyperCDPConsis(String devSn, Map<String, String> map) {
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/cdp_consistency_group";
        logger.debug((Object)"start createHyperCDPConsistencyGroup, url: %s, devsn: %s, params: %s", new Object[]{url, devSn, map});
        Map result = connection.post(url, map);
        logger.debug((Object)"end createHyperCDPConsistencyGroup, url: %s, devsn: %s, result: %s", new Object[]{url, devSn, result});
        return this.transitionHyperCDPConsistencyGroup(result);
    }

    public void restore(String devSn, String id, String restoreSpeed) {
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{devSn, id});
        RestConnection connection = this.getConnection(devSn);
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)restoreSpeed)) {
            restoreSpeed = String.valueOf(DmEnumDefine.SPEED_LEVEL_E.SPEED_LEVEL_MIDDLE.getValue());
        }
        String url = "/rest/${deviceID}/cdp_consistency_group/rollback";
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("TYPE", String.valueOf(XveMOType.HYPERCDP_CONSISTENCY_GROUP.getValue()));
            map.put("ID", id);
            map.put("RESTORESPEED", restoreSpeed);
            logger.debug((Object)"start restoreHyperCDPConsistentGroup, url: %s, devsn: %s, params: %s", new Object[]{url, devSn, map});
            connection.put(url, map);
            logger.debug((Object)"end restoreHyperCDPConsistentGroup, url: %s, devsn: %s", new Object[]{url, devSn});
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("restore HyperCDP error, url: " + url), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("restore HyperCDP failed, url: " + url), (Throwable)e);
            throw new LegoCheckedException("restore HyperCDP failed.", (Throwable)e);
        }
    }

    public void delete(String devSn, String id) {
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{devSn, id});
        String url = "/rest/${deviceID}/cdp_consistency_group/" + id;
        RestConnection connection = this.getConnection(devSn);
        try {
            logger.debug((Object)"start deleteHyperCDPConsistentGroup, url: %s, devsn: %s", new Object[]{url, devSn});
            connection.delete(url, null);
            logger.debug((Object)"end deleteHyperCDPConsistentGroup, url: %s, devsn: %s", new Object[]{url, devSn});
        }
        catch (LegoCheckedException le) {
            logger.error((Object)"delete HyperCDP error.", (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)"delete HyperCDP failed.", (Throwable)e);
            throw new LegoCheckedException("delete HyperCDP failed.", (Throwable)e);
        }
    }

    private HyperCDPConsistencyGroup transitionHyperCDPConsistencyGroup(Map<String, String> result) {
        if (VerifyUtil.isEmpty(result)) {
            logger.error((Object)"parameter error.");
            throw new LegoCheckedException(1073947393L);
        }
        HyperCDPConsistencyGroup cdpCg = new HyperCDPConsistencyGroup();
        cdpCg.setId(result.get("ID"));
        cdpCg.setScheduledConsistencyGroup(Boolean.valueOf(result.get("ISSCHEDULEDCDPCG").equals("1")));
        cdpCg.setSrcLunConsistentGroupId(result.get("PARENTID"));
        cdpCg.setSrcLunConsistentGroupName(result.get("PARENTNAME"));
        cdpCg.setRunningState(result.get("RUNNINGSTATUS"));
        cdpCg.setTimeStamp(result.get("TIMESTAMP"));
        return cdpCg;
    }

    public HyperCDPConsistencyGroup query(String devSn, String id) {
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{devSn, id});
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/cdp_consistency_group/" + id;
        try {
            logger.debug((Object)"start queryHyperCDPConsistencyGroup, url: %s, devsn: %s", new Object[]{url, devSn});
            Map map = connection.get(url, null);
            logger.debug((Object)"end queryHyperCDPConsistencyGroup, url: %s, devsn: %s, result: %s", new Object[]{url, devSn, map});
            return this.transitionHyperCDPConsistencyGroup(map);
        }
        catch (LegoCheckedException le) {
            if (Long.valueOf(1073748848L).equals(le.getErrorCode())) {
                logger.error((Object)("HyperCDPConsistencyGroup not exist, url: " + url + "devSN:" + devSn + ",id:" + id));
                return null;
            }
            logger.error((Object)("query HyperCDP error, url: " + url + "devsn: " + devSn), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("query HyperCDP failed, url: " + url + "devsn: " + devSn), (Throwable)e);
            throw new LegoCheckedException("query HyperCDP failed.", (Throwable)e);
        }
    }

    private String getCondition(Map<String, String> filter) {
        StringBuilder condition = new StringBuilder();
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(filter)) {
            condition.append("?filter=");
            int i = 0;
            for (Map.Entry<String, String> entry : filter.entrySet()) {
                if (i > 0) {
                    condition.append("%20and%20");
                }
                if (entry.getKey().equals("PARENTID")) {
                    condition.append(entry.getKey());
                    condition.append("::");
                    condition.append(entry.getValue());
                } else if (entry.getKey().equals("TIMESTAMP")) {
                    condition.append(entry.getKey());
                    condition.append(":");
                    condition.append(entry.getValue());
                }
                ++i;
            }
        }
        return condition.toString();
    }

    private String getCondition(String range, Map<String, String> filter) {
        String conditionFilter = this.getCondition(filter);
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)range)) {
            return conditionFilter;
        }
        StringBuilder condition = new StringBuilder();
        if (conditionFilter.equals("")) {
            condition.append("?range=");
            condition.append(range);
        } else {
            condition.append(conditionFilter);
            condition.append("&range=");
            condition.append(range);
            condition.append("&sortby=TIMESTAMP,d");
        }
        return condition.toString();
    }

    public List<HyperCDPConsistencyGroup> query(String devSn, String range, Map<String, String> filterMap) {
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{devSn});
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/cdp_consistency_group" + this.getCondition(range, filterMap);
        try {
            logger.debug((Object)"start queryHyperCDPConsistencyGroupList, url: %s, devsn: %s", new Object[]{url, devSn});
            List results = connection.pagingQuery(url, 0, 0);
            logger.debug((Object)"end queryHyperCDPConsistencyGroupList, url: %s, devsn: %s", new Object[]{url, devSn});
            ArrayList<HyperCDPConsistencyGroup> hyperCDPCg = new ArrayList<HyperCDPConsistencyGroup>();
            for (Map result : results) {
                hyperCDPCg.add(this.transitionHyperCDPConsistencyGroup(result));
            }
            return hyperCDPCg;
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("query HyperCDPs error, url: " + url + "devsn: " + devSn), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("query HyperCDPs failed, url: " + url + "devsn: " + devSn), (Throwable)e);
            throw new LegoCheckedException("query HyperCDPs failed.", (Throwable)e);
        }
    }

    public int count(String devSn, String hyperCDPConsistentGroupId, Map<String, String> map) {
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{devSn, hyperCDPConsistentGroupId});
        map.put("PARENTID", hyperCDPConsistentGroupId);
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/cdp_consistency_group/count" + this.getCondition(map);
        try {
            logger.debug((Object)"start queryHyperCDPConsistentGroupCount, url: %s, devsn: %s", new Object[]{url, devSn});
            Map result = connection.get(url, null);
            logger.debug((Object)"end queryHyperCDPConsistentGroupCount, url: %s, devsn: %s, result: %s", new Object[]{url, devSn, result});
            return NumberUtil.convertToInteger(result.get("COUNT"));
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("get number of HyperCDP error, url: " + url + "devsn: " + devSn), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("get number of HyperCDP failed, url: " + url + "devsn: " + devSn), (Throwable)e);
            throw new LegoCheckedException("get number of HyperCDP failed.", (Throwable)e);
        }
    }

    protected RestConnection getConnection(String devSn) {
        RestConnection connection = this.connMgr.getConnection(devSn);
        if (null == connection) {
            logger.error((Object)("The connection does not exist. sn=" + devSn));
            throw new LegoCheckedException(1073947649L);
        }
        return connection;
    }
}

