/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.handler.impl;

import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.drm.storage.handler.IStorageSnapshotScheduleHandler;
import com.huawei.ism.drm.storage.hvs.discovery.util.HVSRestTransitionExtend;
import com.huawei.ism.drm.storage.hvs.handler.impl.AbstractRestStorageHandler;
import com.huawei.ism.drm.storage.sdk.model.SnapshotSchedule;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.Map;

public class StorageSnapshotScheduleHandlerImpl
extends AbstractRestStorageHandler
implements IStorageSnapshotScheduleHandler {
    protected Map<String, String> constructCreateScheduleParameter(SnapshotSchedule schedule) {
        Long frequencyValue = schedule.getFrequencyValue();
        Integer snapshotMaxNum = schedule.getSnapshotMaxNum();
        if (null == frequencyValue || null == snapshotMaxNum) {
            logger.error((Object)("create snapshotSchedule error parameter,frequencyValue:" + frequencyValue + ",snapshotMaxNum:" + snapshotMaxNum));
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("NAME", schedule.getName());
        paramMap.put("FREQUENCYVALUE", String.valueOf(frequencyValue));
        paramMap.put("FREQUENCYNUM", String.valueOf(snapshotMaxNum));
        paramMap.put("SCHEDULETYPE", String.valueOf(SnapshotSchedule.SCHEDULE_TYPE.SNAPSHOT.getValue()));
        return paramMap;
    }

    protected Map<String, String> constructModifyScheduleParameter(SnapshotSchedule schedule) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        Long frequencyValue = schedule.getFrequencyValue();
        Integer snapshotMaxNum = schedule.getSnapshotMaxNum();
        if (null != frequencyValue && frequencyValue > 0L) {
            paramMap.put("FREQUENCYVALUE", String.valueOf(frequencyValue));
        }
        if (null != snapshotMaxNum && snapshotMaxNum > 0) {
            paramMap.put("FREQUENCYNUM", String.valueOf(snapshotMaxNum));
        }
        paramMap.put("SCHEDULETYPE", String.valueOf(schedule.getScheduleType()));
        return paramMap;
    }

    public SnapshotSchedule create(SnapshotSchedule schedule) {
        if (null == schedule) {
            logger.error((Object)"create snapshotSchedule error. snapshotSchedule is null.");
            throw new LegoCheckedException(1073947393L);
        }
        VerifyUtil.checkStrs((String[])new String[]{schedule.getDevSn(), schedule.getName()});
        logger.debug((Object)"create snapshotSchedule start.", new Object[]{schedule.toString()});
        Map<String, String> paramMap = this.constructCreateScheduleParameter(schedule);
        try {
            RestConnection connection = this.getConnection(schedule.getDevSn());
            Map map = connection.post("/rest/${deviceID}/snapshot_schedule", paramMap);
            SnapshotSchedule result = HVSRestTransitionExtend.transitionSnapshotSchedule(map);
            result.setDevSn(schedule.getDevSn());
            logger.debug((Object)("create snapshotSchedule finished. result:" + result.toString()));
            return result;
        }
        catch (LegoCheckedException le) {
            if (le.getErrorCode() == 404L) {
                throw new LegoCheckedException(1073948253L, (Throwable)le);
            }
            logger.error((Object)("create snapshotSchedule failed." + schedule.toString()), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("create snapshotSchedule failed." + schedule.toString()), (Throwable)e);
            throw new LegoCheckedException("create snapshotSchedule failed." + schedule.toString(), (Throwable)e);
        }
    }

    public void addLun(String devSn, String scheduleId, String lunId) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, scheduleId, lunId});
        logger.debug((Object)("add lun to snapshotSchedule. devSn=" + devSn + ", scheduleId:" + scheduleId + ", lunId:" + lunId));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ID", scheduleId);
        paramMap.put("ASSOCIATEOBJTYPE", String.valueOf(XveMOType.LUN.getValue()));
        paramMap.put("ASSOCIATEOBJID", lunId);
        RestConnection connection = this.getConnection(devSn);
        try {
            connection.put("/rest/${deviceID}/snapshot_schedule/create_associate", paramMap);
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("add lun to snapshotSchedule failed. devSn=" + devSn + ", scheduleId=" + scheduleId + ", lunId=" + lunId), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("add lun to snapshotSchedule failed. devSn=" + devSn + ", scheduleId=" + scheduleId + ", lunId=" + lunId), (Throwable)e);
            throw new LegoCheckedException("add lun to snapshotSchedule failed.", (Throwable)e);
        }
    }

    public void removeLun(String devSn, String scheduleId, String lunId) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, scheduleId, lunId});
        logger.debug((Object)("remove lun from snapshotSchedule. devSn=" + devSn + ", scheduleId:" + scheduleId + ", lunId:" + lunId));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ID", scheduleId);
        paramMap.put("ASSOCIATEOBJTYPE", String.valueOf(XveMOType.LUN.getValue()));
        paramMap.put("ASSOCIATEOBJID", lunId);
        RestConnection connection = this.getConnection(devSn);
        try {
            connection.put("/rest/${deviceID}/snapshot_schedule/remove_associate", paramMap);
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("remove lun from snapshotSchedule failed. devSn=" + devSn + ", scheduleId:" + scheduleId + ", lunId:" + lunId), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("remove lun from snapshotSchedule failed. devSn=" + devSn + ", scheduleId:" + scheduleId + ", lunId:" + lunId), (Throwable)e);
            throw new LegoCheckedException("remove lun from snapshotSchedule failed.", (Throwable)e);
        }
    }

    public void delete(String devSn, String scheduleId, int type) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, scheduleId});
        logger.debug((Object)("delete snapshotSchedule. devSn=" + devSn + ", scheduleId:" + scheduleId + ", type:" + type));
        RestConnection connection = this.getConnection(devSn);
        try {
            connection.delete("/rest/${deviceID}/snapshot_schedule/" + scheduleId + "?SCHEDULETYPE=" + type, null);
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("delete snapshotSchedule failed. devSn=" + devSn + ", scheduleId:" + scheduleId + ", type:" + type), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("delete snapshotSchedule failed. devSn=" + devSn + ", scheduleId:" + scheduleId + ", type:" + type), (Throwable)e);
            throw new LegoCheckedException("delete snapshotSchedule failed.", (Throwable)e);
        }
    }

    public void enable(String devSn, String scheduleId, int type, boolean enable) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, scheduleId});
        logger.debug((Object)("enabled snapshotSchedule. devSn:" + devSn + ", scheduleId:" + scheduleId + ", enable:" + enable));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("ID", scheduleId);
        paramMap.put("ENABLESCHEDULE", enable);
        RestConnection connection = this.getConnection(devSn);
        try {
            connection.putForObject("/rest/${deviceID}/snapshot_schedule/enable_snapshot_schedule?SCHEDULETYPE=" + type, paramMap);
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("enabled snapshotSchedule failed. devSn=" + devSn + ", scheduleId:" + scheduleId + ", type:" + type), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("enabled snapshotSchedule failed. devSn=" + devSn + ", scheduleId:" + scheduleId + ", type:" + type), (Throwable)e);
            throw new LegoCheckedException("enabled snapshotSchedule failed.", (Throwable)e);
        }
    }

    public SnapshotSchedule query(String devSn, String scheduleId) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, scheduleId});
        logger.debug((Object)("query snapshotSchedule: devSn:" + devSn + ", scheduleId:" + scheduleId));
        RestConnection connection = this.getConnection(devSn);
        try {
            Map map = connection.get("/rest/${deviceID}/snapshot_schedule/" + scheduleId, null);
            if (!VerifyUtil.isEmpty((Map)map)) {
                SnapshotSchedule result = HVSRestTransitionExtend.transitionSnapshotSchedule(map);
                result.setDevSn(devSn);
                logger.debug((Object)("query snapshotSchedule:" + result.toString()));
                return result;
            }
            return null;
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("query snapShotSchedule error. devSn:" + devSn + ", scheduleId:" + scheduleId), (Throwable)le);
            if (1077948996L == le.getErrorCode()) {
                logger.error((Object)"XVE_SPECIFIED_OBJECT_UNAVAILABLE.");
                return null;
            }
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("query snapShotSchedule failed. devSn:" + devSn + ", scheduleId:" + scheduleId), (Throwable)e);
            throw new LegoCheckedException("query snapShotSchedule failed.", (Throwable)e);
        }
    }

    public void modify(SnapshotSchedule schedule) {
        VerifyUtil.checkStrs((String[])new String[]{schedule.getDevSn(), schedule.getId()});
        logger.debug((Object)("modify snapshotSchedule. schedule:" + schedule.toString()));
        Map<String, String> paramMap = this.constructModifyScheduleParameter(schedule);
        RestConnection connection = this.getConnection(schedule.getDevSn());
        try {
            connection.put("/rest/${deviceID}/snapshot_schedule/" + schedule.getId(), paramMap);
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("modify snapShotSchedule failed. schedule:" + schedule.toString()), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("modify snapShotSchedule failed. schedule:" + schedule.toString()), (Throwable)e);
            throw new LegoCheckedException("modify snapShotSchedule failed.", (Throwable)e);
        }
    }

    public Integer count(String devSn, int type) {
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        logger.debug((Object)("count snapshot: devSn:" + devSn));
        RestConnection connection = this.getConnection(devSn);
        try {
            Map result = connection.get("/rest/${deviceID}/snapshot_schedule/count?filter=SCHEDULETYPE::" + type, null);
            if (!VerifyUtil.isEmpty((Map)result)) {
                logger.debug((Object)("count snapshot:  devSn:" + devSn), new Object[]{"count :" + (String)result.get("COUNT")});
                Integer count = NumberUtil.convertToInteger(result.get("COUNT"));
                return count;
            }
            return null;
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("count snapshot error. devSn:" + devSn), (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)("count snapshot failed. devSn:" + devSn), (Throwable)e);
            throw new LegoCheckedException("count snapshot failed.", (Throwable)e);
        }
    }
}

