/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.manager;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.HyperMetroConsistentGroup;
import com.huawei.ism.array.sdk.model.HyperMetroDomain;
import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.QuorumServerLink;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnectionManager;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefine;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.storage.hvs.discovery.util.HVSRestTransitionExtend;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperMetroManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HvsStorageHyperMetroManager
implements IStorageHyperMetroManager {
    protected static final String PREFERRED_SITE = "0";
    protected static final String NON_PREFERRED_SITE = "1";
    private static final Log logger = LogFactory.getInstance(HvsStorageHyperMetroManager.class);

    public String getStorageType() {
        return HvsUnit.class.getName();
    }

    public HyperMetroPair queryHyperMetroPair(String devSn, String pairId, String vstoreId) {
        logger.debug((Object)("Enter queryHyperMetroPair, sn=" + devSn + ", pairId=" + pairId + ",vstoreId=" + vstoreId));
        if (VerifyUtil.isEmpty((String)devSn)) {
            logger.error((Object)"devSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)pairId)) {
            logger.error((Object)"pairId is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection conn = this.getConn(devSn);
        String url = "/rest/${deviceID}/HyperMetroPair/" + pairId;
        if (!VerifyUtil.isEmpty((String)vstoreId)) {
            url = url + "?vstoreId=" + vstoreId;
        }
        logger.debug((Object)"Get hyperMetroPair: url = %s", new Object[]{url});
        Map record = conn.get(url, null);
        logger.debug((Object)"Get hyperMetro: result is %s", new Object[]{record});
        HyperMetroPair pair = HVSRestTransitionExtend.transitionHyperMetroPair(devSn, record);
        logger.debug((Object)"Exist queryHyperMetroPair.");
        return pair;
    }

    public List<QuorumServerLink> queryQuorumServerLinks(String devSn, String serverId) {
        logger.debug((Object)("Enter queryQuorumServerLinks, sn=" + devSn + ", serverId=" + serverId));
        if (VerifyUtil.isEmpty((String)devSn)) {
            logger.error((Object)"devSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)serverId)) {
            logger.error((Object)"serverId is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection conn = this.getConn(devSn);
        String url = "/rest/${deviceID}/QuorumServerLink?PARENTID=" + serverId + "&range=[0-65536]";
        logger.debug((Object)"Get quorumServerLinks: url = %s", new Object[]{url});
        List records = conn.getBatch(url, null);
        ArrayList<QuorumServerLink> links = new ArrayList<QuorumServerLink>();
        for (Map record : records) {
            QuorumServerLink link = HVSRestTransitionExtend.transitionQuorumServerLink(devSn, record);
            links.add(link);
        }
        logger.debug((Object)"Exit queryQuorumServerLinks.");
        return links;
    }

    public void synchronize(String devSn, String id, boolean isCg, String vstoreId) {
        logger.debug((Object)("Enter sync, sn=" + devSn + ", id=" + id + ", isCg=" + isCg));
        VerifyUtil.checkStrs((String[])new String[]{devSn, id});
        if (isCg) {
            this.syncCg(devSn, id);
        } else {
            this.syncPair(devSn, id, vstoreId);
        }
        logger.debug((Object)"Exit sync.");
    }

    protected void syncPair(String devSn, String pairId, String vstoreId) {
        RestConnection conn = this.getConn(devSn);
        HashMap<String, String> paras = new HashMap<String, String>();
        paras.put("ID", pairId);
        if (!VerifyUtil.isEmpty((String)vstoreId)) {
            paras.put("vstoreId", vstoreId);
        }
        paras.put("TYPE", Integer.toString(XveMOType.HyperMetroPair.getValue()));
        String url = "/rest/${deviceID}/HyperMetroPair/synchronize_hcpair";
        logger.debug((Object)"Put syncPair: url = %s, params = %s", new Object[]{url, paras});
        conn.put(url, paras);
    }

    protected void syncCg(String devSn, String cgId) {
        RestConnection conn = this.getConn(devSn);
        HashMap<String, String> paras = new HashMap<String, String>();
        paras.put("ID", cgId);
        paras.put("TYPE", Integer.toString(XveMOType.HyperMetroConsistentGroup.getValue()));
        String url = "/rest/${deviceID}/HyperMetro_ConsistentGroup/sync";
        logger.debug((Object)"Put syncConsistentGroup: url = %s, params = %s", new Object[]{url, paras});
        conn.put(url, paras);
    }

    public void disable(String devSn, String id, DrmEnumDefine.ROLE_TYPE role, boolean isCg, String vstoreId) {
        logger.debug((Object)("Enter disable, sn=" + devSn + ", id=" + id + ", role=" + role + ", isCg=" + isCg));
        VerifyUtil.checkStrs((String[])new String[]{devSn, id});
        if (isCg) {
            this.parseCg(devSn, id, role);
        } else {
            this.parsePair(devSn, id, role, vstoreId);
        }
        logger.debug((Object)"Exit disable.");
    }

    protected void parsePair(String devSn, String id, DrmEnumDefine.ROLE_TYPE role, String vstoreId) {
        RestConnection conn = this.getConn(devSn);
        HashMap<String, String> paras = new HashMap<String, String>();
        paras.put("ID", id);
        if (!VerifyUtil.isEmpty((String)vstoreId)) {
            paras.put("vstoreId", vstoreId);
        }
        paras.put("TYPE", Integer.toString(XveMOType.HyperMetroPair.getValue()));
        if (null != role) {
            if (DrmEnumDefine.ROLE_TYPE.PRIORITY.equals((Object)role)) {
                paras.put("ISPRIMARY", Boolean.TRUE.toString());
            } else if (DrmEnumDefine.ROLE_TYPE.NONE_PRIORITY.equals((Object)role)) {
                paras.put("ISPRIMARY", Boolean.FALSE.toString());
            }
        }
        String url = "/rest/${deviceID}/HyperMetroPair/disable_hcpair";
        logger.debug((Object)"Put disable_hcpair: url = %s, params = %s", new Object[]{url, paras});
        conn.put(url, paras);
    }

    protected void parseCg(String devSn, String id, DrmEnumDefine.ROLE_TYPE role) {
        RestConnection conn = this.getConn(devSn);
        HashMap<String, String> paras = new HashMap<String, String>();
        paras.put("ID", id);
        paras.put("TYPE", Integer.toString(XveMOType.HyperMetroConsistentGroup.getValue()));
        if (null != role) {
            if (DrmEnumDefine.ROLE_TYPE.PRIORITY.equals((Object)role)) {
                paras.put("PRIORITYSTATIONTYPE", PREFERRED_SITE);
            } else if (DrmEnumDefine.ROLE_TYPE.NONE_PRIORITY.equals((Object)role)) {
                paras.put("PRIORITYSTATIONTYPE", NON_PREFERRED_SITE);
            }
        }
        String url = "/rest/${deviceID}/HyperMetro_ConsistentGroup/stop";
        logger.debug((Object)"Put stopHyperMetroConsistentGroup: url = %s, params = %s", new Object[]{url, paras});
        conn.put(url, paras);
    }

    public void swap(String devSn, String id, Integer resourceType, boolean isCg) {
        logger.debug((Object)("Enter swap, sn=" + devSn + ", id=" + id + ", resourceType=" + resourceType + ", isCg=" + isCg));
        VerifyUtil.checkStrs((String[])new String[]{devSn, id});
        if (isCg) {
            this.swapCg(devSn, id);
        } else {
            this.swapPair(devSn, id, resourceType);
        }
        logger.debug((Object)"Exit swap.");
    }

    private void swapPair(String devSn, String id, Integer resourceType) {
        RestConnection conn = this.getConn(devSn);
        HashMap<String, String> paras = new HashMap<String, String>();
        paras.put("ID", id);
        paras.put("TYPE", Integer.toString(XveMOType.HyperMetroPair.getValue()));
        int hcResourceType = XveEnumDefine.HC_RESOURCE_TYPE_E.ST_LUN.getValue();
        if (null != resourceType) {
            hcResourceType = XveEnumDefine.HC_RESOURCE_TYPE_E.valueOf((int)resourceType).getValue();
        }
        paras.put("HCRESOURCETYPE", Integer.toString(hcResourceType));
        String url = "/rest/${deviceID}/HyperMetroPair/swap_hcpair";
        logger.debug((Object)"Put swapPair: url = %s, params = %s", new Object[]{url, paras});
        conn.put(url, paras);
    }

    private void swapCg(String devSn, String id) {
        RestConnection conn = this.getConn(devSn);
        HashMap<String, String> paras = new HashMap<String, String>();
        paras.put("ID", id);
        paras.put("TYPE", Integer.toString(XveMOType.HyperMetroConsistentGroup.getValue()));
        String url = "/rest/${deviceID}/HyperMetro_ConsistentGroup/switch";
        logger.debug((Object)"switch HyperMetroCG: url = %s, params = %s", new Object[]{url, paras});
        conn.put(url, paras);
    }

    public void startup(String devSn, String pairId) {
        logger.debug((Object)("Enter startup, devSn=" + devSn + ", pairId=" + pairId));
        if (VerifyUtil.isEmpty((String)devSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)pairId)) {
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection conn = this.getConn(devSn);
        HashMap<String, String> paras = new HashMap<String, String>();
        paras.put("ID", pairId);
        paras.put("TYPE", Integer.toString(XveMOType.HyperMetroPair.getValue()));
        paras.put("RECONVERYPOLICY", NON_PREFERRED_SITE);
        String url = "/rest/${deviceID}/HyperMetroPair/startup_mode";
        logger.debug((Object)"Put hyperMetroPair start: url = %s, params = %s", new Object[]{url, paras});
        conn.put(url, paras);
        logger.debug((Object)"Exit startup.");
    }

    public void shutdown(String devSn, String pairId) {
        logger.debug((Object)("Enter shutdown, devSn=" + devSn + ", pairId=" + pairId));
        if (VerifyUtil.isEmpty((String)devSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)pairId)) {
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection conn = this.getConn(devSn);
        HashMap<String, String> paras = new HashMap<String, String>();
        paras.put("ID", pairId);
        paras.put("TYPE", Integer.toString(XveMOType.HyperMetroPair.getValue()));
        String url = "/rest/${deviceID}/HyperMetroPair/SHUTDOWN";
        logger.debug((Object)"Put hyperMetroPair shutdown: url = %s, params = %s", new Object[]{url, paras});
        conn.put(url, paras);
        logger.debug((Object)"Exit shutdown");
    }

    protected RestConnection getConn(String devSn) {
        RestConnection conn = RestConnectionManager.getInstance().getConnection(devSn);
        if (null == conn) {
            throw new LegoCheckedException(1073947649L);
        }
        return conn;
    }

    public HyperMetroConsistentGroup queryHyperMetroConsistentGroup(String devSn, String cgId) {
        logger.debug((Object)("Enter queryHyperMetroConsistentGroup, sn=" + devSn + ", cgId=" + cgId));
        VerifyUtil.checkStrs((String[])new String[]{devSn, cgId});
        RestConnection conn = this.getConn(devSn);
        String url = "/rest/${deviceID}/HyperMetro_ConsistentGroup/" + cgId;
        logger.debug((Object)"queryHyperMetroCG url = %s", new Object[]{url});
        Map record = conn.get(url, null);
        logger.debug((Object)"queryHyperMetroCG result = %s", new Object[]{record});
        HyperMetroConsistentGroup cg = HVSRestTransitionExtend.transitionHyperMetroCg(devSn, record);
        logger.debug((Object)cg);
        logger.debug((Object)"Exit queryHyperMetroConsistentGroup.");
        return cg;
    }

    public List<HyperMetroPair> queryHyperMetroPairsByCg(String devSn, String cgId) {
        logger.debug((Object)("Enter queryHyperMetroPairsByCg, sn=" + devSn + ", cgId=" + cgId));
        VerifyUtil.checkStrs((String[])new String[]{devSn, cgId});
        RestConnection conn = this.getConn(devSn);
        StringBuilder url = new StringBuilder("/rest/${deviceID}/HyperMetroPair");
        url.append("?filter=CGID::").append(cgId);
        url.append("&range=[0-65536]");
        logger.debug((Object)"queryHyperMetroPairByCg url = %s", new Object[]{url.toString()});
        List records = conn.getBatch(url.toString(), null);
        ArrayList<HyperMetroPair> pairs = new ArrayList<HyperMetroPair>();
        for (Map record : records) {
            logger.debug((Object)record);
            HyperMetroPair temp = HVSRestTransitionExtend.transitionHyperMetroPair(devSn, record);
            pairs.add(temp);
        }
        logger.debug((Object)"Exit queryHyperMetroPairsByCg.");
        return pairs;
    }

    public List<HyperMetroPair> queryHyperMetroPairs(String devSn, String vstoreId) {
        logger.debug((Object)("Enter batchQueryHyperMetroPairs, sn=" + devSn + ",vstoreId=" + vstoreId));
        if (VerifyUtil.isEmpty((String)devSn)) {
            logger.error((Object)"devSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection conn = this.getConn(devSn);
        String url = "/rest/${deviceID}/HyperMetroPair?range=[0-65536]";
        if (!VerifyUtil.isEmpty((String)vstoreId)) {
            url = url + "&vstoreId=" + vstoreId;
        }
        logger.debug((Object)"queryHyperMetroPairs url = %s", new Object[]{url});
        List records = conn.getBatch(url, null);
        ArrayList<HyperMetroPair> pairs = new ArrayList<HyperMetroPair>();
        for (Map record : records) {
            logger.debug((Object)record);
            HyperMetroPair temp = HVSRestTransitionExtend.transitionHyperMetroPair(devSn, record);
            pairs.add(temp);
        }
        logger.debug((Object)"Exit batchQueryHyperMetroPairs.");
        return pairs;
    }

    public HyperMetroDomain queryHyperMetroDomainById(String devSn, String id) {
        logger.debug((Object)"Enter queryHyperMetroDomain, devSn=%s, Id=%s", new Object[]{devSn, id});
        if (VerifyUtil.isEmpty((String)devSn) || VerifyUtil.isEmpty((String)id)) {
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection conn = this.getConn(devSn);
        String url = "/rest/${deviceID}/FsHyperMetroDomain/" + id;
        Map records = conn.get(url, null);
        HyperMetroDomain hyperMetroDomain = HVSRestTransitionExtend.transitionHyperMetroDomain(devSn, records);
        return hyperMetroDomain;
    }
}

