/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.protection.rate;

import com.huawei.ism.cbb.base.sdk.constant.DmEnumDefine;
import com.huawei.ism.drm.protection.checker.job.IJobExecutionContextAWare;
import com.huawei.ism.drm.protection.checker.manager.RateConfigByReplicaServiceImpl;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.storage.hvs.protection.util.CommonUtil;
import com.huawei.ism.drm.storage.hvs.protection.util.DRRingUtil;
import com.huawei.ism.drm.storage.hvs.protection.util.ReplicationPairQueryAtMineSideService;
import com.huawei.ism.drm.storage.hvs.protection.util.RingTopologyUtil;
import com.huawei.ism.drm.storage.protection.util.DRRingCommUtil;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.quartz.JobExecutionContext;

@ServiceBoundInfo(methodName="onBind", targetBeanName="rateConfigServiceMgr", properties="type:26##27")
public class HyperDRRingPairRateConfigByReplicaServiceImpl
extends RateConfigByReplicaServiceImpl
implements IJobExecutionContextAWare {
    private static Log logger = LogFactory.getInstance(HyperDRRingPairRateConfigByReplicaServiceImpl.class);
    private ReplicationPairQueryAtMineSideService query;
    private ThreadLocal<JobExecutionContext> local = new ThreadLocal();

    public JobExecutionContext getJobExecutionContext() {
        return this.local.get();
    }

    public void setJobExecutionContext(JobExecutionContext context) {
        this.local.set(context);
    }

    public ReplicationPairQueryAtMineSideService getQuery() {
        return this.query;
    }

    public void setQuery(ReplicationPairQueryAtMineSideService query) {
        this.query = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyRate(DmEnumDefine.SPEED_LEVEL_E speedLevel, ProtectGroup pg, int protectionLocation) {
        try {
            super.modifyRate(speedLevel, pg, protectionLocation);
        }
        finally {
            this.local.remove();
        }
    }

    protected List<ReplicationRelationBo> getReplicationRelationBos(ProtectGroup protectGroup, Set<ProtectObjectReplica> replicas) {
        List policies = DRRingCommUtil.getProtectGroupSyncRatePolicies((JobExecutionContext)this.getJobExecutionContext());
        Collection storageList = CommonUtil.get(policies, "storage", String.class);
        if (VerifyUtil.isEmpty(storageList)) {
            logger.error((Object)"the returned storageList is null");
            throw new LegoCheckedException(1073947393L);
        }
        if (storageList.size() != 1) {
            logger.error((Object)"size of storage list should be 1, now the size is %s", (long)storageList.size());
            throw new LegoCheckedException(1073947393L);
        }
        String storage = (String)new ArrayList(storageList).get(0);
        Collection<RelicaStorageInfo> storageInfos = DRRingUtil.getRelicaStorageInfos(replicas);
        Collection<String> storages = this.getAllStorageSn(storageInfos);
        if (storages.contains(storage)) {
            return super.getReplicationRelationBos(protectGroup, replicas);
        }
        return this.getReplicationRelationBosForAnotherSide(protectGroup, replicas, storageInfos, storage);
    }

    private List<ReplicationRelationBo> getReplicationRelationBosForAnotherSide(ProtectGroup protectGroup, Set<ProtectObjectReplica> replicas, Collection<RelicaStorageInfo> storageInfos, String storage) {
        Map<String, Collection<ReplicationPair>> replicaPairMap = DRRingUtil.getRelatedReplicationPairs(storageInfos, this.query, false);
        Map<String, Collection<ReplicationPair>> hyperMetroSnPairMap = DRRingUtil.classifyReplicationPairByHyperMetroSide(replicaPairMap);
        if (hyperMetroSnPairMap == null) {
            logger.error((Object)"hypermetro side may has problem, can not classify replication pair by hypermetro side");
            throw new LegoCheckedException(1073947393L);
        }
        Collection<ReplicationPair> pairs = this.getRelatedReplicationPairs(hyperMetroSnPairMap, storage);
        if (pairs == null) {
            logger.error((Object)("not find replication pairs for current side at " + storage));
            throw new LegoCheckedException(1073947393L);
        }
        Collection<ProtectObjectReplica> dumps = RingTopologyUtil.dump(replicas, replicaPairMap);
        return super.getReplicationRelationBos(protectGroup, new HashSet<ProtectObjectReplica>(dumps));
    }

    private Collection<String> getAllStorageSn(Collection<RelicaStorageInfo> storageInfos) {
        HashSet<String> results = new HashSet<String>();
        Collection production = DRRingUtil.get(storageInfos, "srcStorageProviderSN", String.class);
        Collection recovery = DRRingUtil.get(storageInfos, "storageProviderSN", String.class);
        results.addAll(production);
        results.addAll(recovery);
        return results;
    }

    private Collection<ReplicationPair> getRelatedReplicationPairs(Map<String, Collection<ReplicationPair>> pairMap, String storage) {
        if (storage == null) {
            return null;
        }
        for (Map.Entry<String, Collection<ReplicationPair>> entry : pairMap.entrySet()) {
            if (!storage.equals(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }
}

