/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.protection.template.filter;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.task.sdk.service.IProtectionTaskService;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.hvs.protection.util.CommonUtil;
import com.huawei.ism.drm.storage.hvs.protection.util.DRRingUtil;
import com.huawei.ism.drm.storage.protection.template.context.PolicyTemplateContext;
import com.huawei.ism.drm.storage.protection.template.filter.ArraySyncAsyncConcurrent3DCFilter;
import com.huawei.ism.drm.storage.protection.util.DRRingCommUtil;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.TryCatchThrowable;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class ArraySyncAsyncConcurrentDRRingFilter
extends ArraySyncAsyncConcurrent3DCFilter {
    private static final Log logger = LogFactory.getInstance(ArraySyncAsyncConcurrentDRRingFilter.class);
    private static final String PO_LIST = "po_list_drring";

    public boolean isMatch(List<ProtectObject> protectObjects) {
        return this.isMatch(protectObjects, new PolicyTemplateContext());
    }

    public boolean isMatch(List<ProtectObject> protectObjects, PolicyTemplateContext context) {
        boolean is3DCSite;
        boolean isTwoTgt;
        logger.info((Object)("Start " + ((Object)((Object)this)).getClass().getSimpleName() + " isMatch"), 90160758786989L);
        String arraySn = this.checkSameSrcDevice(protectObjects);
        Site site = this.getSiteFromSn(arraySn);
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.warn((Object)("can't get site by deviceSN:" + arraySn), 90160758786989L);
            throw new LegoCheckedException(1073948449L);
        }
        this.getFilterContext().clear();
        this.getFilterContext().put("temp_policy_template_context", context);
        boolean isMatchAB = this.isMatchByLocation(1, DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue(), protectObjects, this.getType());
        if (!isMatchAB) {
            logger.warn((Object)"Concurrent3DC is not MatchAB", 90160758787071L);
        }
        boolean bl = isTwoTgt = !VerifyUtil.isEmpty(this.getFilterContext().get("CONCURRENT_3DC")) && (Boolean)this.getFilterContext().get("CONCURRENT_3DC") != false;
        if (!isTwoTgt) {
            logger.warn((Object)"Concurrent3DC is not isTwoTgt", 90160758787071L);
            throw new LegoCheckedException(1073948191L);
        }
        Object siteA = this.getFilterContext().get("SITE_A_3DC");
        Object siteB = this.getFilterContext().get("SITE_B_3DC");
        Object siteC = this.getFilterContext().get("SITE_C_3DC");
        if (VerifyUtil.isEmpty(siteA) || VerifyUtil.isEmpty(siteB) || VerifyUtil.isEmpty(siteC)) {
            logger.warn((Object)("Concurrent3DC isMatch site is null:" + siteA + "-" + siteB + "-" + siteC), 90160758787071L);
            throw new LegoCheckedException(1073948211L);
        }
        boolean bl2 = is3DCSite = !String.valueOf(siteA).equals(String.valueOf(siteB)) && !String.valueOf(siteB).equals(String.valueOf(siteC)) && !String.valueOf(siteA).equals(String.valueOf(siteC));
        if (!is3DCSite) {
            logger.warn((Object)("Concurrent3DC isMatch site is same:" + siteA + "-" + siteB + "-" + siteC), 90160758787071L);
            throw new LegoCheckedException(1073948211L);
        }
        logger.info((Object)("End " + ((Object)((Object)this)).getClass().getSimpleName() + " isMatch"), 90160758786989L);
        return isMatchAB;
    }

    public boolean isMatch(final List<ProtectObject> protectObjects, PolicyTemplate policyTemplate) {
        if (null == policyTemplate) {
            logger.error((Object)"error param.");
            return false;
        }
        final PolicyTemplateContext context = new PolicyTemplateContext();
        context.addObject(PO_LIST, protectObjects);
        boolean success = this.isMatch(protectObjects, context);
        if (!success) {
            logger.error((Object)"policyTemplate not match.");
            return false;
        }
        final AtomicBoolean matchDRStar = new AtomicBoolean(false);
        new TryCatchThrowable(){

            protected void doTry() {
                matchDRStar.set(ArraySyncAsyncConcurrentDRRingFilter.this.matchDRStar(protectObjects, context));
            }

            protected void doCatch(Throwable e) {
                logger.error((Object)("match DRRing error. template type 5." + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        }.run();
        if (matchDRStar.get()) {
            policyTemplate.setSketch("policy_template_5_concurrent_sa_dr_star.png");
            return success;
        }
        if (!VerifyUtil.isEmpty((Object)context.getObject("support_down_grade"))) {
            policyTemplate.setSketch("policy_template_6_concurrent_sa.png");
            return success;
        }
        logger.error((Object)"refresh DRRing pg, but policyTemplate not match.");
        throw new LegoCheckedException(1073948191L);
    }

    private boolean matchDRStar(List<ProtectObject> protectObjects, PolicyTemplateContext context) {
        HashSet<String> usedDRRings;
        boolean isDRStar;
        ExecutionContext executionContext = this.init(DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue(), protectObjects);
        String devSn = (String)executionContext.getAttribute("DEVICE_SN", String.class);
        Set resourceIdSet = (Set)executionContext.getAttribute("RESOURCE_ID_SET");
        logger.info((Object)("resourceIdSet:" + resourceIdSet));
        List lunList = this.queryLuns(devSn, resourceIdSet);
        Map abAndAcPairMap = this.getClassifiedPairMap(resourceIdSet, lunList);
        if (null == abAndAcPairMap) {
            logger.error((Object)"abAndAcPairMap is null");
            return false;
        }
        HashMap<String, List<ReplicationPair>> abPairMap = new HashMap<String, List<ReplicationPair>>();
        HashMap<String, List<ReplicationPair>> acPairMap = new HashMap<String, List<ReplicationPair>>();
        this.classifyPairMap(abAndAcPairMap, abPairMap, acPairMap);
        context.addObject("DR_RING_SITE_A_SYNC_PAIR_MAP", abPairMap);
        context.addObject("DR_RING_SITE_C_ASYNC_PAIR_MAP", acPairMap);
        if (abPairMap.size() == 0 || abPairMap.size() != acPairMap.size()) {
            logger.error((Object)("abAndAcPairMap size is " + abPairMap.size() + "abPairMap size is " + abPairMap.size() + "acPairMap size is " + acPairMap.size()));
            return false;
        }
        if (this.checkAllowSiteBFault(abPairMap, acPairMap, protectObjects, devSn)) {
            return true;
        }
        String seconDevdSn = DRRingCommUtil.getSnByPair((boolean)false, abPairMap);
        String thirdDevSn = DRRingCommUtil.getSnByPair((boolean)false, acPairMap);
        HashSet<String> resourceIds = new HashSet<String>();
        for (List pairs : abPairMap.values()) {
            for (ReplicationPair replicationPair : pairs) {
                for (ReplicationTargetLun tgtLun : replicationPair.getRepTgtLuns()) {
                    resourceIds.add(tgtLun.getTgtLunId());
                }
            }
        }
        Map bcStandByPair = this.getStandbyPair(seconDevdSn, thirdDevSn, protectObjects, resourceIds);
        if (VerifyUtil.isEmpty((Map)bcStandByPair) && !DRRingCommUtil.hasDRRingId(abPairMap)) {
            context.addObject("support_down_grade", (Object)true);
        }
        if ((isDRStar = this.getAndCheckIsRing(abPairMap, bcStandByPair, acPairMap, usedDRRings = new HashSet<String>())) && CommonUtil.matchDRRingLimit(protectObjects, abPairMap, true)) {
            DRRingUtil.checkDRRingsUsedByOtherProtectGroup(protectObjects, usedDRRings, Arrays.asList(devSn, seconDevdSn, thirdDevSn), Arrays.asList(devSn, seconDevdSn));
            context.addObject("DR_RING_SITE_B_ASYNC_PAIR_MAP", (Object)bcStandByPair);
            return true;
        }
        return false;
    }

    private boolean checkAllowSiteBFault(Map<String, List<ReplicationPair>> abPairMap, Map<String, List<ReplicationPair>> acPairMap, List<ProtectObject> protectObjects, String devSn) {
        HashSet<String> usedDRRings = new HashSet<String>();
        for (List<ReplicationPair> pairs : abPairMap.values()) {
            for (ReplicationPair replicationPair : pairs) {
                String drRingId = replicationPair.getDrRingId();
                if (!VerifyUtil.isEmpty((String)drRingId) && !"--".equals(drRingId)) {
                    usedDRRings.add(replicationPair.getDrRingId());
                }
                if (!replicationPair.isNormal()) continue;
                return false;
            }
        }
        for (List<ReplicationPair> pairs : abPairMap.values()) {
            for (ReplicationPair replicationPair : pairs) {
                if (replicationPair.isNormal() && usedDRRings.contains(replicationPair.getDrRingId())) continue;
                return false;
            }
        }
        if (usedDRRings.isEmpty()) {
            return true;
        }
        if (!CommonUtil.matchDRRingLimit(protectObjects, abPairMap, false)) {
            return false;
        }
        String thirdDevSn = DRRingCommUtil.getSnByPair((boolean)false, acPairMap);
        DRRingUtil.checkDRRingsUsedByOtherProtectGroup(protectObjects, usedDRRings, Arrays.asList(devSn, thirdDevSn));
        return true;
    }

    private void classifyPairMap(Map<String, List<ReplicationPair>> abAndAcPairMap, Map<String, List<ReplicationPair>> abPairMap, Map<String, List<ReplicationPair>> acPairMap) {
        Set<Map.Entry<String, List<ReplicationPair>>> entris = abAndAcPairMap.entrySet();
        for (Map.Entry<String, List<ReplicationPair>> entry : entris) {
            String srcLunId = entry.getKey();
            for (ReplicationPair pair : entry.getValue()) {
                ArrayList<ReplicationPair> pairs;
                if (pair.getReplicationMode() == 2) {
                    if (null == acPairMap.get(srcLunId)) {
                        pairs = new ArrayList<ReplicationPair>();
                        pairs.add(pair);
                        acPairMap.put(srcLunId, pairs);
                        continue;
                    }
                    acPairMap.get(srcLunId).add(pair);
                    continue;
                }
                if (null == abPairMap.get(srcLunId)) {
                    pairs = new ArrayList();
                    pairs.add(pair);
                    abPairMap.put(srcLunId, pairs);
                    continue;
                }
                abPairMap.get(srcLunId).add(pair);
            }
        }
    }

    public List<ProtectLocationPath> getProtectLocationPaths(List<ProtectObject> protectObjects) {
        PolicyTemplate tempTemplate = new PolicyTemplate();
        this.isMatch(protectObjects, tempTemplate);
        String siteA = (String)this.getFilterContext().get("SITE_A_3DC");
        String siteB = (String)this.getFilterContext().get("SITE_B_3DC");
        String siteC = (String)this.getFilterContext().get("SITE_C_3DC");
        ArrayList<ProtectLocationPath> path = new ArrayList<ProtectLocationPath>();
        path.add(this.constructSitePath(DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue(), siteA, siteB));
        String sketch = tempTemplate.getSketch();
        if (!VerifyUtil.isEmpty((String)sketch) && "policy_template_5_concurrent_sa_dr_star.png".equals(sketch)) {
            path.add(this.constructSitePath(DrmEnumDefine.PROTECT_LOCATION.PL_C.getValue(), siteA, siteC));
        } else {
            path.add(this.constructSitePath(DrmEnumDefine.PROTECT_LOCATION.PL_A_C.getValue(), siteA, siteC));
        }
        return path;
    }

    protected Map<String, List<ReplicationPair>> filterStandbyBySite(String masterSn, String slaveSn, Map<String, List<ReplicationPair>> devicesnPairMap) {
        return CommonUtil.filterStandbyBySite(masterSn, slaveSn, devicesnPairMap);
    }

    protected void degradeCreateReplication(Lun lun, ReplicationPair replicationPair, boolean checkPairStatus) {
        Object poList = this.getFilterContext().get(PO_LIST);
        if (null == poList) {
            super.degradeCreateReplication(lun, replicationPair, checkPairStatus);
        }
        if (this.existProtectGroupReplica((List)poList)) {
            super.degradeCreateReplication(lun, replicationPair, false);
        } else {
            super.degradeCreateReplication(lun, replicationPair, checkPairStatus);
        }
    }

    protected Map<String, List<ReplicationPair>> classifyPair(List<ReplicationPair> pairList) {
        if (VerifyUtil.isEmpty(pairList)) {
            logger.info((Object)"pairList is null or empty");
            return Collections.emptyMap();
        }
        return super.classifyPair(pairList);
    }

    protected void checkPairNum(Set<String> resourceIdSet, List<Lun> lunList, Map<String, List<ReplicationPair>> devicesnPairMap) {
        if (!VerifyUtil.isEmpty(devicesnPairMap)) {
            super.checkPairNum(resourceIdSet, lunList, devicesnPairMap);
        }
    }

    public boolean refreshPolicy(ProtectGroup protectGroup) {
        if (null == protectGroup || VerifyUtil.isEmpty((Object)protectGroup.getTemplate())) {
            return false;
        }
        Set schedules = protectGroup.getTemplate().getSchedules();
        Set pgReplicas = protectGroup.getReplicaList();
        if (VerifyUtil.isEmpty((Collection)schedules) || VerifyUtil.isEmpty((Collection)pgReplicas)) {
            logger.info((Object)"schedules or pgReplicas is null or empty.");
            return false;
        }
        for (ProtectGroupReplica protectGroupReplica : pgReplicas) {
            for (Schedule schedule : schedules) {
                this.updateSchedule(protectGroup, protectGroupReplica, schedule);
            }
        }
        return true;
    }

    private void updateSchedule(ProtectGroup protectGroup, ProtectGroupReplica protectGroupReplica, Schedule schedule) {
        IProtectionTaskService service = (IProtectionTaskService)ServiceLocator.getInstance().getService(IProtectionTaskService.class);
        if (DrmEnumDefine.PROTECT_LOCATION.PL_C.getValue() == protectGroupReplica.getProtectLocation() && (DrmEnumDefine.PROTECT_LOCATION.PL_A_C.getValue() == schedule.getProtectLocation() || DrmEnumDefine.PROTECT_LOCATION.PL_B_C.getValue() == schedule.getProtectLocation())) {
            schedule.setProtectLocation(DrmEnumDefine.PROTECT_LOCATION.PL_C.getValue());
            this.fillStandbySpeedPolicy(schedule, protectGroupReplica, protectGroup.getReplicationReplicaByLocation(DrmEnumDefine.PROTECT_LOCATION.PL_A_B));
            if (null != service.getTask(protectGroup.getUuid(), schedule.getScheduleId())) {
                service.updateTask(protectGroup.getUuid(), schedule);
            }
        }
        if (DrmEnumDefine.PROTECT_LOCATION.PL_A_C.getValue() == protectGroupReplica.getProtectLocation() && DrmEnumDefine.PROTECT_LOCATION.PL_C.getValue() == schedule.getProtectLocation()) {
            schedule.setProtectLocation(protectGroupReplica.getProtectLocation());
            this.deleteStandbySpeedPolicy(schedule, protectGroupReplica, protectGroup.getReplicationReplicaByLocation(DrmEnumDefine.PROTECT_LOCATION.PL_A_B));
            if (null != service.getTask(protectGroup.getUuid(), schedule.getScheduleId())) {
                service.updateTask(protectGroup.getUuid(), schedule);
            }
        }
    }
}

