/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.topology;

import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.hvs.protection.util.DRRingUtil;
import com.huawei.ism.drm.storage.hvs.protection.util.ReplicationPairQueryAtBothSideService;
import com.huawei.ism.drm.storage.hvs.protection.util.ReplicationPairQueryAtMineSideService;
import com.huawei.ism.drm.storage.hvs.protection.util.RingTopologyUtil;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.topology.ArrayReplicationTopoBuilder;
import com.huawei.ism.drm.topo.sdk.context.TopoContext;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import twaver.Node;

@ServiceBoundInfo(methodName="onBind", targetBeanName="topoBuilderManager", properties="type:PolicyTemplate-3##PolicyTemplate-5")
public class ArrayReplicationRingTopoBuilder
extends ArrayReplicationTopoBuilder {
    private ReplicationPairQueryAtBothSideService bothSideQueryService;

    public ReplicationPairQueryAtMineSideService getBothSideQueryService() {
        return this.bothSideQueryService;
    }

    public void setBothSideQueryService(ReplicationPairQueryAtBothSideService mineSideQueryService) {
        this.bothSideQueryService = mineSideQueryService;
    }

    public void buildTopo(TopoContext context) {
        ProtectGroup pg = context.getProtectGroup();
        boolean hasRing = ArrayReplicationRingTopoBuilder.hasRing(pg.getReplicaList());
        Map<String, Collection<ReplicationPair>> pairMap = null;
        if (hasRing) {
            pairMap = RingTopologyUtil.prepare(context.getProtectGroup(), this.bothSideQueryService);
            this.sortRelation(pg.getReplicaList());
        }
        super.buildTopo(context);
        if (hasRing) {
            RingTopologyUtil.updateReplicationPairStatus(context, RingTopologyUtil.spread(pairMap.values()));
        }
    }

    public static boolean hasRing(Collection<ProtectGroupReplica> replicaList) {
        boolean hasRing = false;
        if (VerifyUtil.isEmpty(replicaList)) {
            return hasRing;
        }
        ProtectGroupReplica protectGroupReplica = replicaList.stream().findFirst().get();
        Set replicas = protectGroupReplica.getReplicas();
        if (VerifyUtil.isEmpty((Collection)replicas)) {
            return hasRing;
        }
        ProtectObjectReplica protectObjectReplica = (ProtectObjectReplica)replicas.stream().findFirst().get();
        Set storageInfos = protectObjectReplica.getStorageInfos();
        if (VerifyUtil.isEmpty((Collection)storageInfos)) {
            return hasRing;
        }
        RelicaStorageInfo relicaStorageInfo = (RelicaStorageInfo)storageInfos.stream().findFirst().get();
        if (relicaStorageInfo instanceof RemoteStorageReplica) {
            RemoteStorageReplica remoteStorageReplica = (RemoteStorageReplica)relicaStorageInfo;
            hasRing = !VerifyUtil.isEmpty((String)remoteStorageReplica.getDrRingId());
        }
        return hasRing;
    }

    protected Map<String, String> initWrapMap(ProtectGroup pg) {
        List<String> siteIdSequece;
        Map wrapMap = super.initWrapMap(pg);
        if (ArrayReplicationRingTopoBuilder.hasRing(pg.getReplicaList()) && (siteIdSequece = this.getSiteIdSequece(pg)).size() >= 3) {
            wrapMap.put(siteIdSequece.get(1), "Replication-Data-Center-Group-1");
            wrapMap.put(siteIdSequece.get(2), "Replication-Data-Center-Group-2");
        }
        return wrapMap;
    }

    protected Node createSiteNode(TopoContext context, Site siteInfo, boolean wrap, String wrapId) {
        ProtectGroup pg = context.getProtectGroup();
        boolean hasRing = ArrayReplicationRingTopoBuilder.hasRing(pg.getReplicaList());
        List<Object> siteIdSequece = new ArrayList();
        if (hasRing) {
            siteIdSequece = this.getSiteIdSequece(pg);
        }
        if (siteIdSequece.size() < 3) {
            hasRing = false;
        }
        if (hasRing && siteInfo.getSiteId().equals(siteIdSequece.get(1))) {
            Site siteInfoCircle = new Site();
            siteInfoCircle.setSiteId(siteInfo.getSiteId() + ":circle");
            Node node = this.createSiteNode(context, siteInfoCircle, wrap, wrapId);
            this.resetNode(node);
        }
        Node rtnNode = super.createSiteNode(context, siteInfo, wrap, wrapId);
        if (hasRing && siteInfo.getSiteId().equals(siteIdSequece.get(2))) {
            Site siteInfoCircle = new Site();
            siteInfoCircle.setSiteId(siteInfo.getSiteId() + ":circle");
            Node node = this.createSiteNode(context, siteInfoCircle, wrap, wrapId);
            this.resetNode(node);
        }
        return rtnNode;
    }

    private void resetNode(Node node) {
        node.setWidth(200.0);
        node.setHeight(200.0);
        node.setStyle("vector.fill.alpha", 0);
        node.setStyle("vector.outline.alpha", 0);
        node.setToolTip("");
    }

    private List<String> getSiteIdSequece(ProtectGroup pg) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.add(pg.getProductSiteId());
        pg.getReplicaList().stream().forEach(pgRep -> {
            Collection<Site> recoverySites;
            Collection<Site> productSites = DRRingUtil.getSiteByStorageSn(Arrays.asList(pgRep.getProductArray()));
            if (!VerifyUtil.isEmpty(productSites)) {
                set.add(productSites.stream().findFirst().get().getSiteId());
            }
            if (!VerifyUtil.isEmpty(recoverySites = DRRingUtil.getSiteByStorageSn(Arrays.asList(pgRep.getRecoveryArray())))) {
                set.add(recoverySites.stream().findFirst().get().getSiteId());
            }
        });
        return set.stream().collect(Collectors.toList());
    }
}

