/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.fsb.connection;

import com.huawei.ism.drm.rest.client.IResponseHandler;
import com.huawei.ism.drm.rest.client.util.ServiceResponse;
import com.huawei.lego.core.sdk.exception.FusionStorageException;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.MessageFormatUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.net.URISyntaxException;
import java.util.Collection;
import org.apache.hc.core5.http.HttpRequest;

public class FusionStorageResponseHandler
implements IResponseHandler {
    private static final Log LOGGER = LogFactory.getInstance(FusionStorageResponseHandler.class);
    private static final int SUCCESS = 0;
    private static final String RESULT_KEY = "result";
    private static final String DESCRIBE_KEY = "describe";
    private static final String ERROR_CODE_KEY = "errorCode";
    private static final String ERROR_KEY = "error";
    private static final String CODE_KEY = "code";
    private static final String DESCRIPTION_KEY = "description";
    private static final String DETAIL_KEY = "detail";
    private static final int INTERNAL_SERVER_ERROR = 500;

    public void handleReponse(ServiceResponse response) {
        int result;
        JSONObject jsonObject;
        String requestUri;
        if (response == null) {
            LOGGER.error((Object)"response is empty");
            throw new LegoCheckedException(1073947647L);
        }
        HttpRequest request = response.getRequest();
        try {
            requestUri = request != null ? String.valueOf(request.getUri()) : "";
        }
        catch (URISyntaxException e) {
            LOGGER.error((Object)"Get requestUri result failed, errorMsg: %s", new Object[]{e.getMessage()});
            throw new LegoCheckedException(1073947394L);
        }
        if (response.getStatusCode() == 404 || response.getStatusCode() >= 500) {
            String errorMsg = MessageFormatUtil.format((String)"Request:[{0}], Response status:[{1}], ResponseText:[{2}]", (Object[])new Object[]{requestUri, response.getStatusCode(), response.getResponseString()});
            LOGGER.error((Object)errorMsg);
            throw new LegoCheckedException(1073947395L);
        }
        String responseText = response.getResponseString();
        try {
            jsonObject = JSONObject.fromObject((Object)responseText);
        }
        catch (LegoCheckedException e) {
            String errorMsg = MessageFormatUtil.format((String)"Request:[{0}], Cannot parse fs response text:[{1}], Response status:[{2}]", (Object[])new Object[]{requestUri, responseText, response.getStatusCode()});
            LOGGER.error((Object)errorMsg, (Throwable)e);
            throw e;
        }
        if (jsonObject.containsKey((Object)RESULT_KEY) && (result = jsonObject.getInt(RESULT_KEY)) != 0) {
            this.setFailedInfo(requestUri, jsonObject, result);
        }
        if (jsonObject.containsKey((Object)ERROR_KEY)) {
            this.setErrorInfo(requestUri, jsonObject);
        }
    }

    private void setFailedInfo(String requestUri, JSONObject jsonObject, int result) {
        JSONArray jsonArray;
        String errorInfo = "";
        long errorCode = result;
        if (jsonObject.containsKey((Object)DETAIL_KEY) && !jsonObject.containsKey((Object)ERROR_CODE_KEY) && !VerifyUtil.isEmpty((Collection)(jsonArray = jsonObject.getJSONArray(DETAIL_KEY))) && jsonArray.iterator().hasNext()) {
            jsonObject = JSONObject.fromObject(jsonArray.iterator().next());
        }
        if (jsonObject.containsKey((Object)ERROR_CODE_KEY)) {
            errorCode = jsonObject.getLong(ERROR_CODE_KEY);
            errorInfo = jsonObject.getString(DESCRIPTION_KEY);
        }
        if (jsonObject.containsKey((Object)DESCRIBE_KEY)) {
            errorInfo = jsonObject.getString(DESCRIBE_KEY);
        }
        String errorMsg = MessageFormatUtil.format((String)"Request:[{0}], Response Error Info:[{1}], errorCode:[{2}]", (Object[])new Object[]{requestUri, errorInfo, String.valueOf(errorCode)});
        LOGGER.error((Object)errorMsg);
        throw new FusionStorageException(errorCode, errorInfo);
    }

    private void setErrorInfo(String requestUri, JSONObject jsonObject) {
        JSONObject errorValue = jsonObject.getJSONObject(ERROR_KEY);
        long errorCode = errorValue.getInt(CODE_KEY);
        if (errorCode != 0L) {
            String errorInfo = errorValue.getString(DESCRIPTION_KEY);
            String errorMsg = MessageFormatUtil.format((String)"Request:[{0}], Response Error Info:[{1}], errorCode:[{2}]", (Object[])new Object[]{requestUri, errorInfo, String.valueOf(errorCode)});
            LOGGER.error((Object)errorMsg);
            throw new FusionStorageException(errorCode, errorInfo);
        }
    }
}

