/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.fsb.discovery.process;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.discover.commons.process.AbstractPingProcessor;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.drm.storage.fsb.connection.FusionStorageRestConnection;
import com.huawei.ism.drm.storage.fsb.connection.FusionStorageRestConnectionFactory;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.text.MessageFormat;

public class FusionStoragePingProcessor
extends AbstractPingProcessor {
    private static final Log logger = LogFactory.getInstance(FusionStoragePingProcessor.class);

    protected String getCurrentIp(String sn) {
        logger.debug((Object)"Ping process begin to check connection validation.");
        FusionStorageRestConnection connection = FusionStorageRestConnectionFactory.getInstance().getConnection(sn);
        if (connection != null && connection.isValid()) {
            return connection.getIpAddress();
        }
        return null;
    }

    protected void connect(String sn, String ip, NeMgrProtocolExtend info) {
        logger.debug((Object)("Begin to connect:" + ip));
        String username = info.getNetworkUserName();
        String password = info.getNetworkPassword();
        String port = (String)info.getExtendParams().get("port");
        FusionStorageRestConnection connection = FusionStorageRestConnectionFactory.getInstance().getConnection(sn);
        connection.setIpAddress(ip);
        connection.setPort(NumberUtil.parseInteger((Object)port));
        connection.setUserName(username);
        connection.setPassword(password);
        connection.setDeviceId(null);
        if (!connection.isValid()) {
            logger.error((Object)("connection to:" + connection.getIpAddress() + " is invalid."));
            throw new LegoCheckedException(1073947649L);
        }
        if (!sn.equals(connection.getDeviceId())) {
            logger.error((Object)MessageFormat.format("SN match fail, db devSn={0}, but real devSn={2} with the ip={1}", sn, ip, connection.getDeviceId()));
            throw new LegoCheckedException(1073947432L);
        }
    }
}

