/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.fsb.discovery.synchronizer;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.cbb.discover.commons.DiscoverContext;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.CommonTemplate;
import com.huawei.ism.cbb.discover.framework.CommonTemplateManager;
import com.huawei.ism.cbb.discover.util.DiscoverUtil;
import com.huawei.ism.cbb.proxy.util.ResourceHelper;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.storage.fsb.connection.FusionStorageRestConnection;
import com.huawei.ism.drm.storage.fsb.connection.FusionStorageRestConnectionFactory;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.mediation.synchronize.AbstractSynchronizer;
import com.huawei.lego.core.sdk.mediation.synchronize.model.MoListOrMap;
import com.huawei.lego.core.sdk.mediation.synchronize.model.SynchronizeParameter;
import java.util.Arrays;

public class FusionStorageSynchronizer
extends AbstractSynchronizer {
    private static final Log LOGGER = LogFactory.getInstance(FusionStorageSynchronizer.class);

    public MoListOrMap synchronizeDataAndConstructMo(SynchronizeParameter params, MoListOrMap parent) {
        if (null == params) {
            LOGGER.error((Object)"SynchronizeParameter is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        LOGGER.info((Object)("Begin to discover fusionstorage block storage, device IP:" + params.getDeviceIp()), 90160777658372L);
        NeMgrProtocolExtend neMgrProtocolExtend = DiscoverUtil.parseHuaweiStorageParams((SynchronizeParameter)params);
        if (VerifyUtil.isEmpty((Object)neMgrProtocolExtend) || VerifyUtil.isEmpty((String)neMgrProtocolExtend.getNetworkUserName()) || VerifyUtil.isEmpty((String)neMgrProtocolExtend.getNetworkPassword())) {
            LOGGER.error((Object)"NeMgrProtocolExtend some parameter is empty", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        String restPort = (String)neMgrProtocolExtend.getExtendParams().get("port");
        if (VerifyUtil.isEmpty((String)restPort)) {
            restPort = ResourceHelper.getValue((String)"fsb.port");
            LOGGER.info((Object)("Use default rest port, value=" + restPort), 90160758784000L);
            neMgrProtocolExtend.getExtendParams().put("port", restPort);
        }
        this.retrieve(params, parent, neMgrProtocolExtend);
        return null;
    }

    private void retrieve(SynchronizeParameter params, MoListOrMap parent, NeMgrProtocolExtend neMgrProtocolExtend) {
        CommonTemplate template = CommonTemplateManager.getInstance().getTemplateByManagementProtocol("FSB-REST", 1);
        if (null == template) {
            LOGGER.error((Object)"discoverTemplate is null.", 90160758784000L);
            throw new LegoCheckedException(127402L);
        }
        FusionStorageRestConnection connection = FusionStorageRestConnectionFactory.getInstance().createConnection(neMgrProtocolExtend, true);
        StorageNE storage = this.buildStorageEntity(params, connection);
        DiscoverContext context = new DiscoverContext(params, parent);
        context.setAttribute("StorageDevice", (Object)storage);
        context.setAttribute("NeMgrProtocolExtend", (Object)neMgrProtocolExtend);
        context.setAttribute("AvailableIps", Arrays.asList(params.getDeviceIp()));
        context.setAttribute("SiteId", (Object)params.getDiscoveryPolicy().getLocation());
        context.setAttribute("OperatorId", (Object)params.getDiscoveryPolicy().getOperatorId());
        LOGGER.info((Object)("begin to execute discovery template. SN:" + storage.getSn()));
        template.process((AbstractContext)context);
    }

    private StorageNE buildStorageEntity(SynchronizeParameter params, FusionStorageRestConnection connection) {
        String devSN = connection.getDeviceId();
        StorageNE storage = new StorageNE();
        storage.setUuid("FSB_Storage:" + devSN);
        storage.setSn(connection.getDeviceId());
        storage.setIpAddress(params.getDeviceIp());
        storage.setLinkIp(params.getDeviceIp());
        storage.setIsTopMo(Boolean.valueOf(true));
        storage.setManaged(Boolean.valueOf(true));
        storage.setManufacturer("ism.storage.manufacture.0huawei");
        storage.setManagementProtocolMap(params.getManagementProtocolMap());
        storage.setManagementProtocol("FSB-REST");
        return storage;
    }
}

