/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.fsb.handler;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.array.sdk.model.XveLun;
import com.huawei.ism.base.sdk.model.Initiator;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.recovery.sdk.model.HostGroupVO;
import com.huawei.ism.drm.recovery.sdk.model.HostVO;
import com.huawei.ism.drm.recovery.sdk.model.ResourceVO;
import com.huawei.ism.drm.storage.fsb.FusionStorageConstants;
import com.huawei.ism.drm.storage.fsb.connection.FusionStorageRestConnection;
import com.huawei.ism.drm.storage.fsb.model.VolumeAttachNode;
import com.huawei.ism.drm.storage.fsb.util.FusionStorageCommonUtil;
import com.huawei.ism.drm.storage.fsb.util.FusionStorageRestTransition;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.ism.drm.storage.sdk.model.StorageLicense;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class FusionStorageHandler {
    public static final String PREPARE_HOST_OPERATION = "ism.drm.prepare.host.operation";
    public static final String PREPARE_GROUP_OPERATION = "ism.drm.prepare.group.operation";
    private static final String QUERY_VOLUME_BY_ID = "volId";
    private static final String QUERY_VOLUME_BY_NAME = "volName";
    private static final Long CG_NOT_EXIST_ERRORCODE = 37120037L;
    private static final Long PAIR_NOT_EXIST_ERROR_CODE = 37120003L;
    private static final Log logger = LogFactory.getInstance(FusionStorageHandler.class);
    private static final int TIMEOUT = 60;
    private static final int COUNT = 15;

    public String getVolumeNameById(String deviceSN, String id) {
        return ((Lun)CommonUtil.requireNonNull((Object)this.getVolumeByLunId(deviceSN, id), (long)1073948685L, (String[])new String[0])).getName();
    }

    public boolean isLunMapped(String deviceSN, String resourceId) {
        String volumeName = this.getVolumeNameById(deviceSN, resourceId);
        return this.isLunMappedBase(deviceSN, volumeName);
    }

    private boolean isLunMappedBase(String deviceSN, String volumeName) {
        List<Object> nodes;
        try {
            nodes = this.queryVolumeAttachNodes(deviceSN, volumeName);
        }
        catch (LegoCheckedException e) {
            nodes = Collections.emptyList();
        }
        return !VerifyUtil.isEmpty(nodes);
    }

    private <Resource extends ResourceVO> OperationResult execute(String devSn, String volumeName, Resource resource, VolumeAction<Resource> iscsi, VolumeAction<Resource> scsi) {
        VolumeAction<Resource> action;
        Lun lun = this.getVolumeByLunName(devSn, volumeName);
        String property = null;
        if (resource instanceof HostVO) {
            property = resource.getExtProperty();
        } else if (resource instanceof HostGroupVO) {
            HostVO hostVO = (HostVO)CommonUtil.getFirstElement((Collection)((HostGroupVO)resource).getHostVOs());
            property = hostVO.getExtProperty();
        }
        if (VerifyUtil.isEmpty((String)property)) {
            action = iscsi;
            logger.debug((Object)"Execute, action is ISCSI");
        } else {
            JSONObject jsonObject = JSONObject.fromObject((Object)property);
            if (!jsonObject.containsKey((Object)"fsb_block_client_ip")) {
                action = iscsi;
                logger.debug((Object)"Execute, action is ISCSI");
            } else {
                action = scsi;
                logger.debug((Object)"Execute, action is SCSI");
            }
        }
        OperationResult result = action.execute(devSn, lun, resource);
        return result;
    }

    public OperationResult unmapping(String devSn, String volumeName, ResourceVO resourceVO) {
        return this.execute(devSn, volumeName, resourceVO, this::unmapping, this::unmount);
    }

    private OperationResult unmapping(String devSn, Lun lun, ResourceVO resourceVO) {
        FusionStorageCommonUtil.paramsCheck(devSn, lun, resourceVO);
        FusionStorageRestConnection connection = FusionStorageCommonUtil.getConnection(devSn);
        JSONObject params = new JSONObject();
        logger.debug((Object)"Unmapping lun from host start. devSn:%s, Lun:%s, resource:%s", new Object[]{devSn, lun.toString(), resourceVO.toString()});
        try {
            JSONArray jsonArray = new JSONArray();
            jsonArray.add((Object)lun.getName());
            if (resourceVO instanceof HostGroupVO) {
                HostGroupVO hostGroupVO = (HostGroupVO)resourceVO;
                List<HostVO> hostVOs = this.extractHostsHaveMapping(devSn, hostGroupVO);
                for (HostVO hostVO : hostVOs) {
                    OperationResult operationResult = this.unmapping(devSn, lun, (ResourceVO)hostVO);
                    if (operationResult.isSuccess()) continue;
                    logger.error((Object)"Unmapping host directly failed: hostGroupName=%s, host=%s", new Object[]{hostGroupVO.getName(), hostVO});
                    return operationResult;
                }
                if (!VerifyUtil.isEmpty(hostVOs) && VerifyUtil.isEmpty((Collection)hostGroupVO.getHostVOs())) {
                    return new OperationResult("ism.drm.unmappinglun.operation", true, true, new String[]{hostGroupVO.getName()});
                }
                String hostGroupName = this.prepareHostGroup(devSn, hostGroupVO, false);
                if (hostGroupName == null) {
                    logger.error((Object)"Prepare host group for storage (%s) failed .", new Object[]{devSn});
                    return new OperationResult(PREPARE_GROUP_OPERATION, true, false, String.valueOf(1073948697L), new String[]{hostGroupVO.getName()});
                }
                params.put((Object)"hostGroupName", (Object)hostGroupName);
                params.put((Object)"lunList", (Object)jsonArray);
                connection.postForObject("/hostGroup/lun/delete", params);
                logger.debug((Object)"Unmapping lun from host group finished.");
                return new OperationResult("ism.drm.unmappinglun.operation", true, true, new String[]{hostGroupVO.getName()});
            }
            if (resourceVO instanceof HostVO) {
                HostVO hostVO = (HostVO)resourceVO;
                String hostname = this.prepareHost(devSn, hostVO);
                if (hostname == null) {
                    logger.error((Object)"Prepare host for storage (%s) failed .", new Object[]{devSn});
                    return new OperationResult(PREPARE_HOST_OPERATION, true, false, String.valueOf(1073948697L), new String[]{hostVO.getName()});
                }
                params.put((Object)"hostName", (Object)hostname);
                params.put((Object)"lunNames", (Object)jsonArray);
                connection.postForObject("/host/lun/delete", params);
                logger.debug((Object)"Unmapping lun from host finished. dev:%s,  lun id:%s,resource name:%s", new Object[]{devSn, lun.getLunId(), resourceVO.getName()});
                return new OperationResult("ism.drm.unmappinglun.operation", true, true, new String[]{hostVO.getName()});
            }
            logger.error((Object)("Unmapping volume not support resource type, type\uff1a" + resourceVO.getClass().getName()));
            throw new LegoCheckedException(100663460L);
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)"Unmapping volume error. dev:%s,  lun:%s, resource :%s", new Object[]{devSn, lun.toString(), resourceVO.toString()});
            return new OperationResult("ism.drm.unmappinglun.operation", true, false, String.valueOf(ex.getErrorCode()), new String[]{resourceVO.getName()});
        }
    }

    private OperationResult unmount(String devSn, Lun lun, ResourceVO resourceVO) {
        List<String> ipList;
        FusionStorageCommonUtil.paramsCheck(devSn, lun, resourceVO);
        FusionStorageRestConnection connection = FusionStorageCommonUtil.getConnection(devSn);
        String volName = lun.getName();
        if (resourceVO instanceof HostVO) {
            HostVO hostVO2 = (HostVO)resourceVO;
            ipList = Arrays.asList(hostVO2.getIpAddress());
        } else if (resourceVO instanceof HostGroupVO) {
            HostGroupVO hostGroupVO = (HostGroupVO)resourceVO;
            ipList = hostGroupVO.getHostVOs().stream().filter(hostVO -> hostVO != null).map(hostVO -> hostVO.getIpAddress()).collect(Collectors.toList());
        } else {
            logger.error((Object)"Unmount volume not support resource type, type\uff1a%s", new Object[]{resourceVO.getClass().getName()});
            throw new LegoCheckedException(100663460L);
        }
        JSONObject params = new JSONObject();
        params.put((Object)QUERY_VOLUME_BY_NAME, Arrays.asList(volName));
        params.put((Object)"ipList", ipList);
        try {
            logger.debug((Object)"Unmount volume start. dev:%s,  lun:%s, resource:%s", new Object[]{devSn, lun.toString(), resourceVO.toString()});
            connection.postForObject("/volume/detach", params);
            logger.debug((Object)"Unmount volume finished. dev:%s,  lun id:%s, resource name:%s", new Object[]{devSn, lun.getLunId(), resourceVO.getName()});
            return new OperationResult("ism.drm.unmappinglun.operation", true, true, new String[]{resourceVO.getName()});
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)"Unmount error, dev:%s, lun:%s, resource:%s", new Object[]{devSn, lun.toString(), resourceVO.toString()});
            return new OperationResult("ism.drm.unmappinglun.operation", true, false, String.valueOf(ex.getErrorCode()), new String[]{resourceVO.getName()});
        }
    }

    public OperationResult mapping(String devSn, String volumeName, ResourceVO resourceVO) {
        return this.execute(devSn, volumeName, resourceVO, this::mapping, this::mount);
    }

    private OperationResult mount(String devSn, Lun lun, ResourceVO resourceVO) {
        List<Object> ipList;
        FusionStorageCommonUtil.paramsCheck(devSn, lun, resourceVO);
        logger.debug((Object)"Mount vol, devSn: %s, lun: %s, resourceVO: %s", new Object[]{devSn, lun, resourceVO});
        FusionStorageRestConnection connection = FusionStorageCommonUtil.getConnection(devSn);
        String volName = lun.getName();
        if (resourceVO instanceof HostGroupVO) {
            HostGroupVO groupVO = (HostGroupVO)resourceVO;
            ipList = groupVO.getHostVOs().stream().filter(hostVO -> hostVO != null).map(hostVO -> {
                JSONObject ext = JSONObject.fromObject((Object)hostVO.getExtProperty());
                if (ext.containsKey((Object)"fsb_block_client_ip")) {
                    return ext.getString("fsb_block_client_ip");
                }
                logger.error((Object)"No available block client, ext property: %s", new Object[]{hostVO.getExtProperty()});
                throw new LegoCheckedException(1073948676L);
            }).collect(Collectors.toList());
        } else if (resourceVO instanceof HostVO) {
            HostVO hostVO2 = (HostVO)resourceVO;
            JSONObject ext = JSONObject.fromObject((Object)hostVO2.getExtProperty());
            ipList = Arrays.asList(ext.getString("fsb_block_client_ip"));
        } else {
            logger.error((Object)"Mount volume not support resource type, type\uff1a%s", new Object[]{resourceVO.getClass().getName()});
            throw new LegoCheckedException(100663460L);
        }
        JSONObject params = new JSONObject();
        params.put((Object)QUERY_VOLUME_BY_NAME, Arrays.asList(volName));
        params.put((Object)"ipList", ipList);
        try {
            connection.postForObject("/volume/attach", params);
            logger.debug((Object)"Mount vol finished. dev:%s,  lun id:%s,resource name:%s", new Object[]{devSn, lun.getLunId(), resourceVO.getName()});
            return new OperationResult("ism.drm.mappingluntohost.operation", true, true, new String[]{resourceVO.getName()});
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)"Mount volume got error, dev:%s, lun:%s, resource:%s", new Object[]{devSn, lun.toString(), resourceVO.toString()});
            return new OperationResult("ism.drm.mappingluntohost.operation", true, false, String.valueOf(ex.getErrorCode()), new String[]{resourceVO.getName()});
        }
    }

    private OperationResult mapping(String devSn, Lun lun, ResourceVO resourceVO) {
        FusionStorageCommonUtil.paramsCheck(devSn, lun, resourceVO);
        logger.debug((Object)"Mapping lun start, devSn:%s, lun:%s, resourceVO:%s", new Object[]{devSn, lun.toString(), resourceVO.toString()});
        try {
            if (resourceVO instanceof HostGroupVO) {
                HostGroupVO groupVO = (HostGroupVO)resourceVO;
                List<HostVO> hostVOs = this.extractHostsHaveMapping(devSn, groupVO);
                for (HostVO hostVO : hostVOs) {
                    OperationResult operationResult = this.mapping(devSn, lun, (ResourceVO)hostVO);
                    if (operationResult.isSuccess()) continue;
                    logger.error((Object)"Mapping host directly failed: hostGroupName=%s, host=%s", new Object[]{groupVO.getName(), hostVO});
                    return operationResult;
                }
                if (!VerifyUtil.isEmpty(hostVOs) && VerifyUtil.isEmpty((Collection)groupVO.getHostVOs())) {
                    return new OperationResult("ism.drm.mappingluntohost.operation", true, true, new String[]{groupVO.getName()});
                }
                String groupName = this.prepareHostGroup(devSn, groupVO, true);
                if (groupName == null) {
                    logger.error((Object)("Failed to prepare host group for " + groupVO.getName()));
                    return new OperationResult(PREPARE_GROUP_OPERATION, true, false, String.valueOf(1073948676L), new String[]{groupVO.getName()});
                }
                FusionStorageRestConnection connection = FusionStorageCommonUtil.getConnection(devSn);
                JSONObject params = new JSONObject();
                params.put((Object)"hostGroupName", (Object)groupName);
                params.put((Object)"lunList", Arrays.asList(lun.getName()));
                connection.postForObject("/hostGroup/lun/add", params);
                logger.debug((Object)"Mapping lun to host group finished. dev:%s,  lun id:%s,resource name:%s", new Object[]{devSn, lun.getLunId(), resourceVO.getName()});
                return new OperationResult(PREPARE_GROUP_OPERATION, true, true, new String[]{groupVO.getName()});
            }
            if (resourceVO instanceof HostVO) {
                HostVO hostVO = (HostVO)resourceVO;
                FusionStorageCommonUtil.paramsCheck(hostVO, lun, devSn);
                String hostname = this.prepareHost(devSn, hostVO);
                if (hostname == null) {
                    return new OperationResult(PREPARE_HOST_OPERATION, true, false, String.valueOf(1073948676L), new String[]{hostVO.getName()});
                }
                FusionStorageRestConnection connection = FusionStorageCommonUtil.getConnection(devSn);
                JSONArray jsonArray = new JSONArray();
                jsonArray.add((Object)lun.getName());
                JSONObject jsonObject = new JSONObject();
                jsonObject.put((Object)"hostName", (Object)hostname);
                jsonObject.put((Object)"lunNames", (Object)jsonArray);
                connection.postForObject("/host/lun/add", jsonObject);
                logger.debug((Object)"Mapping lun to host finished. dev:%s,  lun id:%s,resource name:%s", new Object[]{devSn, lun.getLunId(), resourceVO.getName()});
                return new OperationResult("ism.drm.mappingluntohost.operation", true, true, new String[]{hostVO.getName()});
            }
            logger.error((Object)("Mapping volume not support resource type, type\uff1a" + resourceVO.getClass().getName()));
            throw new LegoCheckedException(100663460L);
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)"Mapping volume got error, dev:%s, lun:%s, resource:%s", new Object[]{devSn, lun.toString(), resourceVO.toString()});
            if (FusionStorageConstants.FSB_LUN_AND_HOST_ALREADY_HAS_MAPPING.contains(ex.getErrorCode())) {
                return new OperationResult("ism.drm.mappingluntohost.operation", true, true, new String[]{resourceVO.getName()});
            }
            return new OperationResult("ism.drm.mappingluntohost.operation", true, false, String.valueOf(ex.getErrorCode()), new String[]{resourceVO.getName()});
        }
    }

    private List<HostVO> extractHostsHaveMapping(String devSn, HostGroupVO groupVO) {
        List<DrHost> hostList = this.queryHosts(devSn);
        HashMap hostMap = new HashMap();
        hostList.forEach(drHost -> hostMap.put(drHost.getIpAddress(), drHost.getName()));
        List<HostVO> hostsHaveMapping = ExecutionService.map((Collection)groupVO.getHostVOs(), hostVO -> {
            List<Lun> luns = this.queryLunOfHost(devSn, (String)hostMap.get(hostVO.getIpAddress()));
            if (!VerifyUtil.isEmpty(luns)) {
                return hostVO;
            }
            return null;
        }).stream().filter(Objects::nonNull).collect(Collectors.toList());
        boolean hasRemoved = groupVO.getHostVOs().removeAll(hostsHaveMapping);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"HostsHaveMapping that has mapping view: size=%s, isRemoved=%s", new Object[]{String.valueOf(hostsHaveMapping.size()), hasRemoved});
        }
        return hostsHaveMapping;
    }

    private List<DrHost> queryHosts(String devSn) {
        FusionStorageCommonUtil.paramsCheck(devSn);
        FusionStorageRestConnection connection = FusionStorageCommonUtil.getConnection(devSn);
        assert (connection != null);
        String res = connection.getForString("/host/list", null);
        JSONObject result = JSONObject.fromObject((Object)res);
        int resultCode = result.getInt("result");
        if (VerifyUtil.isEmpty((Object)resultCode) || resultCode != 0) {
            logger.error((Object)"QueryLunOfHost failed: response=%s", new Object[]{res});
            throw new LegoCheckedException(-1L);
        }
        JSONArray array = result.getJSONArray("hostList");
        List<DrHost> drHostList = array.filter(JSONObject.class).stream().map(this::covertToHost).collect(Collectors.toList());
        logger.debug((Object)"QueryHosts finished, devSn=%s, host size=%s,", new Object[]{devSn, drHostList.size()});
        return drHostList;
    }

    private DrHost covertToHost(JSONObject jsonObject) {
        DrHost drHost = new DrHost();
        drHost.setName(jsonObject.getString("hostName"));
        drHost.setIpAddress(jsonObject.getString("ipAddress"));
        drHost.setOsType(jsonObject.getString("osType"));
        drHost.setSiteId(jsonObject.getString("hostId"));
        return drHost;
    }

    private String prepareHost(String devSn, HostVO hostVO) {
        if (VerifyUtil.isEmpty((Collection)hostVO.getInitiators())) {
            logger.error((Object)"There is no initiators in host");
            return null;
        }
        List initiator2HostsList = ExecutionService.map((Collection)hostVO.getInitiators(), hostInitiator -> this.queryHostByInitiator(devSn, (Initiator)hostInitiator));
        Collection<Map.Entry<String, List<String>>> binded = this.filterInitiators(initiator2HostsList, true);
        String hostName = binded.stream().findFirst().map(e -> ((JSONArray)e.getValue()).filter(String.class).stream().findFirst().orElse(null)).orElseGet(() -> this.createHost(devSn, hostVO));
        if (hostName == null) {
            logger.error((Object)"Failed to create host for %s", new Object[]{hostVO.getName()});
            return null;
        }
        if (!binded.isEmpty()) {
            return hostName;
        }
        boolean done = this.filterInitiators(initiator2HostsList, false).stream().anyMatch(item -> this.addInitiatorToHost(devSn, (String)item.getKey(), hostName));
        if (!done) {
            logger.error((Object)"Failed to add initiator(s) to host. Initiator(s): %s", new Object[]{initiator2HostsList.stream().map(Map.Entry::getKey).collect(Collectors.toSet())});
            return null;
        }
        return hostName;
    }

    private String createHost(String devSn, HostVO hostVO) {
        FusionStorageCommonUtil.paramsCheck(devSn, hostVO);
        logger.debug((Object)"Create host for devSn start: %s, hostVO: %s", new Object[]{devSn, hostVO});
        FusionStorageRestConnection connection = FusionStorageCommonUtil.getConnection(devSn);
        String hostName = this.genName(hostVO.getName());
        JSONObject params = new JSONObject();
        params.put((Object)"hostName", (Object)hostName);
        try {
            connection.postForObject("/host/create", params);
            logger.debug((Object)"Create host for devSn finished. devSn:%s,  host name:%s", new Object[]{devSn, hostName});
            return hostName;
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)"Create host error. devSn:%s, addHostName=%s.", new Object[]{devSn, hostName});
            return null;
        }
    }

    private String prepareHostGroup(String devSn, HostGroupVO groupVO, boolean isNeedCreateHostGroup) {
        logger.debug((Object)"Prepare host group start. devSn=%s, HostGroupVO=%s, isNeedCreateHostGroup=%s.", new Object[]{devSn, groupVO.toString(), isNeedCreateHostGroup});
        List hosts = ExecutionService.map((Collection)groupVO.getHostVOs(), host -> new AbstractMap.SimpleEntry<HostVO, String>((HostVO)host, this.prepareHost(devSn, (HostVO)host)));
        Collection prepareHostFailedNames = hosts.stream().filter(host -> host.getValue() == null).map(host -> ((HostVO)host.getKey()).getName()).collect(Collectors.toSet());
        if (VerifyUtil.isEmpty((Collection)hosts) || !prepareHostFailedNames.isEmpty()) {
            logger.error((Object)"Prepare hosts failed: %s", new Object[]{prepareHostFailedNames});
            return null;
        }
        List hostGroupInfos = ExecutionService.map((Collection)hosts, item -> new AbstractMap.SimpleEntry(item.getValue(), this.queryGroupByHost(devSn, (String)item.getValue())));
        if (hostGroupInfos.size() != hosts.size()) {
            logger.error((Object)"Queried host group size is incorrect, host group size: %s, host size: %s", new Object[]{hostGroupInfos.size(), hosts.size()});
            return null;
        }
        Set belongedToGroupNames = hostGroupInfos.stream().filter(item -> item.getValue() != null).map(e -> (String)e.getValue()).collect(Collectors.toSet());
        if (belongedToGroupNames.size() > 1) {
            logger.error((Object)"Hosts is not in one group");
            return null;
        }
        String groupName = belongedToGroupNames.stream().findFirst().orElseGet(() -> isNeedCreateHostGroup ? this.createHostGroup(devSn, groupVO.getName()) : null);
        if (groupName == null) {
            logger.error((Object)"Fail to prepare host group for %s", new Object[]{groupVO.getName()});
            return null;
        }
        Collection queryGroupFailedHostNames = hostGroupInfos.stream().filter(hostGroupInfo -> hostGroupInfo.getValue() == null).map(hostGroupInfo -> (String)hostGroupInfo.getKey()).collect(Collectors.toSet());
        Set addFailedHostName = ExecutionService.map((Collection)queryGroupFailedHostNames, host -> this.addHostToGroup(devSn, (String)host, groupName)).stream().filter(host -> host != null).collect(Collectors.toSet());
        if (!addFailedHostName.isEmpty()) {
            logger.error((Object)"Fail to add host to group. host: %s", new Object[]{addFailedHostName});
            return null;
        }
        logger.debug((Object)"Prepare host group finished. devSN=%s, group name=%s. ", new Object[]{devSn, groupName});
        return groupName;
    }

    private String createHostGroup(String devSn, String hostGroupName) {
        FusionStorageCommonUtil.paramsCheck(devSn, hostGroupName);
        logger.debug((Object)"AddHostToGroup, devSn: %s, hostGroupName: %s", new Object[]{devSn, hostGroupName});
        FusionStorageRestConnection connection = FusionStorageCommonUtil.getConnection(devSn);
        hostGroupName = this.genName(hostGroupName);
        JSONObject params = new JSONObject();
        params.put((Object)"hostGroupName", (Object)hostGroupName);
        String res = connection.postForObject("/hostGroup/add", params);
        if (FusionStorageCommonUtil.isSuccessResult(res)) {
            return hostGroupName;
        }
        return null;
    }

    private boolean addInitiatorToHost(String devSn, String initiatorName, String hostName) {
        FusionStorageCommonUtil.paramsCheck(devSn, initiatorName, hostName);
        logger.debug((Object)"AddPortToHost start. devSn:%s, initiatorName:%s, hostName:%s", new Object[]{devSn, initiatorName, hostName});
        FusionStorageRestConnection connection = FusionStorageCommonUtil.getConnection(devSn);
        JSONObject params = new JSONObject();
        params.put((Object)"hostName", (Object)hostName);
        params.put((Object)"portNames", Arrays.asList(initiatorName));
        String jsonRes = connection.postForObject("/host/port/add", params);
        if (FusionStorageCommonUtil.isSuccessResult(jsonRes)) {
            logger.debug((Object)"AddPortToHost success. devSn:%s, initiatorName:%s, hostName:%s", new Object[]{devSn, initiatorName, hostName});
            return true;
        }
        return false;
    }

    private Collection<Map.Entry<String, List<String>>> filterInitiators(List<Map.Entry<String, List<String>>> initiator2HostsList, boolean binded) {
        return initiator2HostsList.stream().filter(item -> null != item && !VerifyUtil.isEmpty((Collection)((Collection)item.getValue())) == binded).collect(Collectors.toSet());
    }

    private Map.Entry<String, List<String>> queryHostByInitiator(String devSn, Initiator initiator) {
        FusionStorageCommonUtil.paramsCheck(devSn, initiator);
        logger.debug((Object)"QueryHostByInitiator start. devSn:%s, initiator:%s", new Object[]{devSn, initiator.toString()});
        String portName = initiator.getIdentity();
        JSONArray portNameArray = new JSONArray();
        portNameArray.add((Object)portName);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"portName", (Object)portNameArray);
        FusionStorageRestConnection connection = FusionStorageCommonUtil.getConnection(devSn);
        String jsonRes = connection.postForObject("/host/port/list", jsonObject);
        Object hostName = null;
        if (FusionStorageCommonUtil.isSuccessResult(jsonRes)) {
            JSONObject jsonObjectRes = JSONObject.fromObject((Object)jsonRes);
            JSONObject map = jsonObjectRes.getJSONObject("portHostMap");
            hostName = map.getJSONArray(initiator.getIdentity());
        }
        if (null == hostName) {
            logger.error((Object)"Initiator: %s has no bound hosts.", new Object[]{initiator.toString()});
            hostName = Collections.emptyList();
        }
        logger.debug((Object)"QueryHostByInitiator finished. devSn:%s, initiator:%s, host size:%s", new Object[]{devSn, initiator.toString(), hostName.size()});
        return new AbstractMap.SimpleEntry<String, Object>(initiator.getIdentity(), hostName);
    }

    private String genName(String name) {
        String genName = "RD-" + name + '-' + Long.toHexString(System.currentTimeMillis());
        return genName.length() > 31 ? "RD-" + Long.toHexString(System.currentTimeMillis()) : genName;
    }

    private String addHostToGroup(String devSn, String host, String group) {
        FusionStorageCommonUtil.paramsCheck(devSn, host, group);
        logger.debug((Object)"AddHostToGroup, devSn:%s, host:%s, group:%s", new Object[]{devSn, host, group});
        FusionStorageRestConnection connection = FusionStorageCommonUtil.getConnection(devSn);
        JSONObject params = new JSONObject();
        params.put((Object)"hostGroupName", (Object)group);
        params.put((Object)"hostList", Arrays.asList(host));
        try {
            connection.postForObject("/hostGroup/host/add", params);
            return null;
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)"Add host to group error, devSn = %s, hostname = %s, group =%s.", new Object[]{devSn, host, group});
            return host;
        }
    }

    private String queryGroupByHost(String devSn, String host) {
        FusionStorageCommonUtil.paramsCheck(devSn, host);
        logger.debug((Object)"QueryGroupByHost start, devSn:%s, host:%s", new Object[]{devSn, host});
        FusionStorageRestConnection connection = FusionStorageCommonUtil.getConnection(devSn);
        JSONObject params = new JSONObject();
        params.put((Object)"hostName", Arrays.asList(host));
        String res = connection.postForObject("/host/hostGroup/list", params);
        JSONObject object = JSONObject.fromObject((Object)res);
        JSONObject hostGroupJson = (JSONObject)object.get("hostGroup");
        JSONArray array = (JSONArray)hostGroupJson.get(host);
        logger.debug((Object)"QueryGroupByHost finished. host: %s, host group info: %s", new Object[]{host, array});
        return array != null ? array.get(0).toString() : null;
    }

    public List<Snapshot> querySnapshotByLun(String deviceSn, String volumeName) {
        FusionStorageCommonUtil.paramsCheck(deviceSn, volumeName);
        logger.debug((Object)"QuerySnapshotByLun start, devSn:%s, volumeName:%s", new Object[]{deviceSn, volumeName});
        FusionStorageRestConnection connection = FusionStorageCommonUtil.getConnection(deviceSn);
        int batchLimit = 1000;
        int batchNum = 1;
        TreeSet<Snapshot> snapshotSet = new TreeSet<Snapshot>(Comparator.comparing(Snapshot::getSnapshotId));
        boolean run = true;
        while (run) {
            JSONObject params = new JSONObject();
            params.put((Object)"batchLimit", (Object)batchLimit);
            params.put((Object)"batchNum", (Object)batchNum++);
            String res = connection.postForObject("/volume/snapshot/list", params);
            JSONObject response = JSONObject.fromObject((Object)res);
            if (null == response.get("snapshotList")) {
                logger.error((Object)"Json response got error! snapshotList not exist. deviceSn=%s, volumeName=%s.", new Object[]{deviceSn, volumeName});
                throw new LegoCheckedException(1073947393L);
            }
            List snapshotJsonList = (List)response.get("snapshotList");
            List snapshotAtOnePage = snapshotJsonList.stream().map(jsonObject -> FusionStorageRestTransition.transitionSnapshot(deviceSn, jsonObject)).collect(Collectors.toList());
            snapshotSet.addAll(snapshotAtOnePage);
            run = snapshotAtOnePage.size() == batchLimit;
        }
        logger.debug((Object)"QuerySnapshotByLun finished, devSn:%s, volumeName:%s, snapshotSet size:%s", new Object[]{deviceSn, volumeName, snapshotSet.size()});
        return new ArrayList<Snapshot>(snapshotSet);
    }

    public List<VolumeAttachNode> queryVolumeAttachNodes(String deviceSn, String volumeName) {
        FusionStorageCommonUtil.paramsCheck(deviceSn, volumeName);
        logger.debug((Object)"QueryVolumeAttachNodes start, devSn:%s, volumeName:%s", new Object[]{deviceSn, volumeName});
        FusionStorageRestConnection connection = FusionStorageCommonUtil.getConnection(deviceSn);
        StringBuilder url = new StringBuilder("/volume/attachNodes");
        url.append("?volName=").append(volumeName);
        String res = connection.getForString(url.toString(), null);
        List nodes = null;
        if (FusionStorageCommonUtil.isSuccessResult(res)) {
            JSONObject jsonObject = JSONObject.fromObject((Object)res);
            JSONArray array = jsonObject.getJSONArray("volAttachNodeInfo");
            nodes = array.filter(JSONObject.class).stream().map(jsonNodeInfo -> this.convert2VolumeAttachNode((JSONObject)jsonNodeInfo, deviceSn)).collect(Collectors.toList());
            logger.debug((Object)"QueryVolumeAttachNodes finished, devSn:%s, volumeName:%s, snapshotSet size:%s", new Object[]{deviceSn, volumeName, nodes.size()});
        }
        return nodes;
    }

    private List<Lun> queryLunOfHost(String devSn, String hostName) {
        FusionStorageCommonUtil.paramsCheck(devSn, hostName);
        logger.debug((Object)"QueryLunOfHost start, devSn=%s volumeName=%s", new Object[]{devSn, hostName});
        FusionStorageRestConnection connection = FusionStorageCommonUtil.getConnection(devSn);
        assert (connection != null);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("hostName", hostName);
        String res = connection.postForObject("/host/lun/list", JSONObject.fromObject(params));
        JSONObject result = JSONObject.fromObject((Object)res);
        int resultCode = result.getInt("result");
        if (VerifyUtil.isEmpty((Object)resultCode) || resultCode != 0) {
            logger.error((Object)"QueryLunOfHost failed: response=%s", new Object[]{res});
            throw new LegoCheckedException(1073948705L);
        }
        JSONArray array = result.getJSONArray("hostLunList");
        List<Lun> nodes = array.filter(JSONObject.class).stream().map(this::covertToLun).collect(Collectors.toList());
        logger.debug((Object)"QueryLunOfHost finished, devSn=%s, hostName=%s, mapping view size=%s", new Object[]{devSn, hostName, nodes.size()});
        return nodes;
    }

    private Lun covertToLun(JSONObject jsonNodeInfo) {
        XveLun xveLun = new XveLun();
        xveLun.setLunId(jsonNodeInfo.getString("lunId"));
        xveLun.setName(jsonNodeInfo.getString("lunName"));
        return xveLun;
    }

    private VolumeAttachNode convert2VolumeAttachNode(JSONObject jsonNodeInfo, String deviceSn) {
        VolumeAttachNode node = new VolumeAttachNode();
        node.setDevName(jsonNodeInfo.getString("devName"));
        node.setNodeIp(jsonNodeInfo.getString("nodeIp"));
        node.setVolName(jsonNodeInfo.getString(QUERY_VOLUME_BY_NAME));
        node.setDevSn(deviceSn);
        return node;
    }

    public String getCloneVolNameBySnapshotId(String snapshotId) {
        if (VerifyUtil.isEmpty((String)snapshotId)) {
            logger.error((Object)"SnapshotId is null");
            throw new LegoCheckedException(1073947393L);
        }
        logger.debug((Object)"GetCloneVolNameBySnapshotId start, snapshotId: %s", new Object[]{snapshotId});
        String cloneVolName = snapshotId.replaceAll("_BAK$", "_Clone");
        logger.debug((Object)"GetCloneVolNameBySnapshotId finished, cloneVolName: %s", new Object[]{cloneVolName});
        return cloneVolName;
    }

    public Snapshot getSnapshotByName(String devSn, String snapshotName) {
        FusionStorageCommonUtil.paramsCheck(devSn, snapshotName);
        logger.debug((Object)"GetSnapshotByName, devSn:%s, snapshotName:%s", new Object[]{devSn, snapshotName});
        FusionStorageRestConnection connection = FusionStorageCommonUtil.getConnection(devSn);
        StringBuilder url = new StringBuilder("/snapshot/queryByName");
        url.append("?snapshotName=").append(snapshotName);
        try {
            String res = connection.getForString(url.toString(), null);
            JSONObject jsonObject = JSONObject.fromObject((Object)res);
            if (null == jsonObject.getJSONObject("snapshot")) {
                logger.error((Object)"Json response got error! snapshot not exist. request url =%s, response=%s.", new Object[]{url.toString(), res});
                throw new LegoCheckedException(1073947393L);
            }
            return FusionStorageRestTransition.transitionSnapshot(devSn, jsonObject.getJSONObject("snapshot"));
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"GetSnapshotByName got error, errorcode: %s, devSn: %s, snapshotName: %s", new Object[]{e.getErrorCode(), devSn, snapshotName});
            if (FusionStorageConstants.FSB_VOLUME_OR_SNAPSHOT_NOT_EXIST.contains(e.getErrorCode())) {
                return null;
            }
            throw e;
        }
    }

    public Lun getVolumeBySnapshot(String devSn, String snapshotName) {
        FusionStorageCommonUtil.paramsCheck(devSn, snapshotName);
        logger.debug((Object)"GetVolumeBySnapshot, devSn: %s, snapshotName: %s", new Object[]{devSn, snapshotName});
        String lunId = snapshotName.contains("-") ? snapshotName.split("-")[1] : snapshotName.split("_")[1];
        logger.debug((Object)"GetVolumeBySnapshot, devSn:%s, lunId: %s", new Object[]{devSn, lunId});
        return this.getVolumeByLunId(devSn, lunId);
    }

    public Lun getVolumeByLunId(String devSn, String lunId) {
        return this.getVolume(devSn, lunId, QUERY_VOLUME_BY_ID);
    }

    public Lun getVolumeByLunName(String devSn, String lunName) {
        return this.getVolume(devSn, lunName, QUERY_VOLUME_BY_NAME);
    }

    private Lun getVolume(String devSn, String param, String queryType) {
        StringBuilder url;
        FusionStorageCommonUtil.paramsCheck(devSn, param);
        logger.debug((Object)"GetVolume,devSn:%s, param:%s, queryType:%s", new Object[]{devSn, param, queryType});
        FusionStorageRestConnection connection = FusionStorageCommonUtil.getConnection(devSn);
        if (QUERY_VOLUME_BY_ID.equals(queryType)) {
            url = new StringBuilder("/volume/queryById");
        } else if (QUERY_VOLUME_BY_NAME.equals(queryType)) {
            url = new StringBuilder("/volume/queryByName");
        } else {
            logger.error((Object)"Get volume not support this queryType! queryType=%s", new Object[]{queryType});
            throw new LegoCheckedException(100663460L);
        }
        url.append('?').append(queryType).append('=').append(param);
        try {
            String res = connection.getForString(url.toString(), null);
            JSONObject jsonResponse = JSONObject.fromObject((Object)res);
            if (null == jsonResponse.getJSONObject("lunDetailInfo")) {
                logger.error((Object)"Get volume fail. lunDetailInfo not exist. devSn=%s, request url =%s, response str=%s.", new Object[]{devSn, url.toString(), res});
                throw new LegoCheckedException(1073947393L);
            }
            XveLun result = FusionStorageRestTransition.transitionLun(devSn, jsonResponse.getJSONObject("lunDetailInfo"));
            boolean isMap = this.isLunMappedBase(devSn, result.getName());
            result.setMapped(Boolean.valueOf(isMap));
            logger.debug((Object)"GetVolume success. devSn:%s, param:%s, queryType:%s. result lun:%s", new Object[]{devSn, param, queryType, result.toString()});
            return result;
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)"Get vol error, devSn=%s, request url =%s.", new Object[]{devSn, url.toString()});
            throw ex;
        }
    }

    public void createSnapshotConsistent(String devSn, List<String> snapshotNames) {
        FusionStorageCommonUtil.paramsCheck(devSn, snapshotNames);
        logger.debug((Object)"CreateSnapshotConsistent, devSn:%s, snapshotNames: %s", new Object[]{devSn, snapshotNames.toString()});
        long timeout = LegoConfig.getInstance().getNumber("fsb_query_pair_timeout", 60L);
        long count = LegoConfig.getInstance().getNumber("fsb_query_pair_count", 15L);
        logger.info((Object)"Query fsb volNames timeout: %s, count: %s", new Object[]{timeout, count});
        FusionStorageRestConnection connection = FusionStorageCommonUtil.getConnection(devSn);
        List volNames = ExecutionService.map(snapshotNames, snapshotId -> this.getVolumeBySnapshot(devSn, (String)snapshotId).getName(), null, (int)((int)timeout), (int)((int)count));
        JSONObject params = new JSONObject();
        params.put((Object)"volNameList", (Object)volNames);
        params.put((Object)"snapshotNameList", snapshotNames);
        connection.postForObject("/snapshot/createConsistentByName", params);
    }

    public ReplicationRelation queryReplication(String deviceSN, String replicationId, boolean isConsistentGroup) {
        FusionStorageCommonUtil.paramsCheck(deviceSN, replicationId);
        logger.debug((Object)"QueryReplication, devSn: %s, replicationId: %s, is CG: %s", new Object[]{deviceSN, replicationId, isConsistentGroup});
        FusionStorageRestConnection connection = FusionStorageCommonUtil.getConnection(deviceSN);
        HashMap<String, String> params = new HashMap<String, String>();
        ManagedObject unitMo = CommonDAOLocator.getMoDao().getMoByUuid(deviceSN, Boolean.valueOf(true));
        params.put("id", replicationId);
        String requestUrl = "/CONSISTENTGROUP/{id}";
        if (!isConsistentGroup) {
            requestUrl = "/REPLICATIONPAIR/{id}";
        }
        try {
            String res = connection.getForString(requestUrl, params);
            JSONObject jsonObject = JSONObject.fromObject((Object)res);
            if (null == jsonObject.getJSONArray("data")) {
                logger.error((Object)"Json response got fail! data not exist. requestUrl=%s, replicationId=%s,response=[%s]", new Object[]{requestUrl, replicationId, res});
                return null;
            }
            if (isConsistentGroup) {
                return FusionStorageRestTransition.transitionReplicationGroup(deviceSN, jsonObject.getJSONArray("data").getJSONObject(0));
            }
            return FusionStorageRestTransition.transitionReplicationPair(deviceSN, jsonObject.getJSONObject("data"), unitMo.getTopMoUuid());
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)"The cg or pair does not exist. errorCode:%s. [devSn:%s, replicationId:%s, CG:%s]", new Object[]{ex.getErrorCode(), deviceSN, replicationId, isConsistentGroup});
            if (CG_NOT_EXIST_ERRORCODE.equals(ex.getErrorCode()) || PAIR_NOT_EXIST_ERROR_CODE.equals(ex.getErrorCode())) {
                return null;
            }
            throw ex;
        }
    }

    public void deleteVolByName(String devSn, String volName) {
        Lun lun;
        FusionStorageRestConnection connection;
        block3: {
            FusionStorageCommonUtil.paramsCheck(devSn, volName);
            logger.debug((Object)"Delete Volume by name , devSn:%s, volName:%s", new Object[]{devSn, volName});
            connection = FusionStorageCommonUtil.getConnection(devSn);
            lun = null;
            try {
                lun = this.getVolumeByLunName(devSn, volName);
            }
            catch (LegoCheckedException ex) {
                if (!FusionStorageConstants.FSB_VOLUME_OR_SNAPSHOT_NOT_EXIST.contains(ex.getErrorCode())) break block3;
                logger.debug((Object)"Volume not exist, volName:%s, devSn:%s", new Object[]{volName, devSn});
                return;
            }
        }
        if (lun == null) {
            logger.error((Object)"Get volume got error, volName:%s, devSn:%s", new Object[]{volName, devSn});
            throw new LegoCheckedException(1073948461L);
        }
        JSONObject params = new JSONObject();
        params.put((Object)"volNames", Arrays.asList(lun.getName()));
        connection.postForObject("/volume/delete", params);
    }

    public void expandVolByName(String devSn, String volName, Integer newVolSize) {
        Lun lun;
        FusionStorageRestConnection connection;
        block3: {
            FusionStorageCommonUtil.paramsCheck(devSn, volName, newVolSize);
            logger.debug((Object)"Expand volume by name , devSn:%s, volName:%s, newVolSize:%s", new Object[]{devSn, volName, newVolSize});
            connection = FusionStorageCommonUtil.getConnection(devSn);
            lun = null;
            try {
                lun = this.getVolumeByLunName(devSn, volName);
            }
            catch (LegoCheckedException ex) {
                if (!FusionStorageConstants.FSB_VOLUME_OR_SNAPSHOT_NOT_EXIST.contains(ex.getErrorCode())) break block3;
                logger.debug((Object)"Volume not exist, volName:%s", new Object[]{volName});
                return;
            }
        }
        if (lun == null) {
            logger.error((Object)"Get volume got error, volName:%s, devSn:%s", new Object[]{volName, devSn});
            throw new LegoCheckedException(1073948705L);
        }
        JSONObject params = new JSONObject();
        params.put((Object)QUERY_VOLUME_BY_NAME, (Object)lun.getName());
        params.put((Object)"newVolSize", (Object)newVolSize);
        connection.postForObject("/volume/expand", params);
    }

    public StorageLicense getArrayLicense(String devSn) {
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        StorageLicense storageLicense = new StorageLicense();
        storageLicense.addFeature("10002", null);
        return storageLicense;
    }

    private static interface VolumeAction<Resource extends ResourceVO> {
        public OperationResult execute(String var1, Lun var2, Resource var3);
    }
}

