/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.fsb.service;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.recovery.sdk.model.HostGroupVO;
import com.huawei.ism.drm.recovery.sdk.model.HostVO;
import com.huawei.ism.drm.recovery.sdk.model.ResourceVO;
import com.huawei.ism.drm.storage.fsb.FusionStorageConstants;
import com.huawei.ism.drm.storage.fsb.connection.FusionStorageRestConnection;
import com.huawei.ism.drm.storage.fsb.connection.FusionStorageRestConnectionFactory;
import com.huawei.ism.drm.storage.fsb.handler.FusionStorageHandler;
import com.huawei.ism.drm.storage.fsb.service.IFusionStorageCommonManager;
import com.huawei.ism.drm.storage.fsb.util.FusionStorageCommonUtil;
import com.huawei.ism.drm.storage.fsb.util.FusionStorageRestTransition;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunManager;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class FusionStorageLunManagerAdapter
implements IFusionStorageCommonManager,
IStorageLunManager {
    private static final Log logger = LogFactory.getInstance(FusionStorageLunManagerAdapter.class);
    private FusionStorageHandler fusionStorageHanler;

    public FusionStorageHandler getFusionStorageHanler() {
        return this.fusionStorageHanler;
    }

    public void setFusionStorageHanler(FusionStorageHandler fusionStorageHanler) {
        this.fusionStorageHanler = fusionStorageHanler;
    }

    public List<Lun> queryLuns(String deviceSn, List<String> lunIds) {
        lunIds = CommonUtil.getOrEmpty(lunIds);
        FusionStorageCommonUtil.paramsCheck(deviceSn, lunIds);
        return ExecutionService.map((Collection)lunIds, lunId -> this.fusionStorageHanler.getVolumeByLunId(deviceSn, (String)lunId));
    }

    public List<Lun> queryLunsByNames(String deviceSn, List<String> lunNames) {
        lunNames = CommonUtil.getOrEmpty(lunNames);
        FusionStorageCommonUtil.paramsCheck(deviceSn, lunNames);
        return ExecutionService.map((Collection)lunNames, lunName -> this.fusionStorageHanler.getVolumeByLunName(deviceSn, (String)lunName));
    }

    public boolean isLunMapped(String deviceSN, String resourceId) {
        return this.fusionStorageHanler.isLunMapped(deviceSN, resourceId);
    }

    public String prepareMapping(String devSn, HostVO hostVo) {
        return null;
    }

    public OperationResult mappingLun(String deviceSN, String resourceId, HostVO hostVO) {
        String volumeName = this.fusionStorageHanler.getVolumeNameById(deviceSN, resourceId);
        return this.fusionStorageHanler.mapping(deviceSN, volumeName, (ResourceVO)hostVO);
    }

    public OperationResult removeLunMapping(String devSn, String resourceId, HostVO hostVO) {
        String volumeName = this.fusionStorageHanler.getVolumeNameById(devSn, resourceId);
        return this.fusionStorageHanler.unmapping(devSn, volumeName, (ResourceVO)hostVO);
    }

    public String prepareMapping(String devSn, HostGroupVO hostGroupVo) {
        return null;
    }

    public OperationResult mappingLun(String deviceSN, String resourceId, HostGroupVO hostGroupVO) {
        String volumeName = this.fusionStorageHanler.getVolumeNameById(deviceSN, resourceId);
        return this.fusionStorageHanler.mapping(deviceSN, volumeName, (ResourceVO)hostGroupVO);
    }

    public OperationResult removeLunMapping(String deviceSN, String resourceId, HostGroupVO hostGroupVO) {
        String volumeName = this.fusionStorageHanler.getVolumeNameById(deviceSN, resourceId);
        return this.fusionStorageHanler.unmapping(deviceSN, volumeName, (ResourceVO)hostGroupVO);
    }

    public OperationResult addLunToLunGroup(String devSn, String resourceId, List<HostVO> hostVoList, String lunGroupId, Map<String, Object> caches) {
        throw new LegoCheckedException(100663460L, "Not Supported");
    }

    public Lun createLun(Lun lun) {
        if (null == lun) {
            logger.error((Object)"Create lun fail, invalid input param.");
            return null;
        }
        FusionStorageRestConnection connection = FusionStorageRestConnectionFactory.getInstance().getConnection(lun.getDevSn());
        JSONObject params = new JSONObject();
        params.put((Object)"volName", (Object)lun.getName());
        params.put((Object)"volSize", (Object)lun.getCapacity());
        params.put((Object)"poolId", (Object)NumberUtil.convertToInteger((Object)lun.getStoragePoolId()));
        String response = connection.post("/volume/create", params.toString(), null);
        if (!FusionStorageCommonUtil.isSuccessResult(response)) {
            logger.error((Object)"Create lun fail. create lun info[devSn=%s, poolId=%s, volName=%s, volSize=%s], response str=%s", new Object[]{lun.getDevSn(), lun.getStoragePoolId(), lun.getName(), lun.getCapacity(), response});
            return null;
        }
        lun = this.fusionStorageHanler.getVolumeByLunName(lun.getDevSn(), lun.getName());
        return lun;
    }

    public void deleteLun(String devSN, String ... volNames) {
        if (null == devSN) {
            logger.error((Object)"Delete lun fail, input param is null.");
            return;
        }
        FusionStorageRestConnection connection = FusionStorageRestConnectionFactory.getInstance().getConnection(devSN);
        JSONObject params = new JSONObject();
        params.put((Object)"volNames", (Object)volNames);
        String response = connection.post("/volume/delete", params.toString(), null);
        if (!FusionStorageCommonUtil.isSuccessResult(response)) {
            logger.error((Object)"Delete lun fail. devSn=%s, params=%s, response str=%s", new Object[]{devSN, params.toString(), response});
            throw new LegoCheckedException(1073947649L);
        }
    }

    public Lun getLunById(String devSN, String lunId) {
        if (null == devSN || null == lunId) {
            logger.error((Object)"input param is null. devSn=%s, lunId=%s.", new Object[]{devSN, lunId});
            return null;
        }
        return this.fusionStorageHanler.getVolumeByLunId(devSN, lunId);
    }

    public Lun getLunByWWN(String devSN, String lunWWN) {
        if (null == devSN || null == lunWWN) {
            logger.error((Object)"Delete lun fail, input param is null.devSn=%s, lunWWn=%s.", new Object[]{devSN, lunWWN});
            return null;
        }
        FusionStorageRestConnection connection = FusionStorageRestConnectionFactory.getInstance().getConnection(devSN);
        StringBuilder url = new StringBuilder("/lun/wwn/list");
        url.append('?').append("wwn").append("=0x").append(lunWWN);
        String res = connection.getForString(url.toString(), null);
        JSONObject jsonResponse = JSONObject.fromObject((Object)res);
        if (jsonResponse.containsKey((Object)"errorCode") && "32151404".equals(jsonResponse.getString("errorCode"))) {
            logger.error((Object)"get Lun by WWN fail. request url = %s, response str = %s.", new Object[]{url, res});
            return null;
        }
        if (null == jsonResponse.getJSONObject("lunDetailInfo")) {
            logger.error((Object)"json response got error! lunDetailInfo not exist. request url = %s, response str = %s.", new Object[]{url, res});
            throw new LegoCheckedException(1073947393L);
        }
        return FusionStorageRestTransition.transitionLun(devSN, jsonResponse.getJSONObject("lunDetailInfo"));
    }

    public Lun getLunByName(String devSN, String lunName) {
        Lun lun;
        if (null == devSN || null == lunName) {
            logger.error((Object)"get lun by name fail, input param is null. devS=%s, lunName=%s.", new Object[]{devSN, lunName});
            return null;
        }
        try {
            lun = this.fusionStorageHanler.getVolumeByLunName(devSN, lunName);
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)"get lun by name fail, devSn:%s, volName:%s. ", new Object[]{devSN, lunName});
            if (FusionStorageConstants.FSB_VOLUME_OR_SNAPSHOT_NOT_EXIST.contains(ex.getErrorCode())) {
                logger.debug((Object)"volume not exist.");
                return null;
            }
            return null;
        }
        return lun;
    }

    public boolean expandLun(Lun lun) {
        if (null == lun) {
            logger.error((Object)"Expand lun fail, invalid input param.");
            return false;
        }
        this.fusionStorageHanler.expandVolByName(lun.getDevSn(), lun.getName(), Math.toIntExact(lun.getCapacity()));
        return true;
    }

    public List<Lun> queryLunsWithHostName(String deviceSn, List<String> lunIds) {
        return Collections.emptyList();
    }

    public List<Lun> queryAllLunsBySn(String deviceSn) {
        return Collections.emptyList();
    }
}

