/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.fsb.service;

import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.sdk.constant.DmEnumDefine;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.storage.fsb.connection.FusionStorageRestConnection;
import com.huawei.ism.drm.storage.fsb.connection.FusionStorageRestConnectionFactory;
import com.huawei.ism.drm.storage.fsb.handler.FusionStorageHandler;
import com.huawei.ism.drm.storage.fsb.service.IFusionStorageCommonManager;
import com.huawei.ism.drm.storage.fsb.util.FusionStorageCommonUtil;
import com.huawei.ism.drm.storage.fsb.util.FusionStorageRestTransition;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationLink;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.service.fusion.IStorageReplicationFusionService;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class FusionStorageReplicationManagerAdapter
implements IFusionStorageCommonManager,
IStorageReplicationFusionService {
    private static final Log logger = LogFactory.getInstance(FusionStorageReplicationManagerAdapter.class);
    private static final int PAGE_SIZE = 40;
    private FusionStorageHandler fusionStorageHanler;

    public FusionStorageHandler getFusionStorageHanler() {
        return this.fusionStorageHanler;
    }

    public void setFusionStorageHanler(FusionStorageHandler fusionStorageHanler) {
        this.fusionStorageHanler = fusionStorageHanler;
    }

    public List<String> supportedDeviceList() {
        return null;
    }

    public List<ReplicationTargetLun> querySyncStatus(String sourceArrayId, String targetArrayId, String replicationId, boolean isConsistentGroup) {
        logger.debug((Object)("query sync status. sourceArrayId=" + sourceArrayId + ", targetArrayId=" + targetArrayId + ", replicationId=" + replicationId + ", isConsistentGroup=" + isConsistentGroup));
        ReplicationRelation relation = this.getReplication(sourceArrayId, targetArrayId, replicationId, isConsistentGroup);
        if (null == relation) {
            logger.error((Object)("Replication does not exist. SrcDevId:" + sourceArrayId + ",TgtDevId:" + targetArrayId + ",replicationId:" + replicationId + ",isConsistentGroup:" + isConsistentGroup), 90160758784001L);
            if (isConsistentGroup) {
                throw new LegoCheckedException(1073948767L, new String[]{replicationId});
            }
            throw new LegoCheckedException(1073948677L, new String[]{replicationId});
        }
        FusionStorageRestConnection connection = FusionStorageRestConnectionFactory.getInstance().getConnection(relation.getDevSn());
        List<Object> tgtLunList = new ArrayList<ReplicationTargetLun>();
        if (relation instanceof ReplicationGroup) {
            JSONArray resultList = connection.getStringBatch("/REPLICATIONPAIR?filter=CGID::" + relation.getReplicationId(), 0, 40);
            tgtLunList = resultList.filter(JSONObject.class).stream().map(item -> FusionStorageRestTransition.transitionReplicationTargetLun(relation.getDevSn(), item)).collect(Collectors.toList());
        } else {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("id", replicationId);
            String resultStr = connection.getForString("/REPLICATIONPAIR/{id}", params);
            JSONObject jsonObject = JSONObject.fromObject((Object)resultStr);
            if (null == jsonObject.getJSONObject("data")) {
                logger.error((Object)"json response got error! replication pair not exist. devSn=%s, replicationID=%s, response str=%s.", new Object[]{relation.getDevSn(), replicationId, resultStr});
                throw new LegoCheckedException(1073947393L);
            }
            tgtLunList.add(FusionStorageRestTransition.transitionReplicationTargetLun(relation.getDevSn(), jsonObject.getJSONObject("data")));
        }
        this.updateSyncInfo(tgtLunList);
        logger.debug((Object)("query sync status, target lun list size: " + tgtLunList.size()));
        return tgtLunList;
    }

    public List<ReplicationPair> queryReplications(String deviceSn, String resourceId, Integer resourceType) {
        logger.debug((Object)("query Replications. deviceSn=" + deviceSn + ", resourceId=" + resourceId));
        FusionStorageRestConnection connection = FusionStorageRestConnectionFactory.getInstance().getConnection(deviceSn);
        ManagedObject unitMo = CommonDAOLocator.getMoDao().getMoByUuid(deviceSn, Boolean.valueOf(true));
        StringBuilder sb = new StringBuilder("/REPLICATIONPAIR/associate");
        sb.append("?ASSOCIATEOBJTYPE=").append(String.valueOf(XveMOType.LUN.getValue()));
        sb.append("&ASSOCIATEOBJID=").append(resourceId);
        JSONArray resultList = connection.getStringBatch(sb.toString(), 0, 40);
        List replicationPairList = resultList.filter(JSONObject.class).stream().map(item -> FusionStorageRestTransition.transitionReplicationPair(deviceSn, item, unitMo.getTopMoUuid())).collect(Collectors.toList());
        logger.debug((Object)("query replication, replication pair list size: " + replicationPairList.size()));
        List<ReplicationPair> filterReplicationPairList = replicationPairList.stream().filter(pair -> {
            boolean isPrimaryLun = resourceId.equals(pair.getSrcLunId()) && deviceSn.equals(pair.getSrcDevSN());
            boolean isSecondaryLun = resourceId.equals(pair.getTgtLunId()) && deviceSn.equals(pair.getTgtDevSN());
            return isPrimaryLun || isSecondaryLun;
        }).collect(Collectors.toList());
        if (replicationPairList.size() != filterReplicationPairList.size()) {
            logger.error((Object)("filter size not equal:old:" + replicationPairList.size() + " new:" + filterReplicationPairList.size()));
        }
        return filterReplicationPairList;
    }

    public void changeRate(String sn, String id, boolean isCg, DmEnumDefine.SPEED_LEVEL_E rate) {
        logger.debug((Object)("Enter change replications rate, sn=" + sn + ", id=" + id + ", isCg=" + isCg + ", rate=" + rate));
        VerifyUtil.checkStrs((String[])new String[]{sn, id});
        DmEnumDefine.SPEED_LEVEL_E sl = null == rate ? DmEnumDefine.SPEED_LEVEL_E.SPEED_LEVEL_MIDDLE : rate;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("SPEED", sl.getValue());
        this.modify(sn, id, isCg, params);
        logger.debug((Object)"Exit change replications rate.");
    }

    public void modify(String sn, String id, boolean isCg, Map<String, Object> params) {
        String operationName;
        String url;
        logger.debug((Object)("Begin modify, sn=" + sn + ", id=" + id + ", isCg=" + isCg + ", " + params));
        VerifyUtil.checkStrs((String[])new String[]{sn, id});
        if (VerifyUtil.isEmpty(params)) {
            logger.error((Object)"info can not be empty.");
            throw new LegoCheckedException(1073947393L);
        }
        JSONObject jsonObject = new JSONObject();
        params.entrySet().forEach(e -> jsonObject.put(e.getKey(), e.getValue()));
        logger.debug((Object)("transform result = " + jsonObject.toString()));
        if (isCg) {
            url = "/CONSISTENTGROUP";
            operationName = "ism.business.replication.modifyReplicationGroup";
        } else {
            url = "/REPLICATIONPAIR";
            operationName = "ism.business.replication.modifyReplicationPair";
        }
        url = url + '/' + id;
        OperationResult result = this.processCommand(sn, operationName, url, jsonObject);
        if (null == result) {
            logger.error((Object)"modify policy got error, result is null. devSn:%s, url:%s, params:%s", new Object[]{sn, url, jsonObject.toString()});
            return;
        }
        if (!result.isSuccess()) {
            logger.error((Object)"modify policy got error. devSn:%s, url:%s, params:%s, response str=%s.", new Object[]{sn, url, jsonObject.toString(), result});
            return;
        }
        logger.debug((Object)"End modify.success!");
    }

    public ReplicationRelation queryReplicationRelation(String sn, String id, boolean isCG) {
        return this.fusionStorageHanler.queryReplication(sn, id, isCG);
    }

    public List<ReplicationPair> queryReplications(String deviceSn, Collection<String> resources, Integer resourceType) {
        logger.info((Object)("deviceSn=" + deviceSn));
        return this.getAllReplicationPairs(deviceSn, null);
    }

    public ReplicationRelation getReplication(String sourceArrayId, String targetArrayId, String replicationId, boolean isConsistentGroup) {
        String deviceId = sourceArrayId;
        ReplicationRelation replication = null;
        try {
            logger.debug((Object)"query replication relation from sourceArray.");
            try {
                replication = this.queryReplicationRelation(sourceArrayId, replicationId, isConsistentGroup);
            }
            catch (Exception e) {
                logger.error((Object)"query replication error, sourceArrayId: %s, replicationId: %s", new Object[]{sourceArrayId, replicationId});
                replication = null;
            }
            if (null == replication || !replication.getIsPrimary().booleanValue()) {
                logger.debug((Object)"query replication relation from targetArray.");
                replication = this.queryReplicationRelation(targetArrayId, replicationId, isConsistentGroup);
                deviceId = replication != null ? targetArrayId : deviceId;
            }
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)"query replication relation fail.replication[id=%s, sourceArrayId=%s, targetArrayId=%s]", new Object[]{replicationId, sourceArrayId, targetArrayId});
            if (2117645L == ex.getErrorCode()) {
                replication = this.queryReplicationRelation(targetArrayId, replicationId, isConsistentGroup);
                deviceId = replication != null ? targetArrayId : deviceId;
            }
            throw ex;
        }
        if (null != replication) {
            replication.setDevSn(deviceId);
            logger.debug((Object)"query replication relation success. replication id:%s, devSn: %s ", new Object[]{replication.getReplicationId(), deviceId});
        }
        return replication;
    }

    public OperationResult processCommand(String deviceId, String operationName, String url, JSONObject bodyJson) {
        url = "{rest}/" + url.replaceFirst("^/", "");
        return super.processCommand(deviceId, operationName, url, bodyJson);
    }

    public void dispatchCommand(String deviceId, String url, Object data) {
        FusionStorageRestConnectionFactory.getInstance().getConnection(deviceId).postForObject(url, data);
    }

    public List<ReplicationPair> getAllReplicationPairs(String deviceSn, String vstoreId) {
        logger.debug((Object)"get all replication pairs start. deviceSn=%s, vstoreId=%s", new Object[]{deviceSn, vstoreId});
        if (VerifyUtil.isEmpty((String)deviceSn)) {
            return new ArrayList<ReplicationPair>();
        }
        ManagedObject unitMo = CommonDAOLocator.getMoDao().getMoByUuid(deviceSn, Boolean.valueOf(true));
        FusionStorageRestConnection connection = FusionStorageRestConnectionFactory.getInstance().getConnection(deviceSn);
        JSONArray resultList = connection.getStringBatch("/REPLICATIONPAIR", 0, 40);
        List<ReplicationPair> replicationPairList = resultList.filter(JSONObject.class).stream().map(jsonArray -> FusionStorageRestTransition.transitionReplicationPair(deviceSn, jsonArray, unitMo.getTopMoUuid())).collect(Collectors.toList());
        logger.debug((Object)("get all replication pairs finished, replication pair list size: " + replicationPairList.size()));
        return replicationPairList;
    }

    public List<ReplicationGroup> getAllReplicationGroups(String deviceSn) {
        logger.debug((Object)"get all replication groups start. deviceSn=%s", new Object[]{deviceSn});
        if (VerifyUtil.isEmpty((String)deviceSn)) {
            return new ArrayList<ReplicationGroup>();
        }
        FusionStorageRestConnection connection = FusionStorageRestConnectionFactory.getInstance().getConnection(deviceSn);
        JSONArray resultList = connection.getStringBatch("/CONSISTENTGROUP", 0, 40);
        List<ReplicationGroup> replicationGroupList = resultList.filter(JSONObject.class).stream().map(item -> FusionStorageRestTransition.transitionReplicationGroup(deviceSn, item)).collect(Collectors.toList());
        logger.debug((Object)("get all replication groups finished, replication group list size: " + replicationGroupList.size()));
        return replicationGroupList;
    }

    public ReplicationPair createReplicationPair(ReplicationPair pair) {
        if (null == pair || null == pair.getTgtDevSN()) {
            logger.error((Object)"Create replication pair fail, invalid input param.");
            return null;
        }
        logger.debug((Object)"Create replication pair start. pairId=%s, devSn:%s", new Object[]{pair.getId(), pair.getSrcDevSN()});
        FusionStorageRestConnection connection = FusionStorageRestConnectionFactory.getInstance().getConnection(pair.getSrcDevSN());
        JSONObject params = new JSONObject();
        params.put((Object)"LOCALRESID", (Object)pair.getSrcLunId());
        params.put((Object)"LOCALRESTYPE", (Object)"11");
        params.put((Object)"REMOTEDEVICEID", (Object)this.getRemoteDeviceId(pair.getSrcDevSN(), pair.getTgtDevSN()));
        params.put((Object)"REMOTERESID", (Object)pair.getTgtLunId());
        params.put((Object)"REPLICATIONMODEL", (Object)2);
        String response = connection.post("/REPLICATIONPAIR/?p", params.toString(), null);
        JSONObject responseJson = JSONObject.fromObject((Object)response);
        if (!FusionStorageCommonUtil.isSuccessResponse(responseJson)) {
            logger.error((Object)"Create replication pair fail. devSn=%s, params=%s,response str=%s.", new Object[]{pair.getSrcDevSN(), params.toString(), response});
            return null;
        }
        JSONObject pairData = responseJson.getJSONObject("data");
        pair.setId(pairData.getString("ID"));
        pair.setReplicationId(pairData.getString("ID"));
        pair.setReplicationMode(Integer.valueOf(2));
        logger.debug((Object)"Create replication pair success. pairId=%s", new Object[]{pair.getId()});
        return pair;
    }

    private String getRemoteDeviceId(String srcDevSN, String tgtDevSN) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("deviceId", srcDevSN);
        List linkList = CommonDAOLocator.getMoDao().findMoBy(ReplicationLink.class, props);
        HashSet snList = new HashSet();
        for (ReplicationLink replicationLink : linkList) {
            if (!tgtDevSN.equals(replicationLink.getRemoteArrayId())) continue;
            return replicationLink.getLinkId();
        }
        logger.error((Object)("can not find remoteDeviceId for srcDevSN:" + srcDevSN + " tgtDevSN:" + tgtDevSN));
        throw new LegoCheckedException(1073947393L);
    }

    public void deleteReplicationPair(ReplicationPair pair) {
        if (null == pair || VerifyUtil.isEmpty((String)pair.getSrcDevSN()) || VerifyUtil.isEmpty((String)pair.getTgtDevSN())) {
            logger.error((Object)"deleteReplicationPair fail, valid input params.");
            return;
        }
        if (!this.deleteReplicationPair(pair.getSrcDevSN(), pair.getReplicationId())) {
            logger.debug((Object)"retry deleteReplicationPair on peer site ...");
            this.deleteReplicationPair(pair.getTgtDevSN(), pair.getReplicationId());
        }
    }

    public ReplicationGroup createReplicationGroup(ReplicationGroup group) {
        if (null == group) {
            logger.error((Object)"Create CG fail, input param is null.");
            return null;
        }
        logger.debug((Object)("Create CG start. ReplicationGroup Id:" + group.getReplicationId()));
        FusionStorageRestConnection connection = FusionStorageRestConnectionFactory.getInstance().getConnection(group.getSrcDevSN());
        JSONObject params = new JSONObject();
        params.put((Object)"NAME", (Object)group.getName());
        params.put((Object)"REPLICATIONMODEL", (Object)2);
        if (group.getIsPrimary().booleanValue()) {
            params.put((Object)"REMOTEDEVICEID", (Object)this.getRemoteDeviceId(group.getSrcDevSN(), group.getTgtDevSN()));
        } else {
            params.put((Object)"REMOTEDEVICEID", (Object)this.getRemoteDeviceId(group.getTgtDevSN(), group.getSrcDevSN()));
        }
        String response = connection.post("/CONSISTENTGROUP/?p", params.toString(), null);
        JSONObject responseJson = JSONObject.fromObject((Object)response);
        if (!FusionStorageCommonUtil.isSuccessResponse(responseJson)) {
            logger.error((Object)"Create CG fail, response is [%s]. groupName=%s, DevSN=%s", new Object[]{response, group.getName(), group.getSrcDevSN()});
            return null;
        }
        JSONObject pairData = responseJson.getJSONObject("data");
        logger.debug((Object)("Create CG success. ReplicationGroup Id:" + group.getReplicationId()));
        return this.getReplicationGroup(group.getSrcDevSN(), pairData.getString("ID"));
    }

    public void deleteReplicationGroup(ReplicationGroup group) {
        if (null == group) {
            logger.error((Object)"Delete CG fail, input param is null.");
            return;
        }
        logger.debug((Object)("delete CG start. ReplicationGroup Id:" + group.getReplicationId()));
        FusionStorageRestConnection connection = FusionStorageRestConnectionFactory.getInstance().getConnection(group.getSrcDevSN());
        String response = connection.delete("/CONSISTENTGROUP/" + group.getReplicationId(), null, null);
        JSONObject responseJson = JSONObject.fromObject((Object)response);
        if (!FusionStorageCommonUtil.isSuccessResponse(responseJson)) {
            logger.error((Object)"Delete CG fail, response is [%s]. CgId=%s, DevSN=%s", new Object[]{response, group.getReplicationId(), group.getSrcDevSN()});
            throw new LegoCheckedException(1073947649L);
        }
        logger.debug((Object)("delete CG success. ReplicationGroup Id:" + group.getReplicationId()));
    }

    public ReplicationGroup addReplicationPair(ReplicationGroup group, List<ReplicationPair> pairList) {
        if (null == group || null == pairList) {
            logger.error((Object)"Add replication pair to CG fail, input param is null.");
            return null;
        }
        if (VerifyUtil.isEmpty(pairList)) {
            logger.error((Object)"Add replication pair to CG fail. Invalid parameter: pairList.");
            return null;
        }
        logger.debug((Object)"Add replication pair to CG start, cgId:%s, cg pair size:%d, add pair size:%d .", new Object[]{group.getReplicationId(), group.getReplicationPairs().size(), pairList.size()});
        FusionStorageRestConnection connection = FusionStorageRestConnectionFactory.getInstance().getConnection(group.getSrcDevSN());
        List<ReplicationPair> pairsInCg = this.queryReplicationPairByCgId(group.getSrcDevSN(), group.getReplicationId());
        Set pairIdInCgList = pairsInCg.stream().map(pair -> pair.getReplicationId()).collect(Collectors.toSet());
        JSONObject params = new JSONObject();
        params.put((Object)"ID", (Object)group.getReplicationId());
        List idList = pairList.stream().map(pair -> pair.getReplicationId()).collect(Collectors.toList());
        for (ReplicationPair pair2 : pairList) {
            String addId = pair2.getReplicationId();
            if (pairIdInCgList.contains(addId)) {
                pair2.setConsistentGroupId(group.getReplicationId());
                continue;
            }
            params.put((Object)"RMLIST", (Object)addId);
            String response = connection.postForObject("/ADD_MIRROR", params);
            JSONObject responseJson = JSONObject.fromObject((Object)response);
            if (!FusionStorageCommonUtil.isSuccessResponse(responseJson)) {
                logger.error((Object)("Add replication pair to CG fail for:" + addId));
                continue;
            }
            logger.debug((Object)"Add replication pair to CG success, pairId:%s, cgId:%s.", new Object[]{addId, group.getReplicationId()});
            pair2.setConsistentGroupId(group.getReplicationId());
        }
        group.getReplicationPairs().addAll(pairList);
        logger.debug((Object)"Add replication pair to CG finished. cgId:%s, cg pair size:%d.", new Object[]{group.getReplicationId(), group.getReplicationPairs().size()});
        return group;
    }

    public void removeReplicationPair(ReplicationGroup group, List<ReplicationPair> pairList) {
        if (null == group || null == pairList) {
            logger.error((Object)"Remove replication pair from CG fail, input param is null.");
            return;
        }
        if (VerifyUtil.isEmpty(pairList) || pairList.size() != 1) {
            logger.error((Object)"Remove replication pair from CG[id=%s,devSn=%s] fail. Invalid parameter: pairList.", new Object[]{group.getReplicationId(), group.getSrcDevSN()});
            return;
        }
        logger.debug((Object)"Remove replication pair from CG start, cgId:%s, cg pair size:%d, add pair size:%d .", new Object[]{group.getReplicationId(), group.getReplicationPairs().size(), pairList.size()});
        FusionStorageRestConnection connection = FusionStorageRestConnectionFactory.getInstance().getConnection(group.getSrcDevSN());
        List<ReplicationPair> pairsInCg = this.queryReplicationPairByCgId(group.getSrcDevSN(), group.getReplicationId());
        Set pairIdInCgList = pairsInCg.stream().map(pair -> pair.getReplicationId()).collect(Collectors.toSet());
        JSONObject params = new JSONObject();
        params.put((Object)"ID", (Object)group.getReplicationId());
        List idList = pairList.stream().map(pair -> pair.getReplicationId()).collect(Collectors.toList());
        for (String rmId : idList) {
            if (!pairIdInCgList.contains(rmId)) continue;
            params.put((Object)"RMLIST", (Object)rmId);
            logger.info((Object)("remove pair:" + rmId + " from cg:" + group.getReplicationId()));
            String response = connection.postForObject("/DEL_MIRROR", params);
            JSONObject responseJson = JSONObject.fromObject((Object)response);
            if (FusionStorageCommonUtil.isSuccessResponse(responseJson)) continue;
            logger.error((Object)"Remove replication pair from CG fail. devSn=%s, params=%s, response str=%s.", new Object[]{group.getDevSn(), params.toString(), response});
        }
        group.getReplicationPairs().removeAll(pairList);
        logger.debug((Object)"Remove replication pair from CG finished. cgId:%s, cg pair size:%d.", new Object[]{group.getReplicationId(), group.getReplicationPairs().size()});
    }

    private boolean deleteReplicationPair(String devSn, String pairId) {
        boolean optResult = true;
        logger.debug((Object)"delete replication pair. devSn=%s, pairId=%s", new Object[]{devSn, pairId});
        FusionStorageRestConnection connection = FusionStorageRestConnectionFactory.getInstance().getConnection(devSn);
        String response = connection.delete("/REPLICATIONPAIR/" + pairId + "?TOSYNCSRWHENDELETE=false", null, null);
        JSONObject responseJson = JSONObject.fromObject((Object)response);
        if (!FusionStorageCommonUtil.isSuccessResponse(responseJson)) {
            logger.error((Object)"delete replication pair fail.");
            logger.error((Object)"delete replication pair fail. devSn=%s, pairId=%s, response str=%s.", new Object[]{devSn, pairId, response});
            optResult = false;
        }
        logger.debug((Object)"delete replication pair success. devSn=%s, pairId=%s", new Object[]{devSn, pairId});
        return optResult;
    }

    public ReplicationGroup getReplicationGroup(String devSN, String groupId) {
        if (null == devSN || null == groupId) {
            logger.error((Object)"input param is null.");
            return null;
        }
        return (ReplicationGroup)this.fusionStorageHanler.queryReplication(devSN, groupId, true);
    }

    public ReplicationPair getReplicationPair(String devSN, String pairId) {
        return (ReplicationPair)this.fusionStorageHanler.queryReplication(devSN, pairId, false);
    }

    public List<ReplicationPair> queryReplicationPairByCgId(String devSN, String cgId) {
        logger.debug((Object)"query replication pair by CG start. devSn=%s, cgId=%s", new Object[]{devSN, cgId});
        FusionStorageRestConnection connection = FusionStorageRestConnectionFactory.getInstance().getConnection(devSN);
        JSONArray pairsArray = connection.getStringBatch("/REPLICATIONPAIR?filter=CGID::" + cgId, 0, 40);
        logger.debug((Object)"query replication pair by CG success. devSn=%s, cgId=%s, pairsArraySize=%s", new Object[]{devSN, cgId, pairsArray.size()});
        ManagedObject unitMo = CommonDAOLocator.getMoDao().getMoByUuid(devSN, Boolean.valueOf(true));
        return pairsArray.filter(JSONObject.class).stream().map(item -> FusionStorageRestTransition.transitionReplicationPair(connection.getDeviceId(), item, unitMo.getTopMoUuid())).collect(Collectors.toList());
    }

    public void refresh(String sn, List<String> ids, boolean isCg) {
        logger.info((Object)("Enter refresh repliations, sn=" + sn + ", ids=" + ids + ", isCg=" + isCg));
        if (VerifyUtil.isEmpty((String)sn) || VerifyUtil.isEmpty(ids)) {
            logger.info((Object)"sn or id list is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        IMoDao moDao = CommonDAOLocator.getMoDao();
        StorageUnit storageUnit = (StorageUnit)moDao.getMo(StorageUnit.class, "devSn", (Object)sn);
        ArrayList<ReplicationRelation> replications = new ArrayList<ReplicationRelation>();
        for (String id : ids) {
            ReplicationRelation replication = this.queryReplicationRelation(sn, id, isCg);
            if (null == replication) {
                logger.warn((Object)("replication not exsit, id=" + id));
                continue;
            }
            replications.add(replication);
            replication.setParentMo((ManagedObject)storageUnit);
            replication.setTopMoUuid(storageUnit.getTopMoUuid());
        }
        logger.info((Object)("Replications to be saved, " + replications));
        for (ReplicationRelation rel : replications) {
            moDao.addMoAndSubMoWithoutMsg((ManagedObject)(isCg ? (ReplicationGroup)rel : (ReplicationPair)rel), new HashMap());
        }
        logger.info((Object)"Exit refresh repliations.");
    }
}

