/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.fsb.service;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.recovery.sdk.model.HostGroupVO;
import com.huawei.ism.drm.recovery.sdk.model.HostVO;
import com.huawei.ism.drm.recovery.sdk.model.ResourceVO;
import com.huawei.ism.drm.storage.fsb.connection.FusionStorageRestConnection;
import com.huawei.ism.drm.storage.fsb.connection.FusionStorageRestConnectionFactory;
import com.huawei.ism.drm.storage.fsb.handler.FusionStorageHandler;
import com.huawei.ism.drm.storage.fsb.service.IFusionStorageCommonManager;
import com.huawei.ism.drm.storage.fsb.util.FusionStorageCommonUtil;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FusionStorageSnapshotManagerAdapter
implements IFusionStorageCommonManager,
IStorageSnapshotManager {
    private static final Log LOG = LogFactory.getInstance(FusionStorageSnapshotManagerAdapter.class);
    private static final char SNAPNAME_WWN_SPLIT = '@';
    private static final int VOLUME_NAME_MAX_LENGTH = 95;
    private FusionStorageHandler fusionStorageHanler;

    public FusionStorageHandler getFusionStorageHanler() {
        return this.fusionStorageHanler;
    }

    public void setFusionStorageHanler(FusionStorageHandler fusionStorageHanler) {
        this.fusionStorageHanler = fusionStorageHanler;
    }

    public OperationResult addSnapshotToHost(String deviceId, String srcResourceId, Snapshot snapshot) {
        throw new LegoCheckedException(100663460L);
    }

    public OperationResult removeSnapshotFromHost(String deviceId, Snapshot snapshot, HostVO host) {
        return this.removeSnapshot(deviceId, snapshot, (ResourceVO)host);
    }

    public OperationResult removeSnapshotFromHostGroup(String deviceId, Snapshot snapshot, HostGroupVO hostGroup) {
        return this.removeSnapshot(deviceId, snapshot, (ResourceVO)hostGroup);
    }

    private OperationResult removeSnapshot(String deviceId, Snapshot snapshot, ResourceVO resourceVO) {
        FusionStorageCommonUtil.paramsCheck(deviceId, snapshot, resourceVO);
        LOG.debug((Object)"RemoveSnapshot, devSn:%s, snapshotName:%s, resourceVO:%s", new Object[]{deviceId, snapshot.getSnapshotName(), resourceVO.getName()});
        String cloneVolName = this.fusionStorageHanler.getCloneVolNameBySnapshotId(snapshot.getSnapshotId());
        OperationResult result = this.fusionStorageHanler.unmapping(deviceId, cloneVolName, resourceVO);
        if (result.isSuccess()) {
            try {
                this.fusionStorageHanler.deleteVolByName(deviceId, cloneVolName);
                return new OperationResult("ism.drm.remove.snapshot.mapping.operation", true, true, new String[]{snapshot.getSnapshotName()});
            }
            catch (LegoCheckedException e) {
                return new OperationResult("ism.drm.remove.snapshot.mapping.operation", true, false, String.valueOf(e.getErrorCode()), new String[]{snapshot.getSnapshotName()});
            }
        }
        LOG.error((Object)"RemoveSnapshot got error, devSn:%s, snapshotName: %s, resourceVO:%s", new Object[]{deviceId, snapshot.getSnapshotName(), resourceVO.getName()});
        return result;
    }

    public OperationResult removeSnapshotBySrcLUN(String deviceId, Snapshot snapshot, String srcResourceId) {
        return this.deleteSnapshot(deviceId, snapshot).appendArgs(new String[]{srcResourceId});
    }

    public Snapshot createSnapshot(String deviceSN, List<String> srcResourceIds, Snapshot snapshot) {
        FusionStorageCommonUtil.paramsCheck(deviceSN, srcResourceIds, snapshot);
        LOG.debug((Object)"Create snapshot, devSn: %s, snapshotName: %s", new Object[]{deviceSN, snapshot.getSnapshotName()});
        String snapName = snapshot.getName();
        snapshot.setSnapshotId(snapName);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(deviceSN).append('@').append(snapName);
        snapshot.setWwn(stringBuilder.toString());
        return snapshot;
    }

    public OperationResult deleteSnapshot(String deviceSN, Snapshot arraySnapshot) {
        FusionStorageCommonUtil.paramsCheck(deviceSN, arraySnapshot, arraySnapshot.getSnapshotId());
        if (VerifyUtil.isEmpty((String)arraySnapshot.getName())) {
            arraySnapshot.setSnapshotName(arraySnapshot.getSnapshotId());
        }
        LOG.debug((Object)"DeleteSnapshot, deviceSN: %s, snapshotName:%s", new Object[]{deviceSN, arraySnapshot.getSnapshotName()});
        FusionStorageRestConnection connection = FusionStorageCommonUtil.getConnection(deviceSN);
        Snapshot snapshot = this.fusionStorageHanler.getSnapshotByName(deviceSN, arraySnapshot.getSnapshotName());
        if (null == snapshot) {
            LOG.error((Object)"GetSnapshotByName got error, snapshot not exist in deviceSN:%s, snapshotName:%s", new Object[]{deviceSN, arraySnapshot.getSnapshotName()});
            return new OperationResult("ism.drm.delete.snapshot.operation", true, true, new String[]{arraySnapshot.getSnapshotName()});
        }
        try {
            String cloneVolName = this.fusionStorageHanler.getCloneVolNameBySnapshotId(snapshot.getName());
            this.fusionStorageHanler.deleteVolByName(deviceSN, cloneVolName);
            JSONObject params = new JSONObject();
            params.put((Object)"snapshotName", (Object)snapshot.getName());
            String res = connection.postForObject("/snapshot/delete", params);
            LOG.debug((Object)"deleteSnapshot, deviceSN:%s, snapshotName:%s, cloneVolName:%s . response:  %s", new Object[]{deviceSN, arraySnapshot.getSnapshotName(), cloneVolName, res});
            return new OperationResult("ism.drm.delete.snapshot.operation", true, true, new String[]{arraySnapshot.getSnapshotName()});
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)("Deleting snapshot failed. SnapshotId:" + arraySnapshot.getSnapshotId() + ",SnapshotName:" + arraySnapshot.getSnapshotName() + ",DeviceId:" + deviceSN), (Throwable)e, 90160758784001L);
            return new OperationResult("ism.drm.delete.snapshot.operation", true, false, String.valueOf(e.getErrorCode()), new String[]{arraySnapshot.getName()});
        }
    }

    public OperationResult deleteSnapshot(String deviceSN, List<Snapshot> snapshotList) {
        throw new LegoCheckedException(100663460L, "Not support batch delete snapshot");
    }

    public OperationResult activeSnapshot(String deviceSN, List<String> snapshotIds) {
        LOG.debug((Object)"Protect execute active snapshot");
        FusionStorageCommonUtil.paramsCheck(deviceSN, snapshotIds);
        try {
            this.fusionStorageHanler.createSnapshotConsistent(deviceSN, snapshotIds);
            return new OperationResult("ism.drm.active.snapshot.operation", true, true, new String[]{snapshotIds.toString()});
        }
        catch (LegoCheckedException ex) {
            LOG.error((Object)"Snapshot active error,errorCode=%s. devSN=%s, snapshotIds=[%s].", new Object[]{ex.getErrorCode(), deviceSN, String.join((CharSequence)",", snapshotIds)});
            return new OperationResult("ism.drm.active.snapshot.operation", true, false, String.valueOf(ex.getErrorCode()), new String[]{snapshotIds.toString()});
        }
    }

    public OperationResult activeSnapshotAfterStop(String deviceSN, List<String> snapshotIds) {
        LOG.debug((Object)"Recovery plan active snapshot");
        FusionStorageCommonUtil.paramsCheck(deviceSN, snapshotIds);
        try {
            this.fusionStorageHanler.createSnapshotConsistent(deviceSN, snapshotIds);
            List snapshots = ExecutionService.map(snapshotIds, srcSnapshotId -> this.copySnapshot(deviceSN, (String)srcSnapshotId, this.fusionStorageHanler.getCloneVolNameBySnapshotId((String)srcSnapshotId), false));
            List<String> items = snapshots.stream().map(s -> s.getSrcResourceUuid() + ">" + s.getWwn()).collect(Collectors.toList());
            return new OperationResult("ism.drm.active.snapshot.operation", true, true, items.toArray(new String[items.size()]));
        }
        catch (LegoCheckedException ex) {
            LOG.error((Object)"Snapshot active error,errorCode=%s. devSN=%s, snapshotIds=[%s].", new Object[]{ex.getErrorCode(), deviceSN, String.join((CharSequence)",", snapshotIds)});
            return new OperationResult("ism.drm.active.snapshot.operation", true, false, String.valueOf(ex.getErrorCode()), new String[]{snapshotIds.toString()});
        }
    }

    public OperationResult reCreateSnapshot(String deviceSN, List<String> snapshotIds) {
        throw new LegoCheckedException(100663460L, "Not support snapshot re-create");
    }

    public OperationResult activeOrReCreateSnapshot(String deviceSN, Snapshot snapshot) {
        throw new LegoCheckedException(100663460L, "Not support snapshot active or re-create");
    }

    public OperationResult disableSnapshot(String deviceSN, Snapshot snapshot) {
        LOG.debug((Object)"Start to disableSnapshot");
        return this.deleteSnapshot(deviceSN, snapshot);
    }

    public boolean isSnapshotExist(String deviceSN, Snapshot snapshot) {
        List<Object> snapshots;
        try {
            snapshots = this.getSnapshot(deviceSN, snapshot);
        }
        catch (LegoCheckedException e) {
            snapshots = Collections.emptyList();
        }
        return !snapshots.isEmpty();
    }

    public List<Snapshot> getSnapshot(String deviceSN, Snapshot snapshot) {
        FusionStorageCommonUtil.paramsCheck(deviceSN, snapshot);
        snapshot.setName(snapshot.getSnapshotId());
        Snapshot s = this.fusionStorageHanler.getSnapshotByName(deviceSN, snapshot.getName());
        ArrayList<Snapshot> result = new ArrayList<Snapshot>();
        if (null != s) {
            if (VerifyUtil.isEmpty((Object)s.getSrcResourceId())) {
                Lun srcLun = this.fusionStorageHanler.getVolumeBySnapshot(deviceSN, snapshot.getName());
                s.setSrcResourceId(srcLun != null ? Integer.valueOf(Integer.parseInt(srcLun.getLunId())) : null);
            }
            result.add(s);
        }
        return result;
    }

    public OperationResult restoreSnapshot(String deviceSN, Snapshot snapshot, String restoreSpeed) {
        FusionStorageCommonUtil.paramsCheck(deviceSN, snapshot);
        LOG.debug((Object)"Restore snapshot start. devSn:%s, snapshotName:%s, restoreSpeed:%s.", new Object[]{deviceSN, snapshot.getSnapshotName(), restoreSpeed});
        FusionStorageRestConnection connection = FusionStorageCommonUtil.getConnection(deviceSN);
        String snapshotName = snapshot.getName();
        Lun lun = this.fusionStorageHanler.getVolumeBySnapshot(deviceSN, snapshotName);
        String lunName = lun.getName();
        JSONObject params = new JSONObject();
        params.put((Object)"snapshotName", (Object)snapshotName);
        params.put((Object)"volumeName", (Object)lunName);
        try {
            connection.postForObject("/snapshot/rollback", params);
            LOG.debug((Object)"Restore snapshot finished. devSn:%s, snapshotName:%s.", new Object[]{deviceSN, snapshot.getSnapshotName()});
            return new OperationResult("ism.drm.restore.snapshot.operation", true, true, new String[]{snapshotName});
        }
        catch (LegoCheckedException ex) {
            LOG.error((Object)"Restore snapshot error,errorCode=%s. devSN=%s, params=[%s].", new Object[]{ex.getErrorCode(), deviceSN, params.toString()});
            return new OperationResult("ism.drm.restore.snapshot.operation", true, false, String.valueOf(ex.getErrorCode()), new String[]{snapshotName});
        }
    }

    public OperationResult mappingSnapshot(String devSn, String srcResourceId, Snapshot snapshot, HostVO hostVo) {
        String cloneVolName = this.fusionStorageHanler.getCloneVolNameBySnapshotId(snapshot.getSnapshotId());
        return this.fusionStorageHanler.mapping(devSn, cloneVolName, (ResourceVO)hostVo);
    }

    public OperationResult mappingSnapshot(String devSn, String srcResourceId, Snapshot snapshot, HostGroupVO hgVo) {
        String cloneVolName = this.fusionStorageHanler.getCloneVolNameBySnapshotId(snapshot.getSnapshotId());
        return this.fusionStorageHanler.mapping(devSn, cloneVolName, (ResourceVO)hgVo);
    }

    public Snapshot copySnapshot(String devSn, String srcSnapshotId, String copyName, boolean isHyperCDP) {
        FusionStorageCommonUtil.paramsCheck(devSn, srcSnapshotId, copyName);
        LOG.debug((Object)"Copy snapshot start. devSn:%s, srcSnapshotId:%s, copyName:%s.", new Object[]{devSn, srcSnapshotId, copyName});
        FusionStorageRestConnection connection = this.getConnection(devSn);
        JSONObject params = new JSONObject();
        String cloneVolName = this.fusionStorageHanler.getCloneVolNameBySnapshotId(copyName);
        if (cloneVolName.length() > 95) {
            cloneVolName = cloneVolName.substring(0, 60) + Long.toHexString(System.currentTimeMillis()) + "_Clone";
        }
        params.put((Object)"src", (Object)srcSnapshotId);
        params.put((Object)"volName", (Object)cloneVolName);
        connection.postForObject("/snapshot/volume/create", params);
        Snapshot snapshot = new Snapshot();
        snapshot.setDevSn(devSn);
        snapshot.setSnapshotName(cloneVolName);
        snapshot.setSnapshotId(cloneVolName);
        snapshot.setSrcResourceUuid(devSn + "@" + srcSnapshotId);
        Lun lun = this.fusionStorageHanler.getVolumeByLunName(devSn, cloneVolName);
        if (null != lun) {
            snapshot.setWwn(lun.getWwn());
        }
        LOG.debug((Object)"Copy snapshot finished. devSn:%s, srcSnapshotId:%s, cloneVolName:%s, Wwn:%s.", new Object[]{devSn, srcSnapshotId, cloneVolName, snapshot.getWwn()});
        return snapshot;
    }

    public String prepareMapping(String devSn, HostVO hostVo) {
        return null;
    }

    public String prepareMapping(String devSn, HostGroupVO hostGroupVo) {
        return null;
    }

    public OperationResult addSnapshotToLunGroup(String devSn, Snapshot snapshot, String lunGroupId, Map<String, Object> cache) {
        LOG.info((Object)"Nothing need to do.");
        return null;
    }

    public List<Snapshot> querySnapshotByLun(String deviceSn, String lunId) {
        String volumeName = this.fusionStorageHanler.getVolumeNameById(deviceSn, lunId);
        return this.fusionStorageHanler.querySnapshotByLun(deviceSn, volumeName);
    }

    public List<Snapshot> queryHyperCdpSnapshotsByLun(String devSn, String lunId) {
        return Collections.emptyList();
    }

    private FusionStorageRestConnection getConnection(String devSn) {
        if (VerifyUtil.isEmpty((String)devSn)) {
            LOG.error((Object)"Params error, devSn is null");
            throw new LegoCheckedException(1073947393L);
        }
        return FusionStorageRestConnectionFactory.getInstance().getConnection(devSn);
    }
}

