/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.fsb.util;

import com.huawei.ism.array.sdk.model.FusionStorageUnit;
import com.huawei.ism.array.sdk.model.XveLun;
import com.huawei.ism.base.sdk.model.Initiator;
import com.huawei.ism.base.sdk.model.StoragePool;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.cbb.util.unit.CapabilityUnitType;
import com.huawei.ism.common.entity.TypeEnum;
import com.huawei.ism.drm.base.util.DrmStorageUtil;
import com.huawei.ism.drm.storage.fsb.connection.FusionStorageRestConnection;
import com.huawei.ism.drm.storage.fsb.util.FusionStorageCommonUtil;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationLink;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.util.ManagedObjectUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FusionStorageRestTransition {
    private static final Log logger = LogFactory.getInstance(FusionStorageRestTransition.class);
    private static final int LINK_TYPE_IPPAIR = 3;
    private static final Integer DEFAULT_PROGRESS = 100;
    private static final String REPLICATION_PAIR_MO_TYPE = "REMOTEREPLICATION";
    private static final String REPLICATION_TARGET_LUN_MO_TYPE = "REMOTEREPLICATIONMEMBERLUN";
    private static final String LUN_MO_TYPE = "LUN";
    private static final String CONSISTENT_GROUP_MO_TYPE = "CONSISTENTGROUP";
    private static final String REPLICATION_LINK_MO_TYPE = "REPLICATIONLINK";
    private static final String STORAGEPOOL_MO_TYPE = "STORAGEPOOL";
    private static final String INITIATOR_MO_TYPE = "INITIATOR";
    private static final String HEX_PREFIX = "0x";

    public static XveLun transitionLun(String deviceId, JSONObject jsonObject) {
        if (VerifyUtil.isEmpty((Map)jsonObject)) {
            return null;
        }
        XveLun lun = new XveLun();
        lun.setLunId(jsonObject.getString("volId"));
        lun.setDevSn(deviceId);
        lun.setUuid(DrmStorageUtil.generateMoUuid((String)lun.getLunId(), (String)LUN_MO_TYPE, (String)deviceId));
        lun.setName(jsonObject.getString("volName"));
        long capacity = jsonObject.getLong("volSize");
        lun.setCapacity(Long.valueOf(capacity));
        lun.setTotalCapacity(Double.valueOf(capacity));
        lun.setTotalCapacityUnit(CapabilityUnitType.MB.name());
        String wwn = jsonObject.getString("wwn");
        if (wwn.startsWith(HEX_PREFIX)) {
            wwn = wwn.substring(HEX_PREFIX.length(), wwn.length());
        }
        lun.setWwn(wwn);
        lun.setStoragePoolId(jsonObject.getString("poolId"));
        int status = jsonObject.getInt("status");
        if (status == 0 || status == 6 || status == 5 || status == 4) {
            lun.setStatus(Integer.valueOf(0));
            lun.setHealthStatus(String.valueOf(0));
            lun.setRunningStatus(String.valueOf(0));
        } else if (status == 9 || status == 14) {
            lun.setStatus(Integer.valueOf(2));
            lun.setHealthStatus(String.valueOf(2));
            lun.setRunningStatus(String.valueOf(-1));
        } else {
            lun.setStatus(Integer.valueOf(4));
            lun.setHealthStatus(String.valueOf(4));
            lun.setRunningStatus(String.valueOf(4));
        }
        lun.setUsedCapacity(Double.valueOf(jsonObject.getDouble("realSize")));
        lun.setUsedCapacityUnit(CapabilityUnitType.MB.name());
        if (jsonObject.containsKey((Object)"volType")) {
            Integer volType = jsonObject.getInt("volType");
            JSONObject description = new JSONObject();
            description.put((Object)"lunType", (Object)"FSB_Volume");
            description.put((Object)"FSB_Volume_Type", (Object)volType);
            lun.setDescription(description.toString());
        }
        return lun;
    }

    public static StoragePool transitionStoragePool(String deviceId, JSONObject jsonObject) {
        StoragePool storagePool = new StoragePool();
        storagePool.setPoolId(jsonObject.getString("poolId"));
        storagePool.setName(jsonObject.getString("poolName"));
        storagePool.setNeSN(deviceId);
        storagePool.setUuid(DrmStorageUtil.generateMoUuid((String)storagePool.getPoolId(), (String)STORAGEPOOL_MO_TYPE, (String)deviceId));
        storagePool.setStatus(Integer.valueOf(jsonObject.getInt("poolStatus")));
        storagePool.setHealthStatus(jsonObject.getString("poolStatus"));
        storagePool.setRunningStatus(jsonObject.getString("poolStatus"));
        return storagePool;
    }

    public static FusionStorageUnit transitionStorageUnit(String deviceId, String jsonResult) {
        if (VerifyUtil.isEmpty((String)jsonResult)) {
            return null;
        }
        FusionStorageUnit unit = new FusionStorageUnit();
        JSONObject result = JSONObject.fromObject((Object)jsonResult);
        unit.setDevSn(deviceId);
        unit.setUuid(deviceId);
        unit.setProductModel(result.getString("productModel"));
        unit.setMainType("ism.deviceType.storage.mainType");
        unit.setSubType(result.getString("productModel"));
        unit.setName(result.getString("clusterName"));
        unit.setStatus(Integer.valueOf(result.getInt("clusterStatus")));
        return unit;
    }

    public static ReplicationPair transitionReplicationPair(String deviceId, JSONObject jsonObject, String topUuid) {
        ReplicationPair pair = new ReplicationPair();
        if (jsonObject == null) {
            return null;
        }
        if (jsonObject.containsKey((Object)"CGID")) {
            pair.setConsistentGroupId(jsonObject.getString("CGID"));
        }
        pair.setReplicationId(jsonObject.getString("ID"));
        pair.setReplicationName(jsonObject.getString("ID"));
        pair.setReplicationMode(Integer.valueOf(jsonObject.getInt("REPLICATIONMODEL")));
        pair.setRelationType(Integer.valueOf(0));
        pair.setRunningState(jsonObject.getString("RUNNINGSTATUS"));
        pair.setHealthState(jsonObject.getString("HEALTHSTATUS"));
        pair.setDevSn(deviceId);
        Boolean isPrimary = jsonObject.getBoolean("ISPRIMARY");
        String srcLunId = jsonObject.getString("LOCALRESID");
        String srcLunName = jsonObject.getString("LOCALRESNAME");
        String srcDevSN = deviceId;
        String srcDeviceName = "";
        if (!isPrimary.booleanValue()) {
            srcLunId = jsonObject.getString("REMOTERESID");
            srcLunName = jsonObject.getString("REMOTERESNAME");
            srcDevSN = jsonObject.getString("REMOTEDEVICESN");
            srcDeviceName = jsonObject.getString("REMOTEDEVICENAME");
        }
        pair.setSrcLunId(srcLunId);
        pair.setSrcLunName(srcLunName);
        pair.setSrcDevSN(srcDevSN);
        pair.setSrcDeviceName(srcDeviceName);
        String uuid = DrmStorageUtil.generateMoUuid((String)pair.getReplicationId(), (String)REPLICATION_PAIR_MO_TYPE, (String)deviceId);
        pair.setUuid(uuid);
        pair.setLocalResType(Integer.valueOf(jsonObject.getInt("LOCALRESTYPE")));
        pair.setIsPrimary(isPrimary);
        pair.setTopMoUuid(topUuid);
        ReplicationTargetLun targetLun = FusionStorageRestTransition.transitionReplicationTargetLun(deviceId, jsonObject);
        targetLun.setTopMoUuid(topUuid);
        ManagedObjectUtil.associate((ManagedObject)targetLun, (ManagedObject)pair);
        pair.setRepTgtLuns(Arrays.asList(targetLun));
        return pair;
    }

    public static ReplicationGroup transitionReplicationGroup(String deviceId, JSONObject jsonObject) {
        ReplicationGroup replicationGroup = new ReplicationGroup();
        Boolean isPrimary = jsonObject.getBoolean("ISPRIMARY");
        if (isPrimary.booleanValue()) {
            replicationGroup.setSrcDevSN(deviceId);
        }
        replicationGroup.setResumePolicy(Integer.valueOf(jsonObject.getInt("RECOVERYPOLICY")));
        replicationGroup.setSpeedLevel(Integer.valueOf(jsonObject.getInt("SPEED")));
        int syncType = jsonObject.getInt("SYNCHRONIZETYPE", TypeEnum.HyperMirrorEnums.SyncType.UNKNOW.getValue());
        replicationGroup.setSyncType(Integer.valueOf(syncType));
        if (jsonObject.containsKey((Object)"TIMINGVALINSEC")) {
            replicationGroup.setTiming(Long.valueOf(jsonObject.getLong("TIMINGVALINSEC")));
        }
        replicationGroup.setReplicationId(jsonObject.getString("ID"));
        replicationGroup.setReplicationMode(Integer.valueOf(jsonObject.getInt("REPLICATIONMODEL")));
        replicationGroup.setReplicationName(jsonObject.getString("NAME"));
        replicationGroup.setDevSn(deviceId);
        replicationGroup.setIsPrimary(isPrimary);
        replicationGroup.setRelationType(Integer.valueOf(1));
        replicationGroup.setRunningState(jsonObject.getString("RUNNINGSTATUS"));
        replicationGroup.setHealthState(jsonObject.getString("HEALTHSTATUS"));
        replicationGroup.setName(jsonObject.getString("NAME"));
        replicationGroup.setUuid(DrmStorageUtil.generateMoUuid((String)replicationGroup.getReplicationId(), (String)CONSISTENT_GROUP_MO_TYPE, (String)deviceId));
        return replicationGroup;
    }

    public static ReplicationLink transitionReplicationLink(String deviceId, JSONObject jsonObject) {
        ReplicationLink replicationLink = new ReplicationLink();
        replicationLink.setDeviceId(deviceId);
        replicationLink.setLinkType(3);
        replicationLink.setLinkId(jsonObject.getString("id"));
        replicationLink.setUuid(DrmStorageUtil.generateMoUuid((String)replicationLink.getLinkId(), (String)REPLICATION_LINK_MO_TYPE, (String)deviceId));
        replicationLink.setRemoteArrayId(jsonObject.getString("system_wwn"));
        int status = jsonObject.getInt("runningStatus");
        if (status != 10 && status != 0) {
            replicationLink.setLinkStatus(0);
        } else {
            replicationLink.setLinkStatus(status);
        }
        replicationLink.setLinkIp(jsonObject.getString("initRemoteIp"));
        return replicationLink;
    }

    public static ReplicationTargetLun transitionReplicationTargetLun(String deviceId, JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        ReplicationTargetLun targetLun = new ReplicationTargetLun();
        targetLun.setStartTime(jsonObject.getString("STARTTIME"));
        targetLun.setEndTime(jsonObject.getString("ENDTIME"));
        targetLun.setDataStatus(Integer.valueOf(jsonObject.getInt("SECRESDATASTATUS")));
        targetLun.setPairStatus(Integer.valueOf(jsonObject.getInt("RUNNINGSTATUS")));
        targetLun.setReplicationPairId(jsonObject.getString("ID"));
        String tgtDeviceName = jsonObject.getString("REMOTEDEVICENAME");
        String tgtDevSn = jsonObject.getString("system_wwn");
        if (VerifyUtil.isEmpty((String)tgtDevSn)) {
            logger.info((Object)"TgtDevSn is NULL. jsonObject: %s", new Object[]{jsonObject});
        }
        String tgtLunId = jsonObject.getString("REMOTERESID");
        String tgtLunName = jsonObject.getString("REMOTERESNAME");
        Boolean isPrimary = jsonObject.getBoolean("ISPRIMARY");
        if (!isPrimary.booleanValue()) {
            tgtLunId = jsonObject.getString("LOCALRESID");
            tgtLunName = jsonObject.getString("LOCALRESNAME");
            tgtDevSn = deviceId;
            tgtDeviceName = "";
        }
        targetLun.setTgtDeviceName(tgtDeviceName);
        targetLun.setTgtDevSN(tgtDevSn);
        targetLun.setTgtLunId(tgtLunId);
        targetLun.setTgtLunName(tgtLunName);
        targetLun.setResumePolicy(Integer.valueOf(jsonObject.getInt("RECOVERYPOLICY")));
        targetLun.setSpeedLevel(Integer.valueOf(jsonObject.getInt("SPEED")));
        int syncType = jsonObject.getInt("SYNCHRONIZETYPE", TypeEnum.HyperMirrorEnums.SyncType.UNKNOW.getValue());
        targetLun.setSyncType(Integer.valueOf(syncType));
        targetLun.setDevSn(deviceId);
        targetLun.setRunningState(jsonObject.getString("RUNNINGSTATUS"));
        targetLun.setHealthState(jsonObject.getString("HEALTHSTATUS"));
        targetLun.setName(tgtLunName);
        String uuid = DrmStorageUtil.generateTargetLunMoUuid((String)String.valueOf(tgtLunId), (String)REPLICATION_TARGET_LUN_MO_TYPE, (String)deviceId, (String)tgtDevSn, (String)targetLun.getReplicationPairId());
        targetLun.setUuid(uuid);
        if (jsonObject.containsKey((Object)"REPLICATIONPROGRESS") && jsonObject.get("REPLICATIONPROGRESS") != null) {
            targetLun.setProgressRatio(Integer.valueOf(jsonObject.getInt("REPLICATIONPROGRESS")));
        }
        if (jsonObject.containsKey((Object)"TIMINGVALINSEC")) {
            targetLun.setTiming(Long.valueOf(jsonObject.getLong("TIMINGVALINSEC")));
        }
        targetLun.setSecresAccess(jsonObject.getString("SECRESACCESS"));
        targetLun.setIsPrimary(isPrimary);
        return targetLun;
    }

    public static Snapshot transitionSnapshot(String deviceId, JSONObject jsonObject) {
        FusionStorageCommonUtil.paramsCheck(deviceId, jsonObject);
        Snapshot snapshot = new Snapshot();
        snapshot.setDevSn(deviceId);
        snapshot.setSnapshotName(jsonObject.getString("snapshotName"));
        snapshot.setStatus(Integer.valueOf(jsonObject.getInt("status")));
        snapshot.setWwn(jsonObject.getString("wwn"));
        snapshot.setSnapshotId(jsonObject.getString("snapshotId"));
        snapshot.setTimeStamp(jsonObject.getString("createTime"));
        snapshot.setRestoreProgress(DEFAULT_PROGRESS);
        if (snapshot.getStatus() != null && snapshot.getStatus() == 0) {
            snapshot.setRunningState(String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.ACTIVATED.getValue()));
        }
        return snapshot;
    }

    public static Initiator transitionInitiator(String deviceId, JSONObject jsonObject) {
        Initiator initiator = new Initiator();
        initiator.setAlias(jsonObject.getString("NAME"));
        initiator.setHbaType("ISCSI");
        String id = jsonObject.getString("ID");
        initiator.setIdentity(jsonObject.getString("NAME"));
        initiator.setName(id);
        int runningstatus = jsonObject.getInt("RUNNINGSTATUS");
        if (runningstatus == 27) {
            initiator.setStatus(Integer.valueOf(0));
            initiator.setRunningStatus(Integer.valueOf(0));
            initiator.setHealthStatus(Integer.valueOf(0));
        } else {
            initiator.setStatus(Integer.valueOf(-1));
            initiator.setRunningStatus(Integer.valueOf(-1));
            initiator.setHealthStatus(Integer.valueOf(-1));
        }
        initiator.setIsFree(Boolean.valueOf(jsonObject.getBoolean("ISFREE")));
        String uuid = DrmStorageUtil.generateMoUuid((String)id, (String)INITIATOR_MO_TYPE, (String)deviceId);
        initiator.setUuid(uuid);
        return initiator;
    }

    public static Initiator transitionBlockClient(String deviceId, JSONObject jsonObject) {
        Initiator initiator = new Initiator();
        String initiatorIp = jsonObject.getString("manageIp");
        initiator.setInitiatorIp(initiatorIp);
        Integer status = jsonObject.getInt("status");
        initiator.setHealthStatus(status);
        initiator.setRunningStatus(status);
        String uuid = DrmStorageUtil.generateMoUuid((String)initiatorIp, (String)INITIATOR_MO_TYPE, (String)deviceId);
        initiator.setUuid(uuid);
        return initiator;
    }

    public static Collection<StoragePool> queryFusionStoragePools(FusionStorageRestConnection connection, FusionStorageUnit unit) {
        logger.debug((Object)"query storagepool start. SN:%s", new Object[]{connection.getDeviceId()});
        String responseStr = connection.getForString("/storagePool", null);
        JSONObject responseJson = JSONObject.fromObject((Object)responseStr);
        JSONArray jsonPoolArray = responseJson.getJSONArray("storagePools");
        if (null == jsonPoolArray) {
            logger.error((Object)"Query StoragePools return empty. devSn=%s,response=%s", new Object[]{connection.getDeviceId(), responseStr});
            throw new LegoCheckedException(2117645L);
        }
        List<StoragePool> list = jsonPoolArray.filter(JSONObject.class).stream().map(pool -> FusionStorageRestTransition.transitionStoragePool(connection.getDeviceId(), pool)).collect(Collectors.toList());
        IMoDao moDao = CommonDAOLocator.getMoDao();
        for (StoragePool rel : list) {
            rel.setParentMo((ManagedObject)unit);
            rel.setTopMoUuid(unit.getTopMoUuid());
            moDao.saveOrUpdateMo((ManagedObject)rel);
        }
        logger.debug((Object)("query storagepool finished, size:" + list.size() + ", SN\uff1a" + unit.getDevSn()));
        return list;
    }
}

