/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.anti.blackmail.manager.sdk.model;

import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailSnapshotDetectionInfo;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailSnapshotTaskInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class AntiBlackmailPlatform {
    public static final int SINGLE_CONTROLLER_THRESHOLD_LIMIT = 230;
    private static final Log LOGGER = LogFactory.getInstance(AntiBlackmailPlatform.class);
    private static final int SINGLE_CONTROLLER_QUEUE_LIMIT = 256;
    private static final int SINGLE_CONTROLLER_RUNNING_LIMIT = 20;
    private String devSn;
    private int nodeNum;
    private String slaId;
    private int maxWaitTaskLimit;
    private int maxRunningTaskLimit;
    private BlockingQueue<AntiBlackmailSnapshotTaskInfo> snapshotTasksQueue;
    private Map<String, ProtectObjectReplica> snapshotTasksRunningMap = new ConcurrentHashMap<String, ProtectObjectReplica>();
    private Map<String, AtomicInteger> snapshotTaskFinishedCountMap = new ConcurrentHashMap<String, AtomicInteger>();
    private Map<String, List<AntiBlackmailSnapshotDetectionInfo>> snapshotDetectTasksCacheMap = new ConcurrentHashMap<String, List<AntiBlackmailSnapshotDetectionInfo>>();
    private Map<String, AntiBlackmailSnapshotDetectionInfo> snapshotDetectTasksRunningMap = new ConcurrentHashMap<String, AntiBlackmailSnapshotDetectionInfo>();
    private final Map<String, AntiBlackmailSnapshotDetectionInfo> allSnapshotIdCacheMap = new ConcurrentHashMap<String, AntiBlackmailSnapshotDetectionInfo>();
    private final Map<String, BackTask> snapshotDetectBackTasksRunningMap = new ConcurrentHashMap<String, BackTask>();
    private final Map<String, BackTask> snapshotDeleteBackTasksRunningMap = new ConcurrentHashMap<String, BackTask>();
    private final Map<String, String> snapshotDeleteSnapshotTaskRelateMap = new ConcurrentHashMap<String, String>();

    public AntiBlackmailPlatform(String devSn, int nodeNum, String slaId) {
        this.devSn = devSn;
        this.nodeNum = nodeNum;
        this.slaId = slaId;
        this.maxWaitTaskLimit = 256 * nodeNum;
        this.maxRunningTaskLimit = 20 * nodeNum;
        this.snapshotTasksQueue = new LinkedBlockingQueue<AntiBlackmailSnapshotTaskInfo>(this.maxWaitTaskLimit);
    }

    public boolean hasWaitingDetectTaskToDeal() {
        return this.snapshotDetectTasksCacheMap.size() != 0;
    }

    public boolean hasWaitingDeleteTaskToDeal() {
        return this.snapshotDeleteBackTasksRunningMap.size() != 0;
    }

    public boolean hasWaitingTaskToDeal() {
        return this.snapshotTasksRunningMap.size() != 0 || this.snapshotTasksQueue.size() != 0;
    }

    public boolean hasNewTaskToSend() {
        return this.snapshotTasksQueue.size() > 0 && this.snapshotTasksRunningMap.size() < this.maxRunningTaskLimit;
    }

    public boolean existSnapshotTaskWithPgReplica(String protectGroupReplicaId) {
        return this.snapshotTaskFinishedCountMap.containsKey(protectGroupReplicaId) && this.snapshotTaskFinishedCountMap.get(protectGroupReplicaId).get() > 0;
    }

    public boolean checkCanAddNewTask(int taskNum) {
        return this.snapshotTasksQueue.size() + taskNum > this.maxWaitTaskLimit;
    }

    public void addTask(String pgrId, BackTask backTask) {
        this.snapshotDetectBackTasksRunningMap.put(pgrId, backTask);
    }

    public void addDeleteTask(String pgrId, BackTask backTask) {
        this.snapshotDeleteBackTasksRunningMap.put(pgrId, backTask);
    }

    public void setDevSn(String devSn) {
        this.devSn = devSn;
    }

    public void setNodeNum(int nodeNum) {
        this.nodeNum = nodeNum;
    }

    public void setSlaId(String slaId) {
        this.slaId = slaId;
    }

    public void setMaxWaitTaskLimit(int maxWaitTaskLimit) {
        this.maxWaitTaskLimit = maxWaitTaskLimit;
    }

    public void setMaxRunningTaskLimit(int maxRunningTaskLimit) {
        this.maxRunningTaskLimit = maxRunningTaskLimit;
    }

    public void setSnapshotTasksQueue(BlockingQueue<AntiBlackmailSnapshotTaskInfo> snapshotTasksQueue) {
        this.snapshotTasksQueue = snapshotTasksQueue;
    }

    public void setSnapshotTasksRunningMap(Map<String, ProtectObjectReplica> snapshotTasksRunningMap) {
        this.snapshotTasksRunningMap = snapshotTasksRunningMap;
    }

    public void setSnapshotTaskFinishedCountMap(Map<String, AtomicInteger> snapshotTaskFinishedCountMap) {
        this.snapshotTaskFinishedCountMap = snapshotTaskFinishedCountMap;
    }

    public void setSnapshotDetectTasksCacheMap(Map<String, List<AntiBlackmailSnapshotDetectionInfo>> snapshotDetectTasksCacheMap) {
        this.snapshotDetectTasksCacheMap = snapshotDetectTasksCacheMap;
    }

    public void setSnapshotDetectTasksRunningMap(Map<String, AntiBlackmailSnapshotDetectionInfo> snapshotDetectTasksRunningMap) {
        this.snapshotDetectTasksRunningMap = snapshotDetectTasksRunningMap;
    }

    public String getDevSn() {
        return this.devSn;
    }

    public int getNodeNum() {
        return this.nodeNum;
    }

    public String getSlaId() {
        return this.slaId;
    }

    public int getMaxWaitTaskLimit() {
        return this.maxWaitTaskLimit;
    }

    public int getMaxRunningTaskLimit() {
        return this.maxRunningTaskLimit;
    }

    public BlockingQueue<AntiBlackmailSnapshotTaskInfo> getSnapshotTasksQueue() {
        return this.snapshotTasksQueue;
    }

    public Map<String, ProtectObjectReplica> getSnapshotTasksRunningMap() {
        return this.snapshotTasksRunningMap;
    }

    public Map<String, AtomicInteger> getSnapshotTaskFinishedCountMap() {
        return this.snapshotTaskFinishedCountMap;
    }

    public Map<String, List<AntiBlackmailSnapshotDetectionInfo>> getSnapshotDetectTasksCacheMap() {
        return this.snapshotDetectTasksCacheMap;
    }

    public Map<String, AntiBlackmailSnapshotDetectionInfo> getSnapshotDetectTasksRunningMap() {
        return this.snapshotDetectTasksRunningMap;
    }

    public Map<String, AntiBlackmailSnapshotDetectionInfo> getAllSnapshotIdCacheMap() {
        return this.allSnapshotIdCacheMap;
    }

    public Map<String, BackTask> getSnapshotDetectBackTasksRunningMap() {
        return this.snapshotDetectBackTasksRunningMap;
    }

    public Map<String, BackTask> getSnapshotDeleteBackTasksRunningMap() {
        return this.snapshotDeleteBackTasksRunningMap;
    }

    public Map<String, String> getSnapshotDeleteSnapshotTaskRelateMap() {
        return this.snapshotDeleteSnapshotTaskRelateMap;
    }
}

