/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.schedule.sdk.model;

import com.google.common.collect.ImmutableSet;
import com.huawei.ism.cbb.util.VerifyUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum ScheduleProtectedType {
    SNAPSHOT(2),
    HYPERCDP(100),
    CLOUD_BACKUP(101),
    SECURE_SNAPSHOT(102),
    AIRGAP_NAS_HYPERCDP_SNAPSHOT(103),
    NAS_AIRGAP_ANTI_BLACKMAIL_SECURE_SNAPSHOT(104),
    AIRGAP_SNAPSHOT(44),
    AIRGAP_NAS_SNAPSHOT(45),
    NAS_AIRGAP_ANTI_BLACKMAIL_SNAPSHOT(46),
    NAS_SNAPSHOT(14),
    NAS_HYPERVAULT(17),
    NAS_HYPERMETROVAULT(28);

    public static final Map<Integer, Set<Integer>> SCHEDULE_TO_LOCAL_REPLICA_MAP;
    private final int value;

    private ScheduleProtectedType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static Set<Integer> getAllProtectedTypes() {
        HashSet<Integer> set = new HashSet<Integer>();
        for (ScheduleProtectedType type : ScheduleProtectedType.values()) {
            set.add(type.getValue());
        }
        return set;
    }

    public static boolean isSameType(int replicaType, int protectedType) {
        if (protectedType == -1) {
            return true;
        }
        Set<Integer> replicaTypeSet = SCHEDULE_TO_LOCAL_REPLICA_MAP.get(protectedType);
        if (VerifyUtil.isEmpty(replicaTypeSet)) {
            return false;
        }
        return replicaTypeSet.contains(replicaType);
    }

    static {
        SCHEDULE_TO_LOCAL_REPLICA_MAP = new HashMap<Integer, Set<Integer>>();
        SCHEDULE_TO_LOCAL_REPLICA_MAP.put(SNAPSHOT.getValue(), (Set<Integer>)ImmutableSet.of((Object)3));
        SCHEDULE_TO_LOCAL_REPLICA_MAP.put(HYPERCDP.getValue(), (Set<Integer>)ImmutableSet.of((Object)4));
        SCHEDULE_TO_LOCAL_REPLICA_MAP.put(CLOUD_BACKUP.getValue(), (Set<Integer>)ImmutableSet.of((Object)101));
        SCHEDULE_TO_LOCAL_REPLICA_MAP.put(SECURE_SNAPSHOT.getValue(), (Set<Integer>)ImmutableSet.of((Object)102));
        SCHEDULE_TO_LOCAL_REPLICA_MAP.put(AIRGAP_SNAPSHOT.getValue(), (Set<Integer>)ImmutableSet.of((Object)44, (Object)3));
        SCHEDULE_TO_LOCAL_REPLICA_MAP.put(AIRGAP_NAS_SNAPSHOT.getValue(), (Set<Integer>)ImmutableSet.of((Object)8));
        SCHEDULE_TO_LOCAL_REPLICA_MAP.put(AIRGAP_NAS_HYPERCDP_SNAPSHOT.getValue(), (Set<Integer>)ImmutableSet.of((Object)103));
        SCHEDULE_TO_LOCAL_REPLICA_MAP.put(NAS_AIRGAP_ANTI_BLACKMAIL_SNAPSHOT.getValue(), (Set<Integer>)ImmutableSet.of((Object)11));
        SCHEDULE_TO_LOCAL_REPLICA_MAP.put(NAS_AIRGAP_ANTI_BLACKMAIL_SECURE_SNAPSHOT.getValue(), (Set<Integer>)ImmutableSet.of((Object)104, (Object)11));
        SCHEDULE_TO_LOCAL_REPLICA_MAP.put(16, (Set<Integer>)ImmutableSet.of((Object)5));
        SCHEDULE_TO_LOCAL_REPLICA_MAP.put(14, (Set<Integer>)ImmutableSet.of((Object)8));
        SCHEDULE_TO_LOCAL_REPLICA_MAP.put(1, (Set<Integer>)ImmutableSet.of((Object)2));
        SCHEDULE_TO_LOCAL_REPLICA_MAP.put(NAS_SNAPSHOT.getValue(), (Set<Integer>)ImmutableSet.of((Object)8));
        SCHEDULE_TO_LOCAL_REPLICA_MAP.put(NAS_HYPERVAULT.getValue(), (Set<Integer>)ImmutableSet.of((Object)3));
        SCHEDULE_TO_LOCAL_REPLICA_MAP.put(NAS_HYPERMETROVAULT.getValue(), (Set<Integer>)ImmutableSet.of((Object)3));
    }
}

