/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cdm.usedata.sdk.service;

import com.huawei.cdm.usedata.sdk.job.UseCopyDataJob;
import com.huawei.cdm.usedata.sdk.model.UseCopyDataSchedule;
import com.huawei.cdm.usedata.sdk.model.UseCopyDataTask;
import com.huawei.cdm.usedata.sdk.service.IUseCopyDataService;
import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.service.ITaskManager;
import com.huawei.ism.drm.constant.ReplicaMountStatus;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.ILocalRecoveryManager;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.protection.framework.service.replica.factory.IReplicaFactory;
import com.huawei.ism.drm.protection.framework.service.replica.factory.ReplicaFactoryManager;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.recovery.sdk.model.MountConfiguration;
import com.huawei.ism.drm.task.sdk.model.BaseTask;
import com.huawei.ism.drm.task.sdk.model.ITask;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate5.HibernateTemplate;

@Service(Name="com.huawei.ism.drm.protection.task.sdk.service.IUseCopyDataTaskService", Desc="", Interface=IUseCopyDataService.class)
public class UseCopyDataServiceImpl
extends BaseService
implements SystemStatusChangedListener,
IUseCopyDataService {
    private static final Log logger = LogFactory.getInstance(UseCopyDataServiceImpl.class);
    private static boolean started = false;
    private ITaskManager manager;
    private IBaseDao<Object, Serializable> dao;

    public void setManager(ITaskManager manager) {
        this.manager = manager;
    }

    public void setDao(IBaseDao<Object, Serializable> dao) {
        this.dao = dao;
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() == Status.STATUS_STARTED) {
            this.start();
        }
    }

    private void start() {
        if (started) {
            return;
        }
        List<UseCopyDataTask> tasks = this.getAllAutoTasks();
        ArrayList<UseCopyDataTask> remove = new ArrayList<UseCopyDataTask>();
        for (UseCopyDataTask task : tasks) {
            if (1 != task.getStatus() && 3 != task.getStatus()) continue;
            if (this.isNotBindRecoveryPlan(task)) {
                remove.add(task);
            }
            if (this.isOvertime(task.getSchedule().getStartTime())) {
                task.setStatus(2);
            }
            if (3 == task.getStatus()) {
                task.setStatus(1);
            }
            this.dao.getHibernateTemplate().update((Object)task);
        }
        tasks.removeAll(remove);
        this.dao.getHibernateTemplate().deleteAll(remove);
        List removedIds = remove.stream().map(BaseTask::getTaskId).collect(Collectors.toList());
        logger.warn((Object)("UseCopyDataTask has been delete.taskIds:" + removedIds));
        this.manager.recoveryExistTasks(tasks);
        this.resetAllRunningTaskByHand();
        started = true;
    }

    public void createTask(RecoveryPlan recoveryPlan, String startTime) {
        com.huawei.lego.core.sdk.util.VerifyUtil.checkObjs((Object[])new Object[]{recoveryPlan, startTime});
        UseCopyDataSchedule schedule = new UseCopyDataSchedule();
        schedule.setName(recoveryPlan.getName());
        schedule.setScheduleMode(0);
        schedule.setStartTime(startTime);
        UseCopyDataTask task = new UseCopyDataTask(recoveryPlan, schedule);
        task.setNextExecTime(startTime);
        task.setJobClassName(UseCopyDataJob.getClassName());
        this.addTask(task);
    }

    public void deleteTask(RecoveryPlan recoveryPlan) {
        com.huawei.lego.core.sdk.util.VerifyUtil.checkObjs((Object[])new Object[]{recoveryPlan});
        try {
            this.dao.getTransactionTemplate().execute(status -> {
                HibernateTemplate hibernateTemplate = this.dao.getHibernateTemplate();
                List<UseCopyDataTask> tasksInDb = this.getTaskInternel(recoveryPlan.getPlanId());
                if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(tasksInDb)) {
                    logger.warn((Object)("RecoveryPlan has not Task in DB. PlanId:" + recoveryPlan.getPlanId()));
                    return null;
                }
                for (UseCopyDataTask taskInDb : tasksInDb) {
                    this.manager.deleteJob((ITask)taskInDb);
                    logger.debug((Object)("UseCopyDataTask has been delete in Scheduler. taskId:" + taskInDb.getTaskId()));
                    hibernateTemplate.delete((Object)taskInDb);
                    logger.warn((Object)("UseCopyDataTask has been delete in DB. taskId:" + taskInDb.getTaskId()));
                }
                return null;
            });
        }
        catch (Exception ex) {
            ExceptionUtil.convertException((Throwable)ex, (String)"deleteTask got error, transaction has been roll back", (long)-1L, null, (Log)logger);
        }
    }

    public void updateTask(RecoveryPlan recoveryPlan, String startTime) {
        com.huawei.lego.core.sdk.util.VerifyUtil.checkObjs((Object[])new Object[]{recoveryPlan});
        List<UseCopyDataTask> tasks = this.getTaskInternel(recoveryPlan.getPlanId());
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)startTime)) {
            if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(tasks)) {
                tasks.stream().forEach(task -> {
                    if (1 == task.getStatus()) {
                        this.manager.unschedule((ITask)task);
                        task.setStatus(2);
                    }
                });
                this.dao.saveOrUpdateAll(tasks);
            }
            return;
        }
        if (this.isOvertime(startTime)) {
            logger.error((Object)("start time is overtime. startTime:" + startTime + " .now:" + new Date().getTime()));
            throw new LegoCheckedException(1073948456L);
        }
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(tasks)) {
            this.createTask(recoveryPlan, startTime);
        } else {
            for (UseCopyDataTask task2 : tasks) {
                UseCopyDataSchedule schedule = task2.getSchedule();
                schedule.setStartTime(startTime);
                task2.setNextExecTime(startTime);
                task2.setStatus(1);
                this.dao.update((Object)task2);
                this.manager.updateTrigger((ITask)task2);
            }
        }
    }

    public List<UseCopyDataTask> getTask(RecoveryPlan recoveryPlan) {
        com.huawei.lego.core.sdk.util.VerifyUtil.checkObjs((Object[])new Object[]{recoveryPlan});
        return this.getTaskInternel(recoveryPlan.getPlanId());
    }

    public void mountReplica(String planId, String replicaId, MountConfiguration mountConfiguration, User user) {
        com.huawei.lego.core.sdk.util.VerifyUtil.checkObjs((Object[])new Object[]{planId, replicaId, mountConfiguration, user});
        this.checkMountValid(mountConfiguration.getHostOrGroupSn(), replicaId);
        ILocalRecoveryManager recoveryManager = (ILocalRecoveryManager)ServiceLocator.getInstance().getService(ILocalRecoveryManager.class);
        recoveryManager.mountReplica(planId, mountConfiguration.getExtParameters(), user);
    }

    public void mountReplica(String planId, User user) {
        logger.debug((Object)("start mount rep. planId:" + planId));
        IRecoveryPlanService recoveryPlanService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryPlan recoveryPlan = recoveryPlanService.getRecoveryPlan(planId);
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)recoveryPlan)) {
            logger.error((Object)"get recoveryPlan got error,recoveryPlan is null");
            throw new LegoCheckedException(2117645L);
        }
        String replicaId = (String)recoveryPlan.getGlobalSettings().get("REPLICA_ID");
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)replicaId)) {
            logger.error((Object)"get replicaId got error,replicaId is null");
            throw new LegoCheckedException(2117645L);
        }
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        ProtectGroupReplica replica = replicaService.queryProtectGroupReplicaById(replicaId);
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)replica)) {
            logger.error((Object)"get replica got error,replica is null");
            throw new LegoCheckedException(2117645L);
        }
        String mountConfigs = replica.getProperty("mountConfigs");
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)mountConfigs)) {
            logger.error((Object)"get mountConfigs got error,mountConfigs is null");
            throw new LegoCheckedException(2117645L);
        }
        MountConfiguration mountConfiguration = (MountConfiguration)JSONObject.toBean((String)mountConfigs, MountConfiguration.class);
        this.mountReplica(planId, replicaId, mountConfiguration, user);
    }

    public void checkMountValid(String hostSn, String replicaId) {
        com.huawei.lego.core.sdk.util.VerifyUtil.checkObjs((Object[])new Object[]{hostSn, replicaId});
        IReplicaService service = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        ProtectGroupReplica replica = service.queryProtectGroupReplicaById(replicaId);
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)replica)) {
            logger.error((Object)("replication is null, replicaId:" + replicaId));
            throw new LegoCheckedException(2117645L);
        }
        if (Integer.valueOf(ReplicaMountStatus.MOUNTED.getStatus()).equals(replica.getMountStatus()) || Integer.valueOf(ReplicaMountStatus.UMOUNT_FAILED.getStatus()).equals(replica.getMountStatus())) {
            logger.error((Object)("srcReplica is not valid: " + replica.getId()));
            throw new LegoCheckedException(1073948693L);
        }
        ReplicaFactoryManager replicaFactoryManager = ReplicaFactoryManager.getInstance();
        IReplicaFactory factory = replicaFactoryManager.getReplicaFactory(replica.getType());
        if (!factory.validReplica(replica, true)) {
            logger.error((Object)("srcReplica is not valid: " + replica.getId()));
            throw new LegoCheckedException(1073948459L);
        }
        List<Integer> notAllowMountTypes = Arrays.asList(1, 2, 3, 16);
        if (!VerifyUtil.isEmpty((String)hostSn) && hostSn.equals(replica.getPg().getPoProviderSN()) && notAllowMountTypes.contains(replica.getPg().getPoType())) {
            logger.error((Object)("hostSn is product host." + hostSn));
            throw new LegoCheckedException(1073948256L);
        }
    }

    private void addTask(UseCopyDataTask task) {
        com.huawei.lego.core.sdk.util.VerifyUtil.checkObjs((Object[])new Object[]{task, task.getSchedule(), task.getRecoveryPlan(), task.getJobClassName(), task.getSchedule().getStartTime()});
        task.setCreateTime(String.valueOf(new Date().getTime()));
        task.setStatus(1);
        try {
            this.dao.save((Object)task);
            String startTime = task.getNextExecTime();
            if (this.isOvertime(startTime)) {
                logger.error((Object)("schedule start time is over time by now, startTime:" + startTime));
                return;
            }
            this.manager.schedule((ITask)task);
        }
        catch (DataAccessException e) {
            logger.error((Object)"add task failed", (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    private void resetAllRunningTaskByHand() {
        List tasks = null;
        String hql = "from UseCopyDataTask as t where t.schedule.scheduleMode = ?";
        try {
            tasks = this.dao.getHibernateTemplate().find(hql, new Object[]{1});
        }
        catch (DataAccessException e) {
            logger.error((Object)"get all manual tasks failed", (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        if (null != tasks) {
            for (UseCopyDataTask useCopyDataTask : tasks) {
                if (3 != useCopyDataTask.getStatus()) continue;
                logger.info((Object)("resetAllRunningTaskByHand setstatus task:" + useCopyDataTask.getJobClassName() + "-" + useCopyDataTask.getTaskId()), 90160758784001L);
                useCopyDataTask.setStatus(1);
                this.dao.getHibernateTemplate().update((Object)useCopyDataTask);
            }
        }
    }

    private List<UseCopyDataTask> getAllAutoTasks() {
        List tasks = null;
        String hql = "from UseCopyDataTask as t where t.schedule.scheduleMode = ?";
        try {
            tasks = this.dao.getHibernateTemplate().find(hql, new Object[]{0});
        }
        catch (DataAccessException e) {
            logger.error((Object)"get all auto tasks failed", (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        return tasks;
    }

    private boolean isNotBindRecoveryPlan(UseCopyDataTask task) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)task.getRecoveryPlan())) {
            return true;
        }
        String hql = "from RecoveryPlan as r where r.planId = ?";
        List recoveryPlans = this.dao.getHibernateTemplate().find(hql, new Object[]{task.getRecoveryPlan().getPlanId()});
        return recoveryPlans.isEmpty();
    }

    private List<UseCopyDataTask> getTaskInternel(String planId) {
        String findTaskHql = "from UseCopyDataTask as t where t.recoveryPlan.planId = ?";
        return this.dao.getHibernateTemplate().find(findTaskHql, new Object[]{planId});
    }

    private boolean isOvertime(String startTime) {
        Date now = new Date();
        Date executeTime = new Date(Long.parseLong(startTime));
        return now.after(executeTime);
    }
}

