/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.anti.blackmail.service;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.anti.blackmail.manager.proxy.AntiBlackmailSnapshotManagerProxy;
import com.huawei.ism.drm.anti.blackmail.manager.proxy.AntiBlackmailTaskManagerProxy;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailPlatform;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailPlatformTask;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailSnapshotDetectionInfo;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailSnapshotTaskInfo;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.oceanprotect.OceanProtectPlatformTask;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.service.IAntiBlackmailSnapshotManager;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.service.IAntiBlackmailTaskManager;
import com.huawei.ism.drm.anti.blackmail.service.AntiBlackmailPlatformCache;
import com.huawei.ism.drm.anti.blackmail.util.AntiBlackmailUtil;
import com.huawei.ism.drm.constant.AntiBlackMailEnumDefine;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class AntiBlackmailCreateSnapshotService
extends Thread
implements SystemStatusChangedListener {
    private static final Log LOGGER = LogFactory.getInstance(AntiBlackmailCreateSnapshotService.class);
    private static final String ANTI_BLACKMAIL_SNAPSHOT_THREAD_NAME = "Thread-anti-blackmail-snapshot";
    private static boolean started = false;
    private volatile boolean shouldStop = false;

    public AntiBlackmailCreateSnapshotService() {
        super(ANTI_BLACKMAIL_SNAPSHOT_THREAD_NAME);
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() == Status.STATUS_STARTED && !started) {
            this.initialize();
            AntiBlackmailCreateSnapshotService.setStarted(true);
        }
    }

    public static void setStarted(boolean started) {
        AntiBlackmailCreateSnapshotService.started = started;
    }

    public void initialize() {
        AntiBlackmailCreateSnapshotService snapshotService = new AntiBlackmailCreateSnapshotService();
        snapshotService.start();
    }

    @Override
    public void run() {
        while (!this.shouldStop) {
            try {
                AntiBlackmailPlatformCache.getInstance().getPlatformMap().values().stream().filter(AntiBlackmailPlatform::hasWaitingTaskToDeal).forEach(this::dealSnapshotTask);
                AntiBlackmailCreateSnapshotService.sleep(5000L);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Backend thread to deal running task interrupted, error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
        }
    }

    public void stopSnapshotService() {
        this.shouldStop = true;
    }

    private void dealSnapshotTask(AntiBlackmailPlatform platform) {
        try {
            this.checkAndRefreshSla(platform);
            this.trySendNewTaskToOP(platform);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error happened when try send task, tread keep going on dealing, devSn: %s, message: %s.", new Object[]{platform.getDevSn(), ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        try {
            this.checkRunningTask(platform);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error happened when deal task, tread keep going on dealing, devSn: %s, message: %s.", new Object[]{platform.getDevSn(), ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    private void checkAndRefreshSla(AntiBlackmailPlatform platform) {
        String sla = AntiBlackmailUtil.getOrBuildNasAirGapSla(platform.getDevSn());
        if (!platform.getSlaId().equals(sla)) {
            LOGGER.warn((Object)"ProtectManager sla has changed, refresh it, devSn: %s.", new Object[]{platform.getDevSn()});
            platform.setSlaId(sla);
        }
    }

    private void trySendNewTaskToOP(AntiBlackmailPlatform platform) {
        while (platform.hasNewTaskToSend()) {
            AntiBlackmailSnapshotTaskInfo taskInfo = (AntiBlackmailSnapshotTaskInfo)platform.getSnapshotTasksQueue().peek();
            if (VerifyUtil.isEmpty((Object)taskInfo)) {
                LOGGER.warn((Object)"Current task is null, devSn: %s.", new Object[]{platform.getDevSn()});
                break;
            }
            String jobId = this.doCreateSnapshot(platform, taskInfo);
            if (VerifyUtil.isEmpty((String)jobId)) {
                LOGGER.warn((Object)"Send new task to Protect Manager failed or Protect Manager has refused this task, devSn: %s.", new Object[]{platform.getDevSn()});
                break;
            }
            platform.getSnapshotTasksQueue().poll();
            platform.getSnapshotTasksRunningMap().put(jobId, taskInfo.getProtectObjectReplica());
        }
    }

    private void checkRunningTask(AntiBlackmailPlatform platform) {
        IAntiBlackmailTaskManager taskManager = AntiBlackmailTaskManagerProxy.getInstance().getTaskManager(platform.getDevSn());
        Iterator iterator = platform.getSnapshotTasksRunningMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ProtectObjectReplica> entry = iterator.next();
            Optional taskOptional = taskManager.querySpecificTask(platform.getDevSn(), (String)entry.getKey());
            if (!taskOptional.isPresent()) continue;
            AntiBlackmailPlatformTask antiBlackmailPlatformTask = (AntiBlackmailPlatformTask)taskOptional.get();
            OceanProtectPlatformTask taskDetail = null;
            if (antiBlackmailPlatformTask instanceof OceanProtectPlatformTask) {
                taskDetail = (OceanProtectPlatformTask)antiBlackmailPlatformTask;
            }
            ProtectObjectReplica protectObjectReplica = (ProtectObjectReplica)entry.getValue();
            if (VerifyUtil.isEmpty((Object)taskDetail) || !this.dealResult(platform, taskDetail, protectObjectReplica)) continue;
            String snapshotId = taskDetail.getAssociativeId();
            this.dealNewSnapShotName(entry, snapshotId);
            iterator.remove();
            this.addCheckSnapshotTask(platform, protectObjectReplica, snapshotId);
        }
    }

    private void dealNewSnapShotName(Map.Entry<String, ProtectObjectReplica> entry, String snapshotId) {
        RelicaStorageInfo storageInfo;
        ProtectObjectReplica protectObjectReplica = entry.getValue();
        Set storageInfoSet = protectObjectReplica.getStorageInfos();
        if (!VerifyUtil.isEmpty((Collection)storageInfoSet) && (storageInfo = (RelicaStorageInfo)storageInfoSet.iterator().next()) instanceof LocalStorageReplica) {
            LocalStorageReplica localStorageReplica = (LocalStorageReplica)storageInfo;
            localStorageReplica.setSnapshotName(snapshotId);
            localStorageReplica.setStorageId(localStorageReplica.getSrcStorageId() + "@" + snapshotId);
        }
    }

    private boolean dealResult(AntiBlackmailPlatform platform, OceanProtectPlatformTask taskDetail, ProtectObjectReplica protectObjectReplica) {
        int currentCount;
        if (!AntiBlackMailEnumDefine.OceanProtectTaskStatusEnum.SUCCESS.getValue().equals(taskDetail.getStatus())) {
            return Boolean.FALSE;
        }
        AtomicInteger atomicInteger = (AtomicInteger)platform.getSnapshotTaskFinishedCountMap().get(protectObjectReplica.getPgReplica().getId());
        while ((currentCount = atomicInteger.get()) > 0 && !atomicInteger.compareAndSet(currentCount, currentCount - 1)) {
        }
        return Boolean.TRUE;
    }

    private String doCreateSnapshot(AntiBlackmailPlatform platform, AntiBlackmailSnapshotTaskInfo taskInfo) {
        String copyName = taskInfo.getCopyName();
        String pmFileSystemId = taskInfo.getPmFileSystemId();
        IAntiBlackmailSnapshotManager snapshotManager = AntiBlackmailSnapshotManagerProxy.getInstance().getSnapshotManager(platform.getDevSn());
        Optional snapshotJobId = snapshotManager.createSnapshot(platform.getDevSn(), copyName, platform.getSlaId(), pmFileSystemId);
        if (snapshotJobId.isPresent()) {
            return (String)snapshotJobId.get();
        }
        LOGGER.error((Object)"Create snapshot error: devSn: %s, copyName: %s, slaId: %s, pmFileSystemId: %s.", new Object[]{platform.getDevSn(), copyName, platform.getSlaId(), pmFileSystemId});
        return "";
    }

    private void addCheckSnapshotTask(AntiBlackmailPlatform platform, ProtectObjectReplica protectObjectReplica, String snapshotId) {
        AntiBlackmailSnapshotDetectionInfo detectTaskInfo = new AntiBlackmailSnapshotDetectionInfo();
        String pgRId = protectObjectReplica.getPgReplica().getId();
        detectTaskInfo.setId(pgRId);
        detectTaskInfo.setPgOId(protectObjectReplica.getId());
        detectTaskInfo.setPgRName(protectObjectReplica.getPgReplica().getName());
        detectTaskInfo.setDetectStatus(AntiBlackMailEnumDefine.DetectionStatus.NO_DETECT.getValue());
        detectTaskInfo.setCopyId(snapshotId);
        detectTaskInfo.setPmFileSystemId(protectObjectReplica.getPlaceholderProtectObjectId());
        platform.getSnapshotDetectTasksCacheMap().computeIfAbsent(pgRId, key -> new ArrayList()).add(detectTaskInfo);
    }
}

