/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.anti.blackmail.service;

import com.huawei.ism.cbb.base.sdk.constant.CommonConstant;
import com.huawei.ism.drm.anti.blackmail.manager.proxy.AntiBlackmailTaskManagerProxy;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailPlatform;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailPlatformTask;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailSnapshotDeleteDetail;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.oceanprotect.OceanProtectPlatformTask;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.service.IAntiBlackmailTaskManager;
import com.huawei.ism.drm.anti.blackmail.service.AntiBlackmailPlatformCache;
import com.huawei.ism.drm.anti.blackmail.util.AntiBlackmailResourceLockUtil;
import com.huawei.ism.drm.anti.blackmail.util.AntiBlackmailUtil;
import com.huawei.ism.drm.constant.AntiBlackMailConstant;
import com.huawei.ism.drm.constant.AntiBlackMailEnumDefine;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.backtask.sdk.service.IBackTaskService;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.TimeUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;

public class AntiBlackmailSnapshotDeleteService
extends Thread
implements SystemStatusChangedListener {
    private static final Log LOGGER = LogFactory.getInstance(AntiBlackmailSnapshotDeleteService.class);
    private static final String ANTI_BLACKMAIL_SNAPSHOT_DELETE_THREAD_NAME = "Thread-anti-blackmail-snapshot-delete";
    private static final ReentrantLock LOCK = new ReentrantLock();
    private static int runningTaskNum = 0;
    private static boolean hasStarted = false;
    private volatile boolean shouldStop = false;

    public AntiBlackmailSnapshotDeleteService() {
        super(ANTI_BLACKMAIL_SNAPSHOT_DELETE_THREAD_NAME);
    }

    public static boolean preAddOneTaskNum() {
        LOCK.lock();
        try {
            if (runningTaskNum >= 512) {
                boolean bl = false;
                return bl;
            }
            ++runningTaskNum;
            boolean bl = true;
            return bl;
        }
        finally {
            LOCK.unlock();
        }
    }

    public static void taskNumDecreaseOne() {
        LOCK.lock();
        try {
            --runningTaskNum;
        }
        finally {
            LOCK.unlock();
        }
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() == Status.STATUS_STARTED && !hasStarted) {
            this.initialize();
            AntiBlackmailSnapshotDeleteService.setHasStarted(true);
        }
    }

    public static void setHasStarted(boolean hasStarted) {
        AntiBlackmailSnapshotDeleteService.hasStarted = hasStarted;
    }

    public void initialize() {
        AntiBlackmailSnapshotDeleteService deleteService = new AntiBlackmailSnapshotDeleteService();
        deleteService.start();
    }

    @Override
    public void run() {
        while (!this.shouldStop) {
            try {
                AntiBlackmailPlatformCache.getInstance().getPlatformMap().values().stream().filter(AntiBlackmailPlatform::hasWaitingDeleteTaskToDeal).forEach(this::dealSnapshotDeleteTask);
                AntiBlackmailSnapshotDeleteService.sleep(10000L);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Background thread to deal running delete task interrupted, error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
        }
    }

    private void dealSnapshotDeleteTask(AntiBlackmailPlatform platform) {
        long start = System.currentTimeMillis();
        LOGGER.info((Object)"Start sync time: %s", new Object[]{TimeUtil.toLocalString((long)start)});
        Map backTasksRunningMap = platform.getSnapshotDeleteBackTasksRunningMap();
        String devSn = platform.getDevSn();
        if (VerifyUtil.isEmpty((Map)backTasksRunningMap)) {
            LOGGER.info((Object)"Platform(devSn:%s) has no delete task to sync now.", new Object[]{devSn});
            return;
        }
        IAntiBlackmailTaskManager taskManager = AntiBlackmailTaskManagerProxy.getInstance().getTaskManager(devSn);
        String type = AntiBlackMailEnumDefine.OceanProtectTaskTypeEnum.COPY_DELETE.getValue();
        List runningTaskList = taskManager.queryRunningTask(devSn, type);
        this.syncRunningTaskId(platform, runningTaskList);
        this.freshBackTaskStatus(platform);
        LOGGER.info((Object)"Finish sync and use time: %sS", new Object[]{String.valueOf((System.currentTimeMillis() - start) / 1000L)});
    }

    private void syncRunningTaskId(AntiBlackmailPlatform platform, List<AntiBlackmailPlatformTask> taskList) {
        for (AntiBlackmailPlatformTask antiBlackmailPlatformTask : taskList) {
            if (!(antiBlackmailPlatformTask instanceof OceanProtectPlatformTask)) continue;
            OceanProtectPlatformTask task = (OceanProtectPlatformTask)antiBlackmailPlatformTask;
            platform.getSnapshotDeleteSnapshotTaskRelateMap().putIfAbsent(task.getCopyId(), task.getJobId());
        }
    }

    private void freshBackTaskStatus(AntiBlackmailPlatform platform) {
        Map backTasksRunningMap = platform.getSnapshotDeleteBackTasksRunningMap();
        Iterator<Map.Entry<String, BackTask>> iterator = backTasksRunningMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, BackTask> next = iterator.next();
            BackTask backTask = (BackTask)next.getValue();
            AntiBlackmailSnapshotDeleteDetail deleteDetail = AntiBlackmailUtil.getDetailFromDeleteTask(backTask);
            List snapshotIds = deleteDetail.getSnapshotIds();
            HashMap<String, Integer> countMap = new HashMap<String, Integer>();
            countMap.put("failNum", 0);
            countMap.put("running", 0);
            ArrayList<String> notFinishList = new ArrayList<String>();
            this.summaryAllSnapshotDeleteStatus(platform, deleteDetail, snapshotIds, countMap, notFinishList);
            int running = (Integer)countMap.get("running");
            if (running > 0) {
                deleteDetail.setSnapshotIds(notFinishList);
                backTask.setBackendTaskDetail(JSONObject.fromObject((Object)deleteDetail).toString());
                int total = deleteDetail.getTotal();
                backTask.setTaskProgress(Integer.valueOf((total - running) * 100 / total));
                if (!deleteDetail.isManual()) {
                    LOGGER.info((Object)"Not manual task,no need to update db.");
                    continue;
                }
                this.updateTask(backTask);
                continue;
            }
            if (!deleteDetail.isManual()) {
                iterator.remove();
                continue;
            }
            if ((Integer)countMap.get("failNum") > 0) {
                this.setTaskFail(backTask, iterator, next);
                continue;
            }
            this.setTaskSuccess(backTask, iterator, next);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTaskSuccess(BackTask backTask, Iterator<Map.Entry<String, BackTask>> iterator, Map.Entry<String, BackTask> next) {
        try {
            backTask.setTaskProgress(Integer.valueOf(100));
            backTask.setEndTime(new Date());
            backTask.setTaskResult(Integer.valueOf(CommonConstant.BACKTASK_RESULT_SUCCESS));
            this.updateTask(backTask);
            ((IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class)).deleteProtectGroupReplicaById(next.getKey());
            iterator.remove();
            AntiBlackmailSnapshotDeleteService.taskNumDecreaseOne();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Deal success task error, error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        finally {
            AntiBlackmailResourceLockUtil.unlockRes(next.getKey() + "AntiBlackmailSnapshotReplica");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTaskFail(BackTask backTask, Iterator<Map.Entry<String, BackTask>> iterator, Map.Entry<String, BackTask> next) {
        try {
            backTask.setTaskProgress(Integer.valueOf(100));
            backTask.setEndTime(new Date());
            backTask.setTaskResult(Integer.valueOf(CommonConstant.BACKTASK_RESULT_FAIL));
            this.updateTask(backTask);
            AntiBlackmailUtil.updateReplica(next.getKey(), 3, new HashSet<ProtectObjectReplica>());
            iterator.remove();
            AntiBlackmailSnapshotDeleteService.taskNumDecreaseOne();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Deal fail task error, error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        finally {
            AntiBlackmailResourceLockUtil.unlockRes(next.getKey() + "AntiBlackmailSnapshotReplica");
        }
    }

    private void summaryAllSnapshotDeleteStatus(AntiBlackmailPlatform platform, AntiBlackmailSnapshotDeleteDetail deleteDetail, List<String> snapshotIds, Map<String, Integer> countMap, List<String> notFinishList) {
        IAntiBlackmailTaskManager taskManager = AntiBlackmailTaskManagerProxy.getInstance().getTaskManager(platform.getDevSn());
        for (String snapshotId : snapshotIds) {
            String taskId = (String)platform.getSnapshotDeleteSnapshotTaskRelateMap().get(snapshotId);
            if (VerifyUtil.isEmpty((String)taskId)) {
                LOGGER.error((Object)"Snapshot relate task in PM not exist, snapshotId: %s", new Object[]{snapshotId});
                countMap.put("running", countMap.get("running") + 1);
                notFinishList.add(snapshotId);
                continue;
            }
            Optional taskOptional = taskManager.querySpecificTask(platform.getDevSn(), taskId);
            if (!taskOptional.isPresent()) {
                LOGGER.error((Object)"Do not get task from PM, PM may be abort, snapshotId: %s", new Object[]{snapshotId});
                continue;
            }
            AntiBlackmailPlatformTask task = (AntiBlackmailPlatformTask)taskOptional.get();
            String currentStatus = task.getStatus();
            if (AntiBlackMailConstant.OP_TASK_RUNNING_STATUS_LIST.contains(currentStatus)) {
                LOGGER.info((Object)"Delete snapshot task not finished yet, taskId: %s, snapshotId: %s.", new Object[]{taskId, snapshotId});
                countMap.put("running", countMap.get("running") + 1);
                notFinishList.add(snapshotId);
                continue;
            }
            if (task.getProgress() == 100 && !AntiBlackMailEnumDefine.OceanProtectTaskStatusEnum.SUCCESS.getValue().equals(currentStatus)) {
                LOGGER.error((Object)"Delete snapshot task failed, taskId: %s, snapshotUuid: %s.", new Object[]{taskId, snapshotId});
                countMap.put("failNum", countMap.get("failNum") + 1);
                if (deleteDetail.isManual()) continue;
                AntiBlackmailUtil.sendDeleteFailAlarmMsg(deleteDetail.getDevSn(), deleteDetail.getPgName(), snapshotId);
                continue;
            }
            if (task.getProgress() != 100 || !AntiBlackMailEnumDefine.OceanProtectTaskStatusEnum.SUCCESS.getValue().equals(currentStatus)) continue;
            platform.getSnapshotDeleteSnapshotTaskRelateMap().remove(snapshotId);
        }
    }

    private void updateTask(BackTask backTask) {
        try {
            ((IBackTaskService)ServiceLocator.getInstance().getService(IBackTaskService.class)).updateTask(backTask);
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 201L) {
                LOGGER.error((Object)"Delete snapshot task does not exists in db, Might have been deleted, clean this in cache.");
                AntiBlackmailUtil.cleanDeleteTask(backTask);
                AntiBlackmailResourceLockUtil.unlockRes(AntiBlackmailUtil.getDetailFromDeleteTask(backTask).getPgRId() + "AntiBlackmailSnapshotReplica");
                return;
            }
            throw e;
        }
    }
}

