/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.anti.blackmail.service;

import com.huawei.ism.cbb.base.sdk.constant.CommonConstant;
import com.huawei.ism.cbb.base.util.AlarmUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailPlatform;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailSnapshotDetectionDetail;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailSnapshotDetectionInfo;
import com.huawei.ism.drm.anti.blackmail.service.AntiBlackmailPlatformCache;
import com.huawei.ism.drm.anti.blackmail.service.DetectionResultTask;
import com.huawei.ism.drm.anti.blackmail.util.AntiBlackmailUtil;
import com.huawei.ism.drm.constant.AntiBlackMailConstant;
import com.huawei.ism.drm.constant.AntiBlackMailEnumDefine;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.backtask.sdk.service.BackTaskState;
import com.huawei.lego.cbb.backtask.sdk.service.IBackTaskService;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.TimeUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class AntiBlackmailSnapshotDetectService
extends Thread
implements SystemStatusChangedListener {
    private static final Log LOGGER = LogFactory.getInstance(AntiBlackmailSnapshotDetectService.class);
    private static final String ANTI_BLACKMAIL_SNAPSHOT_DETECT_THREAD_NAME = "Thread-anti-blackmail-snapshot-detect";
    private static boolean started = false;
    private volatile boolean shouldStop = false;
    private volatile boolean isCheckAll = true;
    private IBackTaskService taskService;

    public AntiBlackmailSnapshotDetectService() {
        super(ANTI_BLACKMAIL_SNAPSHOT_DETECT_THREAD_NAME);
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() == Status.STATUS_STARTED && !started) {
            this.initialize();
            AntiBlackmailSnapshotDetectService.setStarted(true);
        }
    }

    public static void setStarted(boolean started) {
        AntiBlackmailSnapshotDetectService.started = started;
    }

    public void initialize() {
        AntiBlackmailSnapshotDetectService detectService = new AntiBlackmailSnapshotDetectService();
        detectService.start();
        try {
            this.reloadDetectionTasksFromDBAfterRestartSystem();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Query detect backTasks from db error, error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        LOGGER.info((Object)"Finish init AntiBlackmailSnapshotDetectService and backTasks.");
    }

    @Override
    public void run() {
        while (!this.shouldStop) {
            try {
                AntiBlackmailPlatformCache.getInstance().getPlatformMap().values().stream().filter(AntiBlackmailPlatform::hasWaitingDetectTaskToDeal).forEach(this::dealSnapshotDetectTask);
                AntiBlackmailSnapshotDetectService.sleep(5000L);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Background thread to deal running detect task interrupted, error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
        }
    }

    public void stopSnapshotDetectService() {
        this.shouldStop = true;
    }

    private void reloadDetectionTasksFromDBAfterRestartSystem() {
        this.getBackTaskService();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("taskName", "protectManager_snapshotDetect_operateName");
        condition.put("taskResult", BackTaskState.process.getValue());
        List backTasks = this.taskService.queryTasks(condition);
        condition.put("taskResult", BackTaskState.fail.getValue());
        List failedBackTasks = this.taskService.queryTasks(condition);
        backTasks.addAll(failedBackTasks);
        if (backTasks.size() == 0) {
            LOGGER.error((Object)"No detection task in db need to reload.");
            return;
        }
        for (BackTask backTask : backTasks) {
            int detectStatus;
            if (!VerifyUtil.isEmpty((String)backTask.getTaskDetail())) {
                LOGGER.info((Object)"Detection task failed for other reason.");
                continue;
            }
            AntiBlackmailSnapshotDetectionDetail detailFromTask = AntiBlackmailUtil.getDetailFromTask(backTask);
            AntiBlackmailPlatform platform = AntiBlackmailPlatformCache.getInstance().getPlatform(detailFromTask.getDevSn());
            if (VerifyUtil.isEmpty((Object)platform)) {
                platform = AntiBlackmailUtil.addAntiBlackMailPlatform(detailFromTask.getDevSn());
            }
            if (AntiBlackMailConstant.REPLICA_DETECTION_FINISH.contains(detectStatus = detailFromTask.getDetectStatus())) continue;
            this.reloadRunningDetectionTask(backTask, detailFromTask, platform);
        }
        LOGGER.info((Object)"Finish reload detection task.");
    }

    private void reloadRunningDetectionTask(BackTask backTask, AntiBlackmailSnapshotDetectionDetail detailFromTask, AntiBlackmailPlatform platform) {
        ProtectGroupReplica protectGroupReplica = (ProtectGroupReplica)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ProtectGroupReplica.class, (Serializable)((Object)detailFromTask.getPgRId()));
        if (VerifyUtil.isEmpty((Object)protectGroupReplica)) {
            LOGGER.error((Object)"Replica has been delete, replicaId: %s", new Object[]{detailFromTask.getPgRId()});
            return;
        }
        Set replicas = protectGroupReplica.getReplicas();
        for (ProtectObjectReplica protectObjectReplica : replicas) {
            RelicaStorageInfo storageInfo;
            AntiBlackmailSnapshotDetectionInfo detectTaskInfo = new AntiBlackmailSnapshotDetectionInfo();
            String pgRId = protectObjectReplica.getPgReplica().getId();
            detectTaskInfo.setId(pgRId);
            detectTaskInfo.setPgOId(protectObjectReplica.getId());
            detectTaskInfo.setPgRName(protectObjectReplica.getPgReplica().getName());
            detectTaskInfo.setDetectStatus(AntiBlackMailEnumDefine.DetectionStatus.NO_DETECT.getValue());
            Set storageInfoSet = protectObjectReplica.getStorageInfos();
            String copyId = "";
            if (!VerifyUtil.isEmpty((Collection)storageInfoSet) && (storageInfo = (RelicaStorageInfo)storageInfoSet.iterator().next()) instanceof LocalStorageReplica) {
                LocalStorageReplica localStorageReplica = (LocalStorageReplica)storageInfo;
                copyId = localStorageReplica.getSnapshotName();
            }
            detectTaskInfo.setCopyId(copyId);
            detectTaskInfo.setPmFileSystemId(protectObjectReplica.getPlaceholderProtectObjectId());
            platform.getSnapshotDetectTasksCacheMap().computeIfAbsent(pgRId, key -> new ArrayList()).add(detectTaskInfo);
            platform.getAllSnapshotIdCacheMap().put(copyId, detectTaskInfo);
        }
        backTask.setTaskResult(Integer.valueOf(BackTaskState.process.getValue()));
        this.updateTaskAndReplica(backTask, "", 0, false);
        platform.addTask(protectGroupReplica.getId(), backTask);
    }

    private void getBackTaskService() {
        if (this.taskService == null) {
            this.taskService = (IBackTaskService)ServiceLocator.getInstance().getService(IBackTaskService.class);
        }
        if (this.taskService == null) {
            LOGGER.error((Object)"Anti blackmail snapshot detect service get taskService failed.");
            throw new LegoCheckedException(102410L);
        }
    }

    private void dealSnapshotDetectTask(AntiBlackmailPlatform platform) {
        Map backTasksRunningMap = platform.getSnapshotDetectBackTasksRunningMap();
        if (VerifyUtil.isEmpty((Map)backTasksRunningMap)) {
            LOGGER.info((Object)"Platform(devSn:%s) has no detect task to sync now.", new Object[]{platform.getDevSn()});
            return;
        }
        this.batchSyncDetectionResult(platform, this.createTasks(platform));
        this.refreshBackTaskStatus(platform, backTasksRunningMap);
    }

    private List<Callable<Boolean>> createTasks(AntiBlackmailPlatform platform) {
        ArrayList<Callable<Boolean>> tasks = new ArrayList<Callable<Boolean>>();
        if (!this.isCheckAll && platform.getSnapshotDetectTasksRunningMap().size() != 0) {
            platform.getSnapshotDetectTasksRunningMap().entrySet().stream().forEach(entry -> tasks.add(new DetectionResultTask((AntiBlackmailSnapshotDetectionInfo)entry.getValue(), platform.getDevSn())));
            LOGGER.info((Object)"Check part task, sn: %s, taskNum: %s", new Object[]{platform.getDevSn(), String.valueOf(tasks.size())});
            return tasks;
        }
        for (List snapshotDetectionInfos : platform.getSnapshotDetectTasksCacheMap().values()) {
            snapshotDetectionInfos.stream().filter(e -> e.getDetectStatus() < AntiBlackMailEnumDefine.DetectionStatus.UN_INFECTED.getValue()).forEach(detectionInfo -> tasks.add(new DetectionResultTask((AntiBlackmailSnapshotDetectionInfo)detectionInfo, platform.getDevSn())));
        }
        LOGGER.info((Object)"Check all task, sn: %s, taskNum: %s", new Object[]{platform.getDevSn(), String.valueOf(tasks.size())});
        return tasks;
    }

    private void batchSyncDetectionResult(AntiBlackmailPlatform platform, List<Callable<Boolean>> tasks) {
        long start = System.currentTimeMillis();
        if (tasks.size() == 0) {
            LOGGER.info((Object)"Has no task, sn: %s, time: %s", new Object[]{platform.getDevSn(), TimeUtil.toLocalString((long)start)});
            return;
        }
        LOGGER.info((Object)"Start to sync detection result, sn: %s, start time: %s", new Object[]{platform.getDevSn(), TimeUtil.toLocalString((long)start)});
        List finnishStatus = ExecutionService.batchSubmit(tasks, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_CONTINUE, (int)0, (int)20);
        long runningCount = finnishStatus.stream().filter(e -> e).count();
        if (runningCount > 0L) {
            this.isCheckAll = true;
        } else if (platform.getSnapshotDetectTasksRunningMap().size() > 0) {
            this.isCheckAll = false;
        }
        long end = System.currentTimeMillis();
        LOGGER.info((Object)"End to sync detection result, sn: %s, end time: %s, total cost: %sS", new Object[]{platform.getDevSn(), TimeUtil.toLocalString((long)end), String.valueOf((end - start) / 1000L)});
    }

    private boolean isDetectionFinish(AntiBlackmailSnapshotDetectionInfo detectionInfo) {
        return AntiBlackMailConstant.SNAPSHOT_DETECTION_FINISH.contains(detectionInfo.getDetectStatus());
    }

    private boolean isDetectionRunning(AntiBlackmailSnapshotDetectionInfo detectionInfo) {
        return AntiBlackMailConstant.SNAPSHOT_DETECTION_DOING.contains(detectionInfo.getDetectStatus());
    }

    private void refreshBackTaskStatus(AntiBlackmailPlatform platform, Map<String, BackTask> backTasks) {
        long start = System.currentTimeMillis();
        LOGGER.info((Object)"Start to refresh task status, sn: %s, start time: %s", new Object[]{platform.getDevSn(), TimeUtil.toLocalString((long)start)});
        Iterator<Map.Entry<String, BackTask>> iterator = backTasks.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, BackTask> backTaskEntry = iterator.next();
            BackTask backTask = backTaskEntry.getValue();
            try {
                BackTask freshBackTask = this.countAndFreshBackTaskStatus(backTask);
                if (freshBackTask.getTaskProgress() != 100) continue;
                this.sendAlarmMsg(freshBackTask);
                iterator.remove();
            }
            catch (Exception e) {
                LOGGER.error((Object)"Sync detect task failed, taskDetail: %s, error: %s", new Object[]{backTask.getTaskDetail(), ExceptionUtil.getErrorMessage((Throwable)e)});
            }
        }
        long end = System.currentTimeMillis();
        LOGGER.info((Object)"End to sync refresh task status, sn: %s, end time: %s, total cost: %sS", new Object[]{platform.getDevSn(), TimeUtil.toLocalString((long)end), String.valueOf((end - start) / 1000L)});
    }

    private BackTask countAndFreshBackTaskStatus(BackTask backTask) {
        String taskDetailStr = backTask.getBackendTaskDetail();
        AntiBlackmailSnapshotDetectionDetail detectionDetail = (AntiBlackmailSnapshotDetectionDetail)JSONObject.toBean((String)taskDetailStr, AntiBlackmailSnapshotDetectionDetail.class);
        AntiBlackmailPlatformCache platformCache = AntiBlackmailPlatformCache.getInstance();
        AntiBlackmailPlatform platform = platformCache.getPlatform(detectionDetail.getDevSn());
        String pgRId = detectionDetail.getPgRId();
        List detectionInfos = (List)platform.getSnapshotDetectTasksCacheMap().get(pgRId);
        boolean isExistError = false;
        int finishedCount = 0;
        int infectedCount = 0;
        int queuingCount = 0;
        for (AntiBlackmailSnapshotDetectionInfo detectTaskInfo : detectionInfos) {
            if (this.isQueuing(detectTaskInfo)) {
                ++queuingCount;
            }
            if (this.isDetectionFinish(detectTaskInfo)) {
                ++finishedCount;
            }
            if (this.isInfected(detectTaskInfo)) {
                ++infectedCount;
            }
            if (!this.isDetectionError(detectTaskInfo)) continue;
            isExistError = true;
        }
        int total = detectionDetail.getTotal();
        int pgReplicaStatus = AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum.QUEUING.getValue();
        if (queuingCount == total) {
            this.setTaskNewBackendDetail(detectionDetail, pgReplicaStatus, backTask);
            this.updateTaskAndReplica(backTask, detectionDetail.getPgRId(), pgReplicaStatus, true);
            return backTask;
        }
        pgReplicaStatus = AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum.SCANNING.getValue();
        if (finishedCount != total) {
            if (!VerifyUtil.isEmpty((String)backTask.getTaskDetail())) {
                return backTask;
            }
            backTask.setTaskProgress(Integer.valueOf(finishedCount * 100 / total));
            this.setTaskNewBackendDetail(detectionDetail, pgReplicaStatus, backTask);
            this.updateTaskAndReplica(backTask, detectionDetail.getPgRId(), pgReplicaStatus, true);
            return backTask;
        }
        pgReplicaStatus = this.getPgReplicaFinishedStatus(backTask, isExistError, infectedCount, total);
        this.setTaskNewBackendDetail(detectionDetail, pgReplicaStatus, backTask);
        this.setTaskErrorMsg(backTask, pgReplicaStatus);
        this.updateTaskAndReplica(backTask, detectionDetail.getPgRId(), pgReplicaStatus, true);
        platform.getSnapshotDetectTasksCacheMap().remove(pgRId);
        this.checkAndTransSecureSnapshot(detectionDetail, pgReplicaStatus);
        return backTask;
    }

    private void setTaskNewBackendDetail(AntiBlackmailSnapshotDetectionDetail detectionDetail, int pgReplicaStatus, BackTask backTask) {
        detectionDetail.setDetectStatus(pgReplicaStatus);
        backTask.setBackendTaskDetail(JSONObject.fromObject((Object)detectionDetail).toString());
    }

    private int getPgReplicaFinishedStatus(BackTask backTask, boolean isExistError, int infectedCount, int total) {
        backTask.setTaskProgress(Integer.valueOf(100));
        backTask.setEndTime(new Date());
        backTask.setTaskResult(Integer.valueOf(isExistError || infectedCount != 0 ? CommonConstant.BACKTASK_RESULT_FAIL : CommonConstant.BACKTASK_RESULT_SUCCESS));
        return isExistError ? AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum.ABNORMAL.getValue() : (infectedCount == total ? AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum.ALL_INFECTED.getValue() : (infectedCount == 0 ? AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum.UNINFECTED.getValue() : AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum.PARTIALLY_INFECTED.getValue()));
    }

    private void setTaskErrorMsg(BackTask backTask, int pgReplicaStatus) {
        if (pgReplicaStatus != AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum.UNINFECTED.getValue()) {
            backTask.setTaskDetail(String.valueOf(1073948511L));
            backTask.setTaskDetailParas(new String[]{AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum.getDetectionStatusEnumDesc((int)pgReplicaStatus)});
        }
    }

    private void checkAndTransSecureSnapshot(AntiBlackmailSnapshotDetectionDetail detail, int pgReplicaStatus) {
        if (pgReplicaStatus != AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum.UNINFECTED.getValue()) {
            LOGGER.error((Object)"Detection task failed, no need to trans secure snapshot.");
            return;
        }
        ProtectGroupReplica protectGroupReplica = (ProtectGroupReplica)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ProtectGroupReplica.class, (Serializable)((Object)detail.getPgRId()));
        if (!AntiBlackmailUtil.isUsingSecureSnapshotPolicy(protectGroupReplica.getPg())) {
            LOGGER.info((Object)"No need to transfer replica(name: %s).", new Object[]{protectGroupReplica.getName()});
            return;
        }
        AntiBlackmailUtil.transferToSecureReplica(protectGroupReplica);
    }

    private boolean isInfected(AntiBlackmailSnapshotDetectionInfo detectionInfo) {
        return detectionInfo.getDetectStatus() == AntiBlackMailEnumDefine.DetectionStatus.INFECTED.getValue();
    }

    private boolean isDetectionError(AntiBlackmailSnapshotDetectionInfo detectionInfo) {
        return detectionInfo.getDetectStatus() == AntiBlackMailEnumDefine.DetectionStatus.ABNORMAL.getValue();
    }

    private boolean isQueuing(AntiBlackmailSnapshotDetectionInfo detectionInfo) {
        return detectionInfo.getDetectStatus() == AntiBlackMailEnumDefine.DetectionStatus.PREPARING.getValue();
    }

    private void updateTaskAndReplica(BackTask backTask, String pgRId, int pgReplicaStatus, boolean isUpdateReplica) {
        this.getBackTaskService();
        try {
            this.taskService.updateTask(backTask);
            if (isUpdateReplica) {
                AntiBlackmailUtil.updateProtectGroupReplicaDetectionStatus(pgRId, pgReplicaStatus);
            }
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 201L) {
                LOGGER.error((Object)"Detection back task does not exists in db, Might have been deleted, clean this in cache.");
                AntiBlackmailUtil.cleanDetectionTask(backTask);
                AntiBlackmailUtil.updateProtectGroupReplicaDetectionStatus(pgRId, AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum.UNKNOWN.getValue());
                return;
            }
            throw e;
        }
    }

    private void sendAlarmMsg(BackTask backTask) {
        AntiBlackmailSnapshotDetectionDetail detail = AntiBlackmailUtil.getDetailFromTask(backTask);
        if (detail.getDetectStatus() != AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum.UNINFECTED.getValue()) {
            String[] alarmParams = new String[]{detail.getDevSn(), detail.getPgRName(), AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum.getDetectionStatusEnumDesc((int)detail.getDetectStatus())};
            AlarmUtil.sendDetectionAlarm((String)"0x3230075", (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])alarmParams);
        }
    }
}

