/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.anti.blackmail.service;

import com.huawei.ism.cbb.base.sdk.constant.CommonConstant;
import com.huawei.ism.cbb.base.util.AlarmUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.anti.blackmail.manager.proxy.AntiBlackmailSnapshotManagerProxy;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailPlatform;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailSnapshot;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailSnapshotDetectionInfo;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.service.IAntiBlackmailSnapshotManager;
import com.huawei.ism.drm.anti.blackmail.util.AntiBlackmailUtil;
import com.huawei.ism.drm.constant.AntiBlackMailConstant;
import com.huawei.ism.drm.constant.AntiBlackMailEnumDefine;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.backtask.sdk.service.IBackTaskService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.io.Serializable;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.Callable;

public class DetectionResultTask
implements Callable<Boolean> {
    private static final Log LOGGER = LogFactory.getInstance(DetectionResultTask.class);
    private AntiBlackmailSnapshotDetectionInfo detectTaskInfo;
    private String devSn;

    public DetectionResultTask(AntiBlackmailSnapshotDetectionInfo detectTaskInfo, String devSn) {
        this.detectTaskInfo = detectTaskInfo;
        this.devSn = devSn;
    }

    @Override
    public Boolean call() {
        String copyId = this.detectTaskInfo.getCopyId();
        if (this.checkTimeOutAndCleanCache(this.detectTaskInfo)) {
            AntiBlackmailUtil.cleanCopyCache(this.devSn, copyId);
            return true;
        }
        int oldDetectStatus = this.detectTaskInfo.getDetectStatus();
        IAntiBlackmailSnapshotManager snapshotManager = AntiBlackmailSnapshotManagerProxy.getInstance().getSnapshotManager(this.devSn);
        Optional optionalSnapshot = snapshotManager.querySpecificSnapshot(this.devSn, this.detectTaskInfo.getPmFileSystemId(), copyId);
        int newDetectStatus = optionalSnapshot.map(AntiBlackmailSnapshot::getAntiStatus).orElseGet(() -> ((AntiBlackMailEnumDefine.DetectionStatus)AntiBlackMailEnumDefine.DetectionStatus.ABNORMAL).getValue());
        if (oldDetectStatus != newDetectStatus) {
            this.detectTaskInfo.setDetectStatus(newDetectStatus);
            AntiBlackmailUtil.updateProtectObjectReplicaDetectionStatus(this.detectTaskInfo, newDetectStatus);
            if (newDetectStatus == AntiBlackMailEnumDefine.DetectionStatus.DETECTING.getValue()) {
                AntiBlackmailUtil.addRunningDetectionCache(this.devSn, copyId, this.detectTaskInfo);
            }
        }
        if (AntiBlackMailConstant.SNAPSHOT_DETECTION_FINISH.contains(this.detectTaskInfo.getDetectStatus())) {
            AntiBlackmailUtil.cleanCopyCache(this.devSn, copyId);
            return true;
        }
        return false;
    }

    private boolean checkTimeOutAndCleanCache(AntiBlackmailSnapshotDetectionInfo detectTaskInfo) {
        ProtectGroupReplica replica = (ProtectGroupReplica)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ProtectGroupReplica.class, (Serializable)((Object)detectTaskInfo.getId()));
        if (VerifyUtil.isEmpty((Object)replica)) {
            return true;
        }
        if (replica.getDetectionStatus() == AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum.QUEUING.getValue() && AntiBlackmailUtil.checkReplicaDetectionTimeOut(replica)) {
            try {
                AntiBlackmailUtil.deleteReplica(replica);
                this.setTaskFailForTimeOut(replica);
                String[] alarmParams = new String[]{this.devSn, replica.getPg().getName(), detectTaskInfo.getId()};
                AlarmUtil.sendCommonAlarm((String)"0x3230081", (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])alarmParams);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Delete replica or snapshot failed, replicaId: %s, copyId: %s, error: %s", new Object[]{replica.getId(), detectTaskInfo.getCopyId(), ExceptionUtil.getErrorMessage((Throwable)e)});
            }
            return true;
        }
        return false;
    }

    private void setTaskFailForTimeOut(ProtectGroupReplica replica) {
        AntiBlackmailPlatform platform = AntiBlackmailUtil.addAntiBlackMailPlatform(this.devSn);
        BackTask backTask = (BackTask)platform.getSnapshotDetectBackTasksRunningMap().remove(replica.getId());
        backTask.setTaskProgress(Integer.valueOf(100));
        backTask.setEndTime(new Date());
        backTask.setTaskResult(Integer.valueOf(CommonConstant.BACKTASK_RESULT_FAIL));
        backTask.setTaskDetail(String.valueOf(1073948528L));
        IBackTaskService taskService = (IBackTaskService)ServiceLocator.getInstance().getService(IBackTaskService.class);
        taskService.updateTask(backTask);
    }
}

