/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.anti.blackmail.util;

import com.huawei.ism.cbb.base.sdk.constant.CommonConstant;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.util.AlarmUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnectionManager;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.anti.blackmail.manager.proxy.AntiBlackmailResourceManagerProxy;
import com.huawei.ism.drm.anti.blackmail.manager.proxy.AntiBlackmailSlaManagerProxy;
import com.huawei.ism.drm.anti.blackmail.manager.proxy.AntiBlackmailSnapshotManagerProxy;
import com.huawei.ism.drm.anti.blackmail.manager.proxy.AntiBlackmailTaskManagerProxy;
import com.huawei.ism.drm.anti.blackmail.manager.proxy.AntiBlackmailVstoreManagerProxy;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailPlatform;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailPlatformTask;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailResource;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailSLA;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailSnapshot;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailSnapshotDeleteDetail;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailSnapshotDetectionDetail;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailSnapshotDetectionInfo;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailSnapshotTaskInfo;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailVstore;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.oceanprotect.OceanProtectPlatformTask;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.oceanprotect.OceanProtectResource;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.service.IAntiBlackmailResourceManager;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.service.IAntiBlackmailSlaManager;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.service.IAntiBlackmailSnapshotManager;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.service.IAntiBlackmailTaskManager;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.service.IAntiBlackmailVstoreManager;
import com.huawei.ism.drm.anti.blackmail.service.AntiBlackmailPlatformCache;
import com.huawei.ism.drm.anti.blackmail.service.AntiBlackmailResourceScanTask;
import com.huawei.ism.drm.anti.blackmail.service.AntiBlackmailSnapshotDeleteTask;
import com.huawei.ism.drm.anti.blackmail.service.AntiBlackmailSnapshotDetectTask;
import com.huawei.ism.drm.base.util.ResourceLockUtil;
import com.huawei.ism.drm.constant.AntiBlackMailConstant;
import com.huawei.ism.drm.constant.AntiBlackMailEnumDefine;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.storage.manager.proxy.StorageFileSystemSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageFileSystemSnapshotManager;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.backtask.sdk.service.IBackTaskService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.TimeUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.thrift.annotation.Nullable;

public class AntiBlackmailUtil {
    private static final Log LOGGER = LogFactory.getInstance(AntiBlackmailUtil.class);
    private static final int ASYNC_RESOURCE_SCANNING_TIMEOUT = 7200;
    private static final int SYNC_RESOURCE_SCANNING_TIMEOUT = 600;
    private static final long BIND_SLA_TIMEOUT = 60000L;
    private static final long TASK_QUERY_INTERVAL = 10000L;
    private static final long TASK_DELETE_COPY_TIME_OUT = 1200000L;
    private static final String PROTECT_PERIOD = "protectPeriod";
    private static final String UNIT_TYPE = "unitType";

    public static void scanResource(String devSn, String connectionType, boolean isAsync, @Nullable Integer timeout) {
        if (VerifyUtil.isEmpty((Object)timeout)) {
            timeout = isAsync ? 7200 : 600;
        }
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn + connectionType);
        String ip = Optional.ofNullable(connection).map(RestConnection::getIpAddress).orElse(null);
        AntiBlackmailResourceScanTask task = new AntiBlackmailResourceScanTask(devSn, connectionType, ip, timeout);
        if (isAsync) {
            LOGGER.info((Object)"Resource scanning in asynchronous mode, dev sn: %s.", new Object[]{devSn});
            BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        } else {
            LOGGER.info((Object)"Resource scanning in synchronous mode, dev sn: %s.", new Object[]{devSn});
            task.scanResource();
        }
    }

    public static String getOrBuildNasAirGapSla(String devSn) {
        if (VerifyUtil.isEmpty((String)devSn)) {
            LOGGER.error((Object)"Dev sn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        String slaId = AntiBlackmailUtil.getNasAirGapSla(devSn);
        if (!VerifyUtil.isEmpty((String)slaId)) {
            return slaId;
        }
        return AntiBlackmailUtil.createNasAirGapSla(devSn);
    }

    public static String getNasAirGapSla(String devSn) {
        if (VerifyUtil.isEmpty((String)devSn)) {
            LOGGER.error((Object)"Dev sn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        IAntiBlackmailSlaManager slaManager = AntiBlackmailSlaManagerProxy.getInstance().getSlaManager(devSn);
        Optional slaOptional = slaManager.querySlaByName(devSn, "BCManagerNASAirGapSLA");
        if (!slaOptional.isPresent()) {
            return "";
        }
        AntiBlackmailSLA nasAirGapSla = (AntiBlackmailSLA)slaOptional.get();
        String slaName = nasAirGapSla.getName();
        if (nasAirGapSla.getRetentionType() != 1) {
            LOGGER.error((Object)"The replica retention type of the SLA named %s isn't permanent, dev sn: %s", new Object[]{slaName, devSn});
            throw new LegoCheckedException(1073948497L, new String[]{devSn, slaName});
        }
        return nasAirGapSla.getUuid();
    }

    public static List<AntiBlackmailResource> checkProtectObjectsValidity(ProtectGroup protectGroup, String slaId, boolean shouldDisableSla) {
        String vstoreName = AntiBlackmailUtil.getVstoreName(protectGroup);
        String devSn = protectGroup.getPoProviderSN();
        IAntiBlackmailResourceManager resourceManager = AntiBlackmailResourceManagerProxy.getInstance().getResourceManager(devSn);
        List resourceList = resourceManager.queryVstoreResources(devSn, vstoreName);
        return AntiBlackmailUtil.checkProtectObjectsValidity(resourceList, protectGroup, slaId, shouldDisableSla);
    }

    public static boolean checkVstoreBindNoSla(ProtectGroup protectGroup) {
        String vstoreName = AntiBlackmailUtil.getVstoreName(protectGroup);
        String devSn = protectGroup.getPoProviderSN();
        IAntiBlackmailResourceManager resourceManager = AntiBlackmailResourceManagerProxy.getInstance().getResourceManager(devSn);
        List resourceList = resourceManager.queryVstoreResources(devSn, vstoreName);
        return AntiBlackmailUtil.doCheckVstoreBindNoSla(resourceList);
    }

    private static String getVstoreName(ProtectGroup protectGroup) {
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            LOGGER.error((Object)"Protect group is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        int type = protectGroup.getTemplate().getType();
        if (type != 46) {
            LOGGER.error((Object)"The policy type of protect group(name: %s) isn't unsatisfied.", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073947393L);
        }
        String vstoreName = Optional.of(protectGroup).map(ProtectGroup::getPolist).orElseGet(Collections::emptySet).stream().findAny().map(protectObject -> protectObject.getProperty("vstoreName")).orElse("");
        if (VerifyUtil.isEmpty((String)vstoreName)) {
            LOGGER.error((Object)"Vstore information is not obtained from the protection group(%s)", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073947394L);
        }
        return vstoreName;
    }

    private static boolean doCheckVstoreBindNoSla(List<AntiBlackmailResource> resourceList) {
        return resourceList.stream().filter(e -> e instanceof OceanProtectResource).map(e -> (OceanProtectResource)e).allMatch(e -> VerifyUtil.isEmpty((String)e.getSlaId()));
    }

    public static void bindSlaForResources(List<AntiBlackmailResource> resources, String slaId, String devSn, boolean shouldDisableProtection) {
        if (VerifyUtil.isEmpty(resources) || VerifyUtil.isEmpty((String)slaId) || VerifyUtil.isEmpty((String)devSn)) {
            LOGGER.error((Object)"Param is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        List<AntiBlackmailResource> operatedResources = resources.stream().filter(resource -> {
            if (!(resource instanceof OceanProtectResource)) {
                return true;
            }
            OceanProtectResource oceanProtectResource = (OceanProtectResource)resource;
            if (VerifyUtil.isEmpty((String)oceanProtectResource.getSlaId())) {
                return true;
            }
            if (!oceanProtectResource.getSlaId().equals(slaId)) {
                LOGGER.error((Object)"The resource(name: %s) is associated with another SLA(name: %s), dev sn: %s.", new Object[]{oceanProtectResource.getName(), oceanProtectResource.getSlaName(), devSn});
                throw new LegoCheckedException(1073948500L, new String[]{devSn});
            }
            return false;
        }).collect(Collectors.toList());
        Set<String> vstoreIdSet = resources.stream().map(AntiBlackmailResource::getVstoreId).collect(Collectors.toSet());
        if (VerifyUtil.isEmpty(operatedResources)) {
            AntiBlackmailUtil.configVstoreSmartDetection(devSn, vstoreIdSet, true);
            LOGGER.info((Object)"All resources have SLA bound, no need to operate.");
            return;
        }
        String resourceNamesStr = AntiBlackmailUtil.getResourcesNameStr(operatedResources);
        IAntiBlackmailSlaManager slaManager = AntiBlackmailSlaManagerProxy.getInstance().getSlaManager(devSn);
        OperationResult operationResult = slaManager.associateResourcesWithSla(devSn, operatedResources, slaId);
        if (!operationResult.isSuccess()) {
            LOGGER.error((Object)"Bind sla failed, operated resource\uff1a%s, sla id: %s, dev sn: %s.", new Object[]{resourceNamesStr, slaId, devSn});
            throw new LegoCheckedException(1073948502L, new String[]{devSn});
        }
        AntiBlackmailUtil.waitSlaBindCompleted(operatedResources, devSn, resourceNamesStr);
        if (!shouldDisableProtection) {
            LOGGER.info((Object)"No need to disable sla protection for resources(%s).", new Object[]{resourceNamesStr});
            return;
        }
        AntiBlackmailUtil.configVstoreSmartDetection(devSn, vstoreIdSet, true);
        AntiBlackmailUtil.disableSlaProtectionForResource(operatedResources, devSn);
    }

    private static void waitSlaBindCompleted(List<AntiBlackmailResource> operatedResources, String devSn, String resourceNamesStr) {
        long endTime;
        String vstoreName = operatedResources.get(0).getVstoreName();
        IAntiBlackmailResourceManager resourceManager = AntiBlackmailResourceManagerProxy.getInstance().getResourceManager(devSn);
        Set resourceUuidSet = operatedResources.stream().map(AntiBlackmailResource::getUuid).collect(Collectors.toSet());
        long startTime = System.currentTimeMillis();
        do {
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)"Wait for SLA binding to complete error, error msg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
            List vstoreResources = resourceManager.queryVstoreResources(devSn, vstoreName);
            boolean isCompleted = vstoreResources.stream().filter(resource -> resourceUuidSet.contains(resource.getUuid())).filter(resource -> resource instanceof OceanProtectResource).map(resource -> (OceanProtectResource)resource).noneMatch(resource -> VerifyUtil.isEmpty((String)resource.getSlaId()));
            if (!isCompleted) continue;
            return;
        } while ((endTime = System.currentTimeMillis()) - startTime < 60000L);
        LOGGER.error((Object)"Wait for SLA binding to complete time out, operatedResources: %s.", new Object[]{operatedResources});
        throw new LegoCheckedException(1073948502L, new String[]{devSn});
    }

    private static void disableSlaProtectionForResource(List<AntiBlackmailResource> resources, String devSn) {
        IAntiBlackmailSlaManager slaManager = AntiBlackmailSlaManagerProxy.getInstance().getSlaManager(devSn);
        String resourceNamesStr = AntiBlackmailUtil.getResourcesNameStr(resources);
        List operatedIdList = resources.stream().map(AntiBlackmailResource::getUuid).collect(Collectors.toList());
        OperationResult operationResult = slaManager.disableSlaProtection(devSn, operatedIdList);
        if (!operationResult.isSuccess()) {
            LOGGER.error((Object)"Disabled sla protection for resources(%s) failed, dev sn: %s.", new Object[]{resourceNamesStr, devSn});
            throw new LegoCheckedException(1073948503L, new String[]{devSn});
        }
    }

    public static void configVstoreSmartDetection(String devSn, Set<String> vstoreIdSet, boolean shouldOpenAutoDetect) {
        IAntiBlackmailVstoreManager vstoreManager = AntiBlackmailVstoreManagerProxy.getInstance().getVstoreManager(devSn);
        vstoreIdSet.forEach(e -> vstoreManager.configVstoreSmartDetection(devSn, e, shouldOpenAutoDetect));
    }

    public static String createNasAirGapSla(String devSn) {
        Optional createdSlaOptional;
        IAntiBlackmailSlaManager slaManager = AntiBlackmailSlaManagerProxy.getInstance().getSlaManager(devSn);
        String creatingSlaName = "BCManagerNASAirGapSLA";
        LOGGER.info((Object)"Start to create SLA named %s, dev sn: %s.", new Object[]{creatingSlaName, devSn});
        try {
            createdSlaOptional = slaManager.createSla(devSn, creatingSlaName);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Failed to create SLA named %s, dev sn: %s.", new Object[]{creatingSlaName, devSn});
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to create SLA named %s, dev sn: %s.Error msg: %s.", new Object[]{creatingSlaName, devSn, ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073948498L, new String[]{devSn, creatingSlaName});
        }
        if (!createdSlaOptional.isPresent()) {
            LOGGER.error((Object)"Failed to create SLA named %s, dev sn: %s.", new Object[]{creatingSlaName, devSn});
            throw new LegoCheckedException(1073948498L, new String[]{devSn, creatingSlaName});
        }
        LOGGER.info((Object)"Created SLA named %s successfully, dev sn: %s.", new Object[]{creatingSlaName, devSn});
        return (String)createdSlaOptional.get();
    }

    private static List<AntiBlackmailResource> checkProtectObjectsValidity(List<AntiBlackmailResource> resourceList, ProtectGroup protectGroup, String slaId, boolean shouldDisableSla) {
        ArrayList<AntiBlackmailResource> antiBlackmailResources = new ArrayList<AntiBlackmailResource>();
        String devSn = protectGroup.getPoProviderSN();
        Map<String, AntiBlackmailResource> resourcesMap = Optional.ofNullable(resourceList).orElseGet(ArrayList::new).stream().collect(Collectors.toMap(AntiBlackmailResource::getResourceId, Function.identity()));
        for (ProtectObject protectObject : protectGroup.getPolist()) {
            AntiBlackmailResource resource = AntiBlackmailUtil.checkResourceBasicInfo(protectObject, resourcesMap, devSn);
            if (!(resource instanceof OceanProtectResource)) {
                antiBlackmailResources.add(resource);
                continue;
            }
            OceanProtectResource oceanProtectResource = (OceanProtectResource)resource;
            AntiBlackmailUtil.checkShouldBindSla(protectGroup, oceanProtectResource);
            AntiBlackmailUtil.checkWhetherBindOtherSla(oceanProtectResource, devSn, slaId);
            AntiBlackmailUtil.checkOrDisableSlaProtection(oceanProtectResource, devSn, shouldDisableSla);
            antiBlackmailResources.add(resource);
        }
        return antiBlackmailResources;
    }

    private static AntiBlackmailResource checkResourceBasicInfo(ProtectObject protectObject, Map<String, AntiBlackmailResource> resourcesMap, String devSn) {
        String resourceId = protectObject.getProperty("nasFsId");
        if (!resourcesMap.containsKey(resourceId)) {
            LOGGER.error((Object)"The resource(name: %s) information isn\u2019t found on the Ocean Protect side.", new Object[]{protectObject.getName()});
            throw new LegoCheckedException(1073948499L, new String[]{devSn, protectObject.getName()});
        }
        AntiBlackmailResource resource = resourcesMap.get(resourceId);
        String oldResourceUuid = protectObject.getProperty("antiBlackmailResourceUuid");
        if (VerifyUtil.isEmpty((String)oldResourceUuid)) {
            protectObject.setProperty("antiBlackmailResourceUuid", (Object)resource.getUuid());
            return resource;
        }
        if (!oldResourceUuid.equals(resource.getUuid())) {
            LOGGER.error((Object)"The resource(name: %s) uuid has changed, dev sn: %s.", new Object[]{resource.getName(), devSn});
            throw new LegoCheckedException(1073948505L, new String[]{devSn, oldResourceUuid});
        }
        return resource;
    }

    private static void checkShouldBindSla(ProtectGroup protectGroup, OceanProtectResource resource) {
        if (protectGroup.getStatus() == DrmEnumDefine.PROTECT_GROUP_STATUS.RUNNING.getStatus() && VerifyUtil.isEmpty((String)resource.getSlaId())) {
            LOGGER.error((Object)"The resource(name: %s) isn't bound to a Sla.", new Object[]{resource.getName()});
            throw new LegoCheckedException(1073948506L, new String[]{"BCManagerNASAirGapSLA", protectGroup.getPoProviderSN()});
        }
    }

    private static void checkWhetherBindOtherSla(OceanProtectResource resource, String devSn, String slaId) {
        if (VerifyUtil.isEmpty((String)resource.getSlaName()) || VerifyUtil.isEmpty((String)resource.getSlaId())) {
            return;
        }
        if (!resource.getSlaName().equals("BCManagerNASAirGapSLA")) {
            LOGGER.error((Object)"The resource(name: %s) is associated with another SLA(name: %s), dev sn: %s.", new Object[]{resource.getName(), resource.getSlaName(), devSn});
            throw new LegoCheckedException(1073948500L, new String[]{devSn});
        }
        if (!resource.getSlaId().equals(slaId)) {
            LOGGER.error((Object)"The uuid of the resource(name: %s) associated Sla has changed, dev sn: %s.", new Object[]{resource.getName(), resource.getSlaName(), devSn});
            throw new LegoCheckedException(1073948507L, new String[]{devSn, slaId});
        }
    }

    private static void checkOrDisableSlaProtection(OceanProtectResource resource, String devSn, boolean shouldDisableSla) {
        if (resource.isEnabledSla()) {
            if (shouldDisableSla) {
                AntiBlackmailUtil.disableSlaProtectionForResource(Collections.singletonList(resource), devSn);
                return;
            }
            LOGGER.error((Object)"The resource(name: %s) has enabled Sla protection, dev sn: %s.", new Object[]{resource.getName(), devSn});
            throw new LegoCheckedException(1073948501L, new String[]{devSn});
        }
    }

    private static String getResourcesNameStr(List<AntiBlackmailResource> resources) {
        if (VerifyUtil.isEmpty(resources)) {
            return "";
        }
        return resources.stream().map(AntiBlackmailResource::getName).collect(Collectors.joining(","));
    }

    public static AntiBlackmailPlatform addAntiBlackMailPlatform(String devSn) {
        String lockId = ResourceLockUtil.lockRes(devSn, "antiBlackmailPlatform", 60000L);
        try {
            AntiBlackmailPlatform platform;
            AntiBlackmailPlatformCache antiBlackmailPlatformCache = AntiBlackmailPlatformCache.getInstance();
            if (!antiBlackmailPlatformCache.isPlatformExist(devSn)) {
                IStorageResourceService service = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
                platform = new AntiBlackmailPlatform(devSn, service.getStorageControllerNum(devSn), AntiBlackmailUtil.getOrBuildNasAirGapSla(devSn));
                antiBlackmailPlatformCache.addPlatform(devSn, platform);
            } else {
                platform = antiBlackmailPlatformCache.getPlatform(devSn);
            }
            AntiBlackmailPlatform antiBlackmailPlatform = platform;
            return antiBlackmailPlatform;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Add anti blackmail platform error, devSn: %s, error msg: %s", new Object[]{devSn, ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073948510L);
        }
        finally {
            ResourceLockUtil.unlockRes(lockId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean clearAntiBlackmailSnapshotCacheByDevSn(String devSn) {
        String lockId = ResourceLockUtil.lockRes(devSn, "antiBlackmailPlatform", 60000L);
        try {
            AntiBlackmailPlatformCache platformCache = AntiBlackmailPlatformCache.getInstance();
            if (!platformCache.isPlatformExist(devSn)) {
                LOGGER.error((Object)"Clear anti blackmail platform error, devSn: %s", new Object[]{devSn});
                throw new LegoCheckedException(1073947393L);
            }
            boolean bl = platformCache.removePlatform(devSn);
            return bl;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Clear anti blackmail platform error, error msg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        finally {
            ResourceLockUtil.unlockRes(lockId);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createAntiBlackMailSnapshot(AntiBlackmailPlatform platform, ProtectGroupReplica protectGroupReplica, ActionContext context) {
        Set replicas = protectGroupReplica.getReplicas();
        if (replicas.size() == 0) {
            return;
        }
        String protectGroupReplicaId = protectGroupReplica.getId();
        String lockId = ResourceLockUtil.lockRes(platform.getDevSn(), "addSnapshotTaskToQueue", 60000L);
        try {
            if (platform.checkCanAddNewTask(replicas.size())) {
                int nodeNum = platform.getNodeNum();
                int maxWaitTaskLimit = platform.getMaxWaitTaskLimit();
                LOGGER.error((Object)"The maximum length of creating anti blackmail snapshot task queue with %d controller is %d, new task added will exceed the limit.", new Object[]{nodeNum, maxWaitTaskLimit});
                throw new LegoCheckedException(1073948508L);
            }
            AntiBlackmailUtil.addTaskToQueue(platform, replicas, protectGroupReplicaId);
        }
        finally {
            ResourceLockUtil.unlockRes(lockId);
        }
        AntiBlackmailUtil.checkAllSubTaskHasFinished(platform, protectGroupReplica, context);
    }

    private static void addTaskToQueue(AntiBlackmailPlatform platform, Set<ProtectObjectReplica> replicas, String protectGroupReplicaId) {
        platform.getSnapshotTaskFinishedCountMap().put(protectGroupReplicaId, new AtomicInteger(replicas.size()));
        for (ProtectObjectReplica protectObjectReplica : replicas) {
            RelicaStorageInfo storageInfo;
            AntiBlackmailSnapshotTaskInfo antiBlackmailSnapshotTaskInfo = new AntiBlackmailSnapshotTaskInfo();
            antiBlackmailSnapshotTaskInfo.setId(protectGroupReplicaId);
            antiBlackmailSnapshotTaskInfo.setProtectObjectReplica(protectObjectReplica);
            antiBlackmailSnapshotTaskInfo.setPmFileSystemId(protectObjectReplica.getPlaceholderProtectObjectId());
            Set storageInfoSet = protectObjectReplica.getStorageInfos();
            if (!VerifyUtil.isEmpty((Collection)storageInfoSet) && (storageInfo = (RelicaStorageInfo)storageInfoSet.iterator().next()) instanceof LocalStorageReplica) {
                antiBlackmailSnapshotTaskInfo.setCopyName(((LocalStorageReplica)storageInfo).getSnapshotName());
            }
            platform.getSnapshotTasksQueue().add(antiBlackmailSnapshotTaskInfo);
        }
        LOGGER.info((Object)"Add %d creating snapshot tasks to wait queue, dev sn: %s, protectGroupReplicaId: %s.", new Object[]{replicas.size(), platform.getDevSn(), protectGroupReplicaId});
    }

    private static void checkAllSubTaskHasFinished(AntiBlackmailPlatform platform, ProtectGroupReplica protectGroupReplica, ActionContext context) {
        boolean shouldCheckOverTime;
        String protectGroupReplicaId = protectGroupReplica.getId();
        Long overTime = (Long)context.getObject("taskOverTime", Long.class);
        boolean bl = shouldCheckOverTime = !VerifyUtil.isEmpty((Object)overTime);
        while (!context.isShouldTerminate()) {
            int taskLeftNum = ((AtomicInteger)platform.getSnapshotTaskFinishedCountMap().get(protectGroupReplicaId)).get();
            if (taskLeftNum == 0 && protectGroupReplica.getReplicas().size() == ((List)platform.getSnapshotDetectTasksCacheMap().get(protectGroupReplica.getId())).size()) {
                platform.getSnapshotTaskFinishedCountMap().remove(protectGroupReplicaId);
                protectGroupReplica.setDetectionStatus(AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum.READY.getValue());
                AntiBlackmailUtil.addCheckSnapshotTask(platform, protectGroupReplica);
                return;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)"Checking all sub task has finished failed, devSn: %s, protectGroupReplicaId: %s, error: %s", new Object[]{platform.getDevSn(), protectGroupReplicaId, ExceptionUtil.getErrorMessage((Throwable)e)});
            }
            if (!shouldCheckOverTime || System.currentTimeMillis() <= overTime) continue;
            LOGGER.error((Object)"Create snapshot for replica(name: %s) timeout.", new Object[]{protectGroupReplica.getName()});
            throw new LegoCheckedException(1677929496L);
        }
        LOGGER.error((Object)"Task has been stopped manually.");
        throw new LegoCheckedException(1073948470L);
    }

    private static void addCheckSnapshotTask(AntiBlackmailPlatform platform, ProtectGroupReplica protectGroupReplica) {
        String replicaId = protectGroupReplica.getId();
        List detectionInfos = (List)platform.getSnapshotDetectTasksCacheMap().get(replicaId);
        AntiBlackmailSnapshotDetectionDetail detectionDetail = new AntiBlackmailSnapshotDetectionDetail();
        detectionDetail.setDevSn(platform.getDevSn());
        detectionDetail.setPgRId(replicaId);
        detectionDetail.setPgRName(((ProtectObjectReplica)protectGroupReplica.getReplicas().iterator().next()).getPgReplica().getName());
        detectionDetail.setTotal(detectionInfos.size());
        detectionDetail.setDetectStatus(AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum.READY.getValue());
        String taskDetailStr = JSONObject.fromObject((Object)detectionDetail).toString();
        AntiBlackmailSnapshotDetectTask detectTask = new AntiBlackmailSnapshotDetectTask(protectGroupReplica.getName(), taskDetailStr);
        detectTask.addSyncSnapshotDetectResultTask();
        for (AntiBlackmailSnapshotDetectionInfo detectionInfo : (List)platform.getSnapshotDetectTasksCacheMap().get(replicaId)) {
            platform.getAllSnapshotIdCacheMap().put(detectionInfo.getCopyId(), detectionInfo);
        }
        AntiBlackmailUtil.checkSmartDetectionAndDeal(platform, detectTask, protectGroupReplica, detectionDetail);
    }

    private static void checkSmartDetectionAndDeal(AntiBlackmailPlatform platform, AntiBlackmailSnapshotDetectTask detectTask, ProtectGroupReplica protectGroupReplica, AntiBlackmailSnapshotDetectionDetail detectionDetail) {
        String vstoreName;
        String devSn = platform.getDevSn();
        IAntiBlackmailVstoreManager antiBlackmailVstoreManager = AntiBlackmailVstoreManagerProxy.getInstance().getVstoreManager(devSn);
        Optional vstoreOptional = antiBlackmailVstoreManager.queryVstoreInfoByName(devSn, vstoreName = AntiBlackmailUtil.getVstoreName(protectGroupReplica.getPg()));
        if (vstoreOptional.isPresent() && ((AntiBlackmailVstore)vstoreOptional.get()).isEnabledSmartDetection()) {
            LOGGER.info((Object)"Vstore smart detection is enable, vstoreName is %s.", new Object[]{vstoreName});
            return;
        }
        LOGGER.error((Object)"Vstore does not exist or smart detection is disable, vstoreName is %s.", new Object[]{vstoreName});
        BackTask backTask = detectTask.getBackTask();
        detectionDetail.setDetectStatus(AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum.NO_DETECT.getValue());
        backTask.setTaskProgress(Integer.valueOf(100));
        backTask.setEndTime(new Date());
        backTask.setTaskResult(Integer.valueOf(CommonConstant.BACKTASK_RESULT_FAIL));
        backTask.setTaskDetail(String.valueOf(1073948517L));
        backTask.setTaskDetailParas(new String[]{devSn});
        IBackTaskService taskService = (IBackTaskService)ServiceLocator.getInstance().getService(IBackTaskService.class);
        taskService.updateTask(backTask);
        LOGGER.info((Object)"BackTask result set to failed,protectGroupReplica id is %s.", new Object[]{protectGroupReplica.getId()});
        protectGroupReplica.setDetectionStatus(AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum.NO_DETECT.getValue());
        AntiBlackmailUtil.doCleanDetectionTask(platform, protectGroupReplica.getId());
    }

    public static void cleanDetectionTask(BackTask backTask) {
        AntiBlackmailSnapshotDetectionDetail detailFromTask = AntiBlackmailUtil.getDetailFromTask(backTask);
        AntiBlackmailPlatform platform = AntiBlackmailUtil.addAntiBlackMailPlatform(detailFromTask.getDevSn());
        AntiBlackmailUtil.doCleanDetectionTask(platform, detailFromTask.getPgRId());
    }

    private static void doCleanDetectionTask(AntiBlackmailPlatform platform, String pgRId) {
        platform.getSnapshotDetectBackTasksRunningMap().remove(pgRId);
        platform.getSnapshotDetectTasksCacheMap().remove(pgRId);
    }

    public static void cleanDeleteTask(BackTask backTask) {
        AntiBlackmailSnapshotDetectionDetail detailFromTask = AntiBlackmailUtil.getDetailFromTask(backTask);
        AntiBlackmailPlatform platform = AntiBlackmailUtil.addAntiBlackMailPlatform(detailFromTask.getDevSn());
        platform.getSnapshotDeleteBackTasksRunningMap().remove(detailFromTask.getPgRId());
        platform.getSnapshotDeleteSnapshotTaskRelateMap().remove(detailFromTask.getPgRId());
    }

    public static void cleanCopyCache(String devSn, String copyId) {
        AntiBlackmailUtil.addAntiBlackMailPlatform(devSn).getSnapshotDetectTasksRunningMap().remove(copyId);
        AntiBlackmailUtil.addAntiBlackMailPlatform(devSn).getAllSnapshotIdCacheMap().remove(copyId);
    }

    public static void addRunningDetectionCache(String devSn, String copyId, AntiBlackmailSnapshotDetectionInfo detectTaskInfo) {
        if (AntiBlackmailUtil.addAntiBlackMailPlatform(devSn).getAllSnapshotIdCacheMap().containsKey(copyId)) {
            AntiBlackmailUtil.addAntiBlackMailPlatform(devSn).getSnapshotDetectTasksRunningMap().put(copyId, detectTaskInfo);
        }
    }

    public static AntiBlackmailSnapshotDetectionDetail getDetailFromTask(BackTask backTask) {
        return (AntiBlackmailSnapshotDetectionDetail)JSONObject.fromObject((Object)backTask.getBackendTaskDetail()).toBean(AntiBlackmailSnapshotDetectionDetail.class);
    }

    public static AntiBlackmailSnapshotDeleteDetail getDetailFromDeleteTask(BackTask backTask) {
        return (AntiBlackmailSnapshotDeleteDetail)JSONObject.fromObject((Object)backTask.getBackendTaskDetail()).toBean(AntiBlackmailSnapshotDeleteDetail.class);
    }

    public static void updateProtectGroupReplicaDetectionStatus(String pgRId, int pgReplicaStatus) {
        ProtectGroupReplica protectGroupReplica = (ProtectGroupReplica)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ProtectGroupReplica.class, (Serializable)((Object)pgRId));
        if (protectGroupReplica.getDetectionStatus() == pgReplicaStatus) {
            LOGGER.info((Object)"Replica detection status is same as db.");
            return;
        }
        protectGroupReplica.setDetectionStatus(pgReplicaStatus);
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)protectGroupReplica);
    }

    public static void updateProtectObjectReplicaDetectionStatus(AntiBlackmailSnapshotDetectionInfo detectionInfo, int pgOReplicaStatus) {
        ProtectGroupReplica protectGroupReplica = (ProtectGroupReplica)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ProtectGroupReplica.class, (Serializable)((Object)detectionInfo.getId()));
        Set replicas = protectGroupReplica.getReplicas();
        ProtectObjectReplica protectObjectReplica = replicas.stream().filter(e -> e.getId().equals(detectionInfo.getPgOId())).findFirst().get();
        protectObjectReplica.setDetectionStatus(pgOReplicaStatus);
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)protectGroupReplica);
    }

    public static void dealMisreportSnapshot(ProtectGroup protectGroup, ProtectGroupReplica replica) {
        boolean isSecure = AntiBlackmailUtil.isUsingSecureSnapshotPolicy(protectGroup);
        if (isSecure && NumberUtil.convertToLong((Object)replica.getDeadlineTimeStamp()) < System.currentTimeMillis()) {
            LOGGER.error((Object)"Replica(name: %s) already expired, not support this operation.", new Object[]{replica.getName()});
            throw new LegoCheckedException(1073948600L, new String[]{replica.getName()});
        }
        List<ProtectObjectReplica> protectObjectReplicas = replica.getReplicas().stream().filter(protectObjectReplica -> protectObjectReplica.getDetectionStatus() == AntiBlackMailEnumDefine.DetectionStatus.INFECTED.getValue()).collect(Collectors.toList());
        if (VerifyUtil.isEmpty(protectObjectReplicas)) {
            LOGGER.error((Object)"No snapshots need to deal, replica name: %s.", new Object[]{replica.getName()});
            throw new LegoCheckedException(2117645L);
        }
        String devSn = protectGroup.getPoProviderSN();
        IAntiBlackmailSnapshotManager snapshotManager = AntiBlackmailSnapshotManagerProxy.getInstance().getSnapshotManager(devSn);
        protectObjectReplicas.forEach(protectObjectReplica -> {
            String snapshotUuid = AntiBlackmailUtil.getAntiBlackmailSnapshotUuid(protectObjectReplica);
            OperationResult operationResult = snapshotManager.misreportDeal(devSn, snapshotUuid);
            if (!operationResult.isSuccess()) {
                LOGGER.error((Object)"Deal the misreport of the snapshot error, snapshot uuid: %s", new Object[]{snapshotUuid});
                throw new LegoCheckedException(0x300001L);
            }
            protectObjectReplica.setDetectionStatus(AntiBlackMailEnumDefine.DetectionStatus.UN_INFECTED.getValue());
        });
        replica.setDetectionStatus(AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum.UNINFECTED.getValue());
        if (isSecure) {
            AntiBlackmailUtil.transferToSecureReplica(replica);
        } else {
            IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
            replicaService.saveOrUpdateReplica(replica);
        }
    }

    public static boolean isUsingSecureSnapshotPolicy(ProtectGroup protectGroup) {
        Set schedules = protectGroup.getTemplate().getSchedules();
        return schedules.stream().anyMatch(schedule -> schedule.getProtectedType() == ScheduleProtectedType.NAS_AIRGAP_ANTI_BLACKMAIL_SECURE_SNAPSHOT.getValue());
    }

    public static void transferToSecureReplica(ProtectGroupReplica protectGroupReplica) {
        long currentTimeMillis = System.currentTimeMillis();
        long deadlineTimeStamp = NumberUtil.convertToLong((Object)protectGroupReplica.getDeadlineTimeStamp());
        LOGGER.debug((Object)"Replica deadline time: %s, current time: %s", new Object[]{TimeUtil.toLocalString((long)deadlineTimeStamp), TimeUtil.toLocalString((long)currentTimeMillis)});
        if (deadlineTimeStamp <= currentTimeMillis) {
            LOGGER.error((Object)"Replica already expired, delete this replica, id:%s.", new Object[]{protectGroupReplica.getId()});
            AntiBlackmailUtil.deleteReplica(protectGroupReplica);
            String[] alarmParams = new String[]{protectGroupReplica.getPg().getPoProviderSN(), protectGroupReplica.getPg().getName(), protectGroupReplica.getId()};
            AlarmUtil.sendCommonAlarm((String)"0x3230081", (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])alarmParams);
            return;
        }
        Set schedules = protectGroupReplica.getPg().getTemplate().getSchedules();
        Schedule schedule = (Schedule)schedules.iterator().next();
        String retentionPolicyData = schedule.getRetentionPolicyData();
        JSONObject retentionPolicy = JSONObject.fromObject((Object)retentionPolicyData);
        int protectPeriod = retentionPolicy.getInt(PROTECT_PERIOD);
        int unitType = retentionPolicy.getInt(UNIT_TYPE);
        long createTimeStamp = NumberUtil.convertToLong((Object)protectGroupReplica.getTimeStamp());
        LOGGER.info((Object)"Replica create time: %s", new Object[]{TimeUtil.toLocalString((long)createTimeStamp)});
        long delta = currentTimeMillis - createTimeStamp;
        if (unitType == 46 && delta >= 86400000L) {
            protectPeriod -= (int)(delta / 86400000L);
        }
        if (!AntiBlackmailUtil.doTransSecureSnapshot(protectPeriod, unitType, protectGroupReplica)) {
            return;
        }
        long transFinishTime = System.currentTimeMillis();
        LOGGER.info((Object)"Replica trans time: %s", new Object[]{TimeUtil.toLocalString((long)transFinishTime)});
        long transDelta = transFinishTime - createTimeStamp;
        long newDeadlineTime = unitType == 46 ? (transDelta < 86400000L ? deadlineTimeStamp + transDelta : deadlineTimeStamp + transDelta % 86400000L) : deadlineTimeStamp + transDelta;
        protectGroupReplica.setDeadlineTimeStamp(String.valueOf(newDeadlineTime));
        LOGGER.info((Object)"Replica new deadline time: %s", new Object[]{TimeUtil.toLocalString((long)newDeadlineTime)});
        protectGroupReplica.setType(104);
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        replicaService.saveOrUpdateReplica(protectGroupReplica);
    }

    public static boolean checkReplicaDetectionTimeOut(ProtectGroupReplica protectGroupReplica) {
        if (!AntiBlackmailUtil.isUsingSecureSnapshotPolicy(protectGroupReplica.getPg())) {
            return false;
        }
        long currentTimeMillis = System.currentTimeMillis();
        long deadlineTimeStamp = NumberUtil.convertToLong((Object)protectGroupReplica.getDeadlineTimeStamp());
        LOGGER.debug((Object)"Replica deadline time: %s, current time: %s", new Object[]{TimeUtil.toLocalString((long)deadlineTimeStamp), TimeUtil.toLocalString((long)currentTimeMillis)});
        if (deadlineTimeStamp <= currentTimeMillis) {
            LOGGER.error((Object)"Replica already expired, delete this replica, id:%s.", new Object[]{protectGroupReplica.getId()});
            return true;
        }
        return false;
    }

    public static void deleteReplica(ProtectGroupReplica protectGroupReplica) {
        String deviceSN = protectGroupReplica.getProductArray();
        Set replicas = protectGroupReplica.getReplicas();
        IAntiBlackmailSnapshotManager snapshotManager = AntiBlackmailSnapshotManagerProxy.getInstance().getSnapshotManager(deviceSN);
        for (ProtectObjectReplica replica : replicas) {
            RelicaStorageInfo storageInfo;
            Set storageInfoSet = replica.getStorageInfos();
            if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)storageInfoSet) || !((storageInfo = (RelicaStorageInfo)storageInfoSet.iterator().next()) instanceof LocalStorageReplica)) continue;
            LocalStorageReplica localStorageReplica = (LocalStorageReplica)storageInfo;
            AntiBlackMailConstant.DELETE_PM_SNAPSHOT_EXECUTOR.submit(() -> AntiBlackmailUtil.doDeleteSnapshot(deviceSN, snapshotManager, localStorageReplica.getSnapshotName(), protectGroupReplica));
        }
        CommonDAOLocator.getBaseDao().getHibernateTemplate().delete((Object)protectGroupReplica);
    }

    private static void doDeleteSnapshot(String deviceSN, IAntiBlackmailSnapshotManager snapshotManager, String snapshotUuid, ProtectGroupReplica protectGroupReplica) {
        OperationResult operationResult = snapshotManager.deleteSpecificSnapshot(deviceSN, snapshotUuid);
        if (!operationResult.isSuccess()) {
            AntiBlackmailUtil.sendDeleteFailAlarmMsg(deviceSN, protectGroupReplica.getPg().getName(), snapshotUuid);
            LOGGER.error((Object)"The delete copy failed, dev sn: %s, snapshotUuid: %s.", new Object[]{deviceSN, snapshotUuid});
        } else {
            AntiBlackmailUtil.dealResultAndSendAlarm(deviceSN, snapshotUuid, protectGroupReplica);
        }
    }

    private static boolean doTransSecureSnapshot(int protectPeriod, int unitType, ProtectGroupReplica protectGroupReplica) {
        String devSn = protectGroupReplica.getProductArray();
        Set replicas = protectGroupReplica.getReplicas();
        int failedNum = 0;
        for (ProtectObjectReplica replica : replicas) {
            RelicaStorageInfo storageInfo = (RelicaStorageInfo)replica.getStorageInfos().iterator().next();
            String snapshotId = "";
            if (storageInfo instanceof LocalStorageReplica) {
                LocalStorageReplica localStorageReplica = (LocalStorageReplica)storageInfo;
                snapshotId = localStorageReplica.getSnapshotName();
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("expiredTime", String.valueOf(protectPeriod));
            paramMap.put("expiredTimeUnit", String.valueOf(unitType));
            paramMap.put("NAME", snapshotId);
            paramMap.put("isSecuritySnap", "true");
            paramMap.put("isAutoDelete", "false");
            Map props = replica.getProtectObject().getProps();
            paramMap.put("PARENTID", (String)props.get("nasFsId"));
            paramMap.put("vstoreId", (String)props.get("PROP_KEY_VSTORE_ID"));
            IStorageFileSystemSnapshotManager fileSystemSnapshotManager = StorageFileSystemSnapshotManagerProxy.getInstance().getStorageFileSystemSnapshotManager(devSn);
            OperationResult operationResult = fileSystemSnapshotManager.transSnapshotToSecureSnapshot(devSn, paramMap);
            if (operationResult.isSuccess()) continue;
            ++failedNum;
            String[] alarmParams = new String[]{devSn, protectGroupReplica.getPg().getName(), snapshotId};
            AlarmUtil.sendCommonAlarm((String)"0x3230080", (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])alarmParams);
        }
        if (failedNum > 0) {
            LOGGER.error((Object)"Snapshot trans secure snapshot fail %s, replica name: %s.", new Object[]{String.valueOf(failedNum), protectGroupReplica.getName()});
        }
        return failedNum == 0;
    }

    private static String getAntiBlackmailSnapshotUuid(ProtectObjectReplica protectObjectReplica) {
        Optional<String> snapshotIdOptional = protectObjectReplica.getStorageInfos().stream().filter(relicaStorageInfo -> relicaStorageInfo instanceof LocalStorageReplica).map(relicaStorageInfo -> (LocalStorageReplica)relicaStorageInfo).map(LocalStorageReplica::getSnapshotName).findFirst();
        if (snapshotIdOptional.isPresent()) {
            return snapshotIdOptional.get();
        }
        LOGGER.error((Object)"Extract snapshot uuid error, poReplicaId: %s.", new Object[]{protectObjectReplica.getId()});
        throw new LegoCheckedException(2117645L);
    }

    public static AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum calculateReplicaDetectionStatus(ProtectGroupReplica replica) {
        if (VerifyUtil.isEmpty((Object)replica) || VerifyUtil.isEmpty((Collection)replica.getReplicas())) {
            LOGGER.error((Object)"Invalid param for calculating replica detection status.");
            return AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum.NOT_SUPPORT;
        }
        boolean isExistDetectingSnapshot = false;
        int abnormalNum = 0;
        int infectedNum = 0;
        Set protectObjectReplicas = replica.getReplicas();
        for (ProtectObjectReplica protectObjectReplica : protectObjectReplicas) {
            int detectionStatus = protectObjectReplica.getDetectionStatus();
            if (!AntiBlackMailConstant.SNAPSHOT_DETECTION_FINISH.contains(detectionStatus)) {
                LOGGER.error((Object)"The detection status(%s) of poReplica(id: %s) is running, replica name: %s", new Object[]{detectionStatus, protectObjectReplica.getPoId(), replica.getName()});
                isExistDetectingSnapshot = true;
                continue;
            }
            if (detectionStatus == AntiBlackMailEnumDefine.DetectionStatus.INFECTED.getValue()) {
                ++infectedNum;
                continue;
            }
            if (detectionStatus != AntiBlackMailEnumDefine.DetectionStatus.ABNORMAL.getValue()) continue;
            ++abnormalNum;
        }
        if (isExistDetectingSnapshot) {
            LOGGER.error((Object)"The detection status of replica(name: %s) of protect group is unknown.", new Object[]{replica.getName()});
            return AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum.UNKNOWN;
        }
        AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum newDetectionStatus = abnormalNum == 0 && infectedNum == 0 ? AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum.UNINFECTED : (abnormalNum != 0 ? AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum.ABNORMAL : (infectedNum == protectObjectReplicas.size() ? AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum.ALL_INFECTED : AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum.PARTIALLY_INFECTED));
        int oldDetectionStatus = replica.getDetectionStatus();
        if (oldDetectionStatus != newDetectionStatus.getValue()) {
            LOGGER.info((Object)"The detection status of protect group has changed, old: %s, new: %s", new Object[]{oldDetectionStatus, newDetectionStatus});
        }
        return newDetectionStatus;
    }

    private static boolean shouldTransferToSecure(ProtectGroupReplica replica) {
        if (!AntiBlackmailUtil.isUsingSecureSnapshotPolicy(replica.getPg())) {
            return false;
        }
        long currentTimeMillis = System.currentTimeMillis();
        long deadlineTimeStamp = NumberUtil.convertToLong((Object)replica.getDeadlineTimeStamp());
        LOGGER.debug((Object)"Replica deadline time: %s, current time: %s", new Object[]{TimeUtil.toLocalString((long)deadlineTimeStamp), TimeUtil.toLocalString((long)currentTimeMillis)});
        if (deadlineTimeStamp <= currentTimeMillis) {
            LOGGER.error((Object)"Replica already expired, no need to transfer.", new Object[]{replica.getId()});
            return false;
        }
        return replica.getDetectionStatus() == AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum.UNINFECTED.getValue() && replica.getType() == 11;
    }

    public static void dealResultAndSendAlarm(String devSn, String snapshotUuid, ProtectGroupReplica replica) {
        IAntiBlackmailTaskManager taskManager = AntiBlackmailTaskManagerProxy.getInstance().getTaskManager(devSn);
        String type = AntiBlackMailEnumDefine.OceanProtectTaskTypeEnum.COPY_DELETE.getValue();
        CommUtil.pauseThread((long)10000L);
        Optional<OceanProtectPlatformTask> optionalTask = AntiBlackmailUtil.findTask(taskManager.queryRunningTask(devSn, type), snapshotUuid);
        if (optionalTask.isPresent()) {
            AntiBlackmailUtil.waitCopyDeleteTaskFinishAndCheckStatus(devSn, snapshotUuid, taskManager, optionalTask.get(), replica);
        } else {
            AntiBlackmailUtil.checkDeleteResultStatus(devSn, snapshotUuid, taskManager, type, replica);
        }
    }

    private static void waitCopyDeleteTaskFinishAndCheckStatus(String devSn, String snapshotUuid, IAntiBlackmailTaskManager taskManager, OceanProtectPlatformTask platformTask, ProtectGroupReplica replica) {
        String taskId = platformTask.getJobId();
        long startTime = System.currentTimeMillis();
        do {
            CommUtil.pauseThread((long)10000L);
            Optional taskOptional = taskManager.querySpecificTask(devSn, taskId);
            AntiBlackmailPlatformTask task = (AntiBlackmailPlatformTask)taskOptional.get();
            String currentStatus = task.getStatus();
            if (AntiBlackMailConstant.OP_TASK_RUNNING_STATUS_LIST.contains(currentStatus)) continue;
            if (task.getProgress() == 100 && !AntiBlackMailEnumDefine.OceanProtectTaskStatusEnum.SUCCESS.getValue().equals(currentStatus)) {
                LOGGER.error((Object)"The delete copy task failed, dev sn: %s, taskId: %s, snapshotUuid: %s.", new Object[]{devSn, taskId, snapshotUuid});
                AntiBlackmailUtil.sendDeleteFailAlarmMsg(devSn, replica.getPg().getName(), snapshotUuid);
                return;
            }
            LOGGER.info((Object)"The delete copy task executed successfully, dev sn: %s, taskId: %s, snapshotUuid: %s.", new Object[]{devSn, taskId, snapshotUuid});
            return;
        } while (System.currentTimeMillis() - startTime <= 1200000L);
        LOGGER.error((Object)"Copy delete execution timeout, dev sn: %s", new Object[]{devSn});
        AntiBlackmailUtil.sendDeleteFailAlarmMsg(devSn, replica.getPg().getName(), snapshotUuid);
    }

    private static void checkDeleteResultStatus(String devSn, String snapshotUuid, IAntiBlackmailTaskManager taskManager, String type, ProtectGroupReplica replica) {
        Optional<OceanProtectPlatformTask> optionalTaskComplete = AntiBlackmailUtil.findTask(taskManager.queryHistoricTask(devSn, type), snapshotUuid);
        OceanProtectPlatformTask task = optionalTaskComplete.get();
        if (task.getProgress() == 100 && !AntiBlackMailEnumDefine.OceanProtectTaskStatusEnum.SUCCESS.getValue().equals(task.getStatus())) {
            LOGGER.error((Object)"The delete copy task failed, dev sn: %s, snapshotUuid: %s.", new Object[]{devSn, snapshotUuid});
            AntiBlackmailUtil.sendDeleteFailAlarmMsg(devSn, replica.getPg().getName(), snapshotUuid);
        }
    }

    private static Optional<OceanProtectPlatformTask> findTask(List<AntiBlackmailPlatformTask> taskList, String snapshotUuid) {
        if (VerifyUtil.isEmpty(taskList)) {
            return Optional.empty();
        }
        for (AntiBlackmailPlatformTask antiBlackmailPlatformTask : taskList) {
            OceanProtectPlatformTask task;
            if (!(antiBlackmailPlatformTask instanceof OceanProtectPlatformTask) || !snapshotUuid.equals((task = (OceanProtectPlatformTask)antiBlackmailPlatformTask).getCopyId())) continue;
            return Optional.of(task);
        }
        return Optional.empty();
    }

    public static void sendDeleteFailAlarmMsg(String devSn, String pgName, String snapshotUuid) {
        String[] alarmParams = new String[]{devSn, pgName, snapshotUuid};
        AlarmUtil.sendCommonAlarm((String)"0x3230077", (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])alarmParams);
    }

    public static Map<String, List<AntiBlackmailSnapshot>> queryPgAntiBlackmailSnapshot(ProtectGroup protectGroup, Set<String> storageSnapshotIds) {
        String devSn = protectGroup.getPoProviderSN();
        IAntiBlackmailSnapshotManager antiBlackmailSnapshotManager = AntiBlackmailSnapshotManagerProxy.getInstance().getSnapshotManager(devSn);
        List antiBlackmailSnapshots = antiBlackmailSnapshotManager.queryAllSnapshotByProtectGroup(devSn, protectGroup);
        HashMap<String, List<AntiBlackmailSnapshot>> replicaSnapshotsMap = new HashMap<String, List<AntiBlackmailSnapshot>>();
        for (AntiBlackmailSnapshot antiBlackmailSnapshot : antiBlackmailSnapshots) {
            String[] split;
            String snapshotName = antiBlackmailSnapshot.getName();
            if (VerifyUtil.isEmpty((String)snapshotName) || (split = snapshotName.split("_")).length < 3 || !"BCM".equals(split[0])) continue;
            if (!storageSnapshotIds.contains(antiBlackmailSnapshot.getStorageSnapshotId())) {
                antiBlackmailSnapshotManager.deleteSpecificSnapshot(devSn, antiBlackmailSnapshot.getUuid());
                continue;
            }
            List snapshotList = replicaSnapshotsMap.computeIfAbsent(split[1], key -> new ArrayList());
            snapshotList.add(antiBlackmailSnapshot);
        }
        return replicaSnapshotsMap;
    }

    public static void refreshSinglePgReplica(ProtectGroupReplica replica, Map<String, List<AntiBlackmailSnapshot>> replicaSnapshotsMap, Set<String> currentPoIdSet) {
        if (AntiBlackMailConstant.REPLICA_DETECTION_RUNNING_STATUS_SET.contains(replica.getDetectionStatus()) || AntiBlackMailConstant.NOT_SUPPORT_RECOVER_STATUS_SET.contains(replica.getStatus())) {
            LOGGER.info((Object)"Replica(name: %s) is being used by detect program, status: %s, detectionStatus: %s.", new Object[]{replica, replica.getStatus(), replica.getDetectionStatus()});
            return;
        }
        List<AntiBlackmailSnapshot> snapshotList = replicaSnapshotsMap.get(replica.getId());
        Map idToSnapshotMap = snapshotList.stream().collect(Collectors.toMap(AntiBlackmailSnapshot::getStorageSnapshotId, Function.identity()));
        Set poReplicas = replica.getReplicas();
        Iterator iterator = poReplicas.iterator();
        while (iterator.hasNext()) {
            ProtectObjectReplica poReplica = (ProtectObjectReplica)iterator.next();
            Optional<RelicaStorageInfo> storageInfoOptional = poReplica.getStorageInfos().stream().filter(replicaStorageInfo -> idToSnapshotMap.containsKey(replicaStorageInfo.getStorageId())).findFirst();
            if (!storageInfoOptional.isPresent()) {
                if (!currentPoIdSet.contains(poReplica.getPoId())) continue;
                iterator.remove();
                continue;
            }
            AntiBlackmailSnapshot antiBlackmailSnapshot = (AntiBlackmailSnapshot)idToSnapshotMap.get(storageInfoOptional.get().getStorageId());
            poReplica.setDetectionStatus(antiBlackmailSnapshot.getAntiStatus());
        }
        AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum newDetectionStatus = AntiBlackmailUtil.calculateReplicaDetectionStatus(replica);
        LOGGER.debug((Object)String.format("The calculated status of replica detection is %s", newDetectionStatus));
        replica.setDetectionStatus(newDetectionStatus.getValue());
        if (AntiBlackmailUtil.shouldTransferToSecure(replica)) {
            LOGGER.info((Object)"Transform replica(name: %s) to secure.", new Object[]{replica.getName()});
            AntiBlackmailUtil.transferToSecureReplica(replica);
        } else {
            ((IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class)).saveOrUpdateReplica(replica);
        }
    }

    public static void dealNonExistentReplica(ProtectGroupReplica replica, Set<String> currentPoIdSet, IReplicaService replicaService) {
        Set poReplicas = replica.getReplicas();
        poReplicas.removeIf(poReplica -> currentPoIdSet.contains(poReplica.getPoId()));
        if (VerifyUtil.isEmpty((Collection)poReplicas)) {
            LOGGER.info((Object)"Delete invalid protectGroup Replica(ReplicaName: %s).", new Object[]{replica.getName()});
            replicaService.deleteProtectGroupReplicaById(replica.getId());
        } else {
            replicaService.saveOrUpdateReplica(replica);
        }
    }

    public static void updateReplica(String pgRId, int pgReplicaStatus, Set<ProtectObjectReplica> replicaSet) {
        ProtectGroupReplica protectGroupReplica = (ProtectGroupReplica)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ProtectGroupReplica.class, (Serializable)((Object)pgRId));
        protectGroupReplica.setStatus(pgReplicaStatus);
        if (!VerifyUtil.isEmpty(replicaSet)) {
            protectGroupReplica.setReplicas(replicaSet);
        }
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)protectGroupReplica);
    }

    public static void buildBackTaskAndAddToCache(String devSn, ProtectGroupReplica replica, List<String> successIds, boolean isManual) {
        AntiBlackmailSnapshotDeleteDetail detail = new AntiBlackmailSnapshotDeleteDetail();
        detail.setDevSn(devSn);
        detail.setPgRId(replica.getId());
        detail.setPgName(replica.getPg().getName());
        detail.setSnapshotIds(successIds);
        detail.setTotal(successIds.size());
        detail.setManual(isManual);
        AntiBlackmailSnapshotDeleteTask deleteTask = new AntiBlackmailSnapshotDeleteTask(replica.getName(), JSONObject.fromObject((Object)detail).toString(), isManual);
        deleteTask.addSyncSnapshotDeleteResultTask();
    }

    public static ProtectGroupReplica findFirstUninfectedReplica(List<ProtectGroupReplica> replicas) {
        ProtectGroupReplica first = null;
        Optional<ProtectGroupReplica> firstOptional = replicas.stream().filter(e -> !VerifyUtil.isEmpty((String)e.getTimeStamp()) && e.getDetectionStatus() == AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum.UNINFECTED.getValue()).sorted(Comparator.comparing(ProtectGroupReplica::getTimeStamp).reversed()).findFirst();
        if (firstOptional.isPresent()) {
            first = firstOptional.get();
        }
        return first;
    }

    public static boolean checkSecureSnapshotCanBeDelete(String devSn, ProtectGroupReplica replica) {
        IStorageFileSystemSnapshotManager snapshotManager = StorageFileSystemSnapshotManagerProxy.getInstance().getStorageFileSystemSnapshotManager(devSn);
        for (ProtectObjectReplica poReplica : replica.getReplicas()) {
            String fsId;
            RelicaStorageInfo storageInfo;
            Set storageReplicaList = poReplica.getStorageInfos();
            if (VerifyUtil.isEmpty((Collection)storageReplicaList) || !((storageInfo = (RelicaStorageInfo)storageReplicaList.iterator().next()) instanceof LocalStorageReplica)) continue;
            LocalStorageReplica storageReplica = (LocalStorageReplica)storageInfo;
            String snapshotUuid = storageReplica.getSnapshotName();
            String vstoreId = (String)poReplica.getProtectObject().getProps().get("PROP_KEY_VSTORE_ID");
            if (!snapshotManager.isSecureSnapshotInProtectionPeriod(devSn, vstoreId, fsId = (String)poReplica.getProtectObject().getProps().get("nasFsId"), snapshotUuid)) continue;
            return true;
        }
        return false;
    }
}

