/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.backup;

import com.huawei.ism.drm.backup.IBackupManager;
import java.util.HashMap;
import java.util.Map;

public class BackupManagerProxy {
    public static final String DEFAULT_BACKUP_ENGINETYPE = "NativeBackupEngine";
    private static Map<String, IBackupManager> manageServiceMap = new HashMap<String, IBackupManager>();
    private static BackupManagerProxy instance = null;

    public static synchronized BackupManagerProxy getInstance() {
        if (null == instance) {
            instance = new BackupManagerProxy();
        }
        return instance;
    }

    public void onBind(IBackupManager backupService, Map properties) {
        manageServiceMap.put(backupService.getBackupEngineType(), backupService);
    }

    public void onUnbind(IBackupManager backupService, Map properties) {
        manageServiceMap.remove(backupService.getBackupEngineType());
    }

    public IBackupManager getBackupService(String backupType) {
        IBackupManager iBackupManager = manageServiceMap.get(backupType);
        if (iBackupManager == null) {
            return manageServiceMap.get(DEFAULT_BACKUP_ENGINETYPE);
        }
        return manageServiceMap.get(backupType);
    }
}

