/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cert.component;

import com.huawei.ism.drm.cert.component.ComponentCertificateService;
import com.huawei.ism.drm.cert.sdk.model.CertificateSummary;
import com.huawei.ism.drm.cert.sdk.service.IComplexCertificateService;
import com.huawei.ism.drm.cert.sdk.service.command.CommandReaction;
import com.huawei.ism.drm.cert.sdk.service.command.INodeAgentCommand;
import com.huawei.ism.drm.cert.sdk.service.command.Parameter;
import com.huawei.nodeagent.thrift.Node;
import com.huawei.nodeagent.thrift.Response;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ServerCertificateService
extends ComponentCertificateService {
    private boolean singleAvailable = true;
    private IComplexCertificateService complexCertificateService;

    public ServerCertificateService(List<String> certs, String replaceCommandName, String rollbackCommandName) {
        super(certs, replaceCommandName, rollbackCommandName);
    }

    public boolean isSingleAvailable() {
        return this.singleAvailable;
    }

    public void setSingleAvailable(boolean singleAvailable) {
        this.singleAvailable = singleAvailable;
    }

    public IComplexCertificateService getComplexCertificateService() {
        return this.complexCertificateService;
    }

    public void setComplexCertificateService(IComplexCertificateService complexCertificateService) {
        this.complexCertificateService = complexCertificateService;
    }

    public void initialize() {
        if (this.complexCertificateService != null) {
            this.complexCertificateService.initialize(this.getCertificateSummaries());
        } else {
            this.getCertificateSummaries().forEach(this::initialize);
        }
    }

    private void initialize(CertificateSummary summary) {
        this.getSystemCertificateService().getCertificateHandler(summary).fulfil(summary);
    }

    @Override
    protected CommandReaction<Map<Node, Response>> executeCommand(INodeAgentCommand command, List<Node> nodes, Parameter ... params) {
        if (!this.singleAvailable && nodes.size() <= 1) {
            return new CommandReaction(Collections.emptyMap());
        }
        return super.executeCommand(command, nodes, params);
    }
}

