/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cert.handler;

import com.huawei.ism.drm.cert.sdk.model.CertificateAuthority;
import com.huawei.ism.drm.cert.sdk.model.CertificateContent;
import com.huawei.ism.drm.cert.sdk.model.CertificateSummary;
import com.huawei.ism.drm.cert.sdk.model.CertificateUpdateParam;
import com.huawei.ism.drm.cert.sdk.service.ICertificateHandler;
import com.huawei.ism.drm.cert.sdk.service.command.Parameter;
import com.huawei.ism.drm.util.Base64;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.file.util.FileUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.PathUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.springframework.util.Base64Utils;
import org.springframework.util.ObjectUtils;

public abstract class CertificateHandler
implements ICertificateHandler {
    public static final int KEY_LENGTH = 2048;
    public static final int KEY_LENGTH_KEY = 2;
    private static final Path LEGO_RUNTIME_TEMP_DIR = PathUtil.getLegoRuntimeTempDir();
    private static final Path CERT_TEMP_PATH = LEGO_RUNTIME_TEMP_DIR.resolve("cert");
    private static final Log logger = LogFactory.getInstance(CertificateHandler.class);
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private String type;

    public CertificateHandler(String type) {
        this.type = Objects.requireNonNull(type);
    }

    public boolean suitable(CertificateSummary certificate) {
        return certificate != null && this.type.equalsIgnoreCase(certificate.getType());
    }

    public String validate(CertificateUpdateParam param) {
        return Optional.ofNullable(this.validateCas(param)).orElseGet(() -> this.validateCert(param));
    }

    protected String validateCas(CertificateUpdateParam param) {
        List cas = param.getCas();
        if (cas != null) {
            if (cas.stream().anyMatch(ca -> ca == null || ca.getCaContent() == null)) {
                return "has invalid CA content";
            }
        } else {
            param.setCas(Collections.emptyList());
        }
        return null;
    }

    protected String validateCert(CertificateUpdateParam param) {
        logger.info((Object)"validate cert.");
        CertificateContent cert = param.getCert();
        StringBuilder msg = new StringBuilder();
        if (ObjectUtils.isEmpty((Object)cert)) {
            return "no cert";
        }
        msg.append(this.validateCertContent(cert));
        return msg.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String validateCertContent(CertificateContent cert) {
        if (VerifyUtil.isEmpty((Object)cert)) {
            return "value of field 'cert' is not provided";
        }
        if (VerifyUtil.isEmpty((String)cert.getCertContent())) {
            return "value of field 'cert.certContent' is not provided";
        }
        if (!ParamChecker.checkBase64((String)cert.getCertContent())) {
            return "value of field 'cert.certContent' is not correct";
        }
        try (ByteArrayInputStream bi = new ByteArrayInputStream(Base64.base64ToByteArray((String)cert.getCertContent()));){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate certificate = (X509Certificate)cf.generateCertificate(bi);
            String algorithm = certificate.getPublicKey().getAlgorithm();
            if (!"RSA".equals(algorithm)) return "";
            KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
            RSAPublicKeySpec rsaPublicKeySpec = keyFactory.getKeySpec(certificate.getPublicKey(), RSAPublicKeySpec.class);
            int moduleLength = rsaPublicKeySpec.getModulus().toString(2).length();
            if ("SHA256withRSA".equals(certificate.getSigAlgName())) {
                if (moduleLength >= 2048) return "";
            }
            String string = "The signature algorithm and key length do not meet requirements.";
            return string;
        }
        catch (IOException | GeneralSecurityException e) {
            logger.error((Object)"Failed to parse the certificate file.");
            return "Failed to parse the certificate file.";
        }
    }

    protected String saveTextToFile(String certDir, String certName, String text, String taskId, String message) {
        File file = null;
        try {
            File dir = CertificateHandler.resolveCertTempDir(certDir);
            File temp = file = File.createTempFile(certName, ".pem", dir);
            if (!FileUtil.writeText((File)temp, (String)new String(Base64Utils.decode((byte[])text.getBytes(UTF8)), UTF8)) && !temp.delete()) {
                logger.error((Object)("delete temp file failed. file name: " + temp.getName()));
            }
        }
        catch (IOException e) {
            Optional.ofNullable(file).ifPresent(File::delete);
            throw new LegoCheckedException(0x300001L, null, message + " failed. " + new JSONObject().set((Object)"taskId", (Object)taskId).set((Object)"certName", (Object)certName).toString());
        }
        catch (LegoCheckedException e) {
            Optional.ofNullable(file).ifPresent(File::delete);
            throw e;
        }
        return CertificateHandler.getRelativizeCertTempPath(file);
    }

    protected static String getRelativizeCertTempPath(File file) {
        return LEGO_RUNTIME_TEMP_DIR.relativize(file.toPath()).toString();
    }

    protected void writeCaToFile(CertificateAuthority ca, File file, String certName, String taskId) {
        this.writeCaToFile(ca, file, certName, taskId, true);
    }

    protected void writeCaToFile(CertificateAuthority ca, File file, String certName, String taskId, boolean append) {
        try (FileOutputStream outputStream = new FileOutputStream(file, append);){
            ((OutputStream)outputStream).write(Base64Utils.decode((byte[])ca.getCaContent().getBytes(UTF8)));
            outputStream.flush();
        }
        catch (IOException e) {
            String message = "save certificate content to file failed. " + new JSONObject().set((Object)"taskId", (Object)taskId).set((Object)"certName", (Object)certName).toString();
            throw new LegoCheckedException(0x300001L, null, message);
        }
    }

    protected String writeCaToFile(CertificateAuthority ca, String certName, String taskId) {
        File file = null;
        try {
            File temp = file = File.createTempFile("ca", ".pem", CertificateHandler.resolveCertTempDir(certName));
            temp.deleteOnExit();
            this.writeCaToFile(ca, file, certName, taskId, false);
        }
        catch (IOException e) {
            Optional.ofNullable(file).ifPresent(File::deleteOnExit);
            String message = "save certificate content to file failed. " + new JSONObject().set((Object)"taskId", (Object)taskId).set((Object)"certName", (Object)certName).toString();
            throw new LegoCheckedException(0x300001L, null, message);
        }
        return CertificateHandler.getRelativizeCertTempPath(file);
    }

    protected List<String> saveCasToFile(CertificateUpdateParam param, boolean append) {
        CertificateContent cert = param.getCert();
        List cas = param.getCas();
        if (VerifyUtil.isEmpty((Collection)cas)) {
            logger.info((Object)("CAs is empty for cert " + cert.getCertName()));
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (CertificateAuthority ca2 : cas) {
            if (builder.length() > 0) {
                builder.append('\n');
            }
            builder.append(ca2.getCaContent());
        }
        ArrayList<String> files = new ArrayList<String>();
        if (append) {
            File file = null;
            try {
                File base = CertificateHandler.resolveCertTempDir(cert.getCertName());
                File temp = file = File.createTempFile("ca-", ".pem", base);
                temp.deleteOnExit();
                cas.forEach(ca -> this.writeCaToFile((CertificateAuthority)ca, temp, cert.getCertName(), param.getTaskId()));
            }
            catch (IOException e) {
                Optional.ofNullable(file).ifPresent(File::deleteOnExit);
                String message = "save certificate content to file failed. ";
                throw new LegoCheckedException(0x300001L, null, message + new JSONObject().set((Object)"taskId", (Object)param.getTaskId()).set((Object)"certName", (Object)cert.getCertName()).toString());
            }
            catch (LegoCheckedException e) {
                Optional.ofNullable(file).ifPresent(File::deleteOnExit);
                throw e;
            }
            files.add(CertificateHandler.getRelativizeCertTempPath(file));
        } else {
            cas.forEach(ca -> files.add(this.writeCaToFile((CertificateAuthority)ca, cert.getCertName(), param.getTaskId())));
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveCertificateToFileSystem(CertificateUpdateParam param, Map<String, String> options, boolean single, Consumer<Parameter> handler, Map.Entry<String, String> ... entries) {
        ArrayList<String> paths = new ArrayList<String>();
        CertificateContent cert = param.getCert();
        for (Map.Entry<String, String> entry : entries) {
            paths.add(this.saveTextToFile(cert.getCertName(), cert.getCertName() + "-" + entry.getKey(), entry.getValue(), param.getTaskId(), "save " + entry.getKey() + " file to file system"));
        }
        paths.addAll(Optional.ofNullable(this.saveCasToFile(param, single)).orElse(Collections.emptyList()));
        try {
            handler.accept(new Parameter(Optional.ofNullable(options).orElse(Collections.emptyMap()), paths));
        }
        finally {
            this.cleanTempFile(paths);
        }
    }

    private void cleanTempFile(List<String> names) {
        Path temp = PathUtil.getLegoRuntimeTempDir();
        names.stream().map(name -> temp.resolve((String)name).toFile()).filter(File::exists).forEach(File::delete);
    }

    protected File createTempFile(String certName, String prefix, String suffixKey, String defaultSuffix) throws IOException {
        LegoConfig config = LegoConfig.getInstance();
        String suffix = config.getKeyValue(suffixKey, defaultSuffix);
        File dir = CertificateHandler.resolveCertTempDir(certName);
        return File.createTempFile(prefix, suffix, dir);
    }

    protected static File resolveCertTempDir(String certName) {
        File dir = CERT_TEMP_PATH.resolve(certName).toFile();
        if (dir.mkdirs()) {
            logger.debug((Object)"success to create temp dir for %s", new Object[]{certName});
        }
        return dir;
    }
}

