/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cert.handler;

import com.huawei.ism.drm.cert.handler.ServerCertificateHandler;
import com.huawei.ism.drm.cert.sdk.model.CertificateAuthority;
import com.huawei.ism.drm.cert.sdk.model.CertificateContent;
import com.huawei.ism.drm.cert.sdk.model.CertificateUpdateParam;
import com.huawei.ism.drm.cert.sdk.service.command.Parameter;
import com.huawei.ism.drm.util.Base64;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;

public class Pem2JksServerCertificateHandler
extends ServerCertificateHandler {
    private static final String TYPE = "JKS";
    private static final String FORMAT = "pem2jks";
    private static final Log logger = LogFactory.getInstance(Pem2JksServerCertificateHandler.class);

    public Pem2JksServerCertificateHandler() {
        super(FORMAT);
    }

    @Override
    protected String validateCert(CertificateUpdateParam param) {
        return Optional.ofNullable(super.validateCert(param)).orElseGet(() -> Pem2JksServerCertificateHandler.validateCertPriKey(param.getCert()));
    }

    public void saveCertificateToFileSystem(CertificateUpdateParam param, Consumer<Parameter> handler) {
        CertificateContent cert = param.getCert();
        File file = null;
        String password = cert.getPriKeyPwd();
        FileOutputStream output = null;
        try {
            KeyStore keyStore = KeyStore.getInstance(TYPE);
            keyStore.load(null, null);
            LegoConfig config = LegoConfig.getInstance();
            PrivateKey priKey = this.convertEncPemToObject(new String(Base64.base64ToByteArray((String)cert.getPriKey()), StandardCharsets.UTF_8), password);
            List<String> certs = param.getCas().stream().map(CertificateAuthority::getCaContent).collect(Collectors.toList());
            certs.add(0, cert.getCertContent());
            Certificate[] chain = this.loadCertificateChain(certs);
            this.trustCaCertificates(keyStore, chain);
            char[] pwd = password.toCharArray();
            keyStore.setKeyEntry(config.getKeyValue("config.cert.jks.alias.key", "bcmrootca"), priKey, pwd, chain);
            File temp = file = this.createTempFile(cert.getCertName(), cert.getCertName(), "config.cert.jks.suffix", ".keystore");
            temp.deleteOnExit();
            output = new FileOutputStream(temp);
            keyStore.store(output, pwd);
            handler.accept(new Parameter(Collections.singletonMap("password", password), Collections.singletonList(Pem2JksServerCertificateHandler.getRelativizeCertTempPath(temp))));
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            String message = "save certificate content to keystore file failed. ";
            logger.error((Object)(message + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException(0x300001L, null, message + new JSONObject().set((Object)"taskId", (Object)param.getTaskId()).set((Object)"certName", (Object)cert.getCertName()).toString());
        }
        finally {
            if (file != null && !file.delete()) {
                logger.error((Object)("Fail to delete temp file " + file.getName()));
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    logger.error((Object)("close output stream failed. " + ExceptionUtil.getErrorMessage((Throwable)e)));
                }
            }
        }
    }

    private void trustCaCertificates(KeyStore keyStore, Certificate[] certificates) {
        int n = certificates.length;
        for (int i = 1; i < n; ++i) {
            try {
                keyStore.setCertificateEntry("ca-" + (n - i), certificates[i]);
                continue;
            }
            catch (KeyStoreException e) {
                String message = "add ca as trust certificate failed. ";
                logger.error((Object)(message + ExceptionUtil.getErrorMessage((Throwable)e)));
                throw new LegoCheckedException(0x300001L, null, message);
            }
        }
    }

    private PrivateKey convertEncPemToObject(String encPemStrs, String password) {
        PrivateKey rdKey;
        try (PEMParser parser = new PEMParser((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(encPemStrs.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8));){
            Object object = parser.readObject();
            if (object == null) {
                logger.error((Object)"parse priKey failed. cause: read pem object failed");
                throw new LegoCheckedException(0x300001L, "convertEncPemToPriKey PEMParser failed . ");
            }
            if (!(object instanceof PKCS8EncryptedPrivateKeyInfo)) {
                logger.error((Object)"parse priKey failed. cause: format is not pkcs encrypted private key");
                throw new LegoCheckedException(0x300001L, "prikey EncPem is not PKCS8 style.");
            }
            PKCS8EncryptedPrivateKeyInfo pInfo = (PKCS8EncryptedPrivateKeyInfo)object;
            InputDecryptorProvider provider = new JceOpenSSLPKCS8DecryptorProviderBuilder().setProvider("BC").build(password.toCharArray());
            rdKey = new JcaPEMKeyConverter().setProvider("BC").getPrivateKey(pInfo.decryptPrivateKeyInfo(provider));
        }
        catch (IOException | OperatorCreationException | PKCSException e) {
            logger.error((Object)"parse priKey failed. cause: incorrect content", e);
            throw new LegoCheckedException(0x300001L, "parse priKey failed.");
        }
        return rdKey;
    }

    private Certificate[] loadCertificateChain(List<String> certContents) throws CertificateException, IOException {
        CertificateFactory cf = CertificateFactory.getInstance(LegoConfig.getInstance().getKeyValue("config.cert.type", "X.509"));
        Certificate[] certificates = new Certificate[certContents.size()];
        int n = certContents.size();
        for (int i = 0; i < n; ++i) {
            try (ByteArrayInputStream is = new ByteArrayInputStream(Base64.base64ToByteArray((String)certContents.get(i)));){
                certificates[i] = cf.generateCertificate(is);
                continue;
            }
        }
        return certificates;
    }
}

