/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cert.handler;

import com.huawei.ism.drm.cert.handler.ServerCertificateHandler;
import com.huawei.ism.drm.cert.sdk.model.CertificateContent;
import com.huawei.ism.drm.cert.sdk.model.CertificateUpdateParam;
import com.huawei.ism.drm.cert.sdk.service.command.Parameter;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Consumer;

public class PemServerCertificateHandler
extends ServerCertificateHandler {
    private static final String FORMAT = "pem";

    public PemServerCertificateHandler() {
        super(FORMAT);
    }

    @Override
    protected String validateCert(CertificateUpdateParam param) {
        return Optional.ofNullable(super.validateCert(param)).orElseGet(() -> PemServerCertificateHandler.validateCertPriKey(param.getCert()));
    }

    public void saveCertificateToFileSystem(CertificateUpdateParam param, Consumer<Parameter> handler) {
        CertificateContent cert = param.getCert();
        this.saveCertificateToFileSystem(param, Collections.singletonMap("password", cert.getPriKeyPwd()), true, handler, new AbstractMap.SimpleEntry<String, String>("crt", cert.getCertContent()), new AbstractMap.SimpleEntry<String, String>("key", cert.getPriKey()));
    }
}

