/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cert.task;

import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.drm.cert.sdk.model.CertificateUpdateParam;
import com.huawei.ism.drm.cert.sdk.service.ICertificateHandler;
import com.huawei.ism.drm.cert.sdk.service.IComponentCertificateService;
import com.huawei.ism.drm.cert.sdk.service.ISystemCertificateService;
import com.huawei.ism.drm.cert.sdk.service.command.CommandReaction;
import com.huawei.ism.drm.cert.sdk.service.command.Parameter;
import com.huawei.ism.drm.cert.task.CertificateOperateTask;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.nodeagent.thrift.Node;
import com.huawei.nodeagent.thrift.Response;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.Charsets;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.URLEncodedUtils;

public class CertificateUpdateTask
extends CertificateOperateTask {
    public static final String TASK_NAME = "ism.drm.cert.update";
    public static final String TASK_TYPE = "cert.update";
    private static final Log logger = LogFactory.getInstance(CertificateUpdateTask.class);
    private CertificateUpdateParam param;
    private ICertificateHandler handler;

    public CertificateUpdateTask(ISystemCertificateService systemCertificateService, ICertificateHandler handler, CertificateUpdateParam param, boolean independent) {
        super("update", systemCertificateService, BackTaskUtil.buildBackTask((String)param.getCert().getCertName(), (String)TASK_NAME, (String)"System", (String)TASK_TYPE, (String)"", (String[])new String[0]), param.getTaskId(), independent);
        this.param = param;
        this.handler = handler;
    }

    protected void doWork() {
        List<Node> nodes = this.getNodeList();
        List stoppedNodes = nodes.stream().filter(node -> !node.running).collect(Collectors.toList());
        if (!stoppedNodes.isEmpty()) {
            List addresses = stoppedNodes.stream().map(node -> node.getAddresses().stream().findFirst().orElse("unknown")).collect(Collectors.toList());
            throw CommandReaction.genNodeAgentStatusException(addresses, null).log(logger);
        }
        this.handler.saveCertificateToFileSystem(this.param, this::updateCertificate);
    }

    private void updateCertificate(Parameter detail) {
        detail.getOpts().put("cert-name", this.getCertName());
        String timeStamp = String.valueOf(System.currentTimeMillis());
        detail.getOpts().put("timestamp", timeStamp);
        logger.info((Object)"Time stamp for task: %s is: %s", new Object[]{this.param.getTaskId(), timeStamp});
        this.operateCertificate(detail);
    }

    private void operateCertificate(Parameter detail) {
        this.disableHaAutoSwitch();
        try {
            this.doOperateCertificate(detail);
        }
        finally {
            this.enableHaAutoSwitch();
        }
    }

    private void doOperateCertificate(Parameter detail) {
        IComponentCertificateService componentCertificateService = this.getComponentCertificateService();
        CommandReaction commandReaction = componentCertificateService.operateCertificate(this.getNodeList(), new Parameter[]{detail});
        if (commandReaction.success()) {
            return;
        }
        this.doRollbackCertificate(componentCertificateService, (CommandReaction<Map<Node, Response>>)commandReaction);
        commandReaction.check(1073949714L);
    }

    private void doRollbackCertificate(IComponentCertificateService componentCertificateService, CommandReaction<Map<Node, Response>> commandReaction) {
        String resultMapStr = JSONObject.fromObject((Object)commandReaction.getContext()).toString();
        BasicNameValuePair pair = new BasicNameValuePair("resultMap", resultMapStr);
        String resultUrlStr = URLEncodedUtils.format(Collections.singletonList(pair), (Charset)Charsets.UTF_8);
        this.getBackTask().setTaskLink(this.getBackTask().getTaskLink() + "&" + resultUrlStr);
        Map responses = (Map)commandReaction.getResult();
        List nodes = responses.entrySet().stream().filter(e -> ((Response)e.getValue()).code == 0L).map(Map.Entry::getKey).collect(Collectors.toList());
        Parameter rollbackParam = new Parameter(new HashMap());
        rollbackParam.getOpts().put("cert-name", this.getCertName());
        rollbackParam.getOpts().put("resultMap", resultMapStr);
        componentCertificateService.rollbackCertificate(nodes, new Parameter[]{rollbackParam}).check(1073949717L);
    }
}

