/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.service.impl;

import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanObserverManager;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RecoveryPlanObserverManager
extends BaseService
implements IRecoveryPlanObserverManager {
    private static Log logger = LogFactory.getInstance(RecoveryPlanObserverManager.class);
    private List<IObjectObserver> observerList = new ArrayList<IObjectObserver>();

    public void addObserver(IObjectObserver observer, Map<?, ?> properties) {
        if (RecoveryPlan.class.getName().equals(observer.getObserverType())) {
            this.observerList.add(observer);
        }
    }

    public void removeObserver(IObjectObserver observer, Map<?, ?> properties) {
        this.observerList.remove(observer);
    }

    public void notifyObserverList(MessageEvent event, String notifyType) {
        try {
            for (IObjectObserver observer : this.getObserverList()) {
                if (null == observer || !RecoveryPlan.class.getName().equals(observer.getObserverType())) continue;
                if ("before".equals(notifyType)) {
                    observer.before(event);
                    continue;
                }
                if ("after".equals(notifyType)) {
                    observer.after(event);
                    continue;
                }
                logger.error((Object)("notifyType is " + notifyType), 90160758786898L);
            }
        }
        catch (LegoCheckedException le) {
            logger.error((Object)"failed to notify observer.", (Throwable)le, 90160758786898L);
            throw le;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"failed to notify observer.", (long)-1L, (String[])new String[0], (Log)logger);
        }
    }

    public List<IObjectObserver> getObserverList() {
        return this.observerList;
    }
}

