/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.license;

import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.service.DrmBaseService;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.license.LicenseOverflowStackControl;
import com.huawei.ism.drm.license.RDLicenseFactory;
import com.huawei.ism.drm.license.sdk.IDRVMPlatinicInter;
import com.huawei.ism.drm.license.sdk.ILicenseControl;
import com.huawei.ism.drm.license.sdk.ILicenseInter;
import com.huawei.ism.drm.license.sdk.ILicenseUseInter;
import com.huawei.ism.drm.license.sdk.LicenseBuffer;
import com.huawei.ism.drm.license.sdk.LicenseCalcBean;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.ManagementServer;
import com.huawei.ism.drm.site.sdk.service.IManagementServerService;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.lego.cbb.license.sdk.model.FeatureBo;
import com.huawei.lego.cbb.license.sdk.model.LicenseInfoBo;
import com.huawei.lego.cbb.license.sdk.model.ResourceItemBo;
import com.huawei.lego.cbb.license.sdk.model.po.LicenseInfo;
import com.huawei.lego.cbb.license.util.LicensePolicyUtil;
import com.huawei.lego.cbb.license.util.TranslateLicenseModel;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoExceptionTranslator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.nodeagent.thrift.Command;
import com.huawei.nodeagent.thrift.Node;
import com.huawei.nodeagent.thrift.NodeAgentLocalService;
import com.huawei.nodeagent.thrift.Response;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.thrift.TException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

@Service(Name="ILicenseInter", Desc="", Interface=ILicenseInter.class)
public class LicManSDPImpl
extends DrmBaseService
implements ILicenseInter {
    private static final long serialVersionUID = 700980509227973621L;
    private static Log logger = LogFactory.getInstance(LicManSDPImpl.class);
    private static final int CALC_LICENSE_TIMEOUT = 10000;
    private Map<String, List<ILicenseUseInter>> useServiceMap = new HashMap<String, List<ILicenseUseInter>>();
    private ISiteService siteService = null;
    private IDRVMPlatinicInter vmPlatinicService = null;
    private NodeAgentLocalService.Iface nodeAgentAccessClient;

    public void onBindDRVMPlatinic(IDRVMPlatinicInter service, Map<?, ?> properties) {
        this.vmPlatinicService = service;
        logger.info((Object)("onBindDRVMPlatinic->" + this.vmPlatinicService), 90160758786816L);
    }

    public void onUnbindDRVMPlatinic(IDRVMPlatinicInter service, Map<?, ?> properties) {
        this.vmPlatinicService = null;
        logger.info((Object)("onUnbindDRVMPlatinic->" + service), 90160758786816L);
    }

    public boolean isDRVMPlatinic() {
        if (null == this.vmPlatinicService) {
            return false;
        }
        return this.vmPlatinicService.isDRVMPlatinic();
    }

    public String adaptiveLMHashEx(String src) {
        return null;
    }

    public LicenseInfoBo convert2LicBo(byte[] licFile) {
        return RDLicenseFactory.getInstance().convert2LicBo(licFile);
    }

    public long isLicExpired() {
        return RDLicenseFactory.getInstance().isLicExpired();
    }

    public boolean checkLicItemValid(String feaName, String itemName) {
        logger.debug((Object)("feaName=" + feaName));
        return RDLicenseFactory.getInstance().checkLicItemValid(feaName, itemName);
    }

    public void activateLic(byte[] licFile) {
        logger.debug((Object)"activateLic");
        LicenseInfo licenseInfo = RDLicenseFactory.getInstance().activateLic(licFile);
        this.activateLic(licenseInfo);
        this.updateLicenseBuff(false);
        LicenseOverflowStackControl.getInstance().resetLicenseUsedItem();
        ILicenseControl licenseControl = (ILicenseControl)ServiceLocator.getInstance().getService(ILicenseControl.class);
        licenseControl.checkLicenseOutOfControlAlarm(true);
    }

    private void activateLic(LicenseInfo curLic) {
        Transaction tx = null;
        Session session = null;
        IBaseDao baseDao = CommonDAOLocator.getBaseDao();
        try {
            session = baseDao.getHibernateTemplate().getSessionFactory().openSession();
            if (null != session) {
                tx = session.beginTransaction();
                Query query = session.createQuery("delete from LicenseInfo");
                query.executeUpdate();
                session.save((Object)curLic);
                tx.commit();
            }
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                logger.error((Object)"Exception", (Throwable)e, 90160758787071L);
                throw LegoExceptionTranslator.convert((Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession(session);
    }

    private List<LicenseInfo> getAllLicense() {
        String queryString = "from LicenseInfo where inUse = ?";
        Boolean inUse = true;
        List licenseList = null;
        Transaction tx = null;
        Session session = null;
        IBaseDao baseDao = CommonDAOLocator.getBaseDao();
        try {
            session = baseDao.getHibernateTemplate().getSessionFactory().openSession();
            if (null != session) {
                tx = session.beginTransaction();
                licenseList = session.createQuery(queryString).setBoolean(0, inUse.booleanValue()).list();
                tx.commit();
            }
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                logger.error((Object)"Exception", (Throwable)e, 90160758787071L);
                throw LegoExceptionTranslator.convert((Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession(session);
        return licenseList;
    }

    public LicenseInfoBo getLicenseNotUpdateUseNum() {
        LicenseInfoBo temp = LicenseBuffer.getInstance().getLicenseBuff();
        if (null == temp) {
            logger.debug((Object)"temp is null");
            this.updateLicenseBuff(true);
            temp = LicenseBuffer.getInstance().getLicenseBuff();
        }
        return temp;
    }

    public LicenseInfoBo getLicense() {
        LicenseInfoBo temp = this.getLicenseNotUpdateUseNum();
        if (null == temp) {
            logger.debug((Object)"temp is null");
            return temp;
        }
        if (temp.getFeaBolst() != null && !temp.getFeaBolst().isEmpty()) {
            for (FeatureBo fitem : temp.getFeaBolst()) {
                List resList = fitem.getReslst();
                this.countResUseNum(resList);
            }
        }
        return temp;
    }

    public List<String> getEsnInfo() {
        ArrayList<String> esnList = new ArrayList<String>();
        try {
            List nodeList = this.nodeAgentAccessClient.getNodeList();
            Map esnResultList = this.nodeAgentAccessClient.execute(new Command("query_esn"), nodeList, null);
            if (VerifyUtil.isEmpty((Map)esnResultList)) {
                logger.error((Object)"get esn empty.");
                return Collections.emptyList();
            }
            boolean hasError = false;
            for (Map.Entry responseEntry : esnResultList.entrySet()) {
                Response response = (Response)responseEntry.getValue();
                Node key = (Node)responseEntry.getKey();
                long code = response.getCode();
                if (code != 0L) {
                    logger.error((Object)"get esn info failed: address=%s, code=%s, detail=%s", new Object[]{key.getAddresses(), response.getCode(), response.getDetails()});
                    hasError = true;
                    break;
                }
                String details = response.getDetails();
                if (VerifyUtil.isEmpty((String)details)) {
                    logger.error((Object)"get esn info empty: address=%s, code=%s", new Object[]{key.getAddresses(), response.getCode()});
                    hasError = true;
                    break;
                }
                String[] split = details.split(",");
                esnList.addAll(Arrays.asList(split));
            }
            if (hasError) {
                return Collections.singletonList("--");
            }
        }
        catch (TException e) {
            logger.error((Object)"get esn info failed: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            return Collections.emptyList();
        }
        return esnList;
    }

    public void countResUseNum(List<ResourceItemBo> resList) {
        if (resList == null || resList.isEmpty()) {
            return;
        }
        List<String> resTypeList = this.getResTypeList(resList);
        LicenseCalcBean bean = this.calcLicenseConsume(new ArrayList<String>(), resTypeList);
        for (ResourceItemBo item : resList) {
            String useCount = "0";
            if (bean.getErrorCode() != 0L) {
                useCount = "--";
            } else if (bean.getResConsumeMap().containsKey(item.getItemName())) {
                useCount = ((Integer)bean.getResConsumeMap().get(item.getItemName())).toString();
            }
            item.setErrorCode(bean.getErrorCode());
            item.setParameters(bean.getParameters());
            item.setConsumeNum(useCount);
            logger.info((Object)("res item name=" + item.getItemName() + "; value=" + useCount), 90160758787071L);
        }
    }

    private List<String> getResTypeList(List<ResourceItemBo> resList) {
        ArrayList<String> resTypeList = new ArrayList<String>();
        for (ResourceItemBo item : resList) {
            resTypeList.add(item.getItemName());
        }
        return resTypeList;
    }

    private void updateLicenseBuff(boolean needActive) {
        List<LicenseInfo> licList = this.getAllLicense();
        if (licList != null && !licList.isEmpty()) {
            LicenseInfo tmpLicInfo = licList.get(0);
            byte[] bFile = TranslateLicenseModel.getByteByBlob((Blob)tmpLicInfo.getFile());
            if (needActive) {
                RDLicenseFactory.getInstance().activateLic(bFile);
            }
            LicenseInfoBo temp = this.convert2LicBo(bFile);
            temp.setId(tmpLicInfo.getId());
            temp.setInUse(Boolean.valueOf(tmpLicInfo.isInUse()));
            temp.setProductESN(tmpLicInfo.getProductESN());
            temp.setProductName(tmpLicInfo.getProductName());
            temp.setUploadTime(Long.valueOf(tmpLicInfo.getUploadTime()));
            temp.setSoftId(tmpLicInfo.getSoftId());
            LicenseBuffer.getInstance().updateLicenseBuff(temp);
        }
    }

    public long getSysInstallTime() {
        LicensePolicyUtil policy = new LicensePolicyUtil();
        long sysInstallTime = policy.getSystemInstalledTime();
        logger.debug((Object)("install Time: " + sysInstallTime));
        return sysInstallTime;
    }

    public void onBindLicenseUse(ILicenseUseInter service, Map<?, ?> properties) {
        if (service != null) {
            if (!this.useServiceMap.containsKey(service.getType())) {
                this.useServiceMap.put(service.getType(), new ArrayList());
            }
            this.useServiceMap.get(service.getType()).add(service);
        }
        logger.info((Object)("onBindLicenseUse->" + service), 90160758787071L);
    }

    public void onUnbindLicenseUse(ILicenseUseInter service, Map<?, ?> properties) {
        if (service != null && this.useServiceMap.containsKey(service.getType())) {
            this.useServiceMap.get(service.getType()).remove(service);
        }
        logger.info((Object)("onUnbindLicenseUse->" + service), 90160758787071L);
    }

    public LicenseCalcBean calcLicenseConsume(List<String> calcServerList, List<String> resTypeList) {
        logger.info((Object)"into calcLicenseConsume", 90160758787071L);
        LicenseCalcBean licenseCalcBean = new LicenseCalcBean();
        try {
            IManagementServerService msSvc = (IManagementServerService)ServiceLocator.getInstance().getService(IManagementServerService.class);
            ManagementServer localServer = msSvc.getServerInfo();
            if (null == localServer) {
                logger.error((Object)"can not find local info");
                throw new LegoCheckedException(0x200909L);
            }
            if (VerifyUtil.isEmpty(resTypeList) || null == calcServerList || calcServerList.contains(localServer.getUuid())) {
                logger.error((Object)"resTypeList is %s,calcServerList:%s, localServer uuid is %s.", new Object[]{resTypeList, calcServerList, localServer.getUuid()});
                return licenseCalcBean;
            }
            boolean haveCloudLicenseRes = ((ILicenseControl)ServiceLocator.getInstance().getService(ILicenseControl.class)).isHaveCloudLicenseRes();
            for (String resType : resTypeList) {
                int consumeCount = 0;
                List<ILicenseUseInter> serviceList = this.useServiceMap.get(resType);
                if (null == serviceList) continue;
                for (ILicenseUseInter ser : serviceList) {
                    consumeCount += ser.getUseCount();
                }
                if ("LSTQDPMP".equals(resType) && !haveCloudLicenseRes) {
                    consumeCount += this.getCloudConsumeNum();
                }
                licenseCalcBean.getResConsumeMap().put(resType, consumeCount);
            }
            licenseCalcBean.setCalculated(Boolean.valueOf(true));
            ArrayList<String> calcLocalServerList = new ArrayList<String>();
            calcLocalServerList.addAll(calcServerList);
            calcLocalServerList.add(localServer.getUuid());
            licenseCalcBean.setCalculatedSiteIdList(calcLocalServerList);
            List servers = msSvc.getServers();
            for (ManagementServer server : servers) {
                logger.info((Object)"start calc remote site; server type: %s, id: %s", new Object[]{server.getServerType(), server.getUuid()});
                if (0 == server.getServerType() || licenseCalcBean.getCalculatedSiteIdList().contains(server.getUuid())) continue;
                LicenseCalcBean remoteCalcResult = this.getRemoteLicenseConsume(server, licenseCalcBean.getCalculatedSiteIdList(), resTypeList);
                if (remoteCalcResult.getErrorCode() != 0L) {
                    logger.error((Object)"getRemoteLicenseConsume failed.");
                    licenseCalcBean.setErrorCode(-1L);
                    break;
                }
                this.addRemoteToLocal(licenseCalcBean, remoteCalcResult);
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"getRemoteLicenseConsume failed.", (Throwable)e, 90160758787071L);
            licenseCalcBean.setErrorCode(e.getErrorCode());
            licenseCalcBean.setParameters(e.getParameters());
        }
        catch (Exception e) {
            licenseCalcBean.setErrorCode(-1L);
            logger.error((Object)("getRemoteLicenseConsume failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        logger.info((Object)"out calcLicenseConsume", 90160758787071L);
        return licenseCalcBean;
    }

    private int getCloudConsumeNum() {
        int res = 0;
        ArrayList<String> cloudType = new ArrayList<String>();
        cloudType.add("LSTQCSDR");
        cloudType.add("LSTQCSHA");
        cloudType.add("LSTQVHA");
        for (String type : cloudType) {
            List<ILicenseUseInter> iLicenseUseInters = this.useServiceMap.get(type);
            if (VerifyUtil.isEmpty(iLicenseUseInters)) {
                res += 0;
                continue;
            }
            for (ILicenseUseInter iLicenseUseInter : iLicenseUseInters) {
                res += iLicenseUseInter.getUseCount();
            }
        }
        return res;
    }

    private LicenseCalcBean getRemoteLicenseConsume(ManagementServer server, List<String> calcSiteList, List<String> resTypeList) throws UnsupportedEncodingException {
        logger.info((Object)("into getRemoteLicenseConsume serverUuid=" + server.getUuid() + ", name=" + server.getName()), 90160758787071L);
        RestClient client = SiteUtil.initClient(server);
        JSONArray obj = JSONArray.fromObject(calcSiteList);
        JSONArray resTypeJson = JSONArray.fromObject(resTypeList);
        String url = "/ws/license/calculateConsume?calculatedSiteIds=" + URLEncoder.encode(obj.toString(), "utf-8") + "&resTypes=" + URLEncoder.encode(resTypeJson.toString(), "utf-8");
        client.setTimeout(10000);
        String result = client.get(url, null);
        logger.info((Object)("getRemoteLicenseConsume serverUuid=" + server.getUuid() + ", name=" + server.getName() + " result=" + result), 90160758787071L);
        JSONObject jsonObject = JSONObject.fromObject((Object)result);
        LicenseCalcBean bean = this.json2LicenseCalcBean(jsonObject);
        return bean;
    }

    private LicenseCalcBean json2LicenseCalcBean(JSONObject jsonObject) {
        LicenseCalcBean bean = new LicenseCalcBean();
        try {
            bean.setCalculated(Boolean.valueOf(jsonObject.getBoolean("calculated")));
            JSONArray calcSiteArray = jsonObject.getJSONArray("calculatedSiteIdList");
            for (int i = 0; i < calcSiteArray.size(); ++i) {
                bean.getCalculatedSiteIdList().add(calcSiteArray.getString(i));
            }
            JSONObject mapObj = jsonObject.getJSONObject("resConsumeMap");
            if (mapObj == null) {
                logger.error((Object)"can't get json object [resConsumeMap]: jsonObject=%s", new Object[]{jsonObject});
                throw new LegoCheckedException(2117645L);
            }
            Iterator inters = mapObj.keys();
            String mapKey = null;
            while (inters.hasNext()) {
                mapKey = (String)inters.next();
                bean.getResConsumeMap().put(mapKey, mapObj.getInt(mapKey));
            }
        }
        catch (Exception e) {
            logger.error((Object)("json2LicenseCalcBean failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        return bean;
    }

    private void addRemoteToLocal(LicenseCalcBean local, LicenseCalcBean remote) {
        if (remote != null && remote.getCalculated().booleanValue()) {
            this.uniteList(remote.getCalculatedSiteIdList(), local.getCalculatedSiteIdList());
            Map resConsumeMap = remote.getResConsumeMap();
            for (Map.Entry item : resConsumeMap.entrySet()) {
                int count = (Integer)item.getValue();
                if (local.getResConsumeMap().containsKey(item.getKey())) {
                    count += ((Integer)local.getResConsumeMap().get(item.getKey())).intValue();
                }
                local.getResConsumeMap().put(item.getKey(), count);
            }
        }
    }

    private void uniteList(List<String> fromList, List<String> toList) {
        if (null == toList) {
            logger.error((Object)"uniteList toList is null", 90160758787071L);
            return;
        }
        if (null == fromList || fromList.isEmpty()) {
            logger.info((Object)"uniteList fromList is null or empty", 90160758787071L);
            return;
        }
        for (String item : fromList) {
            if (toList.contains(item)) continue;
            toList.add(item);
        }
    }

    public ISiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(ISiteService siteService) {
        this.siteService = siteService;
    }

    public boolean isLicenseProbationTimeout() {
        long sysInstallTime = this.getSysInstallTime();
        long curTime = System.currentTimeMillis();
        boolean expire = curTime - sysInstallTime > 7776000000L;
        logger.debug((Object)("installTime->" + sysInstallTime + "; curTime->" + curTime + "; expire->" + expire), 90160758787071L);
        return expire;
    }

    public boolean isBasicVersion() {
        LicenseInfoBo bo = this.getLicense();
        return null == bo && this.isLicenseProbationTimeout();
    }

    public void setNodeAgentAccessClient(NodeAgentLocalService.Iface nodeAgentAccessClient) {
        this.nodeAgentAccessClient = nodeAgentAccessClient;
    }
}

