/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.action;

import com.huawei.ism.drm.backup.BackupManagerProxy;
import com.huawei.ism.drm.backup.IBackupManager;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractSnapshotsPropareAction;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.storage.sdk.model.BackupPlan;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Map;

public abstract class AbstractBackupAction
extends AbstractSnapshotsPropareAction {
    private static final Log logger = LogFactory.getInstance(AbstractBackupAction.class);

    @Override
    public boolean doExecute(ActionContext context) {
        try {
            ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
            logger.info((Object)("BaseSnapshotAction begin to execute,pgId:" + protectGroup.getUuid()), 90160758786988L);
            ProtectGroupReplica oldPgReplica = this.getToActiveReplicas(context);
            if (null != oldPgReplica) {
                context.addObject("PROTECTGROUP_REPLICA_TO_DELETE", (Object)oldPgReplica);
            }
            this.backup(context);
        }
        catch (LegoCheckedException e) {
            this.setDetail(e.getErrorMessageKey());
            this.setDetailParams(this.constructParams(e.getParameters()));
            return false;
        }
        return true;
    }

    protected boolean backup(ActionContext context) {
        IBackupManager manager = BackupManagerProxy.getInstance().getBackupService(this.getBackupEngine());
        if (null == manager) {
            logger.error((Object)"can not get IBackupManager.");
            throw new LegoCheckedException(1073947394L);
        }
        BackupPlan plan = this.getBackupPlan(context);
        Map<String, String> paraMap = this.getParameterMap(context);
        String requestID = manager.run(plan, paraMap);
        context.addObject("BACKUP_REQUEST_ID", (Object)requestID);
        return true;
    }

    protected BackupPlan getBackupPlan(ActionContext context) {
        return null;
    }

    protected Map<String, String> getParameterMap(ActionContext context) {
        return null;
    }

    protected String getBackupEngine() {
        return null;
    }

    protected Integer getBackupMode(ActionContext context) {
        Map parameter = (Map)context.getObject("EXCUTE_PARAMETER_MAP");
        boolean fullBackup = ProtectionJobUtil.getInstance().isFullBackup(parameter);
        if (fullBackup) {
            return BackupPlan.BACKUPMODE.FULL_BACKUP.getValue();
        }
        return BackupPlan.BACKUPMODE.INCREMENT_BACKUP.getValue();
    }
}

