/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.action;

import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.action.service.IProtectExecutionPreprocessor;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectExecutionPreprocessorManager;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.framework.service.replica.realtime.service.ExecuteReplicaManager;
import com.huawei.ism.drm.protection.framework.template.util.ProtectionRelationJsonConverter;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectionRelation;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BasePrepareAction
extends AbstractBaseProtectAction {
    private static final Log logger = LogFactory.getInstance(BasePrepareAction.class);

    @Override
    public boolean doExecute(ActionContext context) {
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        logger.info((Object)("BasePrepareAction begin to execute,pgId:" + protectGroup.getUuid()), 90160758786988L);
        return this.prepare(context);
    }

    protected boolean prepare(ActionContext context) {
        ProtectGroup pg = (ProtectGroup)context.getObject("PG_ENTITY");
        logger.info((Object)("BasePrepareAction begin to execute:" + pg.getName()), 90160758786988L);
        if (DrmEnumDefine.PROTECT_GROUP_STATUS.RUNNING.getStatus() != pg.getStatus()) {
            logger.error((Object)"pg'status is not Running.", 90160758786989L);
            this.setDetail("lego.err.1073948458");
            return false;
        }
        if (this.checkAndSet(context, pg)) {
            return false;
        }
        try {
            this.preprocess(context);
        }
        catch (LegoCheckedException e) {
            this.setDetail(e.getErrorMessageKey());
            this.setDetailParams(this.constructParams(e.getParameters()));
            return false;
        }
        return true;
    }

    private boolean checkAndSet(ActionContext context, ProtectGroup pg) {
        try {
            if (!this.checkHyperVault(pg, context)) {
                logger.error((Object)"vstore pair not normal and the local vault is not the hyper ACTIVE ", 90160758786989L);
                this.setDetail("lego.err.1073948223");
                return true;
            }
            HashSet pos = new HashSet();
            pos.addAll(pg.getPolist());
            ProtectGroupReplica pgReplica = this.getWillOperateReplica(pg, context);
            context.addObject("PG_REPLICA_ENTITY", (Object)pgReplica);
            if (!VerifyUtil.isEmpty((Object)pgReplica)) {
                HashSet poReplicas = new HashSet();
                poReplicas.addAll(pgReplica.getReplicas());
                context.addObject("PO_REPLICA_ENTITY", poReplicas);
            }
            context.addObject("PO_ENTITY", pos);
            logger.info((Object)("BasePrepareAction end to execute:" + pg.getName()), 90160758786988L);
            ProtectionJobUtil.getInstance().checkHyperMetro(pg, context);
        }
        catch (LegoCheckedException e) {
            this.setDetail(e.getErrorMessageKey());
            this.setDetailParams(this.constructParams(e.getParameters()));
            return true;
        }
        return false;
    }

    private boolean checkHyperVault(ProtectGroup protectGroup, ActionContext context) {
        PolicyTemplate template = protectGroup.getTemplate();
        if (VerifyUtil.isEmpty((Object)template)) {
            logger.info((Object)("checkHyperVault empty:" + protectGroup.getUuid()));
            return true;
        }
        if (template.getType() == 28) {
            Integer activeOrPassive;
            String prStr = (String)template.getProps().get("protectionRelation");
            if (VerifyUtil.isEmpty((String)prStr)) {
                logger.error((Object)("checkHyperVault protectionRelation is null:" + protectGroup.getUuid()));
                return false;
            }
            List<ProtectionRelation> protectionRelations = ProtectionRelationJsonConverter.toProtectionRelationList(prStr);
            if (VerifyUtil.isEmpty(protectionRelations)) {
                logger.error((Object)("checkHyperVault protectionRelations is empty:" + prStr));
                return false;
            }
            context.addObject("VAULT_PATH", protectionRelations);
            ProtectionRelation protectionRelation = (ProtectionRelation)CommonUtil.getFirstElement(protectionRelations);
            String devSn = protectionRelation.getSrcResourceProviderSn();
            String vStorePairId = (String)protectGroup.getProps().get("PROP_KEY_VSTORE_PAIR_ID");
            if (VerifyUtil.isEmpty((String)vStorePairId) || VerifyUtil.isEmpty((String)devSn)) {
                logger.error((Object)("checkHyperVault vStorePairId or devSn is null:" + protectGroup.getUuid()));
                return false;
            }
            IStorageResourceService srSvc = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
            VstoreHyperMetroPair vstoreHyperMetroPair = srSvc.getVstoreHyperMetroPairById(devSn, vStorePairId, Boolean.valueOf(false));
            if (!VerifyUtil.isEmpty((Object)vstoreHyperMetroPair) && String.valueOf(XveEuumDefineParent.HEALTH_STATUS_E.NORMAL.getValue()).equals(vstoreHyperMetroPair.getHealthStatus())) {
                return true;
            }
            String active = vstoreHyperMetroPair.getActiveOrPassive();
            if (VerifyUtil.isEmpty((String)active)) {
                active = srSvc.getHyperMetroDomainById(vstoreHyperMetroPair.getDomainId(), false).getServiceStatus();
            }
            if ((activeOrPassive = NumberUtil.convertToInteger((Object)active)).equals(XveEuumDefineParent.VSTOREPAIR_ACTIVATION_STATUS_E.PASSIVE.getValue())) {
                logger.info((Object)("This devSn VstorePair is not activeOrPassive:" + devSn + " ,pairId:" + vStorePairId));
                return false;
            }
        }
        return true;
    }

    private ProtectGroupReplica getWillOperateReplica(ProtectGroup pg, ActionContext context) {
        if (null == context.getObject("PG_EXECUTE_LOCATION")) {
            return null;
        }
        return ExecuteReplicaManager.getInstance().calculateExecuteReplica(pg, NumberUtil.convertToInteger((Object)context.getObject("PG_EXECUTE_LOCATION")));
    }

    private void preprocess(ActionContext context) {
        ProtectExecutionPreprocessorManager procMgr = ProtectExecutionPreprocessorManager.getInstance();
        Collection<IProtectExecutionPreprocessor> processors = procMgr.getProtectExecutionPreprocessors();
        for (IProtectExecutionPreprocessor processor : processors) {
            Map preProcResult = processor.process(context);
            if (VerifyUtil.isEmpty((Map)preProcResult)) continue;
            Set entrySet = preProcResult.entrySet();
            for (Map.Entry entry : entrySet) {
                context.addObject((String)entry.getKey(), entry.getValue());
            }
        }
    }
}

