/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.action;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.job.airgapjob.AirGapLinkProcessor;
import com.huawei.ism.drm.base.util.AirGapLinkPortUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.storage.sdk.model.EnablePortTask;
import com.huawei.ism.drm.storage.sdk.model.StorageLinkPort;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class StartDisableAirGapPortAction
extends AbstractBaseProtectAction {
    private static final Log logger = LogFactory.getInstance(StartDisableAirGapPortAction.class);
    private static final String DISABLE_PORTS_DESCRIPTION = "com.huawei.ism.drm.protection.framework.engine.action.StartDisableAirGapPortAction.Description";

    @Override
    public boolean doExecute(ActionContext context) {
        logger.info((Object)"DisableAirGapPortAction begin to execute.");
        try {
            this.checkAndSetDisableTime(context);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Disable port exception.", (Throwable)e);
            if (context.isShouldTerminate()) {
                this.setDetail("lego.err.1073948470");
            } else {
                this.setDetail(e.getErrorMessageKey());
                this.setDetailParams(this.constructParams(e.getParameters()));
            }
            return false;
        }
        ProtectGroup pg = (ProtectGroup)context.getObject("PG_ENTITY");
        List<StorageLinkPort> linkPorts = AirGapLinkPortUtil.getAirGapPortList(pg);
        Set<String> portNames = linkPorts.stream().map(StorageLinkPort::getPortName).collect(Collectors.toSet());
        this.setDetail(DISABLE_PORTS_DESCRIPTION);
        this.setDetailParams(AirGapLinkPortUtil.getPortNames(portNames));
        return true;
    }

    private void checkAndSetDisableTime(ActionContext context) {
        ProtectGroup pg = (ProtectGroup)context.getObject("PG_ENTITY");
        if (!PolicyTemplateType.AIR_GAP_NETWORKING.contains(pg.getTemplate().getType())) {
            return;
        }
        Map map = pg.getProps();
        if (!map.containsKey("isAirGapType")) {
            logger.error((Object)"Not find need data of pgName: %s", new Object[]{pg.getName()});
            throw new LegoCheckedException(1073947394L);
        }
        List<StorageLinkPort> linkPorts = AirGapLinkPortUtil.getAirGapPortList(pg);
        List portIds = linkPorts.stream().map(StorageLinkPort::getPortId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(portIds)) {
            logger.error((Object)"Not find link portIds. error!");
            throw new LegoCheckedException(1073947394L);
        }
        AirGapLinkProcessor linkProcessor = AirGapLinkProcessor.getInstance();
        Integer executionMode = (Integer)context.getObject("PG_EXECUTION_MODE", Integer.class);
        EnablePortTask task = (EnablePortTask)context.getObject("linkPortTaskInfo", EnablePortTask.class);
        for (StorageLinkPort linkPort : linkPorts) {
            logger.info((Object)"Update PortName: %s disable time", new Object[]{linkPort.getPortName()});
            StorageLinkPort portInDb = this.getPortInDb(linkPort);
            DrmEnumDefine.ExecTypeEnum execTypeEnum = AirGapLinkPortUtil.getExecTypeEnum(pg, executionMode);
            portInDb.setExecTypeEnum(execTypeEnum);
            portInDb.setTaskId(task.getTaskId());
            portInDb.setOperator(pg.getName());
            portInDb.setPgWorkPorts(portIds);
            portInDb.setOperateType(1);
            linkProcessor.updateDisableTimeMap(portInDb);
        }
        AirGapLinkPortUtil.updateTimeWindowWithPg(pg, false);
    }

    private StorageLinkPort getPortInDb(StorageLinkPort linkPort) {
        return (StorageLinkPort)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(StorageLinkPort.class, (Serializable)((Object)linkPort.getPortId()));
    }
}

