/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.executor;

import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.framework.engine.executor.ProtectionExecutor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLog;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLogDetail;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class ProtectionCascadeExecutor
extends ProtectionExecutor {
    private static final Log logger = LogFactory.getInstance(ProtectionCascadeExecutor.class);
    private List<AbstractBaseProtectAction> protectActions = new ArrayList<AbstractBaseProtectAction>();
    private boolean executeResult;
    private ActionContext actionContext;
    private ProtectGroupLogDetail parentDetailLog;

    private ProtectionCascadeExecutor() {
    }

    public static ProtectionCascadeExecutor createExecutor(List<AbstractBaseProtectAction> protectAction, String pgId, String actionIdParam) {
        ProtectionCascadeExecutor executor = new ProtectionCascadeExecutor();
        executor.protectActions.addAll(protectAction);
        executor.parentDetailLog = ProtectionCascadeExecutor.getLogmanager().getActionLogDetail(pgId, actionIdParam);
        return executor;
    }

    @Override
    public boolean execute(ActionContext context) {
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        ProtectionCascadeExecutor.getActionmanager().initActions(this.protectActions, protectGroup, context, 0);
        ProtectionCascadeExecutor.getLogmanager().initRunningChildDetail(((ProtectGroupLog)context.getObject("PG_LOG_ENTITY")).getHistoryLogId(), this.parentDetailLog, this.protectActions, false);
        this.actionContext = context;
        this.executeResult = false;
        for (AbstractBaseProtectAction action : this.protectActions) {
            if (!action.isEnable()) continue;
            try {
                this.executeResult = this.executeAction(action);
            }
            catch (Exception e) {
                logger.error((Object)("Execute action error!" + ExceptionUtil.getErrorMessage((Throwable)e)), -1L);
            }
            if (this.executeResult) continue;
            this.callbackAction(action);
            break;
        }
        return this.executeResult;
    }

    private boolean executeAction(AbstractBaseProtectAction action) {
        ProtectGroupLogDetail detail = this.getSpecificChildDetail(this.parentDetailLog, action.getActionId());
        if (null == detail) {
            logger.error((Object)("ProtectGroupLogDetail empty error! :" + action.getActionId()), -1L);
            return false;
        }
        Date currentDate = new Date();
        detail.setStartTime(String.valueOf(currentDate.getTime()));
        detail.setResult(2L);
        ProtectionCascadeExecutor.getLogmanager().saveOrUpdateProtectGroupLogDetail(detail);
        this.executeResult = false;
        try {
            this.executeResult = action.execute(this.actionContext);
        }
        catch (Throwable e) {
            logger.error((Object)("action execute error ,action " + action.getClass().getName() + ExceptionUtil.getErrorMessage((Throwable)e)), 0x300001L);
            this.executeResult = false;
        }
        try {
            action.postExcute(this.actionContext);
        }
        catch (Exception e) {
            logger.error((Object)("action post execute error ,action " + action.getClass().getName() + ExceptionUtil.getErrorMessage((Throwable)e)), 0x300001L);
        }
        currentDate = new Date();
        detail.setEndTime(String.valueOf(currentDate.getTime()));
        detail.setInfo(action.getDetail());
        detail.setInfoParams(action.getDetailParams());
        detail.setResult(this.executeResult ? 1L : 0L);
        ProtectionCascadeExecutor.getLogmanager().saveOrUpdateProtectGroupLogDetail(detail);
        return this.executeResult;
    }

    private void callbackAction(AbstractBaseProtectAction action) {
        try {
            action.callBack(this.actionContext);
        }
        catch (Exception e) {
            logger.error((Object)("post Execute error!" + ExceptionUtil.getErrorMessage((Throwable)e)), -1L);
        }
    }
}

