/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.job;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.lego.cbb.resource.util.DaoFactory;
import com.huawei.lego.cbb.resource.util.DaoParamUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;

public class DataBaseClearJob
implements StatefulJob {
    private static final Log LOGGER = LogFactory.getInstance(DataBaseClearJob.class);
    private static final Integer LOG_RESERVED_NUMBER = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        Session session = null;
        try {
            String queryPgSql = "select uuid from ti_protectgroup";
            List pgIdList = CommonDAOLocator.getBaseDao().executeNativeSql(queryPgSql, new Object[0]);
            if (VerifyUtil.isEmpty((Collection)pgIdList)) {
                return;
            }
            String sql = "delete from ti_protectgrouplog where pgid=:pgid and STARTTIME < :logBeginTime";
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            session.beginTransaction();
            for (String pgId : pgIdList) {
                Number logNum;
                int logNumInt;
                String pgLogCountSql = "select count(*) from ProtectGroupLog log where log.pgId=?";
                Map params = DaoParamUtil.hqlParams((String[])new String[]{pgId});
                List logNumList = DaoFactory.getInstance().getResourceDao().findByHql(pgLogCountSql, params);
                if (VerifyUtil.isEmpty((Collection)logNumList) || (logNumInt = (logNum = (Number)logNumList.get(0)).intValue()) <= LOG_RESERVED_NUMBER) continue;
                String pgLog1000StartTimeSql = "select log.startTime from ProtectGroupLog log where log.pgId=? order by log.startTime desc limit 1 offset " + (LOG_RESERVED_NUMBER - 1);
                Map pgLogParams = DaoParamUtil.hqlParams((String[])new String[]{pgId});
                List startTimeList = DaoFactory.getInstance().getResourceDao().findByHql(pgLog1000StartTimeSql, pgLogParams);
                if (VerifyUtil.isEmpty((Collection)startTimeList)) continue;
                NativeQuery deleteLogQuery = session.createSQLQuery(sql);
                deleteLogQuery.setString("pgid", pgId).setString("logBeginTime", (String)startTimeList.get(0));
                int result = deleteLogQuery.executeUpdate();
                LOGGER.info((Object)("Delete ti_protectgrouplog jod success! effect number line:" + result + ",pgid:" + pgId));
            }
            session.getTransaction().commit();
            DBOperationUtil.closeSession(session);
        }
        catch (Exception e) {
            DBOperationUtil.rollbackSession(session);
            LOGGER.error((Object)("Delete ti_protectgrouplog jod failed!" + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
    }
}

