/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.util;

import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefine;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.AirGapLinkPortUtil;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.bean.AlarmParameter;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLogDetail;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleRangeTime;
import com.huawei.ism.drm.protection.task.sdk.model.ProtectionTask;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectionRelation;
import com.huawei.ism.drm.protection.template.sdk.model.SiteInfo;
import com.huawei.ism.drm.recovery.framework.util.RecoveryTaskUtil;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.sdk.model.ResourceTimeWindowRange;
import com.huawei.ism.drm.storage.sdk.model.StorageLinkPort;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.task.sdk.model.ISchedule;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.triggers.AbstractTrigger;

public final class ProtectionJobUtil {
    public static final String PROTECTION_QUARTZ_TRIGGER_LISTENER = "ProtectionQuartzTriggerListener";
    public static final String PROTECTION_HYPERVAULTID = "HyperVaultId";
    public static final String PROTECTION_HYPERVAULT_SRCDEVICESN = "HyperVaultSrcArrayDeviceSn";
    public static final String PROTECTION_HYPERVAULT_JOBID = "HyperVaultJobId";
    private static Log logger = LogFactory.getInstance(ProtectionJobUtil.class);
    private static final List<Integer> ASYN_REPLICATION_TEMPLATE_TYPES = Arrays.asList(1, 3, 4, 5, 6, 17, 18, 20, 22, 28, 30, 31, 32, 33, 35, 36, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47);
    private static final List<Integer> CHECK_HYPERMETRO_MASTER_LUN = Arrays.asList(19, 18, 28, 31, 26);
    private static final long MAX_TIME_OUT = LegoConfig.getInstance().getNumber("array.sync.monitor.timeout", 43200L) * 1000L;
    private static Set<String> moKeySet = new HashSet<String>();
    private static ProtectionJobUtil jobUtil = new ProtectionJobUtil();

    private ProtectionJobUtil() {
    }

    public static ProtectionJobUtil getInstance() {
        return jobUtil;
    }

    public synchronized boolean getLockPg(String pgId) {
        if (moKeySet.contains(pgId)) {
            logger.debug((Object)("get lock failed!,pgId:" + pgId), 90160758784001L);
            return false;
        }
        logger.info((Object)("get lock success!,pgId:" + pgId), 90160758784000L);
        moKeySet.add(pgId);
        return true;
    }

    public boolean isPgLocked(String pgId) {
        return moKeySet.contains(pgId);
    }

    public boolean getLockPg(String pgId, long time, String flagName) {
        boolean lockFlag = false;
        long startTime = System.currentTimeMillis();
        logger.info((Object)("begin to try get lock.  flagName " + flagName), 90160758784001L);
        while (!lockFlag) {
            long curTime = System.currentTimeMillis();
            if (time <= curTime - startTime) {
                logger.error((Object)("get lock with protectgroup time out. " + pgId + " flagName " + flagName), 90160758784001L);
                return lockFlag;
            }
            CommUtil.pauseThread((long)1000L);
            lockFlag = this.getLockPg(pgId);
        }
        return lockFlag;
    }

    public boolean getLockPg(String pgId, long time) {
        return this.getLockPg(pgId, time, "");
    }

    public synchronized void releaseLockPg(String pgId) {
        if (moKeySet.contains(pgId)) {
            logger.info((Object)("release lock success!,pgId:" + pgId), 90160758784000L);
            moKeySet.remove(pgId);
        }
    }

    public void genetateAlarm(AlarmParameter param) {
        logger.debug((Object)("genetateAlarm " + param.getGroupName()));
        AlarmReporter.generatePolicyUnknowErrorAlarm(param.getPgId(), param.getGroupName());
    }

    public String getSiteName(String siteId) {
        String result = "";
        if (VerifyUtil.isEmpty((String)siteId)) {
            return result;
        }
        try {
            Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(siteId);
            if (null != site) {
                result = site.getName();
            }
        }
        catch (Exception e) {
            logger.error((Object)("get Sitename error:" + siteId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
        return result;
    }

    public String getResourceName(String arraySN) {
        String result = "";
        if (VerifyUtil.isEmpty((String)arraySN)) {
            return result;
        }
        try {
            DrResource resource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(arraySN);
            if (null != resource) {
                result = resource.getName();
            }
        }
        catch (Exception e) {
            logger.error((Object)("get arrayname error:" + arraySN + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
        return result;
    }

    public IProtectGroupService getProtectGroupService() {
        IProtectGroupService protectGroupService = null;
        for (int i = 0; i < 100; ++i) {
            try {
                IProtectGroupService pgService;
                protectGroupService = pgService = (IProtectGroupService)ServiceContext.getInstance().lookup("DRM_Base/com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService");
                break;
            }
            catch (Exception e) {
                logger.error((Object)("get protection group service failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                continue;
            }
        }
        return protectGroupService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void updateProtectGroupStartStatus(ProtectGroup pg) {
        Session session;
        block7: {
            if (VerifyUtil.isEmpty((String)pg.getUuid())) {
                logger.debug((Object)"pd ID is empty,not update ProtectGroup startStatus");
                return;
            }
            session = null;
            try {
                session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                String sql = "UPDATE ti_protectgroup SET STATUS=:status, LASTEXECTIME=:lastExecTime WHERE PGID=:pgid";
                session.beginTransaction();
                long lastExecTime = pg.getLastExecTime() == null ? new Date().getTime() : pg.getLastExecTime().longValue();
                NativeQuery query = session.createSQLQuery(sql);
                query.setParameter("status", (Object)pg.getStatus());
                query.setParameter("lastExecTime", (Object)lastExecTime);
                query.setParameter("pgid", (Object)pg.getUuid());
                int updateResult = query.executeUpdate();
                session.getTransaction().commit();
                if (1 == updateResult) break block7;
                logger.error((Object)"updatePrtectGroupStartStatus failed!", 90160758786989L);
                throw new LegoCheckedException(-1L);
            }
            catch (LegoCheckedException e) {
                DBOperationUtil.rollbackSession(session);
                ExceptionUtil.rethrowException((Throwable)e, (String)"Update protectGroup basic info failed!", (long)e.getErrorCode(), (String[])e.getParameters(), (Log)logger);
                DBOperationUtil.closeSession(session);
            }
            catch (Exception ex) {
                DBOperationUtil.rollbackSession(session);
                ExceptionUtil.rethrowException((Throwable)ex, (String)"updateProtectGroupEndStatus failed!", (long)-1L, (String[])new String[0], (Log)logger);
                {
                    catch (Throwable throwable) {
                        DBOperationUtil.closeSession(session);
                        throw throwable;
                    }
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void updateProtectGroupEndStatus(ProtectGroup pg) {
        Session session;
        block7: {
            if (VerifyUtil.isEmpty((String)pg.getUuid())) {
                logger.debug((Object)"pd ID is empty,not update ProtectGroup EndStatus");
                return;
            }
            session = null;
            try {
                session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                String sql = "UPDATE ti_protectgroup SET STATUS=:status, PG_REPLICA_INDEX=:index, LASTEXECTIME=:lastExecTime, LAST_EXEC_RESULT=:lastExecResult, LAST_EXEC_ERROR_RESULT=:lastExecErrorDetail, LAST_EXEC_PARAM=:lastExecParam where PGID=:pgid";
                session.beginTransaction();
                NativeQuery query = session.createSQLQuery(sql);
                query.setParameter("status", (Object)pg.getStatus());
                query.setParameter("index", (Object)pg.getPgReplicaIndex());
                query.setParameter("lastExecTime", (Object)pg.getLastExecTime());
                query.setParameter("lastExecResult", (Object)pg.getLastExecResult());
                query.setParameter("lastExecErrorDetail", (Object)pg.getLastExecErrorDetail());
                query.setParameter("lastExecParam", (Object)pg.getLastExecParam());
                query.setParameter("pgid", (Object)pg.getUuid());
                int updateResult = query.executeUpdate();
                session.getTransaction().commit();
                if (1 == updateResult) break block7;
                logger.error((Object)"updateProtectGroupEndStatus failed!", 90160758786989L);
                throw new LegoCheckedException(-1L);
            }
            catch (LegoCheckedException e) {
                DBOperationUtil.rollbackSession(session);
                ExceptionUtil.rethrowException((Throwable)e, (String)"Update protectGroup basic info failed!", (long)e.getErrorCode(), (String[])e.getParameters(), (Log)logger);
                DBOperationUtil.closeSession(session);
            }
            catch (Exception ex) {
                DBOperationUtil.rollbackSession(session);
                ExceptionUtil.rethrowException((Throwable)ex, (String)"updateProtectGroupEndStatus failed!", (long)-1L, (String[])new String[0], (Log)logger);
                {
                    catch (Throwable throwable) {
                        DBOperationUtil.closeSession(session);
                        throw throwable;
                    }
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
    }

    public void updatePrtectGroupReplicaStatus(ProtectGroupReplica pgReplica) {
        if (VerifyUtil.isEmpty((Object)pgReplica)) {
            return;
        }
        ProtectGroupReplica replica = (ProtectGroupReplica)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ProtectGroupReplica.class, (Serializable)((Object)pgReplica.getId()));
        if (null != replica) {
            replica.setStatus(pgReplica.getStatus());
            replica.setTimeStamp(pgReplica.getTimeStamp());
            ((IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class)).updateProtectGroupReplica(replica);
            return;
        }
        logger.error((Object)("replica is not existed! pgReplicaId:" + pgReplica.getId()));
    }

    public boolean isTimeAvailable(ProtectionTask task) {
        if (VerifyUtil.isEmpty((Object)task)) {
            return false;
        }
        if (null != task.getNextExecTime() && new Date(NumberUtil.convertToLong((Object)task.getNextExecTime())).after(new Date())) {
            logger.debug((Object)("no need to execute, next exec time=" + task.getNextExecTime()), 90160758784001L);
            return false;
        }
        return true;
    }

    public boolean checkAirGapTimeRange(ProtectGroup protectGroup, Date execStartTime) {
        List<ResourceTimeWindowRange> rangeList = ProtectionJobUtil.getTimeRangesByPg(protectGroup);
        if (CollectionUtils.isEmpty(rangeList)) {
            logger.info((Object)"No time window can exec. pgName: %s", new Object[]{protectGroup.getName()});
            return true;
        }
        long execTime = execStartTime.getTime();
        Optional<ResourceTimeWindowRange> rangeOpt = ProtectionJobUtil.findSpecificTimeWindow(rangeList, execTime);
        logger.info((Object)"ExecTime: %s check time range result: %s", new Object[]{execTime, rangeOpt.isPresent()});
        return rangeOpt.isPresent();
    }

    public static List<ResourceTimeWindowRange> getTimeRangesByPg(ProtectGroup protectGroup) {
        if (!protectGroup.isAirGapType()) {
            logger.info((Object)"The site of the protectGroup{name:%s} is not a Air Gap resource.", new Object[]{protectGroup.getName()});
            return Collections.emptyList();
        }
        List<StorageLinkPort> linkPorts = AirGapLinkPortUtil.getAirGapPortList(protectGroup);
        Optional opt = linkPorts.stream().findAny();
        if (!opt.isPresent()) {
            logger.error((Object)"Not find StorageLinkPort by pgName: %s", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073947394L);
        }
        List<String> portIds = linkPorts.stream().map(StorageLinkPort::getPortId).collect(Collectors.toList());
        AirGapLinkPortUtil linkPortUtil = AirGapLinkPortUtil.getInstance();
        List<ResourceTimeWindowRange> rangeList = linkPortUtil.getTimeRangesByPgPortIds(portIds, ((StorageLinkPort)opt.get()).getDevSn());
        logger.info((Object)"Get Air Gap time window: %s", new Object[]{rangeList.toString()});
        return rangeList;
    }

    public static Optional<ResourceTimeWindowRange> findSpecificTimeWindow(List<ResourceTimeWindowRange> timeWindowRanges, long timeMills) {
        return timeWindowRanges.stream().filter(range -> timeMills >= range.getStartTime().getTime() && timeMills <= range.getEndTime().getTime()).findAny();
    }

    public boolean isTimeInRange(ISchedule schedule, Date execStartTime) {
        Set scheduleRanges = schedule.getScheduleRanges();
        if (VerifyUtil.isEmpty((Collection)scheduleRanges)) {
            logger.debug((Object)"schedule Ranges not set.");
            return true;
        }
        for (ScheduleRangeTime us : scheduleRanges) {
            logger.debug((Object)("Schedule Range check: now time:" + Calendar.getInstance().getTime() + " undoStartTime:" + us.getStartTime() + " undoEndTime:" + us.getEndTime()), 90160758784001L);
            if (!this.isInRangeTime(us, execStartTime)) continue;
            logger.debug((Object)"Schedule Range check is in range.", 90160758784001L);
            return true;
        }
        logger.warn((Object)("Schedule Range check has not in range. scheduleId:" + schedule.getScheduleId()), 90160758784001L);
        return false;
    }

    private boolean isInRangeTime(ScheduleRangeTime us, Date execStartTime) {
        Calendar c = Calendar.getInstance();
        Calendar tempNow = Calendar.getInstance();
        Calendar tempDatebase = Calendar.getInstance();
        tempNow.setTime(execStartTime);
        c.set(6, tempNow.get(6));
        c.set(11, tempNow.get(11));
        c.set(12, tempNow.get(12));
        c.set(13, 0);
        Date now = c.getTime();
        tempDatebase.setTime(us.getStartTime());
        c.set(6, tempNow.get(6));
        c.set(11, tempDatebase.get(11));
        c.set(12, tempDatebase.get(12));
        c.set(13, 0);
        Date start = c.getTime();
        tempDatebase.setTime(us.getEndTime());
        if (tempDatebase.get(12) == 59) {
            c.set(6, tempNow.get(6) + 1);
            c.set(11, 0);
            c.set(12, 0);
        } else {
            c.set(6, tempNow.get(6));
            c.set(11, tempDatebase.get(11));
            c.set(12, tempDatebase.get(12));
        }
        c.set(13, 0);
        Date end = c.getTime();
        return now.after(start) && now.before(end) || now.equals(start) || now.equals(end);
    }

    public boolean isStatusAvailable(ProtectGroup pg) {
        int status = pg.getStatus();
        return DrmEnumDefine.PROTECT_GROUP_STATUS.NORMAL.getStatus() == status || DrmEnumDefine.PROTECT_GROUP_STATUS.RUNNING.getStatus() == status;
    }

    public ProtectGroupLogDetail createActionLog(String detailId, String stepTitle, Date startTime) {
        ProtectGroupLogDetail historyDetailLog = new ProtectGroupLogDetail();
        if (VerifyUtil.isEmpty((String)detailId)) {
            historyDetailLog.setDetailId(UUIDGenerator.getUUID());
        } else {
            historyDetailLog.setDetailId(detailId);
        }
        historyDetailLog.setTitle(stepTitle);
        historyDetailLog.setStartTime(String.valueOf(startTime.getTime()));
        historyDetailLog.setInfo("--");
        historyDetailLog.setProtectionLogDetails(new HashSet());
        return historyDetailLog;
    }

    public void checkIsNeedLock(String pgId) {
        boolean lockFlag = false;
        long startTime = System.currentTimeMillis();
        logger.info((Object)"begin to try get lock. ", 90160758784001L);
        while (!lockFlag) {
            long curTime = System.currentTimeMillis();
            if (MAX_TIME_OUT <= curTime - startTime) {
                logger.error((Object)"get lock with protectgroup time out. ", 90160758784001L);
                throw new LegoCheckedException(1073947433L);
            }
            CommUtil.pauseThread((long)1000L);
            lockFlag = this.getLockPg(pgId);
        }
    }

    public AlarmParameter createAlarm(ActionContext actionContext, ProtectGroup pg) {
        AlarmParameter alarmParam = new AlarmParameter();
        alarmParam.setPgId(pg.getUuid());
        alarmParam.setProtectSiteId(pg.getProductSiteId());
        alarmParam.setGroupName(pg.getName());
        logger.debug((Object)("createAlarm" + pg.getName()));
        return alarmParam;
    }

    public boolean getFreezeFlag(String freezeFlag) {
        int flag = 1;
        if (VerifyUtil.isEmpty((String)freezeFlag)) {
            logger.error((Object)"freezeFlag for  protectGroup is null.", 1073947393L);
        } else {
            try {
                flag = Integer.parseInt(freezeFlag);
            }
            catch (Exception e) {
                logger.error((Object)"freezeFlag for  protectGroup is null.", 1073947393L);
            }
        }
        return flag != 0;
    }

    public static boolean checkWhetherTerminateTask(ActionContext context) {
        if (context.isShouldTerminate()) {
            logger.debug((Object)"Another thread wants to terminate the task!");
            return true;
        }
        Object pgObj = context.getObject("PG_ENTITY");
        Object pgReplicaObj = context.getObject("PG_REPLICA_ENTITY");
        if (!(pgObj instanceof ProtectGroup)) {
            logger.error((Object)"Protect group from context is null!");
            return false;
        }
        if (!(pgReplicaObj instanceof ProtectGroupReplica)) {
            logger.error((Object)"ProtectGroupReplica from context is null!");
            return false;
        }
        ProtectGroup protectGroup = (ProtectGroup)pgObj;
        ProtectGroupReplica pgReplica = (ProtectGroupReplica)pgReplicaObj;
        PolicyTemplate template = protectGroup.getTemplate();
        if (!ASYN_REPLICATION_TEMPLATE_TYPES.contains(template.getType())) {
            logger.debug((Object)"The template type: [%s] is not allowed to teminate task!", new Object[]{template.getType() + ""});
            return false;
        }
        Schedule autoSchedule = ProtectionJobUtil.getAutoScheduleByProtectlocation(pgReplica, template);
        if (autoSchedule == null) {
            logger.debug((Object)"The autoSchedule is null, so will not to teminate task!");
            return false;
        }
        String abortTaskTime = autoSchedule.getAbortTaskTime();
        if (VerifyUtil.isEmpty((String)abortTaskTime) || autoSchedule.getPeriodType() != 2) {
            logger.debug((Object)"The abortTaskTime[%s] is null, or periodType[%s] is not the day type!, so will not to terminate task!", new Object[]{abortTaskTime, autoSchedule.getPeriodType()});
            return false;
        }
        String hours = autoSchedule.getHours();
        if (VerifyUtil.isEmpty((String)hours)) {
            logger.error((Object)"Hours is null, so will not to terminate task!");
            return false;
        }
        String[] hourArray = hours.split(",");
        if (hourArray.length != 1) {
            logger.debug((Object)"Hours[%s] size is not one, so will not to teminate task!", new Object[]{hours});
            return false;
        }
        return ProtectionJobUtil.checkIsBeyongTheAbortTime(autoSchedule, abortTaskTime);
    }

    private static boolean checkIsBeyongTheAbortTime(Schedule autoSchedule, String abortTaskTime) {
        String[] hourMinute = abortTaskTime.split(":");
        if (hourMinute.length != 2) {
            logger.error((Object)("abortTaskTime is not legal! abortTaskTime :" + abortTaskTime), 90160758784001L);
            return false;
        }
        String abortHour = hourMinute[0];
        String abortMinute = hourMinute[1];
        Calendar nowCalendar = Calendar.getInstance();
        Calendar startTimeCalendar = Calendar.getInstance();
        Calendar abortTaskTimeCalendar = Calendar.getInstance();
        Date now = new Date();
        nowCalendar.setTime(now);
        String hours = autoSchedule.getHours();
        String minutes = autoSchedule.getMinutes();
        startTimeCalendar.set(6, nowCalendar.get(6));
        startTimeCalendar.set(11, CommUtil.convertToInteger((Object)hours));
        startTimeCalendar.set(12, CommUtil.convertToInteger((Object)minutes));
        startTimeCalendar.set(13, 0);
        abortTaskTimeCalendar.set(6, nowCalendar.get(6));
        abortTaskTimeCalendar.set(11, CommUtil.convertToInteger((Object)abortHour));
        abortTaskTimeCalendar.set(12, CommUtil.convertToInteger((Object)abortMinute));
        abortTaskTimeCalendar.set(13, 0);
        Date startDate = startTimeCalendar.getTime();
        Date abortDate = abortTaskTimeCalendar.getTime();
        return startDate.before(abortDate) ? abortDate.before(now) || now.before(startDate) : abortDate.before(now) && now.before(startDate);
    }

    private static Schedule getAutoScheduleByProtectlocation(ProtectGroupReplica pgReplica, PolicyTemplate template) {
        Schedule autoSchedule = null;
        Set schedules = template.getSchedules();
        for (Schedule sch : schedules) {
            if (sch.getScheduleMode() != 0 || pgReplica.getProtectLocation() != sch.getProtectLocation()) continue;
            autoSchedule = sch;
            break;
        }
        return autoSchedule;
    }

    public static void terminateTask(ReplicationRelationBo replicationRelationBo) {
        if (VerifyUtil.isEmpty((Object)replicationRelationBo)) {
            logger.error((Object)"replicationRelationBo is null!", 90160758784001L);
            return;
        }
        try {
            logger.info((Object)"start to abort task successful!", 90160758784000L);
            StorageReplicationManagerProxy.getInstance().splitReplication(replicationRelationBo.getSrcDeviceSn(), replicationRelationBo.getTgtDeviceSn(), replicationRelationBo.getReplicationId(), replicationRelationBo.isConsistentGroup());
            logger.info((Object)"abort task successful!", 90160758784000L);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("terminateTask split replication failed. SrcStorageProviderSN:" + replicationRelationBo.getSrcDeviceSn() + ",TgtStorageProviderSN:" + replicationRelationBo.getTgtDeviceSn()), (Throwable)e, 90160758784001L);
            throw e;
        }
        catch (Exception e) {
            String errorMsg = "terminateTask split replication failed. SrcStorageProviderSN:" + replicationRelationBo.getSrcDeviceSn() + ",TgtStorageProviderSN:" + replicationRelationBo.getTgtDeviceSn();
            ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)-1L, (String[])new String[0], (Log)logger);
        }
    }

    public void resetNextExecuteTime(ISchedule schedule, Date startTime, Scheduler quartzScheduler, Trigger quartzTrigger) {
        Date nextStartDate = this.getNextExeTimeWhenOutOfTimeRange(schedule, startTime);
        try {
            ((AbstractTrigger)quartzTrigger).setStartTime(nextStartDate);
            logger.info((Object)("reset next execution time successfully! Next execution time is " + nextStartDate), 90160758784000L);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"setStartTime error!", (long)1073948179L, null, (Log)logger);
        }
        try {
            quartzScheduler.rescheduleJob(new TriggerKey(quartzTrigger.getKey().getName(), quartzTrigger.getKey().getGroup()), quartzTrigger);
        }
        catch (SchedulerException e) {
            logger.error((Object)"rescheduleJob error!", (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(1073948179L, (Throwable)e);
        }
        throw new LegoCheckedException(1073948179L);
    }

    public Date getNextExeTimeWhenOutOfTimeRange(ISchedule schedule, Date startTime) {
        Set scheduleRanges = schedule.getScheduleRanges();
        Date nextStartDate = this.getTimeRangeStartDate(schedule, startTime);
        Iterator iterator = scheduleRanges.iterator();
        ScheduleRangeTime scheduleRangeTime = (ScheduleRangeTime)iterator.next();
        Calendar nowCalendar = Calendar.getInstance();
        nowCalendar.setTime(startTime);
        nowCalendar.set(13, 0);
        Calendar startTimeCalendar = Calendar.getInstance();
        startTimeCalendar.setTime(scheduleRangeTime.getStartTime());
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(startTime);
        startCalendar.set(11, startTimeCalendar.get(11));
        startCalendar.set(12, startTimeCalendar.get(12));
        startCalendar.set(13, 0);
        int size = scheduleRanges.size();
        if (size == 1 && startCalendar.getTime().before(nowCalendar.getTime())) {
            Calendar newNextStartCalendar = Calendar.getInstance();
            newNextStartCalendar.setTime(nextStartDate);
            newNextStartCalendar.add(5, 1);
            nextStartDate = newNextStartCalendar.getTime();
        }
        return nextStartDate;
    }

    public Date getStartTimeInRangeTime(ISchedule schedule, Date startTime) {
        Date timeRangeStartDate = this.getTimeRangeStartDate(schedule, startTime);
        Set scheduleRanges = schedule.getScheduleRanges();
        if (scheduleRanges.size() == 2 && startTime.before(timeRangeStartDate)) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(timeRangeStartDate);
            calendar.add(5, -1);
            return calendar.getTime();
        }
        return timeRangeStartDate;
    }

    private Date getTimeRangeStartDate(ISchedule schedule, Date startTime) {
        Date timeRangeStartDate = null;
        Set scheduleRanges = schedule.getScheduleRanges();
        int size = scheduleRanges.size();
        for (ScheduleRangeTime us : scheduleRanges) {
            Calendar nowCalendar = Calendar.getInstance();
            nowCalendar.setTime(startTime);
            Calendar endTimeCalendar = Calendar.getInstance();
            Calendar startTimeCalendar = Calendar.getInstance();
            Date endTime = us.getEndTime();
            Date stTime = us.getStartTime();
            endTimeCalendar.setTime(endTime);
            int min = endTimeCalendar.get(12);
            if ((min != 59 || size != 2) && size != 1) continue;
            startTimeCalendar.setTime(stTime);
            nowCalendar.set(11, startTimeCalendar.get(11));
            nowCalendar.set(12, startTimeCalendar.get(12));
            nowCalendar.set(13, 0);
            timeRangeStartDate = nowCalendar.getTime();
        }
        if (timeRangeStartDate == null) {
            logger.error((Object)"startDate is null!", 90160758784001L);
            throw new LegoCheckedException(1073948179L);
        }
        return timeRangeStartDate;
    }

    public void checkHyperMetro(ProtectGroup protectGroup, ActionContext context) {
        this.checkHyperMetro(protectGroup, context, (ProtectGroupReplica)context.getObject("PG_REPLICA_ENTITY"));
    }

    public void checkHyperMetro(ProtectGroup protectGroup, ActionContext context, ProtectGroupReplica pgReplica) {
        int templateType = protectGroup.getTemplate().getType();
        boolean is4DC = PolicyTemplateType.REP_4DC_POLICYTEMPLATE.contains(templateType);
        if (is4DC && !ProtectionJobUtil.isHyperMetroInFirstSite(protectGroup)) {
            return;
        }
        if (!CHECK_HYPERMETRO_MASTER_LUN.contains(templateType)) {
            return;
        }
        int resourcetype = this.getResourcetype(protectGroup);
        if (resourcetype == DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue()) {
            if (templateType == 28) {
                List relationList = (List)context.getObject("VAULT_PATH");
                this.checkNasHyperMetro(relationList);
            } else {
                this.checkNasHyperMetro(pgReplica);
            }
            return;
        }
        pgReplica = this.getProtectGroupReplica(protectGroup, templateType, pgReplica);
        ArrayList<String> allWWN = new ArrayList<String>();
        allWWN.addAll(this.getAllStorageWWN(pgReplica));
        List<HyperMetroPair> pairList = this.getHyperMetroPairs(protectGroup, allWWN);
        this.checkSyncDirection(pgReplica, pairList);
    }

    private List<HyperMetroPair> getHyperMetroPairs(ProtectGroup protectGroup, List<String> allWWN) {
        IStorageResourceService storageResourceService = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
        List pairList = null;
        try {
            pairList = storageResourceService.getHyperMetroPairByWwn(allWWN, null, true);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("RealTime to query hyperMetro pair error! , all wwns:" + allWWN + ",errorCode:" + e.getErrorCode()), e.getErrorCode());
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("RealTime to query hyperMetro pair error! , all wwns:" + allWWN), (long)-1L, null, (Log)logger);
        }
        if (VerifyUtil.isEmpty((Collection)pairList)) {
            logger.error((Object)("pairList is empty! pgName:" + protectGroup.getName() + ", allWWN:" + allWWN));
            throw new LegoCheckedException(-1L);
        }
        return pairList;
    }

    public static boolean isHyperMetroInFirstSite(ProtectGroup protectGroup) {
        List siteInfoList;
        if (null == protectGroup) {
            logger.error((Object)"pg is null!", 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        String siteInfoListStr = (String)protectGroup.getProps().get("PROP_KEY_SITE_INFO");
        return null != siteInfoListStr && (siteInfoList = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)siteInfoListStr), SiteInfo.class)).size() > 0 && ((SiteInfo)siteInfoList.get(0)).getSiteIdSet().size() >= 2;
    }

    private void checkSyncDirection(ProtectGroupReplica pgReplica, List<HyperMetroPair> pairList) {
        for (HyperMetroPair pair : pairList) {
            if (!pair.getDevSn().equals(pgReplica.getProductArray())) continue;
            Integer syncDirection = pair.getSyncDirection();
            if (VerifyUtil.isEmpty((Object)syncDirection)) {
                logger.error((Object)("The syncDirection is null! pairId:" + pair.getId()));
                throw new LegoCheckedException(-1L);
            }
            if (!String.valueOf(XveEnumDefine.HC_SYNC_DIRECTION.HC_SYNC_REMOTE_TO_LOCAL.getValue()).equals(String.valueOf(syncDirection)) || String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue()).equals(pair.getRunningState())) continue;
            logger.warn((Object)("hyper metro pair :" + pair.getId() + " pair devsn :" + pair.getDevSn() + " ,execute pg array :" + pgReplica.getProductArray() + ", syncDirection:" + syncDirection));
            throw new LegoCheckedException(1073948228L);
        }
    }

    private ProtectGroupReplica getProtectGroupReplica(ProtectGroup protectGroup, int templateType, ProtectGroupReplica pgReplica) {
        ProtectGroupReplica replica;
        if (templateType == 31 && null != (replica = protectGroup.getAnyoneReplicationReplica())) {
            return replica;
        }
        return pgReplica;
    }

    private void checkNasHyperMetro(List<ProtectionRelation> relationList) {
        HashSet<String> result = new HashSet<String>();
        String devSn = ((ProtectionRelation)CommonUtil.getFirstElement(relationList)).getSrcResourceProviderSn();
        for (ProtectionRelation relation : relationList) {
            result.add(relation.getSrcResourceId());
        }
        this.checkNasHyperMetro(devSn, devSn, new ArrayList<String>(result));
    }

    private void checkNasHyperMetro(ProtectGroupReplica pgReplica) {
        ArrayList<String> fileSystemIds = new ArrayList<String>();
        HashSet<String> result = new HashSet<String>();
        String srcDevsn = this.getSrcDevSN(pgReplica, result);
        fileSystemIds.addAll(result);
        this.checkNasHyperMetro(srcDevsn, pgReplica.getProductArray(), fileSystemIds);
    }

    private void checkNasHyperMetro(String storageDevSn, String productDevSn, List<String> fileSystemIds) {
        HyperMetroPair pair;
        IStorageResourceService storageResourceService = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
        List pairList = null;
        try {
            pairList = storageResourceService.getHyperMetroPairByFileSystems(storageDevSn, fileSystemIds, null, Boolean.valueOf(true));
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("RealTime to query hyperMetro pair error! , all fileSystemIds:" + fileSystemIds + ",errorCode:" + e.getErrorCode()), e.getErrorCode());
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("RealTime to query hyperMetro pair error! , all fileSystemIds:" + fileSystemIds), (long)-1L, null, (Log)logger);
        }
        if (VerifyUtil.isEmpty((Collection)pairList)) {
            logger.error((Object)("pairList is empty!  fileSystemIds:" + fileSystemIds));
            throw new LegoCheckedException(-1L);
        }
        Iterator iterator = pairList.iterator();
        while (iterator.hasNext() && (pair = (HyperMetroPair)iterator.next()).getDevSn().equals(productDevSn)) {
            Integer syncDirection = pair.getSyncDirection();
            if (VerifyUtil.isEmpty((Object)syncDirection)) {
                logger.error((Object)("The syncDirection is null! pairId:" + pair.getId()));
                throw new LegoCheckedException(-1L);
            }
            if (!String.valueOf(XveEnumDefine.HC_SYNC_DIRECTION.HC_SYNC_REMOTE_TO_LOCAL.getValue()).equals(String.valueOf(syncDirection)) || String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue()).equals(pair.getRunningState())) continue;
            logger.warn((Object)("hyper metro pair :" + pair.getId() + " pair devsn :" + pair.getDevSn() + " ,execute pg array :" + productDevSn + ", syncDirection:" + syncDirection));
            throw new LegoCheckedException(1073948228L);
        }
    }

    protected int getResourcetype(ProtectGroup protectGroup) {
        int type;
        block2: {
            Set polist = protectGroup.getPolist();
            if (VerifyUtil.isEmpty((Collection)polist)) {
                logger.error((Object)"The Set<ProtectObject> is null!");
                throw new LegoCheckedException(-1L);
            }
            Set allStorageInfo = ((ProtectObject)CommonUtil.getFirstElement((Collection)polist)).getUsedStorageResourceSet();
            if (VerifyUtil.isEmpty((Collection)allStorageInfo)) {
                logger.error((Object)"The Set<ProtectObjectStorageInfo> is null!");
                throw new LegoCheckedException(-1L);
            }
            type = 1;
            Iterator iterator = allStorageInfo.iterator();
            if (!iterator.hasNext()) break block2;
            ProtectObjectStorageInfo posi = (ProtectObjectStorageInfo)iterator.next();
            type = posi.getResourceType();
        }
        return type;
    }

    public void checkLunPairStatus(ProtectGroup protectGroup) {
        logger.debug((Object)"checkLunPairStatus when create lun snapshot");
        Set protectObjects = protectGroup.getPolist();
        if (11 != ((ProtectObject)protectObjects.iterator().next()).getPoType()) {
            return;
        }
        String tgtDeviceSn = protectGroup.getPoProviderSN();
        List<String> lunIds = this.getLunIdsByPO(protectObjects);
        IMoDao moDao = CommonDAOLocator.getMoDao();
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("tgtDevSN", tgtDeviceSn);
        props.put("tgtLunId", lunIds.toArray());
        List tgtLuns = moDao.findMoBy(ReplicationTargetLun.class, props);
        if (VerifyUtil.isEmpty((Collection)tgtLuns)) {
            return;
        }
        for (ProtectObject po : protectObjects) {
            Set resourceSet = po.getUsedStorageResourceSet();
            for (ProtectObjectStorageInfo storageInfo : resourceSet) {
                ReplicationTargetLun lun;
                List<ReplicationTargetLun> luns;
                String lunId = storageInfo.getResourceId();
                ReplicationTargetLun tgtLun = this.getTargetLuns(tgtLuns, lunId, tgtDeviceSn);
                if (null == tgtLun || VerifyUtil.isEmpty(luns = this.querySyncStatus(tgtLun, tgtDeviceSn)) || 2 != (lun = luns.get(0)).getPairStatus() && XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZING.getValue() != lun.getPairStatus().intValue()) continue;
                logger.info((Object)("lun is synchronizing, can not create snapshot. lunId=" + lunId));
                throw new LegoCheckedException(1073948248L);
            }
        }
    }

    private String getSrcDevSN(ProtectGroupReplica pgReplica, Set<String> result) {
        String srcDevSn = null;
        for (ProtectObjectReplica poReplica : pgReplica.getReplicas()) {
            for (RelicaStorageInfo storage : poReplica.getStorageInfos()) {
                result.add(storage.getSrcStorageId());
                srcDevSn = storage.getSrcStorageProviderSN();
            }
        }
        return srcDevSn;
    }

    private String getProviderInfoByPgReplica(ProtectGroupReplica pgReplica, Set<String> result) {
        String srcDevSn = null;
        for (ProtectObjectReplica poReplica : pgReplica.getReplicas()) {
            for (RelicaStorageInfo storage : poReplica.getStorageInfos()) {
                result.add(storage.getStorageId());
                srcDevSn = storage.getStorageProviderSN();
            }
        }
        return srcDevSn;
    }

    private Set<String> getReplicationPairIds(ProtectGroupReplica pgReplica) {
        HashSet<String> set = new HashSet<String>();
        for (ProtectObjectReplica poReplica : pgReplica.getReplicas()) {
            for (RelicaStorageInfo storage : poReplica.getStorageInfos()) {
                if (!(storage instanceof RemoteStorageReplica)) continue;
                RemoteStorageReplica remoteStorageReplica = (RemoteStorageReplica)storage;
                set.add(remoteStorageReplica.getReplicationPairId());
            }
        }
        return set;
    }

    private Set<String> getAllStorageWWN(ProtectGroupReplica pgReplica) {
        HashSet<String> result = new HashSet<String>();
        for (ProtectObjectReplica poReplica : pgReplica.getReplicas()) {
            for (RelicaStorageInfo storage : poReplica.getStorageInfos()) {
                result.add(storage.getProtectObjectStorageWwn());
            }
        }
        return result;
    }

    private ReplicationTargetLun getTargetLuns(List<ReplicationTargetLun> tgtLuns, String tgtLunId, String tgtDevSn) {
        for (ReplicationTargetLun tgtLun : tgtLuns) {
            if (!tgtLunId.equals(tgtLun.getTgtLunId()) || !tgtDevSn.equals(tgtLun.getTgtDevSN()) || !tgtLun.getTgtDevSN().equals(tgtLun.getDevSn())) continue;
            return tgtLun;
        }
        return null;
    }

    private List<String> getLunIdsByPO(Set<ProtectObject> protectObjects) {
        ArrayList<String> lunIds = new ArrayList<String>();
        for (ProtectObject po : protectObjects) {
            Set resourceSet = po.getUsedStorageResourceSet();
            for (ProtectObjectStorageInfo storageInfo : resourceSet) {
                lunIds.add(storageInfo.getResourceId());
            }
        }
        return lunIds;
    }

    private List<ReplicationTargetLun> querySyncStatus(ReplicationTargetLun tgtLun, String tgtDeviceSn) {
        try {
            StorageReplicationManagerProxy proxy = StorageReplicationManagerProxy.getInstance();
            return proxy.querySyncStatus(tgtLun.getDevSn(), tgtDeviceSn, tgtLun.getReplicationPairId(), false);
        }
        catch (LegoCheckedException e) {
            return null;
        }
    }

    public void checkReplicationPair(ProtectGroup protectGroup, ActionContext context) {
        List<ReplicationPair> pairList;
        int templateType = protectGroup.getTemplate().getType();
        if (!PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE.contains(templateType)) {
            return;
        }
        int location = com.huawei.lego.core.sdk.util.NumberUtil.convertToInteger((Object)context.getObject("PG_EXECUTE_LOCATION"));
        if (location == DrmEnumDefine.PROTECT_LOCATION.PL_A.getValue() || location == DrmEnumDefine.PROTECT_LOCATION.PL_B.getValue()) {
            return;
        }
        ProtectGroupReplica pgReplica = Optional.ofNullable((ProtectGroupReplica)context.getObject("PG_REPLICA_ENTITY")).map(replica -> protectGroup.getReplicationReplicaByRecoverySiteId(replica.getRecoverySite())).orElse(null);
        if (Objects.isNull(pgReplica)) {
            return;
        }
        boolean isAirGap = false;
        if (RecoveryTaskUtil.isAirGapSite(protectGroup.getPoProviderSN())) {
            isAirGap = true;
        }
        if (VerifyUtil.isEmpty(pairList = this.getReplicationPairs(pgReplica, isAirGap))) {
            logger.error((Object)("pairList size error! pgName:" + protectGroup.getName()));
            throw new LegoCheckedException(1073948677L, new String[]{this.getLostPairId(pgReplica, pairList)});
        }
        Set<String> pairIds = this.getReplicationPairIds(pgReplica);
        for (ReplicationPair pair : pairList) {
            if (!pairIds.contains(pair.getReplicationId()) || this.isReplicationPairHealthStatusOK(pair)) continue;
            logger.error((Object)"pair status is not allowed.");
            throw new LegoCheckedException(1073948729L);
        }
    }

    private List<ReplicationPair> getReplicationPairs(ProtectGroupReplica pgReplica, boolean isAirGap) {
        List pairList;
        HashSet<String> lunIds = new HashSet<String>();
        IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        if (isAirGap) {
            String devSn = this.getProviderInfoByPgReplica(pgReplica, lunIds);
            pairList = storageService.getReplicationPairsByResourceIds(devSn, lunIds, false, Integer.valueOf(DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue()));
        } else {
            String devSn = this.getSrcDevSN(pgReplica, lunIds);
            pairList = storageService.getReplicationPairsByResourceIds(devSn, new ArrayList<String>(lunIds), Integer.valueOf(DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue()));
        }
        return pairList;
    }

    private String getLostPairId(ProtectGroupReplica pgReplica, List<ReplicationPair> pairList) {
        HashSet<String> pairIdList = new HashSet<String>();
        if (pairList != null) {
            for (ReplicationPair replicationPair : pairList) {
                pairIdList.add(replicationPair.getReplicationId());
            }
        }
        StringBuilder lostPairIds = new StringBuilder();
        for (ProtectObjectReplica replica : pgReplica.getReplicas()) {
            for (RelicaStorageInfo storageInfo : replica.getStorageInfos()) {
                String pairId = ((RemoteStorageReplica)storageInfo).getReplicationPairId();
                if (pairIdList.contains(pairId)) continue;
                lostPairIds.append(lostPairIds.length() == 0 ? pairId : ", " + pairId);
            }
        }
        return lostPairIds.toString();
    }

    private boolean isReplicationPairHealthStatusOK(ReplicationPair pair) {
        try {
            Integer runningState = Integer.valueOf(pair.getRunningState());
            ArrayList<Integer> errorRunningStateList = new ArrayList<Integer>();
            errorRunningStateList.add(XveEuumDefineParent.RUNNING_STATUS_E.INVALID.getValue());
            errorRunningStateList.add(ReplicationConstantDefine.PairStatus.INVALID.getValue());
            errorRunningStateList.add(2);
            errorRunningStateList.add(XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZING.getValue());
            if (errorRunningStateList.contains(runningState)) {
                logger.info((Object)"Pair running state error: %s, ID:%s", new Object[]{runningState.toString(), pair.getReplicationId()});
                return false;
            }
            Integer healthState = Integer.valueOf(pair.getHealthState());
            if (healthState.equals(6) || healthState.equals(XveEuumDefineParent.HEALTH_STATUS_E.FAULT.getValue())) {
                logger.info((Object)"Pair health state error: %s, ID:%s", new Object[]{healthState.toString(), pair.getReplicationId()});
                return false;
            }
        }
        catch (NumberFormatException e) {
            logger.error((Object)"Lun's healthState is error. healthState:%s, runningState:%s", new Object[]{pair.getHealthState(), pair.getRunningState()});
        }
        return true;
    }

    public boolean isFullBackup(Map<String, Object> parameter) {
        if (null == parameter) {
            return false;
        }
        Boolean result = (Boolean)parameter.get("fullBackup");
        return null == result ? false : result;
    }

    public Integer getBackupTypeExcuteSync(Map<String, Object> parameter) {
        if (null == parameter) {
            return null;
        }
        return (Integer)parameter.get("backupTypeAfterSync");
    }

    public int getSyncTypeExecuteSync(Map<String, Object> parameter) {
        if (parameter == null) {
            return -1;
        }
        return (Integer)parameter.get("syncTypeAfterSync");
    }
}

