/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.constant.ProtectObjectConstant;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.framework.service.group.AddProtectObjectsTransaction;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupServiceImpl;
import com.huawei.ism.drm.protection.framework.service.group.refinement.BaseProtectGroupRefineService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProvider;
import com.huawei.lego.cbb.backtask.sdk.model.TaskResultItem;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.springframework.transaction.support.TransactionCallback;

public class AddProtectObjectsBackTask
extends AbstractBackTask {
    private static final Log logger = LogFactory.getInstance(AddProtectObjectsBackTask.class);
    private ProtectGroupServiceImpl service;
    private ProtectGroup protectGroup;
    private Set<ProtectObject> protectObjectSet;
    private ProtectGroupHelper helper = ProtectGroupHelper.getInstance();

    public AddProtectObjectsBackTask(ProtectGroupServiceImpl service, ProtectGroup protectGroup, Set<ProtectObject> protectObjectSet) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)protectGroup.getName(), (String)"ism.drm.pg.add.po", (String)"System", (String)"", null), true);
        this.service = service;
        this.protectGroup = protectGroup;
        this.protectObjectSet = protectObjectSet;
    }

    protected void doWork() {
        int poCount = this.protectObjectSet.size() + this.protectGroup.getPoCount();
        try {
            ProtectObjectConstant.CREATING_PO_COUNT.addAndGet(poCount);
            ProtectGroup tempProtectGroup = (ProtectGroup)this.protectGroup.clone();
            tempProtectGroup.setPolist(new HashSet<ProtectObject>(this.protectObjectSet));
            tempProtectGroup.getPolist().addAll(this.protectGroup.getPolist());
            IProtectObjectProvider poProvider = BaseProtectGroupRefineService.getProtectObjectProvider(tempProtectGroup.getPoType());
            if (VerifyUtil.isEmpty((Object)poProvider)) {
                logger.error((Object)"There is no ProtectObjectProvider for pgName: %s", new Object[]{tempProtectGroup.getName()});
                throw new LegoCheckedException(1073947394L);
            }
            poProvider.checkProtectObjectsInProtectGroup(tempProtectGroup);
            this.excuteWork();
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)"Error to clone ProtectGroup", (Throwable)e);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        finally {
            ProtectObjectConstant.CREATING_PO_COUNT.addAndGet(-poCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void excuteWork() {
        String protectGroupId = this.protectGroup.getUuid();
        HashSet<TaskResultItem> resultSet = new HashSet<TaskResultItem>();
        try {
            this.helper.lockPos(this.protectObjectSet, 5, this.getBackTask(), resultSet);
            this.helper.addBatchTaskResultItem(this.protectObjectSet, this.protectGroup, this.getBackTask(), resultSet);
            MessageEvent event = new MessageEvent();
            event.setMessageType(3);
            ArrayList<ProtectGroup> objectList = new ArrayList<ProtectGroup>();
            objectList.add(this.protectGroup);
            event.setObjectList(objectList);
            this.service.notifyObserver(event, () -> {
                AddProtectObjectsTransaction callback = new AddProtectObjectsTransaction(this.service, this.protectGroup, this.getBackTask(), resultSet);
                this.service.getBaseDao().getTransactionTemplate().execute((TransactionCallback)callback);
            });
        }
        catch (LegoCheckedException e) {
            this.helper.notifyObserverException(this.protectGroup, 25);
            this.helper.updateBatchTaskResult(resultSet, e.getErrorCode(), e.getParameters());
            this.getBackTask().setTaskResultSet(resultSet);
            ExceptionUtil.rethrowException((Throwable)e, (String)("failed to add protectobject to potectgroup(" + this.protectGroup.getName() + ") because of sync error."), (long)e.getErrorCode(), (String[])e.getParameters(), (Log)logger);
        }
        catch (Exception e) {
            this.helper.notifyObserverException(this.protectGroup, 25);
            this.helper.updateBatchTaskResult(resultSet, -1L, new String[0]);
            this.getBackTask().setTaskResultSet(resultSet);
            ExceptionUtil.rethrowException((Throwable)e, (String)("failed to add protectobject to potectgroup(" + this.protectGroup.getName() + ") because of sync error."), (long)-1L, (String[])new String[0], (Log)logger);
        }
        finally {
            this.helper.unlockPos(this.protectObjectSet, 5);
            ProtectionJobUtil.getInstance().releaseLockPg(protectGroupId);
        }
    }
}

