/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunGroupManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunGroupManager;
import com.huawei.ism.drm.storage.sdk.model.LunConsistencyGroup;
import com.huawei.ism.drm.storage.util.SnapshotScheduleUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class LunConsistentGroupObserver
implements IObjectObserver {
    private static Log logger = LogFactory.getInstance(LunConsistentGroupObserver.class);

    public void after(MessageEvent event) {
        List objectList = event.getObjectList();
        if (VerifyUtil.isEmpty((Collection)objectList)) {
            return;
        }
        for (DRMObject object : objectList) {
            if (!(object instanceof ProtectGroup) || !this.checkPolicyTemplateType((ProtectGroup)object)) continue;
            this.dealLunConsistentGroup((ProtectGroup)object, event);
        }
    }

    public void before(MessageEvent event) {
        List objectList = event.getObjectList();
        if (VerifyUtil.isEmpty((Collection)objectList)) {
            return;
        }
        for (DRMObject object : objectList) {
            if (!(object instanceof ProtectGroup) || !this.checkPolicyTemplateType((ProtectGroup)object) || event.getMessageType() != 1) continue;
            this.checkLunConsistentGroup((ProtectGroup)object);
        }
    }

    public String getObserverType() {
        return ProtectGroup.class.getName();
    }

    private void dealLunConsistentGroup(ProtectGroup protectGroup, MessageEvent event) {
        int messageType = event.getMessageType();
        switch (messageType) {
            case 2: {
                this.deleteLunConsistentGroup(protectGroup);
                break;
            }
        }
    }

    private void deleteLunConsistentGroup(ProtectGroup protectGroup) {
        Map map = protectGroup.getProps();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            if (null == key || !key.startsWith("PROP_KEY_LUN_CG_KEY:") && !key.startsWith("PROP_KEY_LUN_LOG_CG_KEY:")) continue;
            String consistencyGroupId = (String)entry.getValue();
            String devSn = key.split(":")[1];
            IStorageLunGroupManager groupManager = StorageLunGroupManagerProxy.getInstance().getStorageSnapshotMgrByDevId(devSn);
            String snapshotScheduleId = SnapshotScheduleUtil.getScheduleIdFromProtectGroup(protectGroup, devSn);
            if (!VerifyUtil.isEmpty((String)snapshotScheduleId)) continue;
            this.deleteLunCG(groupManager, devSn, consistencyGroupId, protectGroup);
        }
    }

    private void deleteLunCG(IStorageLunGroupManager groupManager, String devSn, String lunConsistencyGroupId, ProtectGroup protectGroup) {
        if (lunConsistencyGroupId != null) {
            try {
                List luns = groupManager.queryLuns(devSn, lunConsistencyGroupId);
                if (!VerifyUtil.isEmpty((Collection)luns)) {
                    luns.forEach(lun -> groupManager.remove(devSn, lunConsistencyGroupId, lun.getResourceId()));
                }
                groupManager.delete(devSn, lunConsistencyGroupId);
            }
            catch (LegoCheckedException e) {
                int type = this.getScheduleType(protectGroup);
                if (PolicyTemplateType.AIR_GAP_NETWORKING.contains(protectGroup.getTemplate().getType()) && type == 102) {
                    logger.info((Object)"Secure snapshot need not delete lunCG.");
                    return;
                }
                AlarmReporter.sendAlarm(52625493L, lunConsistencyGroupId, FaultEnum.AlarmResourceType.NETWORKENTITY.getValue(), FaultEnum.AlarmSeverity.MINOR, lunConsistencyGroupId);
                logger.error((Object)("deleteLunCG failed." + lunConsistencyGroupId), (Throwable)e);
            }
        }
    }

    private int getScheduleType(ProtectGroup protectGroup) {
        Set schedules = protectGroup.getTemplate().getSchedules();
        Optional opt = schedules.stream().findAny();
        return opt.map(Schedule::getProtectedType).orElse(-1);
    }

    private void checkLunConsistentGroup(ProtectGroup protectGroup) {
        Map map = protectGroup.getProps();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            if (null == key || !key.startsWith("PROP_KEY_LUN_CG_KEY:") && !key.startsWith("PROP_KEY_LUN_LOG_CG_KEY:")) continue;
            String consistencyGroupId = (String)entry.getValue();
            String devSn = key.split(":")[1];
            IStorageLunGroupManager groupManager = StorageLunGroupManagerProxy.getInstance().getStorageSnapshotMgrByDevId(devSn);
            LunConsistencyGroup group = groupManager.queryConsistencyGroup(devSn, consistencyGroupId);
            if (null != group) continue;
            AlarmReporter.sendAlarm(52625492L, protectGroup.getUuid(), FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), FaultEnum.AlarmSeverity.MAJOR, consistencyGroupId, protectGroup.getName(), consistencyGroupId);
            logger.error((Object)("lunConsistentGroup has been deleted.id:" + consistencyGroupId));
            throw new LegoCheckedException(1073748824L);
        }
    }

    private boolean checkPolicyTemplateType(ProtectGroup protectGroup) {
        return PolicyTemplateType.ARRAY_SECOND_SNAPSHOT.contains(protectGroup.getTemplate().getType());
    }
}

