/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.cbb.base.sdk.constant.CommonConstant;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.ObjectConvert;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.HttpMethod;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.protection.framework.service.group.refinement.BaseProtectGroupRefineService;
import com.huawei.ism.drm.protection.framework.template.factory.ReplicaBuilderFactory;
import com.huawei.ism.drm.protection.framework.template.manager.TemplateFilterManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectTempStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateFilter;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager;
import com.huawei.ism.drm.protection.template.sdk.service.IReplicaBuilder;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.backtask.sdk.model.TaskResultItem;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.TryCatchThrowable;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.NativeQuery;
import org.springframework.dao.DataAccessException;

public class ProtectGroupHelper {
    public static final String NOTIFY_TYPE_BEFORE = "before";
    public static final String NOTIFY_TYPE_AFTER = "after";
    public static final String NOTIFY_TYPE_ERROR = "onError";
    public static final String NOTIFY_TYPE_FINAL = "onFinal";
    public static final long DISABLED_NOT_SUPPORT_ERROR = 1073948193L;
    public static final long NORMAL_NOT_SUPPORT_ERROR = 1073948194L;
    public static final long WAITTING_NOT_SUPPORT_ERROR = 1073948693L;
    public static final long INVALID_NOT_SUPPORT_ERROR = 1073948195L;
    public static final long LOCKED_NOT_SUPPORT_ERROR = 1073948196L;
    public static final long RUNNING_NOT_SUPPORT_ERROR = 1073948197L;
    public static final String EXECTTE_PROTECT_LOCATION = "executeProtectLocation_";
    public static final String CONCURRENT_SYNC_ASYNC_RING_SKETCH = "policy_template_5_concurrent_sa_dr_star.png";
    public static final String CASCADE_SYNC_ASYNC_RING_SKETCH = "policy_template_3_cascaded_sa_dr_star.png";
    private static final List<Integer> MATCH_TEMPLATE_FILTER_BY_TEMPLATE = Arrays.asList(17, 28, 20, 3, 5);
    private static final List<Integer> DOUBLE_PROTECT_LOCATION = Arrays.asList(19, 17, 28, 31, 30, 32, 40, 41, 42, 43);
    private static final Map<Integer, List<Integer>> TEMPLATE_TYPE_CONVERT = new HashMap<Integer, List<Integer>>();
    private static final Map<String, Map<Integer, String>> TEMPLATE_SKETCH_CONVERT = new HashMap<String, Map<Integer, String>>();
    private static final long[][] STATUS_OPT;
    private static final long[][] TEMPLATE_OPT;
    private static final Log LOG;
    private static final ProtectGroupHelper HELPER_INSTANCE;
    private static final Map<Integer, Set<String>> moKeyMap;

    public static ProtectGroupHelper getInstance() {
        return HELPER_INSTANCE;
    }

    public void validateProtectGroupParameter(ProtectGroup protectGroup, boolean isAddObj) {
        this.checkParamWithException(VerifyUtil.isEmpty((Object)protectGroup), "ProtectGroup is null!");
        if (VerifyUtil.isEmpty((String)protectGroup.getUuid())) {
            protectGroup.setUuid(UUIDGenerator.getUUID());
        }
        this.checkParamWithException(VerifyUtil.isEmpty((String)protectGroup.getName()), "ProtectGroup name is null!");
        this.checkParamWithException(VerifyUtil.isEmpty((Object)protectGroup.getPoType()), "ProtectObject Type is null!");
        this.checkParamWithException(VerifyUtil.isEmpty((String)protectGroup.getPoProviderSN()), "ProtectObject ProviderSN is null!");
        this.checkParamWithException(VerifyUtil.isEmpty((String)protectGroup.getProductSiteId()), "Product Site Id or name is null!");
        this.checkParamWithException(isAddObj && VerifyUtil.isEmpty((Collection)protectGroup.getPolist()), "ProtectObject list is null!");
        this.checkParamWithException(this.checkTemplateEmpty(protectGroup), "Policy template or template uuid is null!");
        this.checkParamWithException(this.checkTemplateType(protectGroup), "Policy template type is error!");
    }

    private void checkParamWithException(boolean result, String errMsg) {
        if (result) {
            LOG.error((Object)errMsg);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private boolean checkTemplateEmpty(ProtectGroup protectGroup) {
        return VerifyUtil.isEmpty((Object)protectGroup.getTemplate()) || VerifyUtil.isEmpty((String)protectGroup.getTemplate().getUuid());
    }

    private boolean checkTemplateType(ProtectGroup protectGroup) {
        return VerifyUtil.isEmpty((Object)protectGroup.getTemplate().getType());
    }

    public boolean checkPoStorageInfoChanged(Set<ProtectObjectStorageInfo> older, Set<ProtectObjectStorageInfo> newer) {
        if (null == older || null == newer) {
            return false;
        }
        ArrayList<String> olderStorageInfo = new ArrayList<String>();
        ArrayList<String> newerStorageInfo = new ArrayList<String>();
        for (ProtectObjectStorageInfo poStorage : older) {
            olderStorageInfo.add(poStorage.getResourceProviderSN() + ":" + poStorage.getResourceId());
        }
        LOG.debug((Object)"OlderStorageInfo: %s", new Object[]{((Object)olderStorageInfo).toString()});
        for (ProtectObjectStorageInfo poStorage : newer) {
            newerStorageInfo.add(poStorage.getResourceProviderSN() + ":" + poStorage.getResourceId());
        }
        LOG.debug((Object)"NewerStorageInfo: %s", new Object[]{((Object)newerStorageInfo).toString()});
        for (String olderInfo : olderStorageInfo) {
            if (newerStorageInfo.contains(olderInfo)) {
                newerStorageInfo.remove(olderInfo);
                continue;
            }
            return true;
        }
        return !newerStorageInfo.isEmpty();
    }

    public Schedule getManualSchedule(ProtectGroup protectGroup, Map<String, String> params) {
        int location = this.getExecuteLocation(protectGroup, params);
        Schedule schedule = null;
        for (Schedule sc : protectGroup.getTemplate().getSchedules()) {
            if (sc.getScheduleMode() != 1) continue;
            if (location == DrmEnumDefine.PROTECT_LOCATION.PL_UNKNOWN.getValue()) {
                schedule = sc;
                break;
            }
            if (sc.getProtectLocation() != location) continue;
            schedule = sc;
            break;
        }
        return schedule;
    }

    private int getExecuteLocation(ProtectGroup protectGroup, Map<String, String> params) {
        if (PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE.contains(protectGroup.getTemplate().getType()) && VerifyUtil.isEmpty(params)) {
            params.put(EXECTTE_PROTECT_LOCATION + DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue(), "true");
        }
        if (DOUBLE_PROTECT_LOCATION.contains(protectGroup.getTemplate().getType())) {
            HashSet<String> executeProtectLocations = new HashSet<String>();
            for (Map.Entry<String, String> param : params.entrySet()) {
                if (!param.getKey().startsWith(EXECTTE_PROTECT_LOCATION) || !param.getValue().equals("true")) continue;
                executeProtectLocations.add(param.getKey().trim().substring(EXECTTE_PROTECT_LOCATION.length()));
            }
            if (executeProtectLocations.size() != 1) {
                LOG.error((Object)"The protect location to execute not 1: %s", new Object[]{String.valueOf(executeProtectLocations.size())});
                throw new LegoCheckedException(1073947393L);
            }
            int location = DrmEnumDefine.PROTECT_LOCATION.PL_UNKNOWN.getValue();
            try {
                location = Integer.parseInt((String)executeProtectLocations.iterator().next());
            }
            catch (NumberFormatException e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)"The protect location convert error", (long)1073947393L, (String[])new String[0], (Log)LOG);
            }
            return location;
        }
        String drringUsedSrc = (String)protectGroup.getProps().get("hyper-dr-ring-used-resources");
        if (protectGroup.getTemplate().getType() == 3) {
            if (!VerifyUtil.isEmpty((String)drringUsedSrc)) {
                return DrmEnumDefine.PROTECT_LOCATION.PL_C.getValue();
            }
            return DrmEnumDefine.PROTECT_LOCATION.PL_B_C.getValue();
        }
        if (protectGroup.getTemplate().getType() == 5) {
            if (!VerifyUtil.isEmpty((String)drringUsedSrc)) {
                return DrmEnumDefine.PROTECT_LOCATION.PL_C.getValue();
            }
            return DrmEnumDefine.PROTECT_LOCATION.PL_A_C.getValue();
        }
        return DrmEnumDefine.PROTECT_LOCATION.PL_UNKNOWN.getValue();
    }

    public void checkProtectGroupOpt(PROTECT_GROUP_OPT opt, ProtectGroup protectGroup) {
        if (VerifyUtil.isEmpty((Object)((Object)opt)) || VerifyUtil.isEmpty((Object)protectGroup)) {
            LOG.error((Object)"Failed to operate protectGroup because of invalidity parameter.");
            throw new LegoCheckedException(1073947393L);
        }
        int optValue = opt.getStatus();
        int status = protectGroup.getStatus();
        int templateType = protectGroup.getTemplate().getType();
        if (!PolicyTemplateType.CLASSIFIED_POLICYTEMPLATE.containsKey(templateType) || templateType > TEMPLATE_OPT.length || optValue > TEMPLATE_OPT[templateType].length) {
            LOG.error((Object)"Failed to operate protectGroup, templateType(%s).", new Object[]{String.valueOf(templateType)});
            throw new LegoCheckedException(1073947393L);
        }
        this.checkOptStatus(optValue, status);
        if (0L == TEMPLATE_OPT[templateType][optValue]) {
            LOG.error((Object)"Failed to operate protectGroup, templateType(%s)optValue(%s).", new Object[]{templateType, optValue});
            throw new LegoCheckedException(TEMPLATE_OPT[templateType][PROTECT_GROUP_OPT.ERRORCODE.getStatus()]);
        }
        if (!protectGroup.isPrimary() && !this.checkStatus(opt)) {
            LOG.error((Object)"Failed to operate protectGroup");
            throw new LegoCheckedException(1073948184L);
        }
    }

    public void checkOptStatus(int optValue, int status) {
        if (optValue >= PROTECT_GROUP_OPT.ERRORCODE.getStatus()) {
            LOG.error((Object)"Failed to operate protectGroup, optValue(%s).", new Object[]{String.valueOf(optValue)});
            throw new LegoCheckedException(1073947393L);
        }
        if (status > DrmEnumDefine.PROTECT_GROUP_STATUS.RUNNING.getStatus()) {
            LOG.error((Object)"Failed to operate protectGroup, status(%s).", new Object[]{String.valueOf(status)});
            throw new LegoCheckedException(1073947393L);
        }
        if (status > STATUS_OPT.length || optValue > STATUS_OPT[status].length) {
            LOG.error((Object)"Failed to operate protectGroup, status(%s).", new Object[]{String.valueOf(status)});
            throw new LegoCheckedException(1073947393L);
        }
        if (0L == STATUS_OPT[status][optValue]) {
            LOG.error((Object)"Failed to operate protectGroup, status(%s) optValue(%s).", new Object[]{status, optValue});
            throw new LegoCheckedException(STATUS_OPT[status][PROTECT_GROUP_OPT.ERRORCODE.getStatus()]);
        }
    }

    public void checkAddOrRemovePoIsAvailable(ProtectGroup protectGroup) {
        LOG.debug((Object)"Check add or remove po is available.");
        this.checkPgOperationByRecoveryPlanStatus(protectGroup);
    }

    public void checkPgOperationByRecoveryPlanStatus(ProtectGroup protectGroup) {
        RecoveryPlan plan;
        boolean isUsedProtectGroupByRp = ((IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class)).isUsedProtectGroupByRp(protectGroup.getUuid());
        if (isUsedProtectGroupByRp && !this.checkSubAddPo(plan = ((IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class)).getRecoveryPlan(((IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class)).getAssociatedRecoveryPlanWithProtectGroup(protectGroup.getUuid()), false, false))) {
            LOG.error((Object)"Failed to operate protectGroup, recoveryPlan status: %s", new Object[]{String.valueOf(plan.getPlanStatus())});
            throw new LegoCheckedException(1073948749L);
        }
    }

    private boolean checkSubAddPo(RecoveryPlan plan) {
        if (VerifyUtil.isEmpty((Object)plan)) {
            LOG.error((Object)"Failed to search RecoveryPlan");
            throw new LegoCheckedException(1073948184L);
        }
        return plan.getPlanStatus() == DrmEnumDefine.RECOVERY_PLAN_STATUS_E.READY.getValue() || plan.getPlanStatus() == DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_COMPLETED.getValue() || plan.getPlanStatus() == DrmEnumDefine.RECOVERY_PLAN_STATUS_E.ROLLBACK_COMPLETED.getValue() || plan.getPlanStatus() == DrmEnumDefine.RECOVERY_PLAN_STATUS_E.VM_ROLLBACK_COMPLETED.getValue() || plan.getPlanStatus() == DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_COMPLETED.getValue();
    }

    private boolean checkStatus(PROTECT_GROUP_OPT opt) {
        return opt.getStatus() == PROTECT_GROUP_OPT.DELETE.getStatus() || opt.getStatus() == PROTECT_GROUP_OPT.LOCK.getStatus() || opt.getStatus() == PROTECT_GROUP_OPT.UNLOCK.getStatus();
    }

    public Boolean checkProductPGIsExisted(ProtectGroup protectGroup) {
        if (!protectGroup.isPrimary()) {
            Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(protectGroup.getProductSiteId());
            if (VerifyUtil.isEmpty((Object)site)) {
                LOG.error((Object)"Failed to operate protectGroup");
                throw new LegoCheckedException(1073948184L);
            }
            RestClient client = SiteUtil.initClient(site);
            try {
                HashMap<String, String> uriVariables = new HashMap<String, String>();
                uriVariables.put("protectGroupId", protectGroup.getUuid());
                String url = "/ws/protectgroups/{protectGroupId}";
                client.invoke(url, uriVariables, HttpMethod.GET);
            }
            catch (LegoCheckedException e) {
                long errorCode = e.getErrorCode();
                if (errorCode == 1073947394L) {
                    return false;
                }
                ExceptionUtil.rethrowException((Throwable)e, (String)e.getMessage(), (long)e.getErrorCode(), (String[])new String[0], (Log)LOG);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)"Query protectGroup from remote site error", (long)1073948184L, (String[])new String[0], (Log)LOG);
            }
        }
        return true;
    }

    public void checkProtectGroupRefresh(ProtectGroup protectGroup) {
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            LOG.error((Object)"Failed to operate protectGroup because of invalidity parameter.");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkProtectGroupOpt(PROTECT_GROUP_OPT.REFRESH, protectGroup);
        String isManual = (String)protectGroup.getProps().get("IS_MANUAL");
        if (!VerifyUtil.isEmpty((String)isManual) && String.valueOf(1).equals(isManual)) {
            LOG.error((Object)"Failed to operate protectGroup, protectGroup's isManual(%s).", new Object[]{isManual});
            throw new LegoCheckedException(1073948184L);
        }
    }

    public void updateProtectObjectStorageInfo(ProtectGroup oldProtectGroup, ProtectGroup newProtectGroup) {
        HashMap protectObjectMap = new HashMap();
        for (ProtectObject po : newProtectGroup.getPolist()) {
            HashSet olderStorageInfo = new HashSet(po.getUsedStorageResourceSet());
            protectObjectMap.put(po.getMoUuid(), olderStorageInfo);
        }
        for (ProtectObject po : oldProtectGroup.getPolist()) {
            po.clearUsedStorageResource();
            Set newerStorageInfo = (Set)protectObjectMap.get(po.getMoUuid());
            po.setUsedStorageResourceSet(newerStorageInfo);
            po.setProtectGroup(oldProtectGroup);
        }
    }

    public void updateProtectObjectStorageInfo(ProtectGroup oldProtectGroup, ProtectObject newProtectObject) {
        for (ProtectObject po : oldProtectGroup.getPolist()) {
            String oldMoUuid = po.getMoUuid();
            String newMoUuid = newProtectObject.getMoUuid();
            if (VerifyUtil.isEmpty((String)oldMoUuid) || !oldMoUuid.equals(newMoUuid)) continue;
            po.clearUsedStorageResource();
            Set newerStorageInfo = newProtectObject.getUsedStorageResourceSet();
            po.setUsedStorageResourceSet(newerStorageInfo);
            po.setProtectGroup(oldProtectGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProtectObject> getProtectObjectListByMoUUID(List<String> moUuIds) {
        List listResult = null;
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria crit = session.createCriteria(ProtectObject.class);
            crit.add(Restrictions.in((String)"name", moUuIds));
            crit.createAlias("protectGroup", "protectGroup").add(Restrictions.isNotNull((String)"protectGroup.pgId"));
            listResult = crit.list();
        }
        catch (DataAccessException e) {
            try {
                LOG.error((Object)"GetProtectObjectListByMoUUID failed.", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return listResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtectObject getProtectObjectByMoUUID(String protectGroupId, String uuId) {
        if (VerifyUtil.isEmpty((String)protectGroupId) || VerifyUtil.isEmpty((String)uuId)) {
            LOG.error((Object)"PgId or uuid is empty for getProtectObjectByMoUUID");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectObject result = null;
        Session session = null;
        try {
            List pos;
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria crit = session.createCriteria(ProtectObject.class);
            crit.add((Criterion)Restrictions.eq((String)"moUuid", (Object)uuId));
            crit.createAlias("protectGroup", "protectGroup").add((Criterion)Restrictions.eq((String)"protectGroup.pgId", (Object)protectGroupId));
            try {
                pos = crit.list();
            }
            catch (DataAccessException e) {
                LOG.error((Object)"Failed to query ProtectObject.", (Throwable)e);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            if (!VerifyUtil.isEmpty((Collection)pos)) {
                result = (ProtectObject)pos.get(0);
            }
        }
        catch (Throwable throwable) {
            DBOperationUtil.closeSession(session);
            throw throwable;
        }
        DBOperationUtil.closeSession(session);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtectObject getProtectObjectByMoUUID(int templateType, String uuId) {
        Session session;
        ProtectObject result;
        block5: {
            result = null;
            session = null;
            try {
                session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                Criteria crit = session.createCriteria(ProtectObject.class);
                crit.add((Criterion)Restrictions.eq((String)"moUuid", (Object)uuId));
                crit.createAlias("protectGroup", "protectGroup").add(Restrictions.isNotNull((String)"protectGroup.pgId"));
                List protectObjectList = crit.list();
                if (VerifyUtil.isEmpty((Collection)protectObjectList)) break block5;
                for (ProtectObject protectObject : protectObjectList) {
                    ProtectGroup pg;
                    if (VerifyUtil.isEmpty((Object)protectObject) || templateType != (pg = protectObject.getProtectGroup()).getTemplate().getType()) continue;
                    result = protectObject;
                    break;
                }
            }
            catch (DataAccessException e) {
                try {
                    LOG.error((Object)"Failed to query ProtectObject.", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return result;
    }

    public void addBatchTaskResultItem(Set<ProtectObject> protectObjectSet, ProtectGroup protectGroup, BackTask resultItem, Set<TaskResultItem> resultSet) {
        Iterator<ProtectObject> itr = protectObjectSet.iterator();
        boolean availableToShow = false;
        boolean poIsEmpty = false;
        HashSet<ProtectObject> addPos = new HashSet<ProtectObject>();
        if (protectGroup.getPolist().isEmpty()) {
            poIsEmpty = true;
        }
        long emptyItemError = -1L;
        List<Integer> allowTypes = Arrays.asList(16, 30, 31, 32);
        while (itr.hasNext()) {
            long errorCode = 0L;
            ProtectObject po = itr.next();
            String isManual = (String)po.getProps().get("IS_MANUAL");
            TaskResultItem result = new TaskResultItem();
            result.setResName(po.getName());
            result.setResultItem(resultItem);
            try {
                if (this.checkManual(protectGroup, isManual)) {
                    LOG.error((Object)"The po's 'IS_MANUAL' property is not the same with pg (%s)", new Object[]{protectGroup.getName()});
                    errorCode = 1073948185L;
                    availableToShow = true;
                    result.setResult(Integer.valueOf(CommonConstant.BACKTASK_RESULT_FAIL));
                    result.setDetail("lego.err." + errorCode);
                    resultItem.setTaskDetail(String.valueOf(1073948185L));
                } else if (this.checkSameProtectGroup(protectGroup, poIsEmpty, po)) {
                    LOG.error((Object)"Po(%s) is existed in the same ProtectGroup.", new Object[]{po.getMoUuid()});
                    errorCode = 1073948177L;
                    availableToShow = true;
                    result.setResult(Integer.valueOf(CommonConstant.BACKTASK_RESULT_FAIL));
                    result.setDetail("lego.err." + errorCode);
                    resultItem.setTaskDetail(String.valueOf(1073948177L));
                } else if (!allowTypes.contains(protectGroup.getTemplate().getType()) && !VerifyUtil.isEmpty((Object)this.getProtectObjectByMoUUID(protectGroup.getTemplate().getType(), po.getMoUuid()))) {
                    LOG.error((Object)"po(%s) is existed in the same template ProtectGroup.", new Object[]{po.getMoUuid()});
                    errorCode = 1073948177L;
                    availableToShow = true;
                    result.setResult(Integer.valueOf(CommonConstant.BACKTASK_RESULT_FAIL));
                    result.setDetail("lego.err." + errorCode);
                    resultItem.setTaskDetail(String.valueOf(1073948177L));
                } else {
                    addPos.add(po);
                    protectGroup.getPolist().add(po);
                    po.setProtectGroup(protectGroup);
                    result.setResult(Integer.valueOf(CommonConstant.BACKTASK_RESULT_SUCCESS));
                    result.setDetail("ism.drm.site.success");
                }
            }
            catch (LegoCheckedException le) {
                LOG.error((Object)"Add po failed with legoException.", (Throwable)le);
                errorCode = 0L == le.getErrorCode() ? -1L : le.getErrorCode();
                availableToShow = true;
                result.setResult(Integer.valueOf(CommonConstant.BACKTASK_RESULT_FAIL));
                result.setDetail("lego.err." + errorCode);
                resultItem.setTaskDetail(String.valueOf(le.getErrorCode()));
            }
            catch (Exception e) {
                LOG.error((Object)"Add po failed with exception. %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                errorCode = -1L;
                availableToShow = true;
                result.setResult(Integer.valueOf(CommonConstant.BACKTASK_RESULT_FAIL));
                result.setDetail("lego.err." + errorCode);
                resultItem.setTaskDetail(String.valueOf(-1L));
            }
            resultSet.add(result);
            if (errorCode == 0L) continue;
            emptyItemError = errorCode;
        }
        if (availableToShow) {
            resultItem.setTaskResultSet(resultSet);
        }
        if (addPos.isEmpty()) {
            LOG.error((Object)"The number of po which can be added is zero!");
            throw new LegoCheckedException(emptyItemError);
        }
    }

    private boolean checkSameProtectGroup(ProtectGroup protectGroup, boolean poIsEmpty, ProtectObject po) {
        return !poIsEmpty && !VerifyUtil.isEmpty((Object)this.getProtectObjectByMoUUID(protectGroup.getUuid(), po.getMoUuid()));
    }

    private boolean checkManual(ProtectGroup protectGroup, String isManual) {
        return !VerifyUtil.isEmpty((String)isManual) && !isManual.equals(protectGroup.getProps().get("IS_MANUAL"));
    }

    public void checkPoIsValid(Set<ProtectObject> protectObjectSet, ProtectGroup protectGroup) {
        for (ProtectObject po : protectObjectSet) {
            long errorCode;
            String isManual = (String)po.getProps().get("IS_MANUAL");
            List<Integer> allowTypes = Arrays.asList(16, 30, 31, 32);
            try {
                if (this.checkManual(protectGroup, isManual)) {
                    LOG.error((Object)"The po's 'IS_MANUAL' property is not the same with pg (%s)", new Object[]{protectGroup.getName()});
                    errorCode = 1073948185L;
                    throw new LegoCheckedException(errorCode, "The po's 'IS_MANUAL' property is not the same with pg (" + protectGroup.getName() + ")");
                }
                if (!VerifyUtil.isEmpty((Object)this.getProtectObjectByMoUUID(protectGroup.getUuid(), po.getMoUuid()))) {
                    LOG.error((Object)"Po(%s) is existed in the same ProtectGroup.", new Object[]{po.getMoUuid()});
                    errorCode = 1073948177L;
                    throw new LegoCheckedException(errorCode, "The po's 'IS_MANUAL' property is not the same with pg (" + protectGroup.getName() + ")");
                }
                if (allowTypes.contains(protectGroup.getTemplate().getType()) || VerifyUtil.isEmpty((Object)this.getProtectObjectByMoUUID(protectGroup.getTemplate().getType(), po.getMoUuid()))) continue;
                LOG.error((Object)"Po(%s) is existed in the same template ProtectGroup.", new Object[]{po.getMoUuid()});
                errorCode = 1073948177L;
                throw new LegoCheckedException(errorCode, "The po's 'IS_MANUAL' property is not the same with pg (" + protectGroup.getName() + ")");
            }
            catch (LegoCheckedException le) {
                ExceptionUtil.rethrowException((Throwable)le, (String)("Failed to create ProtectGroup(" + protectGroup.getUuid() + ")."), (long)le.getErrorCode(), (String[])le.getParameters(), (Log)LOG);
            }
            catch (Exception e) {
                errorCode = -1L;
                ExceptionUtil.rethrowException((Throwable)e, (String)("Failed to create ProtectGroup(" + protectGroup.getUuid() + ")."), (long)errorCode, (String[])new String[0], (Log)LOG);
            }
        }
    }

    public void checkPolicyTemplate(ProtectGroup protectGroup, List<BatchOperation> resultList) {
        HashSet<ProtectObject> protectGroupSet = new HashSet<ProtectObject>();
        Iterator itr = protectGroup.getPolist().iterator();
        while (itr.hasNext()) {
            long errorCode = 0L;
            ProtectObject po = (ProtectObject)itr.next();
            try {
                if (!ProtectGroupHelper.getInstance().checkPolicyTemplate(protectGroup.getTemplate().getType(), po)) {
                    LOG.error((Object)"ProtectObject(%s) and PolicyTemplate does not match.", new Object[]{po.getMoUuid()});
                    errorCode = 1073948191L;
                }
            }
            catch (LegoCheckedException le) {
                LOG.error((Object)"Add po failed with legoException.", (Throwable)le);
                errorCode = 0L == le.getErrorCode() ? -1L : le.getErrorCode();
            }
            catch (Exception e) {
                LOG.error((Object)"Add po failed with unexpected exception. %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                errorCode = -1L;
            }
            if (0L == errorCode) continue;
            protectGroupSet.add(po);
            for (BatchOperation opt : resultList) {
                if (0L != opt.getErrorCode() || !po.getMoUuid().equals(opt.getTargetName())) continue;
                opt.setErrorCode(errorCode);
            }
        }
        protectGroup.getPolist().removeAll(protectGroupSet);
    }

    public synchronized void lockPos(Set<ProtectObject> pos, Integer opt, BackTask backTask, Set<TaskResultItem> resultSet) {
        HashSet<ProtectObject> allowPos = new HashSet<ProtectObject>();
        if (moKeyMap.containsKey(opt)) {
            Set<String> existUuids = moKeyMap.get(opt);
            for (ProtectObject po : pos) {
                if (existUuids.contains(po.getMoUuid())) {
                    this.unlockPos(allowPos, opt);
                    LOG.error((Object)"po(%s) is under using. moCreatingMap = {%s}", new Object[]{po.getName(), existUuids.toString()});
                    this.generateResultSet(resultSet, pos, backTask);
                    backTask.setTaskResultSet(resultSet);
                    throw new LegoCheckedException(1073947906L, new String[]{po.getName()});
                }
                allowPos.add(po);
                existUuids.add(po.getMoUuid());
            }
        } else {
            moKeyMap.put(opt, this.getMoUuidSet(pos));
        }
    }

    private Set<String> getMoUuidSet(Set<ProtectObject> existPoIds) {
        HashSet<String> allowPos = new HashSet<String>();
        for (ProtectObject po : existPoIds) {
            allowPos.add(po.getMoUuid());
        }
        return allowPos;
    }

    private void generateResultSet(Set<TaskResultItem> resultSet, Set<ProtectObject> pos, BackTask resultItem) {
        for (ProtectObject po : pos) {
            TaskResultItem result = new TaskResultItem();
            result.setResName(po.getName());
            result.setResultItem(resultItem);
            result.setResult(Integer.valueOf(CommonConstant.BACKTASK_RESULT_FAIL));
            result.setDetail("lego.err.-1");
            resultSet.add(result);
        }
    }

    public Set<TaskResultItem> removeBatchTaskResultItem(Set<ProtectObject> protectGroupSet, ProtectGroup protectGroup, BackTask resultItem, Map<String, ProtectObject> toRemovedProtectObjectMap) {
        HashSet<TaskResultItem> resultSet = new HashSet<TaskResultItem>();
        Iterator<ProtectObject> itr = protectGroupSet.iterator();
        boolean availableToShow = false;
        Map<String, ProtectObject> id2PoMap = this.getPoMap(protectGroup.getPolist());
        while (itr.hasNext()) {
            ProtectObject po = itr.next();
            TaskResultItem opt = new TaskResultItem();
            opt.setResName(po.getName());
            opt.setResultItem(resultItem);
            if (VerifyUtil.isEmpty((String)po.getUuid())) {
                opt.setResult(Integer.valueOf(CommonConstant.BACKTASK_RESULT_FAIL));
                opt.setDetail("lego.err.1073947393");
                resultItem.setTaskDetail(String.valueOf(1073947393L));
                availableToShow = true;
            } else if (!protectGroup.getPolist().contains(po)) {
                opt.setResult(Integer.valueOf(CommonConstant.BACKTASK_RESULT_FAIL));
                opt.setDetail("lego.err.1073947394");
                resultItem.setTaskDetail(String.valueOf(1073947394L));
                availableToShow = true;
            } else {
                protectGroup.getPolist().remove(po);
                toRemovedProtectObjectMap.put(po.getUuid(), id2PoMap.get(po.getUuid()));
                opt.setResId(po.getUuid());
                opt.setResult(Integer.valueOf(CommonConstant.BACKTASK_RESULT_SUCCESS));
                opt.setDetail("ism.drm.site.success");
            }
            resultSet.add(opt);
        }
        if (this.checkPoListIsEmpty(protectGroup)) {
            LOG.error((Object)"Failed to remove protectObject from potectgroup(%s, %s) because of polist is null.", new Object[]{protectGroup.getName(), protectGroup.getUuid()});
            for (TaskResultItem opt : resultSet) {
                opt.setResult(Integer.valueOf(CommonConstant.BACKTASK_RESULT_FAIL));
                opt.setDetail("lego.err.1073948166");
            }
            resultItem.setTaskResultSet(resultSet);
            throw new LegoCheckedException(1073948166L);
        }
        if (availableToShow) {
            resultItem.setTaskResultSet(resultSet);
        }
        if (VerifyUtil.isEmpty(toRemovedProtectObjectMap)) {
            LOG.error((Object)"The number of po which can be removed is zero! pg: %s", new Object[]{protectGroup.getUuid()});
            throw new LegoCheckedException(-1L);
        }
        return resultSet;
    }

    private Map<String, ProtectObject> getPoMap(Set<ProtectObject> polist) {
        HashMap<String, ProtectObject> id2PoMap = new HashMap<String, ProtectObject>();
        for (ProtectObject po : polist) {
            id2PoMap.put(po.getUuid(), po);
        }
        return id2PoMap;
    }

    private boolean checkPoListIsEmpty(ProtectGroup protectGroup) {
        Set polist = protectGroup.getPolist();
        if (VerifyUtil.isEmpty((Collection)polist)) {
            return true;
        }
        int poType = protectGroup.getPoType();
        for (ProtectObject po : polist) {
            if (po.getPoType() != poType) continue;
            return false;
        }
        return true;
    }

    public boolean checkPolicyTemplate(int policyTemplateType, ProtectObject protectObject) {
        IPolicyTemplateFilter filter = TemplateFilterManager.getInstance().getTemplateFilterByType(policyTemplateType);
        if (filter == null) {
            LOG.error((Object)"Cannot get policyTemplateFilter, policyTemplateType = %s", new Object[]{String.valueOf(policyTemplateType)});
            throw new LegoCheckedException(1073947394L);
        }
        ArrayList<ProtectObject> protectObjects = new ArrayList<ProtectObject>();
        protectObjects.add(protectObject);
        return filter.isMatch(protectObjects);
    }

    public void checkPolicyTemplate(ProtectGroup protectGroup) {
        IPolicyTemplateFilter filter = TemplateFilterManager.getInstance().getTemplateFilterByType(protectGroup.getTemplate().getType());
        if (filter == null) {
            LOG.error((Object)"Cannot get policyTemplateFilter, pgUUid=%s", new Object[]{protectGroup.getUuid()});
            throw new LegoCheckedException(1073947394L);
        }
        ArrayList<ProtectObject> protectObjects = new ArrayList<ProtectObject>();
        for (ProtectObject protectObject : protectGroup.getPolist()) {
            protectObjects.add(protectObject);
        }
        if (MATCH_TEMPLATE_FILTER_BY_TEMPLATE.contains(protectGroup.getTemplate().getType())) {
            if (!filter.isMatch(protectObjects, protectGroup.getTemplate())) {
                LOG.error((Object)"ProtectObjects and PolicyTemplate does not match.");
                throw new LegoCheckedException(1073948191L);
            }
            return;
        }
        if (!filter.isMatch(protectObjects)) {
            LOG.error((Object)"ProtectObjects and PolicyTemplate does not match.");
            throw new LegoCheckedException(1073948191L);
        }
    }

    public PolicyTemplate matchAvailableTemplate(ProtectGroup protectGroup) {
        PolicyTemplate pgTemplate = protectGroup.getTemplate();
        int oldPgTemplateType = pgTemplate.getType();
        String pgTemplateSketch = pgTemplate.getSketch();
        List<Integer> converTemplate = TEMPLATE_TYPE_CONVERT.get(oldPgTemplateType);
        if (VerifyUtil.isEmpty(converTemplate) || VerifyUtil.isEmpty((String)pgTemplateSketch)) {
            LOG.info((Object)"ConvertTemplate or pgTemplateSketch is empty. oldPgTemplateType\uff1a%s", new Object[]{String.valueOf(oldPgTemplateType)});
            return null;
        }
        Map<Integer, String> convertSketchs = TEMPLATE_SKETCH_CONVERT.get(pgTemplateSketch);
        ArrayList<PolicyTemplate> allPolicyTemplate = new ArrayList<PolicyTemplate>();
        allPolicyTemplate.add(pgTemplate);
        IPolicyTemplateManager policyTemplateManager = (IPolicyTemplateManager)ServiceLocator.getInstance().getService(IPolicyTemplateManager.class);
        for (Integer type : converTemplate) {
            String targetSketch;
            PolicyTemplate newTemplate = policyTemplateManager.clonePolicyTemlate(type.intValue());
            newTemplate.setPtId(pgTemplate.getPtId());
            newTemplate.setUuid(pgTemplate.getUuid());
            newTemplate.setIsSystemDefine(Boolean.valueOf(true));
            newTemplate.setSchedules(pgTemplate.getSchedules());
            if (!VerifyUtil.isEmpty(convertSketchs) && !VerifyUtil.isEmpty((String)(targetSketch = convertSketchs.get(type)))) {
                newTemplate.setSketch(targetSketch);
            }
            allPolicyTemplate.add(newTemplate);
        }
        return this.matchTemplate(allPolicyTemplate, protectGroup);
    }

    private PolicyTemplate matchTemplate(List<PolicyTemplate> allPolicyTemplate, final ProtectGroup protectGroup) {
        for (final PolicyTemplate policyTemplate : allPolicyTemplate) {
            final IPolicyTemplateFilter templateFilter = TemplateFilterManager.getInstance().getTemplateFilterByType(policyTemplate.getType());
            final AtomicBoolean matchSuccess = new AtomicBoolean(false);
            new TryCatchThrowable(){

                protected void doTry() {
                    matchSuccess.set(templateFilter.isMatch(new ArrayList(protectGroup.getPolist()), policyTemplate));
                }

                protected void doCatch(Throwable e) {
                    LOG.error((Object)"Match policyTemplate error. %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                }
            }.run();
            if (!matchSuccess.get()) continue;
            LOG.debug((Object)"Match success. type: %s", new Object[]{String.valueOf(policyTemplate.getType())});
            return policyTemplate;
        }
        LOG.error((Object)"Match template error.");
        return null;
    }

    public boolean isRebuildReplica(PolicyTemplate oldPolicyTemplate, PolicyTemplate newPolicyTemplate) {
        boolean isRebuildReplica = this.isHyperMetroReplicaCntChanged(oldPolicyTemplate, newPolicyTemplate);
        String newReplicaCount = (String)newPolicyTemplate.getProps().get("PP_SNAPSHOT_COUNT");
        String oldReplicaCount = (String)oldPolicyTemplate.getProps().get("PP_SNAPSHOT_COUNT");
        if (!(VerifyUtil.isEmpty((String)newReplicaCount) || VerifyUtil.isEmpty((String)oldReplicaCount) || oldReplicaCount.equals(newReplicaCount))) {
            isRebuildReplica = true;
        }
        return isRebuildReplica;
    }

    public void updateBatchOperationResult(List<BatchOperation> resultList, Long singleResult) {
        for (BatchOperation opt : resultList) {
            if (0L != opt.getErrorCode()) continue;
            opt.setErrorCode(singleResult.longValue());
        }
    }

    public void updateBatchTaskResult(Set<TaskResultItem> resultSet, Long singleResult, String[] resultParams) {
        for (TaskResultItem opt : resultSet) {
            if (CommonConstant.BACKTASK_RESULT_SUCCESS != opt.getResult()) continue;
            opt.setResult(Integer.valueOf(CommonConstant.BACKTASK_RESULT_FAIL));
            opt.setDetail("lego.err." + singleResult);
            if (VerifyUtil.isEmpty((Object[])resultParams)) continue;
            List paramList = AbstractBackTask.limitSize((String[])resultParams, (int)100, (int)200);
            StringBuilder sb = new StringBuilder();
            for (String resultParam : paramList) {
                sb.append(VerifyUtil.isEmpty((String)sb.toString()) ? resultParam : "|" + resultParam);
            }
            opt.setParam(sb.toString());
        }
    }

    public void updateBatchOperationResult(List<BatchOperation> resultList, LegoCheckedException le) {
        Long singleResult = 0L == le.getErrorCode() ? Long.valueOf(-1L) : Long.valueOf(le.getErrorCode());
        for (BatchOperation opt : resultList) {
            if (0L != opt.getErrorCode()) continue;
            opt.setErrorCode(singleResult.longValue());
            opt.setDetailParam(le.getParameters());
        }
    }

    public synchronized void unlockPos(Set<ProtectObject> pos, Integer opt) {
        if (null == pos) {
            return;
        }
        Set<String> moUuidSet = moKeyMap.get(opt);
        if (null == moUuidSet) {
            return;
        }
        for (ProtectObject po : pos) {
            moUuidSet.remove(po.getMoUuid());
        }
    }

    public static String generateTaskUuid(ProtectGroup protectGroup, String type) {
        return type + "-" + protectGroup.getUuid() + "-" + UUIDGenerator.getUUID();
    }

    public void buildReplica(ProtectGroup protectGroup) {
        this.buildReplica(protectGroup, true);
    }

    public void buildReplica(ProtectGroup protectGroup, boolean isNeedSave) {
        ReplicaBuilderFactory factory = ReplicaBuilderFactory.getInstance();
        IReplicaBuilder builder = factory.getTemplateByType(protectGroup.getTemplate().getType());
        if (builder != null) {
            builder.buildReplica(protectGroup);
            if (isNeedSave && !VerifyUtil.isEmpty((Object)protectGroup.getTemplate())) {
                ((IPolicyTemplateManager)ServiceLocator.getInstance().getService(IPolicyTemplateManager.class)).addTemplate(protectGroup.getTemplate());
            }
        }
    }

    public Set<ProtectGroupReplica> deleteReplica(ProtectGroup protectGroup) {
        ReplicaBuilderFactory factory = ReplicaBuilderFactory.getInstance();
        IReplicaBuilder builder = factory.getTemplateByType(protectGroup.getTemplate().getType());
        if (builder != null) {
            return builder.beforeDeleteProtectGroup(protectGroup);
        }
        return Collections.emptySet();
    }

    public void checkAndBuildReplica(ProtectGroup protectGroup) {
        this.checkPolicyTemplate(protectGroup);
        this.buildReplica(protectGroup);
    }

    public void saveProtectObjectStorageInfo(ProtectObject ... protectObjectList) {
        if (VerifyUtil.isEmpty((Object[])protectObjectList)) {
            return;
        }
        for (ProtectObject protectObject : protectObjectList) {
            Set storageList = protectObject.getUsedStorageResourceSet();
            if (storageList == null || storageList.isEmpty()) continue;
            HashSet<ProtectObjectTempStorageInfo> tempList = new HashSet<ProtectObjectTempStorageInfo>();
            for (ProtectObjectStorageInfo storageInfo : storageList) {
                ProtectObjectTempStorageInfo temp = new ProtectObjectTempStorageInfo();
                ObjectConvert.antiConvert((Object)storageInfo, (Object)temp);
                temp.setArchiveLog(storageInfo.getArchiveLog());
                temp.setPoType(storageInfo.getPoType());
                temp.setResourceType(storageInfo.getResourceType());
                temp.setStorageType(storageInfo.getStorageType());
                temp.setStorageSubType(storageInfo.getStorageSubType());
                temp.setProtectObjectUuId(protectObject.getUuid());
                temp.setId(UUIDGenerator.getUUID());
                temp.setCurrentHostSn(storageInfo.getHostSN());
                temp.setHostSN(protectObject.getProviderSN());
                temp.setAlias(storageInfo.getAlias());
                tempList.add(temp);
            }
            CommonDAOLocator.getBaseDao().saveOrUpdateAll(tempList);
        }
    }

    public void loadProtectObjectStorageInfo(List<ProtectObject> protectObjectList) {
        if (VerifyUtil.isEmpty(protectObjectList)) {
            return;
        }
        IBaseDao baseDao = CommonDAOLocator.getBaseDao();
        for (ProtectObject protectObject : protectObjectList) {
            String uuid = protectObject.getUuid();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("protectObjectUuId", uuid);
            List criterionList = baseDao.translatePropsToCriterions(map);
            List tempList = baseDao.createCriteria(ProtectObjectTempStorageInfo.class, criterionList.toArray(new Criterion[criterionList.size()]));
            if (VerifyUtil.isEmpty((Collection)tempList)) continue;
            protectObject.clearUsedStorageResource();
            for (ProtectObjectTempStorageInfo tempStorageInfo : tempList) {
                ProtectObjectStorageInfo storageInfo = new ProtectObjectStorageInfo();
                ObjectConvert.convert((Object)tempStorageInfo, (Object)storageInfo);
                storageInfo.setArchiveLog(tempStorageInfo.getArchiveLog());
                storageInfo.setPoType(tempStorageInfo.getPoType());
                storageInfo.setResourceType(tempStorageInfo.getResourceType());
                storageInfo.setStorageType(tempStorageInfo.getStorageType());
                storageInfo.setStorageSubType(tempStorageInfo.getStorageSubType());
                storageInfo.setAlias(tempStorageInfo.getAlias());
                storageInfo.setCurrentHostSn(tempStorageInfo.getCurrentHostSn());
                protectObject.setProviderSN(tempStorageInfo.getHostSN());
                protectObject.addHostStorageResourceInfo(storageInfo);
            }
        }
    }

    public void deleteProtectObjectStorageInfo(List<ProtectObject> protectObjectList) {
        if (VerifyUtil.isEmpty(protectObjectList)) {
            return;
        }
        IBaseDao baseDao = CommonDAOLocator.getBaseDao();
        for (ProtectObject protectObject : protectObjectList) {
            String uuid = protectObject.getUuid();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("protectObjectUuId", uuid);
            List criterionList = baseDao.translatePropsToCriterions(map);
            List tempList = baseDao.createCriteria(ProtectObjectTempStorageInfo.class, criterionList.toArray(new Criterion[criterionList.size()]));
            if (VerifyUtil.isEmpty((Collection)tempList)) continue;
            baseDao.getHibernateTemplate().deleteAll((Collection)tempList);
        }
    }

    public boolean checkIsUnvalid(ProtectGroup protectGroup) {
        boolean checkResult = false;
        for (ProtectGroupReplica replica : protectGroup.getReplicaList()) {
            if (1 != replica.getStatus()) continue;
            checkResult = true;
        }
        return checkResult;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resetProtectGroupStatus(ProtectGroup pg) {
        String currentPgId = "";
        Session session = null;
        try {
            String sql = "UPDATE ti_protectgroup SET STATUS=?, LOCKTIME=?, LAST_EXEC_RESULT=?  WHERE PGID=?";
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            session.beginTransaction();
            NativeQuery query = session.createSQLQuery(sql);
            query.setParameter(0, (Object)pg.getStatus());
            query.setParameter(1, (Object)pg.getLockTime());
            query.setParameter(2, (Object)pg.getLastExecResult());
            query.setString(3, pg.getUuid());
            int updateResult = query.executeUpdate();
            session.getTransaction().commit();
            if (1 != updateResult) {
                LOG.error((Object)"Update protectGroup status failed!");
                throw new LegoCheckedException(-1L);
            }
        }
        catch (LegoCheckedException le) {
            try {
                DBOperationUtil.rollbackSession(session);
                LOG.error((Object)"Failed to update status of protectgroup(%s).", (Throwable)le, new Object[]{currentPgId});
                throw le;
                catch (DataAccessException e) {
                    DBOperationUtil.rollbackSession(session);
                    LOG.error((Object)"Failed to update status of protectgroup(%s).", (Throwable)e, new Object[]{currentPgId});
                    throw new LegoCheckedException(-1L, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession(session);
    }

    public void invalidProtectGroupReplica(String pgId, List<String> replicaIds) {
        if (VerifyUtil.isEmpty((String)pgId)) {
            LOG.error((Object)"Pg is Empty!");
            throw new LegoCheckedException(-1L);
        }
        List replicaList = ((IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class)).queryProtectGroupReplicaByGroup(pgId, "TIME_STAMP", false);
        ArrayList<String> pgrIds = new ArrayList<String>();
        for (ProtectGroupReplica pgr : replicaList) {
            String pgrId = pgr.getId();
            pgrIds.add(pgrId);
            if (!replicaIds.contains(pgrId) || DrmEnumDefine.REPLICA_STATUS.ACTIVE_STATUS.getValue() != pgr.getStatus()) continue;
            pgr.setStatus(DrmEnumDefine.REPLICA_STATUS.ERROR_STATUS.getValue());
        }
        if (!pgrIds.containsAll(replicaIds)) {
            LOG.error((Object)"Parameter[replicaIds] is not all legal! replicaIds: %s, pgrIds: %s", new Object[]{replicaIds, pgrIds});
            throw new LegoCheckedException(-1L);
        }
        HashMap<String, String> props = new HashMap<String, String>();
        this.resetReplicaIndex(replicaList, props);
        for (ProtectGroupReplica pgr : replicaList) {
            ((IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class)).updateProtectGroupReplica(pgr);
        }
        ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).saveOrUpdateProtectGroupProps(pgId, props);
        LOG.debug((Object)"To invalid ProtectGroupReplica is successful! pgId: %s, replicaIds: %s", new Object[]{pgId, replicaIds});
    }

    private void resetReplicaIndex(List<ProtectGroupReplica> replicaList, Map<String, String> props) {
        List<ProtectGroupReplica> pgReplicaList;
        HashMap<Integer, List<ProtectGroupReplica>> protectLocation2PgReplica = new HashMap<Integer, List<ProtectGroupReplica>>();
        for (ProtectGroupReplica protectGroupReplica : replicaList) {
            int protectLocation = protectGroupReplica.getProtectLocation();
            pgReplicaList = (ArrayList<ProtectGroupReplica>)protectLocation2PgReplica.get(protectLocation);
            if (pgReplicaList != null) {
                pgReplicaList.add(protectGroupReplica);
                continue;
            }
            pgReplicaList = new ArrayList<ProtectGroupReplica>();
            pgReplicaList.add(protectGroupReplica);
            protectLocation2PgReplica.put(protectLocation, pgReplicaList);
        }
        for (Map.Entry entry : protectLocation2PgReplica.entrySet()) {
            Integer protectLocation = (Integer)entry.getKey();
            pgReplicaList = (List)entry.getValue();
            this.orderReplicaList(pgReplicaList);
            int size = pgReplicaList.size();
            for (int i = 0; i < size; ++i) {
                pgReplicaList.get(i).setIndex(i + 1);
            }
            props.put("DrmFrameWork_Pg_Replica_Inedx" + protectLocation, String.valueOf(1));
        }
    }

    public void orderReplicaList(List<ProtectGroupReplica> replicaList) {
        replicaList.sort((pgr0, pgr1) -> {
            int power1;
            int status0 = pgr0.getStatus();
            int status1 = pgr1.getStatus();
            int power0 = this.getPower(status0);
            if (power0 != (power1 = this.getPower(status1))) {
                Integer powerInteger0 = NumberUtil.convertToInteger((Object)power0);
                Integer powerInteger1 = NumberUtil.convertToInteger((Object)power1);
                return powerInteger0.compareTo(powerInteger1);
            }
            return pgr0.compareTo(pgr1);
        });
    }

    private int getPower(int status) {
        switch (status) {
            case 1: {
                return 3;
            }
            case 3: {
                return 2;
            }
            case 0: {
                return 1;
            }
        }
        LOG.error((Object)"The Nas Snap builder don't support the status!");
        throw new LegoCheckedException(-1L);
    }

    public boolean checkSiteResourceExist(String providerSN, String siteId) {
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(providerSN);
        if (drResource == null) {
            LOG.error((Object)"DrResource(SN: %s) is empty.", new Object[]{providerSN});
            return false;
        }
        Set childResources = drResource.getChildResources();
        if (!VerifyUtil.isEmpty((Collection)childResources)) {
            for (DrResource res : childResources) {
                if (!res.getSiteId().equals(siteId)) continue;
                return true;
            }
            return false;
        }
        return drResource.getSiteId().equals(siteId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List<ProtectObject> getProtectObjectListByUuid(List<String> uuids) {
        List listResult = null;
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria crit = session.createCriteria(ProtectObject.class);
            crit.add(Restrictions.in((String)"uuid", uuids));
            crit.createAlias("protectGroup", "protectGroup").add(Restrictions.isNotNull((String)"protectGroup.pgId"));
            listResult = crit.list();
        }
        catch (DataAccessException e) {
            LOG.error((Object)"GetProtectObjectListByUuid failed.", (Throwable)e);
            DBOperationUtil.closeSession(session);
        }
        catch (Exception e2) {
            LOG.error((Object)"GetProtectObjectListByUuid failed. %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e2)});
            {
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return listResult;
    }

    private boolean isHyperMetroReplicaCntChanged(PolicyTemplate oldPolicyTemplate, PolicyTemplate newPolicyTemplate) {
        if (oldPolicyTemplate.getType() == 19 || oldPolicyTemplate.getType() == 17 || oldPolicyTemplate.getType() == 28) {
            ArrayList<DrmEnumDefine.PROTECT_LOCATION> allLocation = new ArrayList<DrmEnumDefine.PROTECT_LOCATION>();
            if (oldPolicyTemplate.getType() != 28) {
                allLocation.add(DrmEnumDefine.PROTECT_LOCATION.PL_A);
            }
            allLocation.add(DrmEnumDefine.PROTECT_LOCATION.PL_B);
            for (DrmEnumDefine.PROTECT_LOCATION location : allLocation) {
                int newCnt;
                int oldCnt = NumberUtil.convertToInteger(oldPolicyTemplate.getProps().get("PP_SNAPSHOT_COUNT" + location.getValue()));
                if (oldCnt == (newCnt = NumberUtil.convertToInteger(newPolicyTemplate.getProps().get("PP_SNAPSHOT_COUNT" + location.getValue())).intValue())) continue;
                return true;
            }
        }
        return false;
    }

    public void notifyObserverException(ProtectGroup protectGroup, int message) {
        MessageEvent event = new MessageEvent();
        event.setMessageType(message);
        ArrayList<ProtectGroup> objectList = new ArrayList<ProtectGroup>();
        objectList.add(protectGroup);
        event.setObjectList(objectList);
        BaseProtectGroupRefineService baseProtectGroupRefineService = new BaseProtectGroupRefineService();
        baseProtectGroupRefineService.notifyObserverList(event, NOTIFY_TYPE_AFTER);
    }

    public static void checkTimeAllowExecute(ProtectGroup protectGroup) {
        boolean isVasa = LegoConfig.getInstance().getBoolean("VASA", Boolean.valueOf(false));
        if (isVasa) {
            return;
        }
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            LOG.error((Object)"ProtectGroup is null");
            throw new LegoCheckedException(1073947393L);
        }
        Date nowDate = new Date();
        Long lastExec = protectGroup.getLastExecTime();
        if (lastExec != null && nowDate.getTime() - lastExec < 240000L) {
            LOG.error((Object)"Don't executeJob because time too short, protectGroup is %s, nowDate is %s, lastExecTime is %s, gap is %s.", new Object[]{protectGroup.getName(), nowDate, lastExec, nowDate.getTime() - lastExec});
            throw new LegoCheckedException(1073947723L);
        }
    }

    static {
        TEMPLATE_TYPE_CONVERT.put(3, Arrays.asList(5));
        TEMPLATE_TYPE_CONVERT.put(5, Arrays.asList(3));
        HashMap<Integer, String> cascadeSyncAsyncRingAndSkech = new HashMap<Integer, String>();
        cascadeSyncAsyncRingAndSkech.put(3, CASCADE_SYNC_ASYNC_RING_SKETCH);
        TEMPLATE_SKETCH_CONVERT.put(CONCURRENT_SYNC_ASYNC_RING_SKETCH, cascadeSyncAsyncRingAndSkech);
        HashMap<Integer, String> concurrentSyncAsyncRingAndSkech = new HashMap<Integer, String>();
        concurrentSyncAsyncRingAndSkech.put(5, CONCURRENT_SYNC_ASYNC_RING_SKETCH);
        TEMPLATE_SKETCH_CONVERT.put(CASCADE_SYNC_ASYNC_RING_SKETCH, concurrentSyncAsyncRingAndSkech);
        STATUS_OPT = new long[][]{{1L, 0L, 1L, 0L, 0L, 0L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1073948193L}, {1L, 1L, 1L, 1L, 1L, 1L, 0L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 0L, 1073948194L}, {1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 1L, 0L, 0L, 1073948693L}, {1L, 0L, 1L, 0L, 0L, 0L, 0L, 0L, 1L, 1L, 1L, 1L, 0L, 1L, 1L, 1073948195L}, {1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 1073948196L}, {1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1073948197L}};
        TEMPLATE_OPT = new long[][]{{1L, 1L, 1L, 0L, 0L, 0L, 0L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 0L, 0L, 0L, 0L, 1L, 1L, 1L, 1L, 1L, 0L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 0L, 0L, 0L, 0L, 1L, 1L, 1L, 1L, 1L, 0L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 0L, 0L, 0L, 0L, 1L, 1L, 1L, 1L, 1L, 0L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 0L, 0L, 0L, 0L, 1L, 1L, 1L, 1L, 1L, 0L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 0L, 0L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 0L, 0L, 0L, 0L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 0L, 0L, 0L, 0L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 0L, 0L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 0L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 0L, 0L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 0L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}, {1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1073948184L}};
        LOG = LogFactory.getInstance(ProtectGroupHelper.class);
        HELPER_INSTANCE = new ProtectGroupHelper();
        moKeyMap = new HashMap<Integer, Set<String>>();
    }

    public static enum PROTECT_GROUP_OPT {
        CREATE(0),
        MOFIFY(1),
        DELETE(2),
        MANUAL_EXECUTE(3),
        AUTO_EXECUTE(4),
        DISABLE(5),
        ENABLE(6),
        ADD(7),
        REMOVE(8),
        UPDATE_STORAGEINFO(9),
        REFRESH(10),
        UPDATE_PROTECTOBJECT_PROPS(11),
        UPDATE_TEMPLATE(12),
        LOCK(13),
        UNLOCK(14),
        ERRORCODE(15);

        private int status;

        private PROTECT_GROUP_OPT(int status) {
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }

        public static PROTECT_GROUP_OPT valueOf(int status) {
            PROTECT_GROUP_OPT result = null;
            for (PROTECT_GROUP_OPT value : PROTECT_GROUP_OPT.values()) {
                if (status != value.getStatus()) continue;
                result = value;
                break;
            }
            return result;
        }
    }
}

