/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.array.sdk.model.Controller;
import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.HyperMetroDomain;
import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.array.sdk.model.XveLun;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.base.sdk.model.StoragePool;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.proxy.xve.XveUUID;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.constant.DiskProtectStatusEnum;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.HttpMethod;
import com.huawei.ism.drm.drp.sdk.mo.StorageObjectBo;
import com.huawei.ism.drm.protection.framework.service.group.AbstractProtectGroupService;
import com.huawei.ism.drm.protection.framework.service.group.ExportProtectGroupBackTask;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.framework.service.group.refinement.QueryProtectGroupRefineService;
import com.huawei.ism.drm.protection.group.sdk.model.DiskInfo;
import com.huawei.ism.drm.protection.group.sdk.model.DiskStoragePool;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLog;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLogDetail;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.model.SubDiskInfo;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProvider;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.manager.sdk.model.StoragePair;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.ReplicaUtil;
import com.huawei.ism.drm.util.ScriptParamsUtils;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.ism.unistor.sdk.model.VstoreInfo;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.NativeQuery;
import org.springframework.dao.DataAccessException;

abstract class ProtectGroupQueryServiceImpl
extends AbstractProtectGroupService {
    private static Log logger = LogFactory.getInstance(ProtectGroupQueryServiceImpl.class);
    private static final String QUERY_PO_BY_PGID = "select poId, name, moUuid, poType, poStatus, poRecoveryStatus, providerSN from ProtectObject where protectGroup.pgId = ?";
    private static final String QUERY_PG_BY_PTID = "select uuid from ProtectGroup where template.ptId = ?";
    private static final String QUERY_PO_PROPS = "select POID,PROPNAME,PROPVALUE from ti_po_prop where POID in(:ids)";
    private static final String COUNT_PO = "select protectGroup.pgId, count(uuid) from ProtectObject where protectGroup.pgId in(:ids) group by protectGroup.pgId";
    private static final String SELECT_PG = "select pgId, poType, poProviderSN, name, status, productSiteId, productSiteName, lastExecTime, lastExecResult, pgReplicaIndex, primary, template.ptId from ProtectGroup";
    private Map<Integer, IProtectObjectProvider> providerMapping = new ConcurrentHashMap<Integer, IProtectObjectProvider>();

    public List<Lun> getUsedStorageLunsByProtectObject(List<ProtectObject> protectObjects, int poType, int templateType) {
        IProtectObjectProviderDelegate poProvider = (IProtectObjectProviderDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderDelegate.class);
        IProtectObjectProvider provider = poProvider.getProviderByAppType(poType);
        provider.loadProtectObjectStorageInfo(protectObjects);
        String deviceSn = null;
        ArrayList<String> resourceIds = new ArrayList<String>();
        for (ProtectObject protectObject : protectObjects) {
            Set storageInfos = protectObject.getUsedStorageResourceSet();
            for (ProtectObjectStorageInfo storageInfo : storageInfos) {
                deviceSn = storageInfo.getResourceProviderSN();
                resourceIds.add(storageInfo.getResourceId());
            }
        }
        IStorageResourceService storageResourceService = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
        List storageResources = storageResourceService.getStorageResources(deviceSn, resourceIds, Lun.class);
        Map<String, String> poolIdAndNameMap = this.getPoolIdAndNameMap();
        Map<String, String> controllerLocations = this.getControllerLocations();
        for (Lun lun : storageResources) {
            this.fillControllerNameOfLun((StorageResource)lun, controllerLocations);
            if (!(lun instanceof XveLun)) continue;
            XveLun xveLun = (XveLun)lun;
            xveLun.setStoragePoolName(poolIdAndNameMap.get(CommUtil.combineString((String[])new String[]{xveLun.getDevSn(), xveLun.getStoragePoolId()})));
        }
        return storageResources;
    }

    private Map<String, String> getPoolIdAndNameMap() {
        HashMap<String, String> poolIdAndNameMap = new HashMap<String, String>();
        List storagePools = this.getMoDao().find("from StoragePool", new Object[0]);
        if (!VerifyUtil.isEmpty((Collection)storagePools)) {
            for (Object object : storagePools) {
                StoragePool pool = (StoragePool)object;
                poolIdAndNameMap.put(pool.getPoolId(), pool.getName());
                poolIdAndNameMap.put(CommUtil.combineString((String[])new String[]{pool.getNeSN(), pool.getPoolId()}), pool.getName());
            }
        }
        return poolIdAndNameMap;
    }

    public Page pagedQueryProtectObjectByPg(int pageNo, int pageSize, String orderBy, boolean isAsc, String protectGroupId, Integer poType) {
        ProtectGroup group = this.getProtectGroupBasicInfo(protectGroupId, false);
        StringBuilder hql = new StringBuilder(QUERY_PO_BY_PGID);
        ArrayList<Object> queryParams = new ArrayList<Object>();
        queryParams.add(protectGroupId);
        int allPoType = -1;
        if (poType != -1) {
            hql.append(" and poType = ?");
            queryParams.add(poType);
        }
        this.addOrder(hql, orderBy, isAsc);
        Page page = this.getBaseDao().pagedQuery(hql.toString(), pageNo, pageSize, queryParams.toArray());
        List results = (List)page.getResult();
        if (results == null || results.isEmpty() || group == null) {
            return page;
        }
        IProtectObjectProvider provider = this.getProtectObjectProvider(group.getPoType());
        List<ProtectObject> objects = this.castAsProtectObjects(group, results);
        provider.refreshProtectObjectProperties(objects);
        page.setResult(objects);
        return page;
    }

    private List<ProtectObject> castAsProtectObjects(ProtectGroup group, List<?> datas) {
        ArrayList<ProtectObject> objects = new ArrayList<ProtectObject>();
        List ids = this.getColumnData(datas, 0);
        List<?> values = this.executeNativeSql(QUERY_PO_PROPS, "ids", ids);
        Map<Object, Object> props = new HashMap();
        if (!VerifyUtil.isEmpty(values)) {
            props = this.groupPropItems(values);
        } else {
            logger.error((Object)"The props of protectObject is empty.");
        }
        boolean isAirGapSite = Optional.ofNullable(group).map(ProtectGroup::getProps).map(map -> (String)map.get("isAirGapType")).map(Boolean::parseBoolean).orElse(false);
        for (Object each : datas) {
            int i = 0;
            Object[] data = (Object[])each;
            if (VerifyUtil.isEmpty((Object[])data) || data.length < 7) {
                logger.error((Object)"ProtectGroupQueryServiceImpl: data length error.", 90160758786989L);
                continue;
            }
            ProtectObject object = new ProtectObject();
            String id = (String)data[i++];
            object.setUuid(id);
            object.setName((String)data[i++]);
            object.setMoUuid((String)data[i++]);
            object.setPoType(((Integer)data[i++]).intValue());
            object.setPoStatus(((Integer)data[i++]).intValue());
            object.setPoRecoveryStatus(((Integer)data[i++]).intValue());
            object.setProviderSN((String)data[i++]);
            object.setProps((Map)props.get(id));
            String vstoreId = (String)object.getProps().get("PROP_KEY_VSTORE_ID");
            if (isAirGapSite && !VerifyUtil.isEmpty((String)vstoreId)) {
                VstoreInfo vstoreInfo = StorageResourceServiceRouter.getInstance().getVstoreById(object.getProviderSN(), vstoreId);
                object.getProps().put("vstoreName", vstoreInfo.getName());
            }
            object.setProtectGroup(group);
            objects.add(object);
        }
        return objects;
    }

    public void onBind(IProtectObjectProvider provider, Map<?, ?> properties) {
        this.providerMapping.put(provider.getProviderByType(), provider);
    }

    public void onUnbind(IProtectObjectProvider provider, Map<?, ?> properties) {
        this.providerMapping.remove(provider.getProviderByType());
    }

    public IProtectObjectProvider getProtectObjectProvider(Object type) {
        IProtectObjectProvider provider = this.providerMapping.get(type);
        if (null == provider) {
            logger.error((Object)("Could not get provider, protect object type is " + type), 90160758787071L);
            throw new LegoCheckedException(1073947395L);
        }
        return provider;
    }

    public List<ProtectObject> getProtectObjectListByUuid(List<String> uuid) {
        if (VerifyUtil.isEmpty(uuid)) {
            logger.error((Object)"uuid null.", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        return ProtectGroupHelper.getInstance().getProtectObjectListByUuid(uuid);
    }

    public List<ProtectGroup> getAllProtectGroupBasicInfo(Long userId, boolean isQueryReplica, boolean isQueryProps, boolean isQueryPos) {
        return QueryProtectGroupRefineService.getInstance().getAllProtectGroupBasicInfo(userId, isQueryReplica, isQueryProps, isQueryPos);
    }

    public List<ProtectObject> getProtectObjectListByMoUUID(List<String> moUuIds) {
        if (VerifyUtil.isEmpty(moUuIds)) {
            logger.error((Object)"failed to getProtectObjectListByMoUUID because of invalidity paramiter.", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        return ProtectGroupHelper.getInstance().getProtectObjectListByMoUUID(moUuIds);
    }

    public Map<Integer, IProtectObjectProvider> getProviderMapping() {
        return this.providerMapping;
    }

    private Map<String, String> getControllerLocations() {
        HashMap<String, String> controllerLocations = new HashMap<String, String>();
        List controllers = this.getMoDao().find("from Controller", new Object[0]);
        if (!VerifyUtil.isEmpty((Collection)controllers)) {
            for (Object object : controllers) {
                Controller controller = (Controller)object;
                String location = controller.getLocation();
                if (VerifyUtil.isEmpty((String)location) && !VerifyUtil.isEmpty((String)controller.getControllerType())) {
                    location = controller.getControllerType();
                }
                controllerLocations.put(controller.getUuid(), location);
                logger.info((Object)("controller uuid:" + controller.getUuid() + ", location:" + location));
            }
        }
        return controllerLocations;
    }

    private void fillControllerNameOfLun(StorageResource storageResource, Map<String, String> controllerLocations) {
        if (!(storageResource instanceof Lun) || VerifyUtil.isEmpty(controllerLocations)) {
            return;
        }
        Lun lun = (Lun)storageResource;
        String controllerUUID = lun.getDevSn() + "14:0:" + lun.getControllerId();
        if (lun instanceof XveLun) {
            controllerUUID = new XveUUID(lun.getDevSn(), XveMOType.CONTROLLER, lun.getControllerId()).toString();
        }
        if (VerifyUtil.isEmpty((String)controllerLocations.get(controllerUUID))) {
            logger.error((Object)("controller name is empty! lun id:" + lun.getLunId() + "lun name:" + lun.getName() + ",devSn:" + lun.getDevSn() + "controllerId:" + lun.getControllerId() + "controllerUUID:" + controllerUUID + ",Lun is XveLun?" + (lun instanceof XveLun)));
        }
        lun.setControllerName(controllerLocations.get(controllerUUID));
    }

    public ProtectGroup getProtectGroupByPolicyTemplateId(String policyTemplateId) {
        List pgIds = this.getBaseDao().getHibernateTemplate().find(QUERY_PG_BY_PTID, new Object[]{policyTemplateId});
        if (!VerifyUtil.isEmpty((Collection)pgIds)) {
            logger.info((Object)("protectGroupId is: " + (String)pgIds.get(0)), 90160758786989L);
            ProtectGroup pg = new ProtectGroup();
            pg.setUuid((String)pgIds.get(0));
            return pg;
        }
        return null;
    }

    public List<StorageObjectBo> getUseHypermetroStorage(String protectGroupId) {
        if (VerifyUtil.isEmpty((String)protectGroupId)) {
            logger.error((Object)"getUseHyperMetroStorage failed, protectGroupId is empty");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, false);
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            logger.error((Object)("ProtectGroup(" + protectGroupId + ") not exist"), 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        List protectObjectStorageInfoList = protectGroup.distinctStorageInfo();
        if (VerifyUtil.isEmpty((Collection)protectObjectStorageInfoList)) {
            logger.error((Object)"Protect object storage is null", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        ProtectObjectStorageInfo posi = (ProtectObjectStorageInfo)protectObjectStorageInfoList.stream().findAny().get();
        if (VerifyUtil.isEmpty((Object)posi.getResourceType())) {
            logger.error((Object)("posi.getResourceType() is empty! DeviceName : " + posi.getDeviceName()));
            throw new LegoCheckedException(1073947393L);
        }
        if (posi.getResourceType().intValue() == DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue()) {
            return this.queryLunHyperMetroStorageInfo(posi);
        }
        if (posi.getResourceType().intValue() == DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue()) {
            String deviceSn = posi.getResourceProviderSN();
            String vStorePairId = (String)protectGroup.getProps().get("PROP_KEY_VSTORE_PAIR_ID");
            return this.queryNasHyperMetroStorageInfo(deviceSn, vStorePairId);
        }
        logger.error((Object)("pg use storage resource type illegal, type is: " + posi.getResourceType()));
        throw new LegoCheckedException(1073947393L);
    }

    public List<Schedule> getAllSchedule(String protectGroupId) {
        Map<String, Object> protectGroup = this.getProtectGroupBriefInfo(protectGroupId);
        PolicyTemplate template = (PolicyTemplate)protectGroup.get("template");
        template.getSchedules().forEach(schedule -> schedule.setPolicyTemplate(template));
        this.updateSchedule(protectGroupId, template);
        template.getSchedules().forEach(ScriptParamsUtils::filterSensitiveParams);
        return new ArrayList<Schedule>(template.getSchedules());
    }

    public ProtectGroup getProtectGroupByID(String protectGroupId, boolean queryProtectObjectReplica) {
        ProtectGroup protectGroup = QueryProtectGroupRefineService.getInstance().getProtectGroupByID(protectGroupId, true);
        this.updateSchedule(protectGroup, protectGroup.getTemplate());
        return protectGroup;
    }

    public ProtectGroup getProtectGroupByID(String protectGroupId) {
        return this.getProtectGroupByID(protectGroupId, true);
    }

    public Page pagedQueryProtectGroup(int pageNo, int pageSize, String orderBy, boolean isAsc, List<QueryCondition> props, Long userId) {
        logger.info((Object)"pagedQueryProtectGroup");
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder hql = new StringBuilder(SELECT_PG);
        boolean flag = false;
        if (props != null) {
            for (QueryCondition prop : props) {
                if (!CommonUtil.isValidDbColumn((String)prop.getPropName())) {
                    throw new LegoCheckedException(1073947393L);
                }
                String name = prop.getPropName();
                Object value = prop.getPropValue();
                hql.append(flag ? " and " : " where ");
                boolean isName = "name".equals(name) || "productSiteName".equals(name);
                hql.append(isName ? "lower(" + name + ")" : name);
                boolean isStatus = "status".equals(name);
                if (isStatus) {
                    hql.append(" = ?");
                    params.add(NumberUtil.convertToInteger((Object)value));
                } else if (value instanceof String) {
                    hql.append(isName ? " like lower(?) escape '/'" : " like ? escape '/'");
                    String str = ((String)value).replaceAll("/", "//");
                    str = str.replaceAll("%", "/%");
                    str = str.replaceAll("_", "/_");
                    params.add("%" + str + "%");
                } else {
                    hql.append(" = ?");
                    params.add(value);
                }
                flag = true;
            }
        }
        this.appendUserBizCondition(hql, params, userId, flag);
        this.addOrder(hql, orderBy, isAsc);
        Page page = this.getBaseDao().pagedQuery(hql.toString(), pageNo, pageSize, params.toArray());
        List<ProtectGroup> results = (List<ProtectGroup>)page.getResult();
        results = this.convertDatasToProtectGroups(results);
        page.setResult(results);
        return page;
    }

    public Map<String, Object> getProtectGroupBriefInfo(String protectGroupId) {
        String hql = "select new map(p.pgId as pgId, p.poProviderSN as poProviderSN, p.name as name, p.primary as primary, p.description as description, p.productSiteId as productSiteId,d.name as siteName, p.productSiteName as productSiteName, p.template as template)from ProtectGroup p, DrResource d, PolicyTemplate pt where p.pgId = ? and p.template.ptId = pt.ptId and d.deviceSn = p.poProviderSN";
        List list = this.getBaseDao().getHibernateTemplate().find(hql, new Object[]{protectGroupId});
        if (VerifyUtil.isEmpty((Collection)list)) {
            logger.error((Object)"failed to query ProtectGroup.", 1073947394L);
            throw new LegoCheckedException(1073947394L, "failed to query ProtectGroup.");
        }
        Map result = (Map)list.get(0);
        result.put("poCount", this.getProtectGroupObjectCount(protectGroupId));
        result.put("replicaCount", this.getProtectGroupReplicaCount(protectGroupId));
        String sql = "select PGID, PROPNAME, PROPVALUE from ti_protectgroup_prop where PGID = :PGID";
        List<?> pgProps = this.executeNativeSql(sql, "PGID", protectGroupId);
        if (pgProps == null) {
            logger.error((Object)"pgProps is null!");
            return result;
        }
        Map<String, Map<String, String>> props = this.groupPropItems(pgProps);
        if (!VerifyUtil.isEmpty(props) && props.containsKey(protectGroupId)) {
            Map<String, String> prop = props.get(protectGroupId);
            prop.put("providerName", (String)result.get("siteName"));
            result.remove("siteName");
            result.put("props", prop);
        }
        return result;
    }

    public List<ProtectGroup> queryProtectGroups(Long userId) {
        return QueryProtectGroupRefineService.getInstance().queryProtectGroups(userId);
    }

    public List<ProtectGroupLogDetail> queryRunningHistoryLog(String protectGroupId) {
        if (VerifyUtil.isEmpty((String)protectGroupId)) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = this.getProtectGroupBasicInfo(protectGroupId, false);
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            throw new LegoCheckedException(1073947394L);
        }
        return this.queryPgRunningHistoryLog(protectGroupId);
    }

    public List<ProtectGroup> getAllProtectGroup(Long userId) {
        return QueryProtectGroupRefineService.getInstance().getAllProtectGroup(userId);
    }

    public List<ProtectGroup> getProtectGroupByType(int poType, Long userId) {
        return this.getProtectGroupByType(poType, userId, true);
    }

    public List<ProtectGroup> getProtectGroupByType(int poType, Long userId, boolean queryProtectObjectReplica) {
        return QueryProtectGroupRefineService.getInstance().getProtectGroupByType(poType, userId, queryProtectObjectReplica);
    }

    public long exportProtectGroupByType(User user, int poType, Locale locale, boolean isExportChecked) {
        if (isExportChecked) {
            ExportProtectGroupBackTask task = new ExportProtectGroupBackTask(user, poType, locale);
            return BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        }
        List<ProtectGroup> pgList = this.getProtectGroupByType(poType, user.getUserId(), false);
        CommUtil.checkObjectExists((Object[])new Object[]{pgList});
        ArrayList<ProtectGroup> tobeRemove = new ArrayList<ProtectGroup>();
        for (ProtectGroup protectgroup : pgList) {
            if (protectgroup.isPrimary()) continue;
            tobeRemove.add(protectgroup);
        }
        pgList.removeAll(tobeRemove);
        if (!VerifyUtil.isEmpty(tobeRemove) && VerifyUtil.isEmpty(pgList)) {
            logger.warn((Object)"protectgroups is empty", 90160758786989L);
            throw new LegoCheckedException(1073948198L);
        }
        return 0L;
    }

    public ProtectObject getProtectObjectByMoUUID(String protectGroupId, String uuId) {
        ProtectObject po = ProtectGroupHelper.getInstance().getProtectObjectByMoUUID(protectGroupId, uuId);
        if (VerifyUtil.isEmpty((Object)po)) {
            logger.error((Object)"po is empty!");
            throw new LegoCheckedException(1073947394L);
        }
        return po;
    }

    public List<ProtectObject> getAllProtectObjectByType(int poType) {
        List result = null;
        Session session = null;
        try {
            session = this.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria crit = session.createCriteria(ProtectObject.class);
            crit.add((Criterion)Restrictions.eq((String)"poType", (Object)poType));
            crit.createAlias("protectGroup", "protectGroup").add(Restrictions.isNotNull((String)"protectGroup.pgId"));
            result = crit.list();
        }
        catch (DataAccessException e) {
            try {
                logger.error((Object)"failed to query ProtectObject.", (Throwable)e, 90160758786896L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession(session);
        return result;
    }

    public Page pageQueryHistoryLogFromAll(int pageNo, int pageSize, String orderBy, boolean isAsc, String protectGroupId) {
        ProtectGroup protectGroup = this.getProtectGroupBasicInfo(protectGroupId, false);
        if (null == protectGroup) {
            logger.error((Object)("ProtectGroup does not exist.Id:" + protectGroupId), 90160758787071L);
            return Page.createPage((int)pageNo, (int)pageSize, Collections.emptyList());
        }
        Site site = this.getSiteService().getSiteById(protectGroup.getProductSiteId());
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.error((Object)("queryHistoryLogs error, site is null, siteId:" + protectGroup.getProductSiteId()), 90160758787071L);
            return Page.createPage((int)pageNo, (int)pageSize, Collections.emptyList());
        }
        return this.pageQueryHistoryLog(pageNo, pageSize, orderBy, isAsc, protectGroupId);
    }

    private Page pageQueryRemoteLogs(int pageNo, int pageSize, String orderBy, boolean isAsc, ProtectGroup protectGroup, Site site) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("protectGroupId", protectGroup.getUuid());
        uriVariables.put("startPage", pageNo);
        uriVariables.put("pageSize", pageSize);
        uriVariables.put("orderBy", orderBy);
        String orderType = "desc";
        if (isAsc) {
            orderType = "asc";
        }
        uriVariables.put("orderType", orderType);
        String result = this.getPageLogJson(site, uriVariables);
        JSONObject pageJson = JSONObject.fromObject((Object)result);
        JSONArray logJsons = new JSONArray();
        long totalSize = 0L;
        try {
            logJsons = JSONArray.fromObject((Object)pageJson.get("records"));
            totalSize = Long.parseLong(String.valueOf(pageJson.get("totalCount")));
        }
        catch (Exception e) {
            logger.error((Object)("from json object or get totalPage error.json:" + result + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        long start = (long)pageNo * (long)pageSize;
        List arrayList = JSONArray.toCollection((JSONArray)logJsons, ProtectGroupLog.class);
        return new Page(start, totalSize, pageSize, (Object)arrayList);
    }

    private String getPageLogJson(Site site, Map<String, Object> uriVariables) {
        RestClient client = SiteUtil.initClient(site);
        try {
            String url = "/ws/protectgroups/{protectGroupId}/logs?startPage={startPage}&pageSize={pageSize}&orderBy={orderBy}&orderType={orderType}";
            return client.invoke(url, uriVariables, HttpMethod.GET);
        }
        catch (LegoCheckedException e) {
            String errorMsg = "query HistoryLogs from remote site error";
            logger.error((Object)errorMsg, 90160758787071L);
            throw new LegoCheckedException(1073947440L, (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"getPageLogJson error");
            ExceptionUtil.rethrowException((Throwable)e, (String)"query HistoryLogs from remote site error", (long)1073947440L, (String[])new String[0], (Log)logger);
            return null;
        }
    }

    private Page pageQueryHistoryLog(int pageNo, int pageSize, String orderBy, boolean isAsc, String protectGroupId) {
        List<Object> result = new ArrayList();
        try {
            result = this.queryProtectGroupLogs(protectGroupId, 1, orderBy, isAsc);
        }
        catch (Exception e) {
            logger.error((Object)"pageQueryHistoryLog error");
            ExceptionUtil.rethrowException((Throwable)e, (String)"failed to query ProtectObject.", (long)-1L, (String[])new String[0], (Log)logger);
        }
        return Page.createPage((int)pageNo, (int)pageSize, result);
    }

    public List<ProtectGroupLogDetail> queryHistoryLogDetailFromAll(int historyLogId, String protectGroupId) {
        ProtectGroup protectGroup = this.getProtectGroupBasicInfo(protectGroupId, false);
        if (null == protectGroup) {
            logger.error((Object)("ProtectGroup does not exist. Id:" + protectGroupId), 90160758787071L);
            return Collections.emptyList();
        }
        Site site = this.getSiteService().getSiteById(protectGroup.getProductSiteId());
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.error((Object)("queryHistoryLogDetail error, site is null, siteId:" + protectGroup.getProductSiteId()), 90160758787071L);
            return Collections.emptyList();
        }
        return this.queryHistoryLogDetail(String.valueOf(historyLogId));
    }

    public List<ProtectLocationPath> getProtectLocations(String protectGroupId) {
        ArrayList<ProtectLocationPath> result = new ArrayList<ProtectLocationPath>();
        ProtectGroup pg = this.getProtectGroupByID(protectGroupId, false);
        Set<Integer> allProtectLocations = ProtectGroupUtil.getInstance().getAllPgProtectLocation(pg);
        block0: for (Integer location : allProtectLocations) {
            for (Schedule schedule : pg.getTemplate().getSchedules()) {
                if (!location.equals(NumberUtil.convertToInteger((Object)schedule.getProtectLocation()))) continue;
                String targetSiteId = schedule.getTargetSiteId();
                if (VerifyUtil.isEmpty((String)targetSiteId)) continue block0;
                ProtectLocationPath path = new ProtectLocationPath();
                path.setProtectLocation(location.intValue());
                path.setRecoverySiteId(schedule.getTargetSiteId());
                ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
                path.setRecoverySiteName(siteService.getSiteById(schedule.getTargetSiteId()).getName());
                result.add(path);
                continue block0;
            }
        }
        return result;
    }

    public Map<String, ProtectObject> getStorageInfoChangedProtectObjectList(ProtectGroup protectGroup) {
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            logger.error((Object)"parameter is error", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        HashMap protectObjectMap = new HashMap();
        for (ProtectObject po : protectGroup.getPolist()) {
            HashSet olderStorageInfo = new HashSet();
            olderStorageInfo.addAll(po.getUsedStorageResourceSet());
            protectObjectMap.put(po.getMoUuid(), olderStorageInfo);
        }
        IProtectObjectProvider provider = this.getProtectObjectProvider(protectGroup.getPoType());
        HashMap<String, ProtectObject> protectObjectListChanged = new HashMap<String, ProtectObject>();
        for (ProtectObject po : protectGroup.getPolist()) {
            HashSet<ProtectObjectStorageInfo> newerStorageInfo = new HashSet<ProtectObjectStorageInfo>();
            po.clearUsedStorageResource();
            ProtectObject object = null;
            try {
                object = (ProtectObject)po.clone();
            }
            catch (Exception e) {
                logger.error((Object)"getStorageInfoChangedProtectObjectList error");
                ExceptionUtil.rethrowException((Throwable)e, (String)"Error to clone ProtectObject", (long)-1L, (String[])new String[0], (Log)logger);
            }
            newerStorageInfo.addAll(provider.getProtectObjectStorageInfo(object));
            String drRingLimits = "DrRing.Limits";
            if (null == object) {
                logger.error((Object)"object is null");
                throw new LegoCheckedException(0x300001L);
            }
            Map props = object.getProps();
            if (props != null && props.containsKey(drRingLimits)) {
                po.getProps().put(drRingLimits, props.get(drRingLimits));
            }
            Set olderStorageInfo = (Set)protectObjectMap.get(po.getMoUuid());
            if (ProtectGroupHelper.getInstance().checkPoStorageInfoChanged(olderStorageInfo, newerStorageInfo)) {
                protectObjectListChanged.put(po.getMoUuid(), po);
            }
            po.clearUsedStorageResource();
            for (ProtectObjectStorageInfo protectObjectStorageInfo : newerStorageInfo) {
                po.addHostStorageResourceInfo(protectObjectStorageInfo);
            }
        }
        this.addProtectGroupReplicaChangedInfo(protectObjectListChanged, protectGroup);
        return protectObjectListChanged;
    }

    private void addProtectGroupReplicaChangedInfo(Map<String, ProtectObject> changed, ProtectGroup protectGroup) {
        Set replicaList = protectGroup.getReplicaList();
        if (VerifyUtil.isEmpty((Collection)replicaList)) {
            return;
        }
        Optional<ProtectGroupReplica> protectGroupReplicaOptional = replicaList.stream().filter(pgReplica -> !ReplicaUtil.isLocalStorageReplica((ProtectGroupReplica)pgReplica)).findFirst();
        if (!protectGroupReplicaOptional.isPresent()) {
            return;
        }
        ProtectGroupReplica replica = protectGroupReplicaOptional.get();
        if (replica.getReplicas().size() == protectGroup.getPolist().size()) {
            return;
        }
        Set invalidPoIdSet = replica.getReplicas().stream().map(ProtectObjectReplica::getPoId).collect(Collectors.toSet());
        for (ProtectObject protectObject : protectGroup.getPolist()) {
            invalidPoIdSet.remove(protectObject.getUuid());
        }
        logger.info((Object)"find invalid protectObjectReplica in protectGroupReplica: poIds=%s", new Object[]{invalidPoIdSet});
        ProtectObject protectObject = new ProtectObject();
        for (String invalidPoId : invalidPoIdSet) {
            changed.put(invalidPoId, protectObject);
        }
    }

    private List<ProtectGroupLogDetail> queryPgRunningHistoryLog(String protectGroupId) {
        try {
            ProtectGroupLog pglog = this.getRunningProtectGroupLog(protectGroupId);
            if (null == pglog) {
                return null;
            }
            return this.queryHistoryLogDetail(pglog.getHistoryLogId() + "");
        }
        catch (Exception e) {
            logger.error((Object)("queryRunningHistoryLog error" + ExceptionUtil.getErrorMessage((Throwable)e)));
            ExceptionUtil.rethrowException((Throwable)e, (String)"failed to query ProtectObject.", (long)-1L, (String[])new String[0], (Log)logger);
            return new ArrayList<ProtectGroupLogDetail>();
        }
    }

    private List<ProtectGroupLogDetail> queryPgRunningHistoryLog(ProtectGroup protectGroup) {
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            throw new LegoCheckedException(1073947393L);
        }
        Site productSite = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(protectGroup.getProductSiteId());
        if (VerifyUtil.isEmpty((Object)productSite)) {
            throw new LegoCheckedException(1073947394L);
        }
        RestClient client = SiteUtil.initClient(productSite);
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("protectGroupId", protectGroup.getUuid());
        uriVariables.put("logId", -1);
        String result = client.invoke("/ws/protectgroups/{protectGroupId}/logs/{logId}/details", uriVariables, HttpMethod.GET);
        List<ProtectGroupLogDetail> pgLogDetails = ProtectGroupUtil.getInstance().transJsonToLogDetail(result);
        return pgLogDetails;
    }

    private long getProtectGroupObjectCount(String protectGroupId) {
        String hql = "select count(uuid) from ProtectObject where protectGroup.pgId = ?";
        return this.getCountResult(hql, protectGroupId);
    }

    private long getProtectGroupReplicaCount(String protectGroupId) {
        String hql = "select count(id) from ProtectGroupReplica where pg.pgId = ?";
        return this.getCountResult(hql, protectGroupId);
    }

    private long getCountResult(String hql, String arg) {
        List list = this.getBaseDao().getHibernateTemplate().find(hql, new Object[]{arg});
        if (VerifyUtil.isEmpty((Collection)list)) {
            return 0L;
        }
        Long count = (Long)list.get(0);
        return count != null ? count : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ProtectGroup> convertDatasToProtectGroups(List<?> datas) {
        ArrayList<ProtectGroup> items = new ArrayList<ProtectGroup>();
        if (VerifyUtil.isEmpty(datas)) {
            return items;
        }
        List<String> ids = this.getColumnData(datas, 0);
        List<?> counts = null;
        Map<String, Map<String, String>> props = null;
        List<PolicyTemplate> templates = null;
        Session session = null;
        try {
            session = this.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            counts = this.getProtectGroupObjectCounts(ids);
            props = this.getProtectGroupProps(session, ids);
            templates = this.getProtectTemplates(session, datas);
        }
        catch (Exception e) {
            try {
                ExceptionUtil.rethrowException((Throwable)e, (String)"Query infomation for ProtectGroup failed.", (long)-1L, (String[])new String[0], (Log)logger);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        for (String id : ids) {
            Object[] result = ProtectGroupUtil.getInstance().getItemByPgId(datas, id);
            if (result == null || result.length <= 1) continue;
            int count = ProtectGroupUtil.getInstance().getProtectGroupObjectCount(counts, id);
            PolicyTemplate template = this.getPolicyTemplateByPgId(templates, (String)result[result.length - 1]);
            if (props == null) {
                logger.error((Object)"props is null!");
                return items;
            }
            Map<String, String> prop = props.get(id);
            items.add(this.getAndFillProtectGroup(result, template, prop, count));
        }
        return items;
    }

    private List<?> getProtectGroupObjectCounts(List<String> ids) {
        return this.getBaseDao().getHibernateTemplate().findByNamedParam(COUNT_PO, "ids", ids);
    }

    private Map<String, Map<String, String>> getProtectGroupProps(Session session, List<String> ids) {
        String sql = "select PGID, PROPNAME, PROPVALUE from ti_protectgroup_prop where PGID in(:ids)";
        NativeQuery query = session.createSQLQuery(sql);
        query.setParameterList("ids", ids);
        List props = query.list();
        Map<String, Map<String, String>> map = this.groupPropItems(props);
        return map;
    }

    private ProtectGroup getAndFillProtectGroup(Object[] data, PolicyTemplate template, Map<String, String> props, int count) {
        int i = 0;
        ProtectGroup protectGroup = new ProtectGroup();
        if (data == null || data.length < 11) {
            return null;
        }
        protectGroup.setUuid((String)data[i++]);
        protectGroup.setPoType(((Integer)data[i++]).intValue());
        protectGroup.setPoProviderSN((String)data[i++]);
        protectGroup.setName((String)data[i++]);
        protectGroup.setStatus(((Integer)data[i++]).intValue());
        String siteId = (String)data[i++];
        protectGroup.setProductSiteId(siteId);
        protectGroup.setProductSiteName((String)data[i++]);
        Site site = this.getSiteService().getSiteById(siteId);
        protectGroup.setProductSiteName(site.getName());
        protectGroup.setLastExecTime((Long)data[i++]);
        protectGroup.setLastExecResult((Integer)data[i++]);
        protectGroup.setPgReplicaIndex(((Integer)data[i++]).intValue());
        protectGroup.setPrimary(((Boolean)data[i++]).booleanValue());
        protectGroup.setPolist(new HashSet(count));
        protectGroup.setProps(props);
        protectGroup.setTemplate(template);
        return protectGroup;
    }

    private PolicyTemplate getPolicyTemplateByPgId(List<PolicyTemplate> templates, String id) {
        PolicyTemplate template = null;
        for (PolicyTemplate each : templates) {
            if (!each.getPtId().equals(id)) continue;
            template = each;
            break;
        }
        return template;
    }

    private List<PolicyTemplate> getProtectTemplates(Session session, List<?> groups) {
        ArrayList<PolicyTemplate> templates = new ArrayList<PolicyTemplate>();
        List ids = this.getColumnData(groups, -1);
        String sql = "select PTID, NAME, VIEWTEMPLATEURL, TYPE from ti_policytemplate where PTID in(:ids)";
        NativeQuery query = session.createSQLQuery(sql);
        query.setParameterList("ids", ids);
        List datas = query.list();
        for (Object each : datas) {
            Object[] data = (Object[])each;
            PolicyTemplate template = new PolicyTemplate();
            int i = 0;
            if (data == null || data.length < 4) continue;
            template.setPtId((String)data[i++]);
            template.setName((String)data[i++]);
            template.setViewTemplateUrl((String)data[i++]);
            template.setType(((Integer)data[i++]).intValue());
            templates.add(template);
        }
        return templates;
    }

    private List<StorageObjectBo> queryLunHyperMetroStorageInfo(ProtectObjectStorageInfo posi) {
        String lunWWN = posi.getLunWWN();
        if (VerifyUtil.isEmpty((String)lunWWN)) {
            logger.error((Object)"lunWWN is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        List resources = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(new String[]{lunWWN});
        if (VerifyUtil.isEmpty((Collection)resources) || resources.size() != 2) {
            logger.error((Object)("method[getSrcDeviceSN()]. Resources is empty or the size is not two! resources size:" + resources), 90160758786897L);
            throw new LegoCheckedException(1073947393L);
        }
        StorageObjectBo srcBo = this.constructStorageObjectBo(lunWWN, ((StorageResource)resources.get(0)).getDevSn());
        StorageObjectBo remoteBo = this.constructStorageObjectBo(lunWWN, ((StorageResource)resources.get(1)).getDevSn());
        ArrayList<StorageObjectBo> storage = new ArrayList<StorageObjectBo>();
        storage.add(srcBo);
        storage.add(remoteBo);
        return storage;
    }

    private StorageObjectBo constructStorageObjectBo(String lunWWN, String devSn) {
        IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        StorageNE storageArray = storageService.getStorageBySn(devSn, null);
        if (VerifyUtil.isEmpty((Object)storageArray)) {
            logger.error((Object)("StorageNE is empty, devSn is: " + devSn));
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<String> wwns = new ArrayList<String>();
        wwns.add(lunWWN);
        List<HyperMetroPair> pairList = StorageResourceServiceRouter.getInstance().getHyperMetroPairsByWwns(null, wwns, null, devSn, true);
        if (VerifyUtil.isEmpty(pairList)) {
            logger.error((Object)("HyperMetroPair List is emtpty." + wwns));
            throw new LegoCheckedException(1073947393L);
        }
        HyperMetroPair pair = (HyperMetroPair)CommonUtil.getFirstElement(pairList);
        int priorityStationType = 0;
        if (!pair.getIsPrimary().booleanValue()) {
            priorityStationType = 1;
        }
        StorageObjectBo bo = new StorageObjectBo();
        bo.setDevSn(devSn);
        bo.setName(storageArray.getName());
        bo.setPriorityStationType(priorityStationType);
        return bo;
    }

    private List<StorageObjectBo> queryNasHyperMetroStorageInfo(String deviceSn, String vStorePairId) {
        if (VerifyUtil.isEmpty((String)deviceSn) || VerifyUtil.isEmpty((String)vStorePairId)) {
            logger.error((Object)("deviceSn or vStoreId is emtpty, vStorePairId: " + vStorePairId + " deviceSn: " + deviceSn));
            throw new LegoCheckedException(1073947393L);
        }
        VstoreHyperMetroPair vstoreHyperMetroPair = StorageResourceServiceRouter.getInstance().getVstoreHyperMetroPairByVstorePairId(deviceSn, vStorePairId);
        if (VerifyUtil.isEmpty((Object)vstoreHyperMetroPair)) {
            logger.error((Object)"The vstoreHyperMetroPair does not exist.");
            throw new LegoCheckedException(1073947393L);
        }
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteByDeviceSn(deviceSn);
        List<VstoreHyperMetroPair> vstoreHyperMetroPairs = StorageResourceServiceRouter.getInstance().getVstoreHyperPair(site.getServerUuid(), vstoreHyperMetroPair);
        HashSet<String> devSNSet = new HashSet<String>();
        devSNSet.add(deviceSn);
        for (VstoreHyperMetroPair pair : vstoreHyperMetroPairs) {
            ManagedObject managedObject = pair.getParentMo();
            if (!(managedObject instanceof HvsUnit)) continue;
            devSNSet.add(((HvsUnit)managedObject).getDevSn());
        }
        if (devSNSet.size() != 2) {
            logger.error((Object)("method[queryNasHyperMetroStorageInfo()]. DevSNSet is empty or the size is not two! devSNSet size:" + devSNSet), 90160758786897L);
            throw new LegoCheckedException(1073947393L);
        }
        String active = vstoreHyperMetroPair.getActiveOrPassive();
        if (VerifyUtil.isEmpty((String)active)) {
            HyperMetroDomain hyperMetroDomain = ((IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class)).getHyperMetroDomainById(vstoreHyperMetroPair.getDomainId(), false);
            active = hyperMetroDomain.getServiceStatus();
        }
        return this.constructNasStorageObjectBo(deviceSn, active, devSNSet);
    }

    private List<StorageObjectBo> constructNasStorageObjectBo(String deviceSn, String activeOrPassive, Set<String> devSNSet) {
        HashSet<String> types = new HashSet<String>();
        types.add(String.valueOf(XveEuumDefineParent.VSTOREPAIR_ACTIVATION_STATUS_E.ACTIVE.getValue()));
        types.add(String.valueOf(XveEuumDefineParent.VSTOREPAIR_ACTIVATION_STATUS_E.PASSIVE.getValue()));
        if (!types.contains(activeOrPassive)) {
            logger.error((Object)("activeOrPassive is error, activeOrPassive: " + activeOrPassive));
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<StorageObjectBo> list = new ArrayList<StorageObjectBo>();
        IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        for (String devSn : devSNSet) {
            StorageNE storageArray = storageService.getStorageBySn(devSn, null);
            if (VerifyUtil.isEmpty((Object)storageArray)) {
                logger.error((Object)("StorageNE is empty, devSn is: " + devSn));
                throw new LegoCheckedException(1073947393L);
            }
            StorageObjectBo bo = new StorageObjectBo();
            bo.setDevSn(devSn);
            bo.setName(storageArray.getName());
            int srcVstorePairStatus = Integer.parseInt(activeOrPassive);
            if (deviceSn.equals(devSn)) {
                bo.setPriorityStationType(srcVstorePairStatus);
            } else if (XveEuumDefineParent.VSTOREPAIR_ACTIVATION_STATUS_E.ACTIVE.getValue() == srcVstorePairStatus) {
                bo.setPriorityStationType(XveEuumDefineParent.VSTOREPAIR_ACTIVATION_STATUS_E.PASSIVE.getValue());
            } else {
                bo.setPriorityStationType(XveEuumDefineParent.VSTOREPAIR_ACTIVATION_STATUS_E.ACTIVE.getValue());
            }
            list.add(bo);
        }
        return list;
    }

    public List<DiskInfo> queryDiskInfo(String protectGroupId) {
        if (VerifyUtil.isEmpty((String)protectGroupId)) {
            logger.error((Object)"getUseHyperMetroStorage failed, protectGroupId is empty");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, true);
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            logger.error((Object)("ProtectGroup(" + protectGroup.getUuid() + ") not exist"), 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        return this.queryDiskInfo(protectGroup);
    }

    public List<DiskInfo> queryDiskInfo(ProtectGroup protectGroup) {
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            logger.error((Object)"Do getUseHyperMetroStorage failed, protectGroupId is empty");
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, List<ProtectObject>> storagePoMap = new HashMap<String, List<ProtectObject>>();
        HashMap<String, ProtectObjectStorageInfo> poStorageMap = new HashMap<String, ProtectObjectStorageInfo>();
        HashMap<String, List<RelicaStorageInfo>> storageReplicaMap = new HashMap<String, List<RelicaStorageInfo>>();
        HashMap<String, StorageResource> storageResourceMap = new HashMap<String, StorageResource>();
        this.getStorageMap(protectGroup, storagePoMap, poStorageMap, storageReplicaMap, storageResourceMap);
        ArrayList<DiskInfo> diskInfos = new ArrayList<DiskInfo>();
        this.getDiskInfoFromPo(storagePoMap, poStorageMap, storageReplicaMap, storageResourceMap, diskInfos);
        this.getDiskInfoFromReplica(storagePoMap, poStorageMap, storageReplicaMap, storageResourceMap, diskInfos);
        this.checkLunToBeExpand(diskInfos);
        ArrayList storagePairs = new ArrayList();
        String replicationCfg = (String)protectGroup.getProps().get("storagePoolMapping");
        if (!VerifyUtil.isEmpty((String)replicationCfg)) {
            List pairs = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)replicationCfg), StoragePair.class);
            storagePairs.addAll(pairs);
        }
        HashMap<String, String> poolIdAndNameInfoMap = new HashMap<String, String>();
        List storagePoolInfos = CommonDAOLocator.getMoDao().find("from StoragePool", new Object[0]);
        if (!VerifyUtil.isEmpty((Collection)storagePoolInfos)) {
            for (StoragePool pool : storagePoolInfos) {
                poolIdAndNameInfoMap.put(pool.getPoolId(), pool.getName());
                poolIdAndNameInfoMap.put(CommUtil.combineString((String[])new String[]{pool.getNeSN(), pool.getPoolId()}), pool.getName());
            }
        }
        diskInfos.stream().forEach(diskInfo -> {
            String poolId = diskInfo.getPoolId();
            if (null == poolId) {
                return;
            }
            String poolName = (String)poolIdAndNameInfoMap.get(CommUtil.combineString((String[])new String[]{diskInfo.getDevSn(), poolId}));
            if (null != poolName) {
                diskInfo.setPoolName(poolName);
            }
            this.setRecoveryPools((Map<String, String>)poolIdAndNameInfoMap, (DiskInfo)diskInfo, storagePairs, diskInfo.getDevSn(), diskInfo.getPoolId());
        });
        if (logger.isDebugEnabled()) {
            ProtectGroupQueryServiceImpl.logDiskInfo(protectGroup.getName(), diskInfos);
        }
        return diskInfos;
    }

    public static void logDiskInfo(String pgName, List<DiskInfo> diskInfos) {
        if (null == diskInfos) {
            return;
        }
        JSONArray diskJSONArray = new JSONArray();
        diskInfos.stream().map(diskInfo -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"devSn", (Object)diskInfo.getDevSn());
            jsonObject.put((Object)"resourceId", (Object)diskInfo.getResourceId());
            jsonObject.put((Object)"deviceName", (Object)diskInfo.getDeviceName());
            jsonObject.put((Object)"poolId", (Object)diskInfo.getPoolId());
            jsonObject.put((Object)"poolName", (Object)diskInfo.getPoolName());
            jsonObject.put((Object)"status", (Object)diskInfo.getStatus());
            JSONArray poArray = new JSONArray();
            diskInfo.getProtectObjects().stream().map(po -> {
                JSONObject poJsonObj = new JSONObject();
                poJsonObj.put((Object)"moUuid", (Object)po.getMoUuid());
                poJsonObj.put((Object)"name", (Object)po.getName());
                return poJsonObj;
            }).forEach(o -> poArray.add(o));
            jsonObject.put((Object)"protectObjects", (Object)poArray);
            jsonObject.put((Object)"recoveryPools", (Object)JSONArray.fromObject((Object)diskInfo.getRecoveryPools()));
            return jsonObject;
        }).forEach(o -> diskJSONArray.add(o));
        String str = diskJSONArray.toString();
        logger.info((Object)("protectGroup:" + pgName + " diskInfos:" + str));
    }

    private void getDiskInfoFromReplica(Map<String, List<ProtectObject>> storagePoMap, Map<String, ProtectObjectStorageInfo> poStorageMap, Map<String, List<RelicaStorageInfo>> storageReplicaMap, Map<String, StorageResource> storageResourceMap, List<DiskInfo> diskInfos) {
        for (Map.Entry<String, List<RelicaStorageInfo>> entry : storageReplicaMap.entrySet()) {
            ProtectObjectStorageInfo poStorageInfo;
            String key = entry.getKey();
            if (storagePoMap.containsKey(key)) continue;
            String devSn = key.split("-")[0];
            String resourceId = key.split("-")[1];
            String deviceName = "--";
            String poolId = "--";
            String poolName = "--";
            StorageResource storageResource = storageResourceMap.get(key);
            if (null != storageResource && storageResource instanceof Lun) {
                Lun lun = (Lun)storageResource;
                poolId = lun.getStoragePoolId();
                poolName = lun.getStoragePoolName();
            }
            if (null != (poStorageInfo = poStorageMap.get(key))) {
                deviceName = poStorageInfo.getDeviceName();
            }
            List<RelicaStorageInfo> list = entry.getValue();
            ArrayList<ProtectObject> protectObjects = new ArrayList<ProtectObject>();
            HashSet<String> poMoUuidSet = new HashSet<String>();
            DiskInfo diskInfo = new DiskInfo();
            for (RelicaStorageInfo relicaStorageInfo : list) {
                if (null == relicaStorageInfo.getPoReplica() || null == relicaStorageInfo.getPoReplica().getProtectObject()) {
                    logger.error((Object)("can not find protectobject for:" + relicaStorageInfo.toJson().toString()));
                    continue;
                }
                ProtectObject po = relicaStorageInfo.getPoReplica().getProtectObject();
                if (poMoUuidSet.contains(po.getMoUuid())) continue;
                poMoUuidSet.add(po.getMoUuid());
                protectObjects.add(po);
            }
            String status = DiskProtectStatusEnum.REMOVED.getStatus();
            diskInfo.setDevSn(devSn);
            diskInfo.setResourceId(resourceId);
            diskInfo.setDeviceName(deviceName);
            diskInfo.setStatus(status);
            diskInfo.setPoolId(poolId);
            diskInfo.setPoolName(poolName);
            diskInfo.setProtectObjects(protectObjects);
            diskInfos.add(diskInfo);
        }
    }

    private void getDiskInfoFromPo(Map<String, List<ProtectObject>> storagePoMap, Map<String, ProtectObjectStorageInfo> poStorageMap, Map<String, List<RelicaStorageInfo>> storageReplicaMap, Map<String, StorageResource> storageResourceMap, List<DiskInfo> diskInfos) {
        for (Map.Entry<String, List<ProtectObject>> entry : storagePoMap.entrySet()) {
            ProtectObjectStorageInfo poStorageInfo;
            String key = entry.getKey();
            DiskInfo diskInfo = new DiskInfo();
            String devSn = key.split("-")[0];
            String resourceId = key.split("-")[1];
            String deviceName = "--";
            String poolId = "--";
            String poolName = "--";
            Long capacity = 0L;
            StorageResource storageResource = storageResourceMap.get(key);
            if (null != storageResource && storageResource instanceof Lun) {
                Lun lun = (Lun)storageResource;
                poolId = lun.getStoragePoolId();
                capacity = lun.getTotalCapacity().longValue();
                poolName = lun.getStoragePoolName();
            }
            if (null != (poStorageInfo = poStorageMap.get(key))) {
                deviceName = poStorageInfo.getDeviceName();
            }
            String status = DiskProtectStatusEnum.PROTECTED.getStatus();
            if (!storageReplicaMap.containsKey(key)) {
                status = DiskProtectStatusEnum.UNPROTECTED.getStatus();
            } else {
                storageReplicaMap.get(key).forEach(relicaStorageInfo -> {
                    SubDiskInfo subDiskInfo = new SubDiskInfo();
                    subDiskInfo.setResourceId(relicaStorageInfo.getStorageId());
                    subDiskInfo.setDevSn(relicaStorageInfo.getStorageProviderSN());
                    diskInfo.getSubDiskInfo().add(subDiskInfo);
                });
            }
            diskInfo.setDevSn(devSn);
            diskInfo.setResourceId(resourceId);
            diskInfo.setDeviceName(deviceName);
            diskInfo.setStatus(status);
            diskInfo.setPoolId(poolId);
            diskInfo.setPoolName(poolName);
            diskInfo.setCapacity(capacity);
            diskInfo.setProtectObjects(entry.getValue());
            diskInfos.add(diskInfo);
        }
    }

    private void getStorageMap(ProtectGroup protectGroup, Map<String, List<ProtectObject>> storagePoMap, Map<String, ProtectObjectStorageInfo> poStorageMap, Map<String, List<RelicaStorageInfo>> storageReplicaMap, Map<String, StorageResource> storageResourceMap) {
        HashMap deviceStorageMap = new HashMap();
        Set polist = protectGroup.getPolist();
        for (ProtectObject protectObject : polist) {
            Set set = protectObject.getUsedStorageResourceSet();
            for (Object poStorageInfo : set) {
                if (VerifyUtil.isEmpty((String)poStorageInfo.getResourceProviderSN()) || VerifyUtil.isEmpty((String)poStorageInfo.getResourceId())) continue;
                String key = CommUtil.combineString((String[])new String[]{poStorageInfo.getResourceProviderSN(), poStorageInfo.getResourceId()});
                CommUtil.addToMap(storagePoMap, (String)key, (Object)protectObject);
                poStorageMap.put(key, (ProtectObjectStorageInfo)poStorageInfo);
                CommUtil.addToMap(deviceStorageMap, (String)poStorageInfo.getResourceProviderSN(), (Object)poStorageInfo.getResourceId());
            }
        }
        Set replicaList = protectGroup.getReplicaList();
        for (ProtectGroupReplica protectGroupReplica : replicaList) {
            Set replicas = protectGroupReplica.getReplicas();
            for (ProtectObjectReplica protectObjectReplica : replicas) {
                Set storageInfos = protectObjectReplica.getStorageInfos();
                for (RelicaStorageInfo storageInfo : storageInfos) {
                    String key = CommUtil.combineString((String[])new String[]{storageInfo.getSrcStorageProviderSN(), storageInfo.getSrcStorageId()});
                    CommUtil.addToMap(storageReplicaMap, (String)key, (Object)storageInfo);
                    CommUtil.addToMap(deviceStorageMap, (String)storageInfo.getSrcStorageProviderSN(), (Object)storageInfo.getSrcStorageId());
                }
            }
        }
        for (Map.Entry entry : deviceStorageMap.entrySet()) {
            String deviceSn = (String)entry.getKey();
            List idList = (List)entry.getValue();
            List storageRes = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResources(deviceSn, idList, DrmEnumDefine.RESOURCE_TYPE_E.LUN);
            for (StorageResource storageResource : storageRes) {
                storageResourceMap.put(CommUtil.combineString((String[])new String[]{deviceSn, storageResource.getResourceId()}), storageResource);
            }
        }
    }

    private void setRecoveryPools(Map<String, String> poolIdAndNameMap, DiskInfo diskInfo, List<StoragePair> storagePairs, String devSn, String poolId) {
        if (VerifyUtil.isEmpty(storagePairs)) {
            return;
        }
        List recoveryStoragePairs = storagePairs.stream().filter(pair -> pair.getSrcDevSN().equals(devSn)).collect(Collectors.toList());
        if (VerifyUtil.isEmpty(recoveryStoragePairs)) {
            return;
        }
        for (StoragePair pair2 : recoveryStoragePairs) {
            Map storagePools = pair2.getStoragePools();
            String recoveryPoolId = (String)storagePools.get(poolId);
            if (VerifyUtil.isEmpty((String)recoveryPoolId)) {
                logger.error((Object)("can not find recoveryPoolId for:" + poolId));
                continue;
            }
            DiskStoragePool diskStoragePool = new DiskStoragePool();
            diskStoragePool.setDevSn(pair2.getTgtDevSN());
            diskStoragePool.setPoolId(recoveryPoolId);
            diskStoragePool.setPoolName(poolIdAndNameMap.get(CommUtil.combineString((String[])new String[]{diskStoragePool.getDevSn(), diskStoragePool.getPoolId()})));
            if (null != diskInfo.getRecoveryPools()) {
                diskInfo.getRecoveryPools().add(diskStoragePool);
            } else {
                diskInfo.setRecoveryPools(Arrays.asList(diskStoragePool));
            }
            this.setRecoveryPools(poolIdAndNameMap, diskInfo, storagePairs, diskStoragePool.getDevSn(), diskStoragePool.getPoolId());
        }
    }

    private void checkLunToBeExpand(List<DiskInfo> diskInfos) {
        HashMap lunInfo = new HashMap();
        diskInfos.forEach(diskInfo -> diskInfo.getSubDiskInfo().forEach(diskInfo1 -> {
            if (lunInfo.containsKey(diskInfo1.getDevSn())) {
                ((List)lunInfo.get(diskInfo1.getDevSn())).add(diskInfo1.getResourceId());
            } else {
                ArrayList<String> lunId = new ArrayList<String>();
                lunId.add(diskInfo1.getResourceId());
                lunInfo.put(diskInfo1.getDevSn(), lunId);
            }
        }));
        ArrayList<Lun> lunList = new ArrayList<Lun>();
        for (Map.Entry entry : lunInfo.entrySet()) {
            String devSn = (String)entry.getKey();
            List targetLuns = (List)entry.getValue();
            logger.info((Object)String.format("query lun info devSn: %s and targetLuns : %s", devSn, targetLuns.toString()));
            List<Lun> lunLists = StorageResourceServiceRouter.getInstance().getStorageResourcesByIds(devSn, targetLuns, Lun.class);
            if (lunLists.isEmpty()) continue;
            lunList.addAll(lunLists);
        }
        diskInfos.stream().filter(diskInfo -> DiskProtectStatusEnum.PROTECTED.getStatus().equals(diskInfo.getStatus())).forEach(diskInfo -> this.checkLunToBeExpandForDiskInfo((List<Lun>)lunList, (DiskInfo)diskInfo));
    }

    private void checkLunToBeExpandForDiskInfo(List<Lun> lunList, DiskInfo diskInfo) {
        diskInfo.getSubDiskInfo().forEach(subDiskInfo -> this.checkLunToBeExpandForSubDiskInfos(lunList, diskInfo, (SubDiskInfo)subDiskInfo));
    }

    private void checkLunToBeExpandForSubDiskInfos(List<Lun> lunList, DiskInfo diskInfo, SubDiskInfo subDiskInfo) {
        lunList.forEach(lun -> this.checkLunToBeExpandForSubDiskInfo(diskInfo, subDiskInfo, (Lun)lun));
    }

    private void checkLunToBeExpandForSubDiskInfo(DiskInfo diskInfo, SubDiskInfo subDiskInfo, Lun lun) {
        if (lun.getDevSn().equals(subDiskInfo.getDevSn()) && lun.getResourceId().equals(subDiskInfo.getResourceId()) && lun.getTotalCapacity() < (double)diskInfo.getCapacity().longValue()) {
            logger.info((Object)("Src lun id : " + diskInfo.getResourceId() + " capacity : " + diskInfo.getCapacity() + " and targetLun id : " + lun.getResourceId() + " capacity :" + lun.getTotalCapacity()));
            subDiskInfo.setCapacity(Long.valueOf(lun.getTotalCapacity().longValue()));
            subDiskInfo.setName(lun.getName());
            diskInfo.setStatus(DiskProtectStatusEnum.EXPANDED.getStatus());
        }
    }
}

