/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailSnapshot;
import com.huawei.ism.drm.anti.blackmail.util.AntiBlackmailResourceLockUtil;
import com.huawei.ism.drm.anti.blackmail.util.AntiBlackmailUtil;
import com.huawei.ism.drm.base.service.ITaskManager;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupServiceImpl;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotScheduleManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotScheduleManager;
import com.huawei.ism.drm.storage.sdk.model.SnapshotSchedule;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public class RefreshProtectGroupBackTask
extends AbstractBackTask
implements TransactionCallback {
    private static final Log logger = LogFactory.getInstance(RefreshProtectGroupBackTask.class);
    private static List<Integer> supportPtTransferList = Arrays.asList(3, 5);
    private ProtectGroupServiceImpl service;
    private ProtectGroup protectGroup;

    public RefreshProtectGroupBackTask(ProtectGroupServiceImpl service, ProtectGroup protectGroup) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)protectGroup.getName(), (String)"ism.drm.pg.ref.log.motion", (String)"System", (String)"", null), true);
        this.service = service;
        this.protectGroup = protectGroup;
        String protectGroupId = protectGroup.getUuid();
        service.lockProtectGroup(protectGroupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWork() {
        this.protectGroup = this.service.getProtectGroupByID(this.protectGroup.getUuid());
        Long errorCode = 0L;
        String protectGroupId = this.protectGroup.getUuid();
        int protectGroupStatus = this.protectGroup.getStatus();
        MessageEvent event = this.constructUpdateMessage();
        try {
            this.service.notifyObserverList(event, "before");
            this.service.getBaseDao().getTransactionTemplate().execute((TransactionCallback)this);
            this.service.notifyObserverList(event, "after");
        }
        catch (LegoCheckedException e) {
            errorCode = e.getErrorCode();
            if (0L == errorCode) {
                errorCode = -1L;
            }
            logger.error((Object)"failed to refresh protectobject.", (Throwable)e, errorCode.longValue());
            ExceptionUtil.rethrowException((Exception)((Object)e), (String)"failed to refresh protectobject!", (long)errorCode, (String[])e.getParameters());
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"failed to refresh protectobject.", (long)-1L, (String[])new String[0], (Log)logger);
        }
        finally {
            this.doFinishWork(errorCode, protectGroupId, protectGroupStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFinishWork(Long errorCode, String protectGroupId, int protectGroupStatus) {
        try {
            boolean refreshResult = ProtectGroupUtil.refreshProtectGroupReplicas(protectGroupId);
            if (DrmEnumDefine.PROTECT_GROUP_STATUS.INVALID.getStatus() == protectGroupStatus) {
                this.recoveryProtectGroupRelativeStatus(errorCode, protectGroupId, refreshResult);
            } else {
                this.refreshProtectGroupStatus(errorCode, protectGroupId, refreshResult);
            }
        }
        finally {
            ProtectionJobUtil.getInstance().releaseLockPg(protectGroupId);
        }
    }

    private void refreshProtectGroupStatus(Long errorCode, String protectGroupId, boolean refreshResult) {
        this.service.unlockProtectGroup(protectGroupId);
        if (0L == errorCode && refreshResult) {
            this.service.updateProtectGroupStatus(DrmEnumDefine.PROTECT_GROUP_STATUS.NORMAL, protectGroupId);
            return;
        }
        AlarmReporter.sendAlarm(52625421L, this.protectGroup.getUuid(), FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), FaultEnum.AlarmSeverity.CRITICAL, this.protectGroup.getUuid(), this.protectGroup.getName(), this.protectGroup.getPoProviderSN());
        this.service.updateProtectGroupStatus(DrmEnumDefine.PROTECT_GROUP_STATUS.INVALID, protectGroupId);
    }

    private void recoveryProtectGroupRelativeStatus(Long errorCode, String protectGroupId, boolean refreshResult) {
        if (0L == errorCode && refreshResult) {
            this.service.createProtectionTask(this.protectGroup);
            ITaskManager protectionTaskManager = (ITaskManager)ServiceLocator.getInstance().getService(ITaskManager.class);
            protectionTaskManager.resumeGroup(protectionTaskManager.getGroupName(this.protectGroup.getUuid()));
            AlarmReporter.restoreAlarm(52625421L, protectGroupId);
            this.service.updateProtectGroupStatus(DrmEnumDefine.PROTECT_GROUP_STATUS.NORMAL, protectGroupId);
        }
    }

    public Object doInTransaction(TransactionStatus status) {
        HibernateTemplate template = this.service.getBaseDao().getHibernateTemplate();
        try {
            this.service.getProtectObjectProvider(this.protectGroup.getPoType()).refreshProtectGroup(this.protectGroup);
            if (supportPtTransferList.contains(this.protectGroup.getTemplate().getType())) {
                template.saveOrUpdate((Object)this.protectGroup.getTemplate());
            }
            template.saveOrUpdate((Object)this.protectGroup);
            this.refreshSnapshots(this.protectGroup.getPoProviderSN());
        }
        catch (LegoCheckedException le) {
            logger.error((Object)"failed to refresh protectobject.", (Throwable)le, le.getErrorCode());
            status.setRollbackOnly();
            ExceptionUtil.rethrowException((Exception)((Object)le), (String)"failed to refresh protectobject.", (long)le.getErrorCode(), (String[])le.getParameters());
        }
        catch (DataAccessException e) {
            logger.error((Object)"failed to refresh protectobject because of saving error.", (Throwable)e, -1L);
            status.setRollbackOnly();
            ExceptionUtil.rethrowException((Exception)((Object)e), (String)"failed to refresh protectobject because of saving error.", (long)-1L, (String[])new String[0]);
        }
        catch (Exception e) {
            status.setRollbackOnly();
            ExceptionUtil.rethrowException((Throwable)e, (String)"failed to refresh protectobject.", (long)-1L, (String[])new String[0], (Log)logger);
        }
        return null;
    }

    private void refreshSnapshots(String devSn) {
        DrResource resource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(devSn);
        if (!resource.getIsAirGapResource().booleanValue()) {
            return;
        }
        IStorageSnapshotScheduleManager manager = this.getSnapshotScheduleManager(devSn);
        if (manager.getSnapshotType() == SnapshotSchedule.SCHEDULE_TYPE.HYPERCDP.getValue()) {
            logger.info((Object)"Refresh snapshots by hyperCDP consistent group.");
            this.updateSnapshotsByHyperCdpCg(devSn, manager);
        } else {
            logger.info((Object)"Refresh other snapshots.");
            this.updateSnapshots(devSn, manager);
        }
    }

    private IStorageSnapshotScheduleManager getSnapshotScheduleManager(String devSn) {
        int snapshotType = ScheduleProtectedType.SNAPSHOT.getValue();
        String lunConsistentGroupId = (String)this.protectGroup.getProps().get("PROP_KEY_LUN_CG_KEY:" + devSn);
        if (!VerifyUtil.isEmpty((String)lunConsistentGroupId)) {
            snapshotType = ScheduleProtectedType.HYPERCDP.getValue();
        }
        return StorageSnapshotScheduleManagerProxy.getInstance().getStorageSnapshotMgrByDevId(devSn, snapshotType);
    }

    private void updateSnapshots(String devSn, IStorageSnapshotScheduleManager manager) {
        HashSet<String> storageSnapshotIds = new HashSet<String>();
        Set schedules = this.protectGroup.getTemplate().getSchedules();
        for (Schedule schedule : schedules) {
            Set snapshotIds = manager.getProtectGroupSnapshotIds(this.protectGroup, devSn, schedule);
            if (VerifyUtil.isEmpty((Collection)snapshotIds)) continue;
            storageSnapshotIds.addAll(snapshotIds);
        }
        int templateType = this.protectGroup.getTemplate().getType();
        if (templateType == 46) {
            this.updateAntiBlackmailSnapshots(storageSnapshotIds);
        } else {
            this.updateSnapshotsInDB(storageSnapshotIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAntiBlackmailSnapshots(Set<String> storageSnapshotIds) {
        Map<String, List<AntiBlackmailSnapshot>> replicaSnapshotsMap = AntiBlackmailUtil.queryPgAntiBlackmailSnapshot(this.protectGroup, storageSnapshotIds);
        logger.info((Object)"Lock replicas for refreshing protect group(name: %s).", new Object[]{this.protectGroup.getName()});
        Set<String> lockedReplicaIdSet = AntiBlackmailResourceLockUtil.lockReplicasInPg(this.protectGroup);
        try {
            this.refreshAntiBlackmailReplicas(replicaSnapshotsMap, lockedReplicaIdSet);
        }
        catch (Throwable throwable) {
            logger.info((Object)"Unlock replicas for refreshing protect group(name: %s).", new Object[]{this.protectGroup.getName()});
            AntiBlackmailResourceLockUtil.unlockReplicas(lockedReplicaIdSet);
            throw throwable;
        }
        logger.info((Object)"Unlock replicas for refreshing protect group(name: %s).", new Object[]{this.protectGroup.getName()});
        AntiBlackmailResourceLockUtil.unlockReplicas(lockedReplicaIdSet);
    }

    private void refreshAntiBlackmailReplicas(Map<String, List<AntiBlackmailSnapshot>> replicaSnapshotsMap, Set<String> lockedReplicaIdSet) {
        Set pgReplicas = this.protectGroup.getReplicaList();
        if (VerifyUtil.isEmpty((Collection)pgReplicas)) {
            logger.error((Object)"No replicas need to refresh, pg name: %s.", new Object[]{this.protectGroup.getName()});
        }
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        Set<String> currentPoIdSet = this.protectGroup.getPolist().stream().map(DRMObject::getUuid).collect(Collectors.toSet());
        for (ProtectGroupReplica replica : pgReplicas) {
            if (!lockedReplicaIdSet.contains(replica.getId()) || !replica.isStorageSnapshotReplica()) continue;
            String replicaId = replica.getId();
            if (!replicaSnapshotsMap.containsKey(replicaId)) {
                AntiBlackmailUtil.dealNonExistentReplica(replica, currentPoIdSet, replicaService);
                continue;
            }
            AntiBlackmailUtil.refreshSinglePgReplica(replica, replicaSnapshotsMap, currentPoIdSet);
        }
    }

    private void updateSnapshotsInDB(Set<String> storageSnapshotIds) {
        Set pgReplicas = this.protectGroup.getReplicaList();
        for (ProtectGroupReplica replica : pgReplicas) {
            if (!replica.isStorageSnapshotReplica()) continue;
            if (!this.checkReplicaIsValid(replica, storageSnapshotIds)) {
                logger.info((Object)"Delete invalid protectGroup Replica(ReplicaName: %s).", new Object[]{replica.getName()});
                ((IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class)).deleteProtectGroupReplicaById(replica.getId());
                continue;
            }
            ((IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class)).saveOrUpdateReplica(replica);
        }
    }

    private boolean checkReplicaIsValid(ProtectGroupReplica replica, Set<String> storageSnapshotIds) {
        boolean isValid = false;
        Set poReplicas = replica.getReplicas();
        Iterator iterator = poReplicas.iterator();
        while (iterator.hasNext()) {
            ProtectObjectReplica poReplica = (ProtectObjectReplica)iterator.next();
            Set replicaStorageInfos = poReplica.getStorageInfos();
            replicaStorageInfos.removeIf(replicaStorageInfo -> !storageSnapshotIds.contains(replicaStorageInfo.getStorageId()));
            if (replicaStorageInfos.size() > 0) {
                isValid = true;
                continue;
            }
            iterator.remove();
        }
        if (!isValid) {
            logger.info((Object)"ReplicaName: %s is not valid because its snapshots in storage are not exits.", new Object[]{replica.getName()});
        }
        return isValid;
    }

    private void updateSnapshotsByHyperCdpCg(String devSn, IStorageSnapshotScheduleManager manager) {
        HashMap<String, String> conditions = new HashMap<String, String>();
        conditions.put("pageNum", String.valueOf(1));
        conditions.put("pageSize", String.valueOf(1000));
        conditions.put("startTime", "null");
        conditions.put("endTime", "null");
        Set schedules = this.protectGroup.getTemplate().getSchedules();
        ArrayList<ProtectGroupReplica> replicasInStorage = new ArrayList<ProtectGroupReplica>();
        for (Schedule schedule : schedules) {
            List tmpReplicas = manager.getProtectGroupReplica(this.protectGroup, devSn, schedule, conditions);
            replicasInStorage.addAll(tmpReplicas);
        }
        List pgReplicas = ((IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class)).queryProtectGroupReplicaByGroup(this.protectGroup.getUuid(), "TIME_STAMP", false, true);
        this.updateSecureSnapshotInDB(pgReplicas, replicasInStorage);
    }

    private void updateSecureSnapshotInDB(List<ProtectGroupReplica> pgReplicas, List<ProtectGroupReplica> replicasInStorage) {
        if (CollectionUtils.isEmpty(pgReplicas)) {
            return;
        }
        Set<String> storageIds = this.getStorageSnapshotIds(replicasInStorage);
        for (ProtectGroupReplica replica : pgReplicas) {
            if (replica.getType() != 102) continue;
            Map props = replica.getProps();
            if (!props.containsKey("StorageIds")) {
                logger.error((Object)"Error not find StorageId");
                return;
            }
            String storageId = (String)props.get("StorageIds");
            if (!CollectionUtils.isEmpty(storageIds) && storageIds.contains(storageId)) continue;
            logger.info((Object)"replicaName: %s, storageId: %s is not matched secure snapshot in storage.", new Object[]{storageId, replica.getName()});
            ((IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class)).deleteProtectGroupReplicaById(replica.getId());
        }
    }

    private Set<String> getStorageSnapshotIds(List<ProtectGroupReplica> replicas) {
        if (CollectionUtils.isEmpty(replicas)) {
            logger.info((Object)"Not find secure snapshot.");
            return Collections.emptySet();
        }
        HashSet<String> storageIds = new HashSet<String>();
        for (ProtectGroupReplica replica : replicas) {
            Map props = replica.getProps();
            if (!props.containsKey("StorageIds")) continue;
            String storageId = (String)props.get("StorageIds");
            storageIds.add(storageId);
        }
        return storageIds;
    }

    private MessageEvent constructUpdateMessage() {
        MessageEvent event = new MessageEvent();
        event.setMessageType(1);
        ArrayList<ProtectGroup> objectList = new ArrayList<ProtectGroup>();
        objectList.add(this.protectGroup);
        event.setObjectList(objectList);
        return event;
    }
}

