/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.constant.DiskProtectStatusEnum;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupQueryServiceImpl;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupServiceImpl;
import com.huawei.ism.drm.protection.framework.service.group.refinement.CreateProtectGroupRefineService;
import com.huawei.ism.drm.protection.framework.template.factory.ReplicaBuilderFactory;
import com.huawei.ism.drm.protection.group.sdk.model.DiskInfo;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.SubDiskInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.protection.template.sdk.service.IReplicaBuilder;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.model.StoragePair;
import com.huawei.ism.drm.storage.service.impl.DrmStorageServiceImpl;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UpdateDiskProtectedBackTask
extends AbstractBackTask {
    private static final Log logger = LogFactory.getInstance(UpdateDiskProtectedBackTask.class);
    private ProtectGroup protectGroup;
    private List<StoragePair> storagePairs;
    private IReplicaBuilder replicaBuilder;
    private ProtectGroupServiceImpl service;

    public UpdateDiskProtectedBackTask(List<StoragePair> storagePairs, ProtectGroup protectGroup) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)protectGroup.getName(), (String)"ism.drm.instance.disk.update", (String)"System", (String)"", null), true);
        this.storagePairs = storagePairs;
        this.protectGroup = protectGroup;
        this.service = (ProtectGroupServiceImpl)((Object)ServiceLocator.getInstance().getService(ProtectGroupServiceImpl.class));
        this.replicaBuilder = ReplicaBuilderFactory.getInstance().getTemplateByType(protectGroup.getTemplate().getType());
    }

    protected void doWork() {
        boolean lockFlag;
        JSONArray jsonArray = new JSONArray();
        if (null != this.storagePairs && !this.storagePairs.isEmpty()) {
            jsonArray.addAll((Collection)JSONArray.fromObject(this.storagePairs));
            this.protectGroup.getProps().put("storagePoolMapping", jsonArray.toString());
        }
        if (!(lockFlag = ProtectionJobUtil.getInstance().getLockPg(this.protectGroup.getUuid()))) {
            logger.error((Object)("The pg is locked: " + this.protectGroup.getUuid()), 90160758786893L);
            throw new LegoCheckedException(1073948196L);
        }
        try {
            CreateProtectGroupRefineService instanceService = CreateProtectGroupRefineService.getInstance();
            MessageEvent event = new MessageEvent();
            event.setMessageType(3);
            ArrayList<ProtectGroup> objectList = new ArrayList<ProtectGroup>();
            objectList.add(this.protectGroup);
            event.setObjectList(objectList);
            instanceService.notifyObserverList(event, "before");
            List newStorageInfoSet = this.protectGroup.distinctStorageInfo();
            if (VerifyUtil.isEmpty((Collection)newStorageInfoSet)) {
                throw new LegoCheckedException(1073948417L);
            }
            this.replicaBuilder.buildReplica(this.protectGroup);
            this.service.getBaseDao().update((Object)this.protectGroup);
            logger.debug((Object)("build replica success for " + this.protectGroup.getName()), 90160758786988L);
            IProtectGroupService groupServcie = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
            List diskInfoList = groupServcie.queryDiskInfo(this.protectGroup);
            for (DiskInfo diskInfo : diskInfoList) {
                String diskStatus = diskInfo.getStatus();
                if (!DiskProtectStatusEnum.EXPANDED.getStatus().equals(diskStatus)) continue;
                try {
                    this.expandTargetLun(diskInfo);
                }
                catch (LegoCheckedException ex) {
                    logger.error((Object)("expand target lun failed id :" + diskInfo.getResourceId()), (Throwable)ex);
                    throw ex;
                }
                catch (Exception e) {
                    logger.error((Object)("expand target lun failed id :" + diskInfo.getResourceId()), (Throwable)e);
                    throw new LegoCheckedException(100664655L, (Throwable)e);
                }
            }
            this.syncConsistentGroup();
            logger.debug((Object)("Add protect objects success for " + this.protectGroup.getName()), 90160758786988L);
            instanceService.notifyObserverList(event, "after");
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"update disk protect  error", (Throwable)e);
            throw e;
        }
        finally {
            try {
                ProtectionJobUtil.getInstance().releaseLockPg(this.protectGroup.getUuid());
                ProtectGroupQueryServiceImpl protectGroupQueryService = (ProtectGroupQueryServiceImpl)((Object)ServiceLocator.getInstance().getService(IProtectGroupService.class));
                protectGroupQueryService.getProtectObjectProvider(this.protectGroup.getPoType()).refreshProtectGroup(this.protectGroup);
            }
            catch (LegoCheckedException e) {
                logger.error((Object)"refresh protect group  error", (Throwable)e);
            }
        }
    }

    private void syncConsistentGroup() {
        HashSet<String> cgIds = new HashSet<String>();
        Set replicaList = this.protectGroup.getReplicaList();
        for (ProtectGroupReplica protectGroupReplica : replicaList) {
            Set protectObjectReplicaList = protectGroupReplica.getReplicas();
            for (ProtectObjectReplica protectObjectReplica : protectObjectReplicaList) {
                Set relicaStorageInfoList = protectObjectReplica.getStorageInfos();
                this.syncConsistentGroup(cgIds, relicaStorageInfoList);
            }
        }
    }

    private void expandTargetLun(DiskInfo diskInfo) {
        for (SubDiskInfo subDiskInfo : diskInfo.getSubDiskInfo()) {
            try {
                if (null == subDiskInfo.getCapacity() || diskInfo.getCapacity() <= subDiskInfo.getCapacity()) continue;
                Lun subLun = new Lun();
                subLun.setDevSn(subDiskInfo.getDevSn());
                subLun.setName(subDiskInfo.getName());
                subLun.setCapacity(diskInfo.getCapacity());
                DrmStorageServiceImpl drmStorageService = (DrmStorageServiceImpl)((Object)ServiceLocator.getInstance().getService(DrmStorageServiceImpl.class));
                if (!drmStorageService.expandLun(subLun.getDevSn(), subLun)) {
                    logger.error((Object)("expand target lun failed sn:" + subLun.getDevSn() + " name:" + subLun.getName()));
                    throw new LegoCheckedException(100664655L);
                }
                drmStorageService.queryLunByDevSnAndLunIds(subDiskInfo.getDevSn(), Arrays.asList(subDiskInfo.getResourceId()));
            }
            catch (LegoCheckedException ex) {
                logger.error((Object)"expand target lun failed :", (Throwable)ex);
                throw new LegoCheckedException(100664655L, (Throwable)ex);
            }
        }
    }

    private void syncConsistentGroup(Set<String> cgIds, Set<RelicaStorageInfo> relicaStorageInfoList) {
        for (RelicaStorageInfo relicaStorageInfo : relicaStorageInfoList) {
            OperationResult result;
            if (!(relicaStorageInfo instanceof RemoteStorageReplica)) continue;
            RemoteStorageReplica remoteStorageReplica = (RemoteStorageReplica)relicaStorageInfo;
            String consistentGroupId = remoteStorageReplica.getConsistentGroupId();
            String srcSn = remoteStorageReplica.getSrcStorageProviderSN();
            String tgtSn = remoteStorageReplica.getStorageProviderSN();
            String cgIdSrcSnTagSn = consistentGroupId + "@" + srcSn + "@" + tgtSn;
            if (cgIds.contains(cgIdSrcSnTagSn)) continue;
            try {
                StorageReplicationManagerProxy sraProxy = StorageReplicationManagerProxy.getInstance();
                result = sraProxy.getStorageReplicationAdapter(srcSn).syncOnce(srcSn, tgtSn, consistentGroupId, true);
            }
            catch (Exception ex) {
                logger.error((Object)"sync consistentGroup failed. SN:s%", new Object[]{cgIdSrcSnTagSn});
                throw ex;
            }
            if (result == null) {
                logger.error((Object)"sync consistentGroup failed. SN:s%", new Object[]{cgIdSrcSnTagSn});
                throw new LegoCheckedException(0x300001L);
            }
            if (!result.isSuccess()) {
                logger.error((Object)"sync consistentGroup failed. SN:s%", new Object[]{cgIdSrcSnTagSn});
                throw new LegoCheckedException(result.getErrorCode());
            }
            cgIds.add(cgIdSrcSnTagSn);
        }
    }
}

