/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group.refinement;

import com.huawei.lego.core.base.framework.container.support.SystemLauncher;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.ApplicationContext;

public class ProtectGroupServiceLocator {
    private static final ProtectGroupServiceLocator INSTANCE = new ProtectGroupServiceLocator();
    private static Log logger = LogFactory.getInstance(ProtectGroupServiceLocator.class);

    private ProtectGroupServiceLocator() {
    }

    public static ProtectGroupServiceLocator getInstance() {
        return INSTANCE;
    }

    public <T> List<T> getServices(Class<T> clazz) {
        if (null == clazz) {
            logger.error((Object)"clazz is null.");
            throw new LegoCheckedException(1073947393L);
        }
        ApplicationContext context = SystemLauncher.getSpringContext();
        if (null == context) {
            logger.error((Object)("ApplicationContext is null. clazz=" + clazz));
            throw new LegoCheckedException(1073947395L);
        }
        String[] beanNames = context.getBeanNamesForType(clazz);
        if (null == beanNames || beanNames.length <= 0) {
            logger.error((Object)("beanName is null. clazz=" + clazz));
            throw new LegoCheckedException(1073947395L);
        }
        ArrayList<T> result = new ArrayList<T>();
        for (String beanName : beanNames) {
            Object service = context.getBean(beanName);
            if (!clazz.isInstance(service)) continue;
            result.add(clazz.cast(service));
        }
        return result;
    }
}

