/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group.refinement;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.StringEscapeUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.DrmStorageUtil;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.springframework.dao.DataAccessException;

public class QueryProtectGroupRefineService {
    private static final QueryProtectGroupRefineService INSTANCE = new QueryProtectGroupRefineService();
    private static final String QUERY_ALL_PG_SQL = "select pg.PGID, pg.UUID, pg.PRODUCTSITEID, st.siteName, pg.PGNAME, pg.POTYPE, pt.TYPE, pt.SUBTYPE, pg.ISPRIMARY, pg.STATUS, pg.PGPROVIDERSN, pt.ptId, pg.PGDESC, pg.LASTEXECTIME from ti_protectgroup pg, ti_site st, ti_policytemplate pt where pg.PTID = pt.PTID and pg.PRODUCTSITEID = st.siteId";
    private static final String QUERY_PG_SQL = "select pg.PGID, pg.UUID, pg.PRODUCTSITEID, st.siteName, pg.PGNAME, pg.POTYPE, pt.TYPE, pt.SUBTYPE, pg.ISPRIMARY, pg.STATUS, pg.PGPROVIDERSN, pt.ptId, pg.PGDESC, pg.LASTEXECTIME from ti_protectgroup pg, ti_site st, ti_policytemplate pt where pg.PTID = pt.PTID and pg.PRODUCTSITEID = st.siteId and pg.PGID=:pgId";
    private static Log logger = LogFactory.getInstance(QueryProtectGroupRefineService.class);

    private QueryProtectGroupRefineService() {
    }

    public static QueryProtectGroupRefineService getInstance() {
        return INSTANCE;
    }

    /*
     * Exception decompiling
     */
    public ProtectGroup getProtectGroupByID(String protectGroupId, boolean queryProtectObjectReplica) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<ProtectGroup> getAllProtectGroup(Long userId) {
        List<ProtectGroup> protectGroupList = this.getProtectGroups();
        if (VerifyUtil.isEmpty(protectGroupList)) {
            return Collections.emptyList();
        }
        for (ProtectGroup tempProtectGroup : protectGroupList) {
            this.updateProductSiteName(tempProtectGroup);
        }
        return ((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).filterObject(userId, protectGroupList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProtectGroup> queryProtectGroups(Long userId) {
        Session session;
        List<Object> protectGroups;
        block5: {
            protectGroups = new ArrayList();
            session = null;
            try {
                session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                NativeQuery query = session.createSQLQuery(QUERY_ALL_PG_SQL);
                List results = query.list();
                if (VerifyUtil.isEmpty((Collection)results)) break block5;
                protectGroups = this.constructProtectGroups(results);
                for (ProtectGroup protectGroup : protectGroups) {
                    protectGroup.setProps(this.getProtectGroupProps(protectGroup.getUuid(), session));
                    protectGroup.setPolist(this.getProtectObjects(protectGroup.getUuid(), session));
                }
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("Querying protectgroup failed. UserId:" + userId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return ((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).filterObject(userId, protectGroups);
    }

    public List<ProtectGroup> getProtectGroups() {
        ArrayList<ProtectGroup> protectGroups = new ArrayList();
        try {
            protectGroups = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from ProtectGroup", new Object[0]);
        }
        catch (Exception e) {
            logger.error((Object)("Query protect group failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786894L);
        }
        return protectGroups;
    }

    public List<ProtectGroup> getProtectGroupByType(int poType, Long userId, boolean queryProtectObjectReplica) {
        List<ProtectGroup> protectGroupList = this.getProtectGroupByTypeNoScope(poType, queryProtectObjectReplica);
        if (VerifyUtil.isEmpty(protectGroupList)) {
            return Collections.emptyList();
        }
        for (ProtectGroup tempProtectGroup : protectGroupList) {
            this.updateProductSiteName(tempProtectGroup);
        }
        return ((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).filterObject(userId, protectGroupList);
    }

    private List<ProtectGroup> getProtectGroupByTypeNoScope(int poType, boolean queryProtectObjectReplica) {
        logger.debug((Object)("queryProtectObjectReplica:" + queryProtectObjectReplica));
        List result = null;
        Session session = null;
        try {
            String hql = "from ProtectGroup as pg where pg.poType = (:poType) order by pg.pgId";
            if (poType == -1) {
                hql = "from ProtectGroup as pg order by pg.pgId";
            }
            if (!queryProtectObjectReplica) {
                hql = "select new ProtectGroup(pg.pgId, pg.poProviderSN, pg.productSiteId, pg.productSiteName, pg.template, pg.primary) from ProtectGroup as pg where pg.poType = (:poType) order by pg.pgId";
                if (poType == -1) {
                    hql = "select new ProtectGroup(pg.pgId, pg.poProviderSN, pg.productSiteId, pg.productSiteName, pg.template, pg.primary) from ProtectGroup as pg order by pg.pgId";
                }
            }
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Query query = session.createQuery(hql);
            if (poType != -1) {
                query.setParameter("poType", (Object)poType);
            }
            if (!VerifyUtil.isEmpty((Collection)(result = query.list())) && !queryProtectObjectReplica) {
                for (ProtectGroup pg : result) {
                    this.setProtectGroupBasicInfo(pg, session);
                    pg.setPolist(this.getProtectObjects(pg.getUuid(), session));
                }
            }
        }
        catch (DataAccessException e) {
            try {
                logger.error((Object)"failed to query ProtectGroup.", (Throwable)e);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession(session);
        return result;
    }

    private void setProtectGroupBasicInfo(ProtectGroup pg, Session session) {
        String sql = "select pg.PGNAME, pg.LAST_EXEC_RESULT, pg.ISPRIMARY, pg.POTYPE from ti_protectgroup pg where pg.PGID=:pgId";
        String pgUuid = pg.getUuid();
        NativeQuery query = session.createSQLQuery(sql);
        query.setString("pgId", pgUuid);
        List results = query.list();
        if (!VerifyUtil.isEmpty((Collection)results)) {
            this.constructProtectGroup(results, pg);
        }
    }

    private void constructProtectGroup(List<?> results, ProtectGroup pg) {
        for (Object object : results) {
            Object[] values;
            if (!(object instanceof Object[]) || 4 != (values = (Object[])object).length) continue;
            pg.setName(CommUtil.convertToString((Object)values[0]));
            pg.setLastExecResult(CommUtil.convertToInteger((Object)values[1]));
            pg.setPrimary(CommUtil.convertToBoolean((Object)values[2]).booleanValue());
            pg.setPoType(CommUtil.convertToInteger((Object)values[3]).intValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ProtectGroup getProtectGroupBasicInfo(String protectGroupId, boolean isQueryPos) {
        ProtectGroup protectGroup;
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            protectGroup = this.queryProtectGroup(protectGroupId, session, isQueryPos);
        }
        catch (Exception e) {
            try {
                logger.error((Object)("Getting pg failed. id:" + protectGroupId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
            return null;
        }
        DBOperationUtil.closeSession(session);
        return protectGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProtectGroup> getAllProtectGroupBasicInfo(Long userId, boolean isQueryReplica, boolean isQueryProps, boolean isQueryPos) {
        List list;
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            List<ProtectGroup> pgs = null;
            NativeQuery query = session.createSQLQuery(QUERY_ALL_PG_SQL);
            List results = query.list();
            if (!VerifyUtil.isEmpty((Collection)results)) {
                pgs = this.constructProtectGroups(results);
                for (ProtectGroup protectGroup : pgs) {
                    if (isQueryReplica) {
                        Set<ProtectGroupReplica> pgReplicas = this.getProtectGroupReplicas(protectGroup.getUuid(), session);
                        protectGroup.setReplicaList(pgReplicas);
                    }
                    if (isQueryProps) {
                        protectGroup.setProps(this.getProtectGroupProps(protectGroup.getUuid(), session));
                    } else {
                        protectGroup.setProps(new HashMap());
                    }
                    if (isQueryPos) {
                        Set<ProtectObject> protectObjects = this.getProtectObjects(protectGroup.getUuid(), session);
                        protectGroup.setPolist(protectObjects);
                    }
                    this.updateProductSiteName(protectGroup);
                }
            }
            list = ((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).filterObject(userId, pgs);
        }
        catch (Exception e) {
            List<ProtectGroup> list2;
            try {
                logger.error((Object)("Getting pg failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                list2 = null;
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
            return list2;
        }
        DBOperationUtil.closeSession(session);
        return list;
    }

    private ProtectGroup queryProtectGroup(String protectGroupId, Session session, boolean isQueryPos) {
        logger.debug((Object)("protectGroupId:" + protectGroupId + ", isQueryPos:" + isQueryPos));
        ProtectGroup protectGroup = null;
        NativeQuery query = session.createSQLQuery(QUERY_PG_SQL);
        query.setString("pgId", protectGroupId);
        List results = query.list();
        if (!VerifyUtil.isEmpty((Collection)results)) {
            List<ProtectGroup> pgs = this.constructProtectGroups(results);
            if (VerifyUtil.isEmpty(pgs)) {
                return protectGroup;
            }
            protectGroup = pgs.iterator().next();
            Set<ProtectGroupReplica> pgReplicas = this.getProtectGroupReplicas(protectGroup.getUuid(), session);
            protectGroup.setReplicaList(pgReplicas);
            protectGroup.setProps(this.getProtectGroupProps(protectGroup.getUuid(), session));
            protectGroup.setTemplate((PolicyTemplate)session.get(PolicyTemplate.class, (Serializable)((Object)protectGroup.getTemplate().getUuid())));
            if (isQueryPos) {
                Set<ProtectObject> protectObjects = this.getProtectObjects(protectGroup.getUuid(), session);
                protectGroup.setPolist(protectObjects);
            }
        }
        return protectGroup;
    }

    private List<ProtectGroup> constructProtectGroups(List<?> result) {
        ArrayList<ProtectGroup> protectGroups = new ArrayList<ProtectGroup>();
        for (Object object : result) {
            Object[] values;
            if (!(object instanceof Object[]) || 14 != (values = (Object[])object).length) continue;
            ProtectGroup protectGroup = new ProtectGroup();
            protectGroup.setUuid(CommUtil.convertToString((Object)values[1]));
            protectGroup.setProductSiteId(CommUtil.convertToString((Object)values[2]));
            protectGroup.setProductSiteName(CommUtil.convertToString((Object)values[3]));
            protectGroup.setName(CommUtil.convertToString((Object)values[4]));
            protectGroup.setPoType(CommUtil.convertToInteger((Object)values[5]).intValue());
            protectGroup.setDescription(CommUtil.convertToString((Object)values[12]));
            if (null != values[13]) {
                protectGroup.setLastExecTime(CommUtil.convertToLong((Object)values[13]));
            }
            PolicyTemplate template = new PolicyTemplate();
            Integer templateType = CommUtil.convertToInteger((Object)values[6]);
            Integer templateSubType = CommUtil.convertToInteger((Object)values[7]);
            template.setType(templateType.intValue());
            template.setSubType((0 >= templateSubType ? templateType : templateSubType).intValue());
            protectGroup.setTemplate(template);
            protectGroup.setPrimary(CommUtil.convertToBoolean((Object)values[8]).booleanValue());
            protectGroup.setStatus(CommUtil.convertToInteger((Object)values[9]).intValue());
            protectGroup.setPoProviderSN(CommUtil.convertToString((Object)values[10]));
            template.setUuid(CommUtil.convertToString((Object)values[11]));
            protectGroups.add(protectGroup);
        }
        return protectGroups;
    }

    public Set<ProtectGroupReplica> getProtectGroupReplicas(String pgId, Session session) {
        logger.debug((Object)("pgId:" + pgId));
        Set<ProtectGroupReplica> pgReplicas = new HashSet<ProtectGroupReplica>();
        String querSQL = "select id, name, replicatype, replicastatus, RECSITEID, PROARRAYID, RECARRAYID, protectLocation, MOUNTSTATUS from ti_protectgroupreplica where pgid=:pgId";
        NativeQuery query = session.createSQLQuery(querSQL);
        query.setString("pgId", pgId);
        List results = query.list();
        if (!VerifyUtil.isEmpty((Collection)results)) {
            pgReplicas = this.constructProtectGroupReplicas(results);
        }
        return pgReplicas;
    }

    public Set<ProtectObject> getProtectObjects(String pgId, Session session) {
        logger.debug((Object)("pgId:" + pgId));
        Set<ProtectObject> protectObjects = new HashSet<ProtectObject>();
        String strSQL = "select poid, uuid, poname, potype, postatus, PROVIDERSN, PORECOVERYSTATUS, MOUUID, STORAGEMETADATA from ti_protectobject where pgid=:pgId";
        NativeQuery query = session.createSQLQuery(strSQL);
        query.setString("pgId", pgId);
        List results = query.list();
        if (!VerifyUtil.isEmpty((Collection)results)) {
            protectObjects = this.constructProtectObjects(results);
            ArrayList<String> poIdList = new ArrayList<String>();
            for (ProtectObject protectObject : protectObjects) {
                poIdList.add(protectObject.getUuid());
            }
            Map<String, Map<String, String>> poPropMap = this.getProtectObjectProps(poIdList, session);
            for (ProtectObject protectObject : protectObjects) {
                Map<String, String> props = poPropMap.get(protectObject.getUuid());
                if (null == props) {
                    props = new HashMap<String, String>();
                }
                protectObject.setProps(props);
            }
        }
        return protectObjects;
    }

    private Set<ProtectObjectStorageInfo> covertUsedStorageResourceSet(String storageMetadata) {
        HashSet<ProtectObjectStorageInfo> protectObjectStorageInfos = new HashSet<ProtectObjectStorageInfo>();
        if (VerifyUtil.isEmpty((String)storageMetadata)) {
            return protectObjectStorageInfos;
        }
        JSONArray result = JSONArray.fromObject((Object)storageMetadata);
        for (Object r : result) {
            JSONObject jsonObj = JSONObject.fromObject(r);
            ProtectObjectStorageInfo protectObjectStorageInfo = new ProtectObjectStorageInfo();
            protectObjectStorageInfo.setHostName(jsonObj.getString("hostName"));
            protectObjectStorageInfo.setId(jsonObj.getString("id"));
            protectObjectStorageInfo.setResourceId(jsonObj.getString("resourceId"));
            protectObjectStorageInfo.setLabAddress(jsonObj.getString("labAddress"));
            protectObjectStorageInfo.setDeviceName(jsonObj.getString("deviceName"));
            protectObjectStorageInfo.setVgMapInfo(jsonObj.getString("vgMapInfo"));
            protectObjectStorageInfo.setVolumeGroupName(jsonObj.getString("volumeGroupName"));
            protectObjectStorageInfo.setUdevFlag(jsonObj.getString("udevFlag"));
            protectObjectStorageInfo.setMountPoint(jsonObj.getString("mountPoint"));
            protectObjectStorageInfo.setResourceGroupName(jsonObj.getString("resourceGroupName"));
            protectObjectStorageInfo.setAppName(jsonObj.getString("appName"));
            protectObjectStorageInfo.setArchiveLog(Integer.valueOf(jsonObj.getInt("archiveLog")));
            protectObjectStorageInfo.setDbVersion(jsonObj.getString("dbVersion"));
            protectObjectStorageInfo.setLunWWN(jsonObj.getString("lunWWN"));
            protectObjectStorageInfo.setIsManualConfigLun(Boolean.valueOf(jsonObj.getBoolean("isManualConfigLun")));
            protectObjectStorageInfo.setResourceName(jsonObj.getString("resourceName"));
            protectObjectStorageInfo.setAppInstenceName(jsonObj.getString("appInstenceName"));
            protectObjectStorageInfo.setResourceProviderSN(jsonObj.getString("resourceProviderSN"));
            protectObjectStorageInfo.setPvName(jsonObj.getString("pvName"));
            protectObjectStorageInfo.setStorageSubType(Integer.valueOf(jsonObj.getInt("storageSubType")));
            protectObjectStorageInfo.setAppInstenceName(jsonObj.getString("storageType"));
            protectObjectStorageInfo.setAsmDiskGroupName(jsonObj.getString("asmDiskGroupName"));
            protectObjectStorageInfo.setPoType(Integer.valueOf(jsonObj.getInt("poType")));
            protectObjectStorageInfo.setResourceType(Integer.valueOf(jsonObj.getInt("resourceType")));
            protectObjectStorageInfos.add(protectObjectStorageInfo);
        }
        return protectObjectStorageInfos;
    }

    public Map<String, String> getProtectGroupProps(String pgId, Session session) {
        logger.debug((Object)("pgId:" + pgId));
        Map<String, String> props = new HashMap<String, String>();
        String strSQL = "select PGID, PROPNAME, PROPVALUE from ti_protectgroup_prop where PGID=:pgId";
        NativeQuery query = session.createSQLQuery(strSQL);
        query.setString("pgId", pgId);
        List results = query.list();
        if (!VerifyUtil.isEmpty((Collection)results)) {
            props = this.constructExtendProperties(results);
        }
        return props;
    }

    private void updateProductSiteName(ProtectGroup protectGroup) {
        String productSiteName = "--";
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(protectGroup.getProductSiteId());
        if (!VerifyUtil.isEmpty((Object)site)) {
            productSiteName = site.getName();
        }
        protectGroup.setProductSiteName(productSiteName);
    }

    private Map<String, String> constructExtendProperties(List<?> result) {
        HashMap<String, String> props = new HashMap<String, String>();
        for (Object object : result) {
            Object[] values;
            if (!(object instanceof Object[]) || 3 != (values = (Object[])object).length) continue;
            String propName = CommUtil.convertToString((Object)values[1]);
            String propValue = CommUtil.convertToString((Object)values[2]);
            props.put(propName, propValue);
        }
        String instProtectType = (String)props.get("serviceInstanceType");
        ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E filterValue = ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.getTypeFromValue((String)instProtectType);
        if (null != filterValue) {
            props.put("instProtectType", filterValue.getFrontValue());
        }
        return props;
    }

    private Map<String, Map<String, String>> getProtectObjectProps(List<String> poIdList, Session session) {
        HashMap<String, Map<String, String>> poPropMap = new HashMap<String, Map<String, String>>();
        StringBuilder querSQL = new StringBuilder();
        querSQL.append("select poid, PROPNAME, PROPVALUE from ti_po_prop");
        if (!VerifyUtil.isEmpty(poIdList)) {
            querSQL.append(" where poid in (");
            for (int i = 0; i < poIdList.size(); ++i) {
                String poid = poIdList.get(i);
                querSQL.append("'" + StringEscapeUtil.escapeSql((String)poid) + "'");
                if (i >= poIdList.size() - 1) continue;
                querSQL.append(",");
            }
            querSQL.append(")");
        }
        NativeQuery query = session.createSQLQuery(querSQL.toString());
        List results = query.list();
        DrmStorageUtil.setPropMap(poPropMap, results);
        return poPropMap;
    }

    private Set<ProtectObject> constructProtectObjects(List<?> result) {
        HashSet<ProtectObject> protectObjects = new HashSet<ProtectObject>();
        for (Object object : result) {
            Object[] values;
            if (!(object instanceof Object[]) || 9 != (values = (Object[])object).length) continue;
            ProtectObject protectObject = new ProtectObject();
            protectObject.setUuid(CommUtil.convertToString((Object)values[1]));
            protectObject.setName(CommUtil.convertToString((Object)values[2]));
            protectObject.setPoType(CommUtil.convertToInteger((Object)values[3]).intValue());
            protectObject.setPoStatus(CommUtil.convertToInteger((Object)values[4]).intValue());
            protectObject.setProviderSN(CommUtil.convertToString((Object)values[5]));
            protectObject.setPoRecoveryStatus(CommUtil.convertToInteger((Object)values[6]).intValue());
            protectObject.setMoUuid(CommUtil.convertToString((Object)values[7]));
            protectObject.setUsedStorageResourceSet(this.covertUsedStorageResourceSet(CommUtil.convertToString((Object)values[8])));
            protectObjects.add(protectObject);
        }
        return protectObjects;
    }

    protected Set<ProtectGroupReplica> constructProtectGroupReplicas(List<?> result) {
        HashSet<ProtectGroupReplica> pgReplicas = new HashSet<ProtectGroupReplica>();
        for (Object object : result) {
            Object[] values;
            if (!(object instanceof Object[]) || 9 != (values = (Object[])object).length) continue;
            ProtectGroupReplica pgReplica = new ProtectGroupReplica();
            pgReplica.setId(CommUtil.convertToString((Object)values[0]));
            pgReplica.setName(CommUtil.convertToString((Object)values[1]));
            pgReplica.setType(CommUtil.convertToInteger((Object)values[2]).intValue());
            pgReplica.setStatus(CommUtil.convertToInteger((Object)values[3]).intValue());
            pgReplica.setRecoverySite(CommUtil.convertToString((Object)values[4]));
            pgReplica.setProductArray(CommUtil.convertToString((Object)values[5]));
            pgReplica.setRecoveryArray(CommUtil.convertToString((Object)values[6]));
            pgReplica.setProtectLocation(CommUtil.convertToInteger((Object)values[7]).intValue());
            pgReplica.setMountStatus(CommUtil.convertToInteger((Object)values[8]));
            pgReplicas.add(pgReplica);
        }
        return pgReplicas;
    }
}

