/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group.subscriber;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.framework.service.group.subscriber.AbstractExecuteSuccessSubscriber;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.task.sdk.service.IProtectionTaskService;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageTaskManager;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SyncSubscriber
extends AbstractExecuteSuccessSubscriber {
    private static final Log logger = LogFactory.getInstance(SyncSubscriber.class);

    public SyncSubscriber(IMessageCenter messageCenter) {
        messageCenter.addSubscriberTo((MessageTaskManager)this);
    }

    @Override
    protected void handleProtectGroup(ProtectGroup protectGroup, Map<String, Object> parameter) {
        Map<String, Object> workParameter = parameter;
        if (workParameter == null) {
            workParameter = new HashMap<String, Object>();
        }
        if (!this.isSyncAfterSyncEnabled(workParameter)) {
            return;
        }
        PolicyTemplate template = protectGroup.getTemplate();
        int protectedType = ProtectionJobUtil.getInstance().getSyncTypeExecuteSync(workParameter);
        if (protectedType != template.getType() && protectedType != 1) {
            return;
        }
        ProtectGroupReplica lastReplica = protectGroup.getLatestRepica();
        if (this.checkLastReplica(lastReplica)) {
            return;
        }
        if (protectedType == template.getType()) {
            workParameter.put("backupTypeAfterSync", -1);
        }
        workParameter.put("REPLICA_TIMESTANP", lastReplica.getTimeStamp());
        List<Schedule> schedules = this.getSchedules(template);
        for (Schedule schedule : schedules) {
            logger.info((Object)"execute scheduleId: %s", new Object[]{schedule.getScheduleId()});
            IProtectionTaskService service = (IProtectionTaskService)ServiceLocator.getInstance().getService(IProtectionTaskService.class);
            workParameter.remove("syncTypeAfterSync");
            workParameter.put("scheduleId", schedule.getScheduleId());
            service.runTask(protectGroup.getUuid(), schedule.getScheduleId(), workParameter);
        }
    }

    private boolean checkLastReplica(ProtectGroupReplica lastReplica) {
        return lastReplica.getProtectLocation() != DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue();
    }

    private List<Schedule> getSchedules(PolicyTemplate template) {
        ArrayList<Schedule> list = new ArrayList<Schedule>();
        for (Schedule schedule : template.getSchedules()) {
            Map extParams = schedule.getExtParameters();
            if (!extParams.containsKey("replicationMode") || !((String)extParams.get("replicationMode")).equals(String.valueOf(2))) continue;
            list.add(schedule);
        }
        return list;
    }
}

