/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group.util;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.protection.framework.service.group.util.FrontI18Util;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.path.sdk.model.ProtectionPath;
import com.huawei.ism.drm.protection.path.sdk.model.ProtectionPathData;
import com.huawei.ism.drm.protection.path.sdk.service.IProtectionPathService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ProtectGroupExcelOperator {
    private static Log log = FELogFactory.getInstance((String)"ui");
    private static final int FIVE_COL_WIDTH = 4500;
    private static final int SIX_COL_WIDTH = 22000;
    private static final int MAX_LENGTH = 30000;
    private static final String LINE_BREAK = "\n";
    private static Log logger = FELogFactory.getInstance((String)"ui");
    private static Map<Integer, String[]> templateTypePathMap = new HashMap<Integer, String[]>();
    private static List<Integer> notLoadReplicaTemplateTypeList = Arrays.asList(2, 19, 17, 28, 30, 31, 44, 45, 46, 32);
    private static List<Integer> inSensitiveToStorageTemplateTypeList = Arrays.asList(11, 21, 22);
    private BatchOperationResult result = new BatchOperationResult();
    private Locale useLocale = Locale.CHINA;

    public Workbook createExportExcel(List<ProtectGroup> protectgroups, BatchOperationResult results, Locale locale) {
        log.debug((Object)"to create Export Excel..");
        this.result = results;
        if (null != locale) {
            this.useLocale = locale;
        }
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet();
        this.createHeader(sheet);
        this.createDataArea(sheet, protectgroups);
        sheet.setColumnWidth(0, 4500);
        sheet.setColumnWidth(1, 4500);
        sheet.setColumnWidth(2, 4500);
        sheet.setColumnWidth(3, 4500);
        sheet.setColumnWidth(4, 4500);
        sheet.setColumnWidth(5, 4500);
        sheet.setColumnWidth(6, 22000);
        return wb;
    }

    private void createHeader(XSSFSheet sheet) {
        log.debug((Object)"to create excel header..");
        XSSFCellStyle cs = sheet.getWorkbook().createCellStyle();
        this.initialHeaderCellStyle(sheet, cs);
        XSSFRow row0 = sheet.createRow(0);
        XSSFRow row1 = sheet.createRow(1);
        this.generateRow0Header(sheet, cs, (Row)row0);
        this.generateRow1Header(sheet, cs, (Row)row1);
    }

    private void generateRow1Header(XSSFSheet sheet, XSSFCellStyle cs, Row row1) {
        Cell cell = row1.createCell(3);
        cell.setCellValue(this.getText("com.huawei.ism.drm.policy.name.label"));
        cell.setCellStyle((CellStyle)cs);
        CellRangeAddress cra = new CellRangeAddress(1, 1, 3, 3);
        this.setRangeBorder(sheet, cra);
        cell = row1.createCell(4);
        cell.setCellValue(this.getText("com.huawei.ism.drm.gropu.device.column"));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(1, 1, 4, 4);
        this.setRangeBorder(sheet, cra);
        cell = row1.createCell(5);
        cell.setCellValue(this.getText("com.huawei.ism.drm.gropu.device.type.column"));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(1, 1, 5, 5);
        this.setRangeBorder(sheet, cra);
    }

    private void generateRow0Header(XSSFSheet sheet, XSSFCellStyle cs, Row row0) {
        Cell cell = row0.createCell(0);
        cell.setCellValue(this.getText("ism.drm.drp.local.name.label"));
        cell.setCellStyle((CellStyle)cs);
        CellRangeAddress cra = new CellRangeAddress(0, 1, 0, 0);
        this.setRangeBorder(sheet, cra);
        sheet.addMergedRegion(cra);
        cell = row0.createCell(1);
        cell.setCellValue(this.getText("ism.drm.protect.group.aptype"));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(0, 1, 1, 1);
        this.setRangeBorder(sheet, cra);
        sheet.addMergedRegion(cra);
        cell = row0.createCell(2);
        cell.setCellValue(this.getText("ism.drm.protect.group.template"));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(0, 1, 2, 2);
        this.setRangeBorder(sheet, cra);
        sheet.addMergedRegion(cra);
        cell = row0.createCell(3);
        cell.setCellValue(this.getText("ism.drm.protect.element"));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(0, 0, 3, 5);
        this.setRangeBorder(sheet, cra);
        sheet.addMergedRegion(cra);
        cell = row0.createCell(6);
        cell.setCellValue(this.getText("ism.drm.protect.group.therecoverypath"));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(0, 1, 6, 6);
        this.setRangeBorder(sheet, cra);
        sheet.addMergedRegion(cra);
    }

    private void initialHeaderCellStyle(XSSFSheet sheet, XSSFCellStyle cs) {
        XSSFFont font = sheet.getWorkbook().createFont();
        font.setBold(true);
        cs.setAlignment(HorizontalAlignment.CENTER);
        cs.setVerticalAlignment(VerticalAlignment.CENTER);
        cs.setFillForegroundColor(IndexedColors.RED.getIndex());
        cs.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cs.setBorderLeft(BorderStyle.THIN);
        cs.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderTop(BorderStyle.THIN);
        cs.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderBottom(BorderStyle.THIN);
        cs.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderRight(BorderStyle.THIN);
        cs.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cs.setDataFormat(BuiltinFormats.getBuiltinFormat((String)"text"));
        cs.setFont((Font)font);
    }

    private String getText(String string) {
        return FrontI18Util.getText(string, this.useLocale);
    }

    private void setRangeBorder(XSSFSheet sheet, CellRangeAddress cra) {
        log.debug((Object)"to set range border..");
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setTopBorderColor((int)IndexedColors.BLACK.getIndex(), (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setLeftBorderColor((int)IndexedColors.BLACK.getIndex(), (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBottomBorderColor((int)IndexedColors.BLACK.getIndex(), (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setRightBorderColor((int)IndexedColors.BLACK.getIndex(), (CellRangeAddress)cra, (Sheet)sheet);
    }

    private void createDataArea(XSSFSheet sheet, List<ProtectGroup> protectgroups) {
        Map<String, List<List<String>>> dataMap = this.getInfoByPo(protectgroups);
        int rowIndex = 2;
        XSSFCellStyle cs = sheet.getWorkbook().createCellStyle();
        this.initialDataAreaCellStyle(sheet, cs);
        ArrayList<BatchOperation> counterror = new ArrayList<BatchOperation>();
        for (ProtectGroup protectgroup : protectgroups) {
            List<List<String>> poRows = dataMap.get(protectgroup.getUuid());
            int mergeCnt = VerifyUtil.isEmpty(poRows) ? 1 : poRows.size();
            int rowMergeIndex = rowIndex + mergeCnt - 1;
            BatchOperation batchOperation = this.generatePgInExcelCell(sheet, rowIndex, rowMergeIndex, cs, protectgroup);
            this.generatePoInExcelCell(sheet, rowIndex, cs, poRows);
            rowIndex += mergeCnt;
            if (VerifyUtil.isEmpty((String)batchOperation.getTargetName())) continue;
            counterror.add(batchOperation);
        }
        this.result.setResult(counterror);
        this.result.setFailCount(counterror.size());
        this.result.setTotalCount(protectgroups.size());
    }

    private Map<String, StorageResource> prepareResourceForPg(ProtectGroup protectgroup) {
        HashMap<String, StorageResource> resourceMap = new HashMap<String, StorageResource>();
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        HashMap<String, List<String>> groupResourceIds = new HashMap<String, List<String>>();
        if (inSensitiveToStorageTemplateTypeList.contains(protectgroup.getTemplate().getType())) {
            return resourceMap;
        }
        if (notLoadReplicaTemplateTypeList.contains(protectgroup.getTemplate().getType())) {
            return resourceMap;
        }
        List tmpReplicaList = replicaService.queryProtectGroupReplicaByGroup(protectgroup.getUuid(), null, false, null);
        if (VerifyUtil.isEmpty((Collection)tmpReplicaList)) {
            log.debug((Object)("replicaList is empty! pg name :" + protectgroup.getName()));
            return resourceMap;
        }
        List replicaList = tmpReplicaList.stream().filter(replica -> replica.getType() != 3).filter(replica -> replica.getType() != 4).filter(replica -> replica.getType() != 102).collect(Collectors.toList());
        protectgroup.getReplicaList().clear();
        protectgroup.getReplicaList().addAll(replicaList);
        for (ProtectGroupReplica pgr : replicaList) {
            this.groupingResourceIdsByDeviceSN(pgr, groupResourceIds);
        }
        Set entrySet = groupResourceIds.entrySet();
        ProtectObjectStorageInfo posi = (ProtectObjectStorageInfo)protectgroup.getPolist().stream().findFirst().map(po -> po.getUsedStorageResourceSet().stream().findFirst()).get().get();
        DrmEnumDefine.RESOURCE_TYPE_E type = DrmEnumDefine.RESOURCE_TYPE_E.getType((int)posi.getResourceType());
        if (VerifyUtil.isEmpty((Object)type)) {
            logger.error((Object)"unknown resource type of protect object: resourceId=%s, resourceType=%s", new Object[]{posi.getResourceId(), posi.getResourceType()});
            return resourceMap;
        }
        for (Map.Entry entry : entrySet) {
            String deviceSn = (String)entry.getKey();
            List<StorageResource> resources = this.getStorageResources(deviceSn, (List)entry.getValue(), type);
            for (StorageResource storageResource : resources) {
                resourceMap.put(storageResource.getDevSn() + storageResource.getResourceId(), storageResource);
            }
        }
        return resourceMap;
    }

    private BatchOperation generatePgInExcelCell(XSSFSheet sheet, int rowIndex, int rowMergeIndex, XSSFCellStyle cs, ProtectGroup protectgroup) {
        XSSFRow mergeRow = sheet.createRow(rowIndex);
        BatchOperation batchOperation = new BatchOperation();
        Cell cell = mergeRow.createCell(0);
        cell.setCellValue(protectgroup.getName());
        cell.setCellStyle((CellStyle)cs);
        CellRangeAddress cra = new CellRangeAddress(rowIndex, rowMergeIndex, 0, 0);
        this.setRangeBorder(sheet, cra);
        this.mergedCells(sheet, protectgroup, cra);
        cell = mergeRow.createCell(1);
        cell.setCellValue(this.getPoTypeLabel(protectgroup.getPoType()));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(rowIndex, rowMergeIndex, 1, 1);
        this.setRangeBorder(sheet, cra);
        this.mergedCells(sheet, protectgroup, cra);
        cell = mergeRow.createCell(2);
        cell.setCellValue(this.getTemplateName(protectgroup.getTemplate().getName()));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(rowIndex, rowMergeIndex, 2, 2);
        this.setRangeBorder(sheet, cra);
        this.mergedCells(sheet, protectgroup, cra);
        cell = mergeRow.createCell(6);
        cell.setCellValue(this.getDisasterRecoveryPath(protectgroup, batchOperation));
        cs.setAlignment(HorizontalAlignment.LEFT);
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(rowIndex, rowMergeIndex, 6, 6);
        this.setRangeBorder(sheet, cra);
        this.mergedCells(sheet, protectgroup, cra);
        return batchOperation;
    }

    private void generatePoInExcelCell(XSSFSheet sheet, int rowIndex, XSSFCellStyle cs, List<List<String>> poRows) {
        int tmp = 0;
        for (List<String> rowdata : poRows) {
            XSSFRow row = sheet.getRow(rowIndex + tmp);
            if (null == row) {
                row = sheet.createRow(rowIndex + tmp);
            }
            Cell cell = row.createCell(3);
            cell.setCellValue(rowdata.get(0));
            cell.setCellStyle((CellStyle)cs);
            cell = row.createCell(4);
            cell.setCellValue(rowdata.get(2));
            cell.setCellStyle((CellStyle)cs);
            cell = row.createCell(5);
            cell.setCellValue(rowdata.get(1));
            cell.setCellStyle((CellStyle)cs);
            ++tmp;
        }
    }

    private void initialDataAreaCellStyle(XSSFSheet sheet, XSSFCellStyle cs) {
        XSSFFont font = sheet.getWorkbook().createFont();
        font.setBold(true);
        short defaultDataFmt = sheet.getWorkbook().createDataFormat().getFormat("text");
        cs.setDataFormat(defaultDataFmt);
        cs.setAlignment(HorizontalAlignment.CENTER);
        cs.setVerticalAlignment(VerticalAlignment.CENTER);
        cs.setBorderLeft(BorderStyle.THIN);
        cs.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderTop(BorderStyle.THIN);
        cs.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderBottom(BorderStyle.THIN);
        cs.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderRight(BorderStyle.THIN);
        cs.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cs.setWrapText(true);
    }

    private void mergedCells(XSSFSheet sheet, ProtectGroup protectgroup, CellRangeAddress cra) {
        if (protectgroup.getPoCount() > 1) {
            sheet.addMergedRegion(cra);
        }
    }

    private List<StorageResource> getStorageResources(String deviceSn, List<String> resourceIds, DrmEnumDefine.RESOURCE_TYPE_E type) {
        log.debug((Object)("to getStorageResources. deviceSn:" + deviceSn + ", resourceIds:" + resourceIds));
        CommUtil.checkParamEmpty((Object[])new Object[]{deviceSn, resourceIds});
        IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        List srList = storageService.getStorageResources(deviceSn, resourceIds, type);
        return srList;
    }

    private Map<String, List<List<String>>> getInfoByPo(List<ProtectGroup> protectgroups) {
        log.debug((Object)"to getInfoByPo start..");
        HashMap<String, List<List<String>>> dataMap = new HashMap<String, List<List<String>>>();
        for (ProtectGroup protectgroup : protectgroups) {
            String key = protectgroup.getUuid();
            ArrayList data = new ArrayList();
            DrResource dr = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(protectgroup.getPoProviderSN());
            for (ProtectObject protectobject : protectgroup.getPolist()) {
                ArrayList<String> row = new ArrayList<String>();
                row.add(protectobject.getName());
                data.add(row);
                if (protectobject.getPoType() == 14) {
                    DrResource nasSource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(protectobject.getProviderSN());
                    row.add(this.getText(nasSource.getClass().getName()));
                    row.add(nasSource.getIpAddress());
                    continue;
                }
                row.add(this.getText(dr.getClass().getName()));
                if (dr instanceof DrHostGroup) {
                    StringBuffer ipList = new StringBuffer();
                    for (DrResource dRes : dr.getChildResources()) {
                        ipList.append(dRes.getIpAddress());
                        ipList.append(LINE_BREAK);
                    }
                    row.add(ipList.toString().trim());
                    continue;
                }
                row.add(dr.getIpAddress());
            }
            dataMap.put(key, data);
        }
        return dataMap;
    }

    private void groupingResourceIdsByDeviceSN(ProtectGroupReplica pgr, Map<String, List<String>> deviceLuns) {
        log.debug((Object)("to groupingResourceIdsByDeviceSN start.. pgr uuid:" + pgr.getId() + ", deviceLuns:" + deviceLuns));
        for (ProtectObjectReplica por : pgr.getReplicas()) {
            for (RelicaStorageInfo rsi : por.getStorageInfos()) {
                String deviceSN = rsi.getSrcStorageProviderSN();
                String lunId = rsi.getSrcStorageId();
                String tgtDeviceSN = rsi.getStorageProviderSN();
                String tgtLunId = rsi.getStorageId();
                if (deviceLuns.containsKey(deviceSN)) {
                    if (!deviceLuns.get(deviceSN).contains(lunId)) {
                        deviceLuns.get(deviceSN).add(lunId);
                    }
                } else {
                    deviceLuns.put(deviceSN, new ArrayList());
                    deviceLuns.get(deviceSN).add(lunId);
                }
                if (deviceLuns.containsKey(tgtDeviceSN)) {
                    if (deviceLuns.get(tgtDeviceSN).contains(tgtLunId)) continue;
                    deviceLuns.get(tgtDeviceSN).add(tgtLunId);
                    continue;
                }
                deviceLuns.put(tgtDeviceSN, new ArrayList());
                deviceLuns.get(tgtDeviceSN).add(tgtLunId);
            }
        }
    }

    private String getPoTypeLabel(int poType) {
        String typeLabel;
        log.debug((Object)("to getPoTypeLabel start.. poType:" + poType));
        switch (poType) {
            case 11: {
                typeLabel = this.getText("ism.drm.app.type.storage.lun");
                break;
            }
            case 1: {
                typeLabel = this.getText("ism.drm.app.type.oracle");
                break;
            }
            case 2: {
                typeLabel = this.getText("ism.drm.app.type.sqlserver");
                break;
            }
            case 3: {
                typeLabel = this.getText("ism.drm.app.type.db2");
                break;
            }
            case 8: 
            case 13: {
                typeLabel = this.getText("Protection.term.Exchange.label");
                break;
            }
            case 9: {
                typeLabel = this.getText("Protection.term.localFS.label");
                break;
            }
            case 10: {
                typeLabel = this.getText("Protection.term.VMwareVM.label");
                break;
            }
            case 12: {
                typeLabel = this.getText("Protection.term.HWVM.label");
                break;
            }
            case 14: {
                typeLabel = this.getText("protection_term_nasFS_label");
                break;
            }
            case 15: {
                typeLabel = this.getText("ism.drm.app.type.cache");
                break;
            }
            case 16: {
                typeLabel = this.getText("ism.drm.app.type.saphana");
                break;
            }
            default: {
                typeLabel = "--";
            }
        }
        return typeLabel;
    }

    private String getTemplateName(String templatetypename) {
        return this.getText(templatetypename);
    }

    private String getDisasterRecoveryPath(ProtectGroup protectgroup, BatchOperation batchOperation) {
        StringBuffer sb = new StringBuffer();
        try {
            List pps;
            int templatetype = protectgroup.getTemplate().getType();
            String siteRelation = this.getText("ism.drm.protect.group.siterapport") + LINE_BREAK;
            String rdPath = LINE_BREAK + this.getText("ism.drm.protect.group.recoverypath") + LINE_BREAK;
            String siteRelationDesc = "";
            String rdPathDesc = "";
            ArrayList<String> descList = new ArrayList<String>();
            this.siteRelation(templatetype, descList);
            IProtectionPathService protectionPathService = (IProtectionPathService)ServiceLocator.getInstance().getService(IProtectionPathService.class);
            Map<String, StorageResource> storageResources = this.prepareResourceForPg(protectgroup);
            ProtectionPathData ppd = protectionPathService.getPath(protectgroup, storageResources, batchOperation);
            if (3 == templatetype || 5 == templatetype) {
                int actualTemplateType = ppd.getTemplateType();
                this.setDRRingDesc(descList, protectgroup, actualTemplateType);
            }
            if (descList.size() > 1) {
                siteRelationDesc = (String)descList.get(0);
                rdPathDesc = (String)descList.get(1);
            }
            if (null != ppd.getOperation()) {
                batchOperation.setDetailParam(ppd.getOperation().getDetailParam());
                batchOperation.setErrorCode(ppd.getOperation().getErrorCode());
                batchOperation.setExtTargetId(ppd.getOperation().getExtTargetId());
                batchOperation.setOptDetail(ppd.getOperation().getOptDetail());
                batchOperation.setTargetId(ppd.getOperation().getTargetId());
                batchOperation.setTargetName(ppd.getOperation().getTargetName());
                batchOperation.setTargetNameParam(ppd.getOperation().getTargetNameParam());
            }
            if ((pps = ppd.getPathList()).size() >= 2) {
                ((ProtectionPath)pps.get(0)).setName(siteRelation);
                ((ProtectionPath)pps.get(0)).setDecription(siteRelationDesc);
                ((ProtectionPath)pps.get(1)).setName(rdPath);
                ((ProtectionPath)pps.get(1)).setDecription(rdPathDesc);
                for (ProtectionPath pp : pps) {
                    sb.append(pp.getName());
                    sb.append(pp.getDecription());
                    sb.append((String)pp.getPathDetails().get(0) + LINE_BREAK);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("get disaster recovery path failed " + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        String path = sb.toString();
        if (path.length() > 30000) {
            path = (String)path.subSequence(0, 30000) + "..." + LINE_BREAK;
            String alarm = this.getText("ism.drm.protect.group.pathalarm");
            path = path + alarm;
        }
        return path;
    }

    private void setDRRingDesc(List<String> descList, ProtectGroup protectgroup, int actualTemplateType) {
        String[] siteRelationAndPathArray = templateTypePathMap.get(actualTemplateType);
        if (siteRelationAndPathArray == null || siteRelationAndPathArray.length < 2) {
            descList.add("--");
            descList.add("--");
            return;
        }
        Set proReplicas = protectgroup.getReplicaList();
        if (VerifyUtil.isEmpty((Collection)proReplicas)) {
            log.info((Object)("ProtectGroupReplica is empty or null, protectgroup name:" + protectgroup.getName()));
            return;
        }
        for (ProtectGroupReplica proReplica : proReplicas) {
            if (DrmEnumDefine.PROTECT_LOCATION.PL_C.getValue() != proReplica.getProtectLocation()) continue;
            String siteRelationDesc = "";
            StringBuilder rdPathDescBuilder = new StringBuilder();
            this.getRdPathDesc(siteRelationAndPathArray, rdPathDescBuilder);
            descList.clear();
            descList.add(siteRelationDesc);
            descList.add(rdPathDescBuilder.toString());
            break;
        }
    }

    private void siteRelation(int templatetype, List<String> descList) {
        log.debug((Object)("to siteRelation start.. templatetype:" + templatetype + ", descList:" + descList));
        String[] siteRelationAndPathArray = templateTypePathMap.get(templatetype);
        if (siteRelationAndPathArray == null || siteRelationAndPathArray.length < 2) {
            descList.add("--");
            descList.add("--");
            return;
        }
        String siteRelationDesc = null;
        String tempText = this.getText(siteRelationAndPathArray[0]);
        siteRelationDesc = 26 == templatetype || 27 == templatetype ? "" : tempText + LINE_BREAK;
        StringBuilder rdPathDescBuilder = new StringBuilder();
        this.getRdPathDesc(siteRelationAndPathArray, rdPathDescBuilder);
        if (34 == templatetype || 37 == templatetype) {
            siteRelationDesc = "";
            rdPathDescBuilder = new StringBuilder();
        }
        descList.add(siteRelationDesc);
        descList.add(rdPathDescBuilder.toString());
    }

    private void getRdPathDesc(String[] siteRelationAndPathArray, StringBuilder rdPathDescBuilder) {
        for (int i = 1; i < siteRelationAndPathArray.length; ++i) {
            String key = siteRelationAndPathArray[i];
            if (!LINE_BREAK.equals(key)) {
                rdPathDescBuilder.append(this.getText(key));
                continue;
            }
            rdPathDescBuilder.append(key);
        }
    }

    static {
        String siterelationdesc = "ism.drm.protect.group.prositetorecoverysite";
        String[] cascadeAsyncAsyncArray = new String[]{"ism.drm.protect.group.prositetoonetotwo", "ism.drm.protect.group.proluntoonetotwo", LINE_BREAK};
        templateTypePathMap.put(4, cascadeAsyncAsyncArray);
        templateTypePathMap.put(3, cascadeAsyncAsyncArray);
        templateTypePathMap.put(35, cascadeAsyncAsyncArray);
        templateTypePathMap.put(38, cascadeAsyncAsyncArray);
        templateTypePathMap.put(40, cascadeAsyncAsyncArray);
        templateTypePathMap.put(42, cascadeAsyncAsyncArray);
        String[] concurrentSyncAsyncArray = new String[]{"ism.drm.protect.group.prositetoonerecover", "ism.drm.protect.group.proluntoonerecover", LINE_BREAK};
        templateTypePathMap.put(6, concurrentSyncAsyncArray);
        templateTypePathMap.put(5, concurrentSyncAsyncArray);
        templateTypePathMap.put(36, concurrentSyncAsyncArray);
        templateTypePathMap.put(39, concurrentSyncAsyncArray);
        templateTypePathMap.put(41, concurrentSyncAsyncArray);
        templateTypePathMap.put(43, concurrentSyncAsyncArray);
        String[] hyperMetroAsyncRingArray = new String[]{"ism.drm.protect.group.ringnullsitering", "ism.drm.protect.group.proarrayhypermetroasync", LINE_BREAK};
        templateTypePathMap.put(26, hyperMetroAsyncRingArray);
        templateTypePathMap.put(27, hyperMetroAsyncRingArray);
        String[] arrayReplicaAsync = new String[]{siterelationdesc, "ism.drm.protect.group.producttorecoverylun", LINE_BREAK};
        templateTypePathMap.put(1, arrayReplicaAsync);
        templateTypePathMap.put(0, arrayReplicaAsync);
        templateTypePathMap.put(33, arrayReplicaAsync);
        templateTypePathMap.put(11, new String[]{siterelationdesc, "ism.drm.protect.group.provrgtorecoveryvrg", LINE_BREAK});
        String[] arraySnapshot = new String[]{"ism.drm.protect.group.theproductsite", "ism.drm.protect.group.productlun", LINE_BREAK};
        templateTypePathMap.put(2, arraySnapshot);
        templateTypePathMap.put(14, arraySnapshot);
        String[] airGapSnapshot = new String[]{"ism.drm.protect.group.therecoverysite", "ism.drm.protect.group.producttorecoverylun", LINE_BREAK};
        templateTypePathMap.put(44, airGapSnapshot);
        templateTypePathMap.put(45, airGapSnapshot);
        templateTypePathMap.put(46, airGapSnapshot);
        String[] arrayHyperMetro = new String[]{"ism.drm.protect.group.prositearrayhypermetro", "ism.drm.protect.group.proarrayhypermetro", LINE_BREAK};
        templateTypePathMap.put(15, arrayHyperMetro);
        templateTypePathMap.put(19, arrayHyperMetro);
        String[] arrayHyperVault = new String[]{"ism.drm.protect.group.prositearrayhypervault", "ism.drm.protect.group.proarrayhypervault", LINE_BREAK};
        templateTypePathMap.put(17, arrayHyperVault);
        templateTypePathMap.put(30, arrayHyperVault);
        templateTypePathMap.put(47, arrayHyperVault);
        String[] arrayHyperMetroVault = new String[]{"ism.drm.protect.group.prositearrayhypermetrovault", "ism.drm.protect.group.proarrayhypermetrovault", LINE_BREAK};
        templateTypePathMap.put(28, arrayHyperMetroVault);
        templateTypePathMap.put(31, arrayHyperMetroVault);
        templateTypePathMap.put(32, arrayHyperMetroVault);
        String[] arrayHyperMetroAsync = new String[]{"ism.drm.protect.group.prositearrayhypermetroasync", "ism.drm.protect.group.proarrayhypermetroasync", LINE_BREAK};
        templateTypePathMap.put(18, arrayHyperMetroAsync);
        templateTypePathMap.put(23, arrayHyperMetroAsync);
        String[] arrayAsyncHyperMetro = new String[]{"ism.drm.protect.group.prositearrayasynchypermetro", "ism.drm.protect.group.proarrayasynchypermetro", LINE_BREAK};
        templateTypePathMap.put(20, arrayAsyncHyperMetro);
        templateTypePathMap.put(24, arrayAsyncHyperMetro);
        String[] openStackHyperMetroAsyncRingArray = new String[]{"ism.drm.protect.group.proarrayasynchypermetro", "ism.drm.protect.group.proarrayhypermetroasync", LINE_BREAK};
        templateTypePathMap.put(34, openStackHyperMetroAsyncRingArray);
        templateTypePathMap.put(37, openStackHyperMetroAsyncRingArray);
        String[] arrayHyperClone = new String[]{"ism.drm.protect.group.theproductsite", "ism.drm.protect.group.producttorecoverylun", LINE_BREAK};
        templateTypePathMap.put(16, arrayHyperClone);
        String[] osArrayReplica = new String[]{siterelationdesc, "ism.drm.protect.group.producttorecoveryprojandzone", LINE_BREAK};
        templateTypePathMap.put(22, osArrayReplica);
        templateTypePathMap.put(21, osArrayReplica);
    }
}

