/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.provider;

import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.template.manager.TemplateFilterManager;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProvider;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateFilter;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.manager.proxy.StorageAppManagerProxy;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.LegoConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;

@Service(Name="com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate", Desc="", Interface=IProtectObjectProviderDelegate.class)
public class ProtectObjectProviderDelegateImpl
extends BaseService
implements IProtectObjectProviderDelegate {
    private static final Log logger = LogFactory.getInstance(ProtectObjectProviderDelegateImpl.class);
    private static final String CONFIGURE_ENABLE_4DC_TEMPLATE = "enable_4dc_template";
    private static Map<Integer, List<Integer>> mutexTemplateMap = new HashMap<Integer, List<Integer>>();
    private static Map<Integer, List<Integer>> priorityTemplateMap = new HashMap<Integer, List<Integer>>();
    private static List<Integer> doubleActiveTempateList = Arrays.asList(15, 18, 23, 19, 26, 27, 28, 31, 31, 32, 35, 36, 38, 39, 40, 41, 42, 43);
    private Map<Integer, IProtectObjectProvider> providerList = new ConcurrentHashMap<Integer, IProtectObjectProvider>();

    public List<ProtectObject> getSupportProtectObjectTypes() {
        ArrayList<ProtectObject> supportPoList = new ArrayList<ProtectObject>();
        for (Map.Entry<Integer, IProtectObjectProvider> entry : this.providerList.entrySet()) {
            IProtectObjectProvider provider = entry.getValue();
            supportPoList.addAll(provider.getSupportProtectObjectTypes());
        }
        return supportPoList;
    }

    public void onBind(IProtectObjectProvider provider, Map<?, ?> properties) {
        this.providerList.put(provider.getProviderByType(), provider);
    }

    public void onUnbind(IProtectObjectProvider provider, Map<?, ?> properties) {
        this.providerList.remove(provider.getProviderByType());
    }

    public List<ProtectObject> getAvailableProtectObject(int applicationType, String poProviderSn, Map<String, Object> extendCondition) {
        IProtectObjectProvider provider = this.getProviderByAppType(applicationType);
        return provider.getAvailableProtectObject(poProviderSn, extendCondition);
    }

    public void discoveryProtectObjectStorageInfo(int applicationType, ProtectObject po, Map<String, String> condition) {
        IProtectObjectProvider provider = this.getProviderByAppType(applicationType);
        provider.updateProtectObjectProps(po, po.getProps());
        List storageInfoList = provider.getProtectObjectStorageInfo(po);
        this.checkAndInitStorageInfo(storageInfoList);
        if (null != storageInfoList && !storageInfoList.isEmpty()) {
            HashSet storageInfoSet = new HashSet();
            storageInfoSet.addAll(storageInfoList);
            po.setUsedStorageResourceSet(storageInfoSet);
            ProtectGroupHelper.getInstance().saveProtectObjectStorageInfo(po);
        }
    }

    private void checkAndInitStorageInfo(List<ProtectObjectStorageInfo> storageInfoList) {
        if (VerifyUtil.isEmpty(storageInfoList)) {
            logger.info((Object)"storageInfoList is null or empty");
            return;
        }
        int resourceProviderSNSize = storageInfoList.stream().map(ProtectObjectStorageInfo::getResourceProviderSN).collect(Collectors.toSet()).size();
        if (resourceProviderSNSize == 1) {
            logger.info((Object)"resourceProviderSNSize = 1");
            return;
        }
        Map<String, List<ProtectObjectStorageInfo>> lunWWNStorageInfoMap = this.initLunWWNStorageInfoMap(storageInfoList);
        String[] lunWWNStrs = new String[lunWWNStorageInfoMap.size()];
        lunWWNStorageInfoMap.keySet().toArray(lunWWNStrs);
        List lunResourcesList = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(lunWWNStrs);
        if (VerifyUtil.isEmpty((Collection)lunResourcesList)) {
            logger.info((Object)"lunResourcesList is null or empty");
            return;
        }
        Map<String, List<Lun>> lunWWNLunListMap = this.initLunWWNLunListMap(lunResourcesList);
        this.initResourceProSNAndResourceId(lunWWNStorageInfoMap, lunWWNLunListMap);
    }

    private Map<String, List<ProtectObjectStorageInfo>> initLunWWNStorageInfoMap(List<ProtectObjectStorageInfo> storageInfoList) {
        HashMap<String, List<ProtectObjectStorageInfo>> lunWWNStorageInfoMap = new HashMap<String, List<ProtectObjectStorageInfo>>();
        for (ProtectObjectStorageInfo storageInfo : storageInfoList) {
            List<ProtectObjectStorageInfo> storageInfoListIn;
            String lunWWN = storageInfo.getLunWWN();
            if (!lunWWNStorageInfoMap.containsKey(lunWWN)) {
                storageInfoListIn = new ArrayList();
                lunWWNStorageInfoMap.put(lunWWN, storageInfoListIn);
            } else {
                storageInfoListIn = (List)lunWWNStorageInfoMap.get(lunWWN);
            }
            storageInfoListIn.add(storageInfo);
        }
        return lunWWNStorageInfoMap;
    }

    private Map<String, List<Lun>> initLunWWNLunListMap(List<StorageResource> lunResourcesList) {
        HashMap<String, List<Lun>> lunWWNLunListMap = new HashMap<String, List<Lun>>();
        for (StorageResource storageResources : lunResourcesList) {
            List<Lun> lunList;
            if (!Lun.class.isInstance(storageResources)) {
                logger.info((Object)"storageResources is not Lun");
                continue;
            }
            Lun lun = (Lun)Lun.class.cast(storageResources);
            String lunWWN = lun.getWwn();
            if (!lunWWNLunListMap.containsKey(lunWWN)) {
                lunList = new ArrayList();
                lunWWNLunListMap.put(lunWWN, lunList);
            } else {
                lunList = (List)lunWWNLunListMap.get(lunWWN);
            }
            lunList.add(lun);
        }
        return lunWWNLunListMap;
    }

    private void initResourceProSNAndResourceId(Map<String, List<ProtectObjectStorageInfo>> lunWWNStorageInfoMap, Map<String, List<Lun>> lunWWNLunListMap) {
        Set providers = lunWWNLunListMap.values().stream().filter(e -> e.size() == 1).map(e -> ((Lun)e.get(0)).getDevSn()).collect(Collectors.toSet());
        List<List> lunsCollection = lunWWNLunListMap.values().stream().filter(e -> e.size() > 1).collect(Collectors.toList());
        lunsCollection.forEach(items -> {
            Lun lun = items.stream().filter(item -> providers.contains(item.getDevSn())).findFirst().orElseGet(() -> {
                Lun item = (Lun)items.get(0);
                providers.add(item.getDevSn());
                return item;
            });
            this.setResourceProSNAndResourceId((List)lunWWNStorageInfoMap.get(lun.getWwn()), lun);
        });
    }

    private void setResourceProSNAndResourceId(List<ProtectObjectStorageInfo> storageInfoList, Lun lun) {
        for (ProtectObjectStorageInfo storageInfo : storageInfoList) {
            storageInfo.setResourceProviderSN(lun.getDevSn());
            storageInfo.setResourceId(lun.getResourceId());
        }
    }

    public List<PolicyTemplate> getAvailablePolicyTemplate(int appType, List<ProtectObject> poList, int replicationType) {
        IProtectObjectProvider provider = this.getProviderByAppType(appType);
        provider.loadProtectObjectStorageInfo(poList);
        List ptList = provider.getSupportPolicyTemplate(poList, replicationType);
        if (ptList != null && !ptList.isEmpty()) {
            return this.filterAvailablePolicyTemplate(ptList, poList, appType);
        }
        return new ArrayList<PolicyTemplate>();
    }

    private List<PolicyTemplate> filterStorageSupportProtectType(List<PolicyTemplate> ptList, List<ProtectObject> poList, int appType) {
        Set resourceSet = poList.get(0).getUsedStorageResourceSet();
        if (VerifyUtil.isEmpty((Collection)resourceSet)) {
            return ptList;
        }
        String deviceId = ((ProtectObjectStorageInfo)resourceSet.iterator().next()).getResourceProviderSN();
        Map<Integer, List> appMap = StorageAppManagerProxy.getInstance().getSupportedApp(deviceId);
        if (null == appMap) {
            return ptList;
        }
        List appPoTypes = appMap.get(appType);
        ArrayList<PolicyTemplate> ptListTmp = new ArrayList<PolicyTemplate>();
        if (!VerifyUtil.isEmpty((Collection)appPoTypes)) {
            for (PolicyTemplate template : ptList) {
                if (!appPoTypes.contains(template.getType())) continue;
                ptListTmp.add(template);
            }
        }
        return ptListTmp;
    }

    private List<PolicyTemplate> filterForConfig(List<PolicyTemplate> ptList) {
        if (VerifyUtil.isEmpty(ptList)) {
            return ptList;
        }
        Boolean enable4DC = Boolean.valueOf(LegoConfig.getInstance().getKeyValue(CONFIGURE_ENABLE_4DC_TEMPLATE));
        Iterator<PolicyTemplate> it = ptList.iterator();
        while (it.hasNext()) {
            PolicyTemplate template = it.next();
            if (enable4DC.booleanValue() || 35 != template.getType() && 36 != template.getType()) continue;
            it.remove();
        }
        return ptList;
    }

    private List<PolicyTemplate> filterAvailablePolicyTemplate(List<PolicyTemplate> ptList, List<ProtectObject> poList, int appType) {
        ArrayList<PolicyTemplate> result = new ArrayList<PolicyTemplate>();
        Set<Integer> mutexTemplateSet = this.exludeMutexTemplate(poList);
        this.filterOutTemplateByStorageInfo(ptList, poList, appType);
        ptList = this.filterStorageSupportProtectType(ptList, poList, appType);
        ptList = this.filterForConfig(ptList);
        ArrayList<PolicyTemplate> policyTemplateToFilter = new ArrayList<PolicyTemplate>();
        for (PolicyTemplate template : ptList) {
            int type = template.getType();
            if (mutexTemplateSet.contains(type)) {
                template.setAvailable(false);
                template.setErrorCode(1073948214L);
                result.add(template);
                continue;
            }
            if (!template.isAvailable()) {
                result.add(template);
                continue;
            }
            policyTemplateToFilter.add(template);
        }
        result.addAll(PolicyTemplateTools.getInstance().filterAvaiableTemplate(poList, policyTemplateToFilter));
        this.hideLowPriorityTemplate(result);
        return this.classifyPolicyTemplate(result);
    }

    private void filterOutTemplateByStorageInfo(List<PolicyTemplate> ptList, List<ProtectObject> poList, int appType) {
        for (ProtectObject po : poList) {
            if (VerifyUtil.isEmpty((Object)po)) {
                logger.error((Object)"The protectObject is empty!", 90160758787071L);
                continue;
            }
            Set usedStorageResourceSet = po.getUsedStorageResourceSet();
            if (VerifyUtil.isEmpty((Collection)usedStorageResourceSet)) {
                logger.error((Object)("The usedStorageResourceSet is empty! po,MoUuid: " + po.getMoUuid() + ", poName:" + po.getName()), 90160758787071L);
                continue;
            }
            Boolean isDoubleActiveResourceExisted = this.isDoubleActiveResourceExisted(usedStorageResourceSet);
            if (!isDoubleActiveResourceExisted.booleanValue()) continue;
            for (PolicyTemplate pt : ptList) {
                this.checkPolicyTemple(pt);
            }
        }
        this.checkNasHyperMetorAsyncRep(ptList, poList, appType);
        this.checkNasHyperMetorSnapshot(ptList, poList);
    }

    private void checkPolicyTemple(PolicyTemplate pt) {
        int type = pt.getType();
        if (!doubleActiveTempateList.contains(type)) {
            pt.setAvailable(false);
            pt.setErrorCode(1073948191L);
        }
    }

    private Boolean isDoubleActiveResourceExisted(Set<ProtectObjectStorageInfo> usedStorageResourceSet) {
        Boolean isDoubleActiveResourceExisted = false;
        for (ProtectObjectStorageInfo protectObjectStorageInfo : usedStorageResourceSet) {
            List<HyperMetroPair> pairList = null;
            if (Integer.valueOf(DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue()).equals(protectObjectStorageInfo.getResourceType())) {
                pairList = StorageResourceServiceRouter.getInstance().getHyperMetroPairsByFileSystemIds(null, protectObjectStorageInfo.getResourceProviderSN(), Arrays.asList(protectObjectStorageInfo.getResourceId()), null, true);
                if (!this.isAllPairNormal(pairList)) continue;
                logger.info((Object)"The nas resource is double Active Resource!", 90160758786897L);
                isDoubleActiveResourceExisted = true;
                break;
            }
            String wwn = protectObjectStorageInfo.getLunWWN();
            if (VerifyUtil.isEmpty((String)wwn)) continue;
            List resources = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(new String[]{wwn});
            ArrayList<String> wwnList = new ArrayList<String>();
            wwnList.add(wwn);
            pairList = StorageResourceServiceRouter.getInstance().getHyperMetroPairsByWwns(null, wwnList, null, true);
            if (!this.isAllPairNormal(pairList) || resources.size() != 2) continue;
            logger.info((Object)"The resource is double Active Resource!", 90160758786897L);
            isDoubleActiveResourceExisted = true;
            break;
        }
        return isDoubleActiveResourceExisted;
    }

    private boolean isAllPairNormal(List<HyperMetroPair> pairList) {
        if (!VerifyUtil.isEmpty(pairList)) {
            for (HyperMetroPair hyperMetroPair : pairList) {
                if (String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue()).equals(hyperMetroPair.getRunningState())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void hideLowPriorityTemplate(List<PolicyTemplate> result) {
        HashSet<Integer> allType = new HashSet<Integer>();
        for (PolicyTemplate pt : result) {
            if (!pt.isAvailable()) continue;
            allType.add(pt.getType());
        }
        block1: for (PolicyTemplate pt : result) {
            int type = pt.getType();
            List<Integer> highPriorityTypes = priorityTemplateMap.get(type);
            if (VerifyUtil.isEmpty(highPriorityTypes)) continue;
            for (Integer highPriorityType : highPriorityTypes) {
                if (!allType.contains(highPriorityType)) continue;
                pt.setAvailable(false);
                pt.setErrorCode(1073948191L);
                continue block1;
            }
        }
    }

    private Set<Integer> exludeMutexTemplate(List<ProtectObject> poList) {
        HashSet<Integer> mutexTemplateSet = new HashSet<Integer>();
        for (ProtectObject po : poList) {
            List<ProtectObject> tmpPolist = this.getProtectObjectBymoUuid(po.getMoUuid());
            if (tmpPolist.isEmpty()) continue;
            for (ProtectObject tpo : tmpPolist) {
                ProtectGroup pg = tpo.getProtectGroup();
                int templateType = pg.getTemplate().getType();
                List<Integer> mutexTemplateList = mutexTemplateMap.get(templateType);
                if (VerifyUtil.isEmpty(mutexTemplateList)) {
                    List<Integer> allowTypes = Arrays.asList(16);
                    if (allowTypes.contains(templateType)) continue;
                    mutexTemplateSet.add(templateType);
                    continue;
                }
                mutexTemplateSet.addAll(mutexTemplateList);
            }
        }
        return mutexTemplateSet;
    }

    private List<PolicyTemplate> classifyPolicyTemplate(List<PolicyTemplate> result) {
        HashMap<Integer, PolicyTemplate> classifiedTemplateMap = new HashMap<Integer, PolicyTemplate>();
        for (PolicyTemplate pt : result) {
            PolicyTemplate policyTemplate;
            int type = pt.getType();
            if (type == 29 || type == 25) continue;
            Integer classifiedType = (Integer)PolicyTemplateType.CLASSIFIED_POLICYTEMPLATE.get(type);
            if (classifiedType == null) {
                logger.error((Object)"the type of the policytemplate is not added to PolicyTemplateType.CLASSIFIED_POLICYTEMPLATE!", 90160758787071L);
            }
            if ((policyTemplate = (PolicyTemplate)classifiedTemplateMap.get(classifiedType)) != null && !pt.isAvailable()) continue;
            classifiedTemplateMap.put(classifiedType, pt);
        }
        return new ArrayList<PolicyTemplate>(classifiedTemplateMap.values());
    }

    public IProtectObjectProvider getProviderByAppType(int applicationType) {
        IProtectObjectProvider provider = this.providerList.get(applicationType);
        if (null == provider) {
            String errorMsg = "connot get provider by " + applicationType;
            throw new LegoCheckedException(1073947395L, errorMsg);
        }
        return provider;
    }

    public List<NasFileSystem> filterAirGapNas(String devSn, List<NasFileSystem> nasFsList, boolean shouldBelongVstorePair) {
        IProtectObjectProvider provider = this.providerList.get(14);
        if (VerifyUtil.isEmpty((Object)provider)) {
            String errorMsg = "Cannot get Nas FileSystem provider!";
            throw new LegoCheckedException(1073947395L, errorMsg);
        }
        return provider.filterAirGapNas(devSn, nasFsList, shouldBelongVstorePair);
    }

    public boolean testProtectObject(int applicationType, ProtectObject po) {
        IProtectObjectProvider provider = this.getProviderByAppType(applicationType);
        return provider.testProtectObject(po);
    }

    public List<ProtectObject> getAddAvailableProtectObject(int applicationType, String poProviderSn, String pgId, Map<String, Object> extParamInQueryParam) {
        IProtectObjectProvider provider = this.getProviderByAppType(applicationType);
        return provider.getAddAvailableProtectObject(poProviderSn, pgId, extParamInQueryParam);
    }

    private List<ProtectObject> getProtectObjectBymoUuid(String moUuid) {
        if (VerifyUtil.isEmpty((String)moUuid)) {
            logger.error((Object)"getting databaseinstance is error because hostSN is empty", 90160758786896L);
            throw new LegoCheckedException(1073947393L);
        }
        Session session = null;
        List result = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria crit = session.createCriteria(ProtectObject.class);
            crit.add((Criterion)Restrictions.eq((String)"moUuid", (Object)moUuid));
            crit.createAlias("protectGroup", "protectGroup").add(Restrictions.isNotNull((String)"protectGroup.pgId"));
            crit.addOrder(Order.asc((String)"name"));
            result = crit.list();
        }
        catch (DataAccessException e) {
            try {
                logger.error((Object)"failed to query ProtectObject by host.", (Throwable)e, 90160758786896L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession(session);
        return result;
    }

    public boolean validateDbAuthInfo(int applicationType, ProtectObject po) {
        IProtectObjectProvider provider = this.getProviderByAppType(applicationType);
        provider.updateProtectObjectProps(po, po.getProps());
        return this.testProtectObject(applicationType, po);
    }

    public Map<String, Object> pretreatmentParams(int applicationType, Map<String, Object> params) {
        IProtectObjectProvider provider = this.getProviderByAppType(applicationType);
        return provider.pretreatmentParams(params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProtectLocationPath> getScheduleSiteInfo(int poType, String ptUuid, List<ProtectObject> poList) {
        ProtectGroup protectGroup;
        IPolicyTemplateFilter filter;
        Session session;
        block7: {
            List list;
            IProtectObjectProvider provider = this.getProviderByAppType(poType);
            IBaseDao baseDao = CommonDAOLocator.getBaseDao();
            session = null;
            try {
                session = baseDao.getHibernateTemplate().getSessionFactory().openSession();
                Criteria criteria = session.createCriteria(PolicyTemplate.class);
                criteria.add((Criterion)Restrictions.eq((String)"ptId", (Object)ptUuid));
                List policyTemplates = criteria.list();
                if (VerifyUtil.isEmpty((Collection)policyTemplates)) {
                    throw new LegoCheckedException(-1L);
                }
                PolicyTemplate pt = (PolicyTemplate)policyTemplates.get(0);
                TemplateFilterManager manager = TemplateFilterManager.getInstance();
                filter = manager.getTemplateFilterByType(pt.getType());
                if (null == filter) {
                    logger.error((Object)("The policyTemplateFilter is null! PtType = " + pt.getType()), 90160758787071L);
                    throw new LegoCheckedException(-1L);
                }
                protectGroup = this.getProtectGroupByPolicytemplate(pt);
                if (protectGroup != null) break block7;
                provider.loadProtectObjectStorageInfo(poList);
                list = filter.getProtectLocationPaths(poList);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
            return list;
        }
        String protectionPathJson = (String)protectGroup.getProps().get("PROTECTGROUP_PROTECTLOCATIONPATH");
        List pathList = null;
        if (VerifyUtil.isEmpty((String)protectionPathJson)) {
            pathList = filter.getProtectLocationPaths(new ArrayList(protectGroup.getPolist()));
            protectGroup.getProps().put("PROTECTGROUP_PROTECTLOCATIONPATH", JSONArray.fromObject((Object)pathList).toString());
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)protectGroup);
        } else {
            ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
            JSONArray array = JSONArray.fromObject((Object)protectionPathJson);
            pathList = JSONArray.toCollection((JSONArray)array, ProtectLocationPath.class);
            pathList.stream().filter(item -> !VerifyUtil.isEmpty((Object)item)).forEach(item -> {
                Site protectedSite;
                Site recoverySite = siteService.getSiteById(item.getRecoverySiteId());
                if (!VerifyUtil.isEmpty((Object)recoverySite)) {
                    item.setRecoverySiteName(recoverySite.getName());
                }
                if (!VerifyUtil.isEmpty((Object)(protectedSite = siteService.getSiteById(item.getProtectedSiteId())))) {
                    item.setProtectedSiteName(protectedSite.getName());
                }
            });
        }
        List list = pathList;
        DBOperationUtil.closeSession(session);
        return list;
    }

    private void checkNasHyperMetorAsyncRep(List<PolicyTemplate> ptList, List<ProtectObject> poList, int appType) {
        if (VerifyUtil.isEmpty(poList) || VerifyUtil.isEmpty(ptList)) {
            return;
        }
        Set usedStorageResourceSet = ((ProtectObject)CommonUtil.getFirstElement(poList)).getUsedStorageResourceSet();
        if (VerifyUtil.isEmpty((Collection)usedStorageResourceSet)) {
            return;
        }
        Integer resourceType = ((ProtectObjectStorageInfo)CommonUtil.getFirstElement((Collection)usedStorageResourceSet)).getResourceType();
        if (12 == appType && null != resourceType && resourceType.equals(DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue())) {
            for (PolicyTemplate pt : ptList) {
                int type = pt.getType();
                if (type != 18 && type != 20) continue;
                pt.setAvailable(false);
                pt.setErrorCode(1073948191L);
                logger.debug((Object)"Nas not surrpot Hyper asyncReplication");
            }
        }
    }

    private void checkNasHyperMetorSnapshot(List<PolicyTemplate> ptList, List<ProtectObject> poList) {
        if (VerifyUtil.isEmpty(poList) || VerifyUtil.isEmpty(ptList)) {
            return;
        }
        Set usedStorageResourceSet = ((ProtectObject)CommonUtil.getFirstElement(poList)).getUsedStorageResourceSet();
        if (VerifyUtil.isEmpty((Collection)usedStorageResourceSet)) {
            return;
        }
        Integer resourceType = ((ProtectObjectStorageInfo)CommonUtil.getFirstElement((Collection)usedStorageResourceSet)).getResourceType();
        if (null != resourceType && resourceType.equals(DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue())) {
            for (PolicyTemplate pt : ptList) {
                int type = pt.getType();
                if (19 != type) continue;
                pt.setAvailable(false);
                pt.setErrorCode(1073948191L);
                logger.debug((Object)"Nas not surrpot Hyper snapshot");
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProtectGroup getProtectGroupByPolicytemplate(PolicyTemplate pt) {
        Session session;
        block2: {
            ProtectGroup protectGroup;
            session = null;
            try {
                session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                Criteria criteria = session.createCriteria(ProtectGroup.class);
                criteria.add((Criterion)Restrictions.eq((String)"template", (Object)pt));
                List protectGroups = criteria.list();
                if (VerifyUtil.isEmpty((Collection)protectGroups)) break block2;
                protectGroup = (ProtectGroup)protectGroups.iterator().next();
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
            return protectGroup;
        }
        DBOperationUtil.closeSession(session);
        return null;
    }

    static {
        mutexTemplateMap.put(2, Arrays.asList(2));
        mutexTemplateMap.put(1, Arrays.asList(1, 17, 30));
        mutexTemplateMap.put(15, Arrays.asList(15, 1, 16));
        mutexTemplateMap.put(18, Arrays.asList(18, 1, 2, 19, 16, 31, 30));
        mutexTemplateMap.put(23, Arrays.asList(23, 0, 2, 19, 16));
        mutexTemplateMap.put(19, Arrays.asList(18, 23, 1, 2, 19, 16));
        mutexTemplateMap.put(14, Arrays.asList(14, 17));
        mutexTemplateMap.put(17, Arrays.asList(17, 14, 1));
        mutexTemplateMap.put(30, Arrays.asList(1, 31));
        mutexTemplateMap.put(31, Arrays.asList(18, 30, 1));
        mutexTemplateMap.put(32, Arrays.asList(20, 30, 1));
        mutexTemplateMap.put(20, Arrays.asList(32, 30));
        mutexTemplateMap.put(33, Arrays.asList(1, 33));
        mutexTemplateMap.put(46, Arrays.asList(45, 46, 1));
        mutexTemplateMap.put(45, Arrays.asList(46, 45, 1));
        priorityTemplateMap.put(1, Arrays.asList(6, 15, 18, 19, 20, 36, 39, 41, 43, 44, 47, 45, 46));
        priorityTemplateMap.put(2, Arrays.asList(18, 19, 44, 45, 46));
        priorityTemplateMap.put(16, Arrays.asList(18, 19, 15));
        priorityTemplateMap.put(0, Arrays.asList(24));
        priorityTemplateMap.put(18, Arrays.asList(26));
        priorityTemplateMap.put(20, Arrays.asList(27));
        priorityTemplateMap.put(19, Arrays.asList(35, 36, 38, 39, 40, 41, 42, 43));
    }
}

