/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.replica;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.anti.blackmail.manager.proxy.AntiBlackmailSnapshotManagerProxy;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.service.IAntiBlackmailSnapshotManager;
import com.huawei.ism.drm.anti.blackmail.service.AntiBlackmailSnapshotDeleteService;
import com.huawei.ism.drm.anti.blackmail.util.AntiBlackmailResourceLockUtil;
import com.huawei.ism.drm.anti.blackmail.util.AntiBlackmailUtil;
import com.huawei.ism.drm.constant.AntiBlackMailEnumDefine;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;

public class DeleteAntiBlackmailReplicaTask
implements Callable<BatchOperationResult> {
    private static Log logger = LogFactory.getInstance(DeleteAntiBlackmailReplicaTask.class);
    private String replicaId;
    private String devSn;
    private ProtectGroupReplica firstUninfectedReplica;

    public DeleteAntiBlackmailReplicaTask(String replicaId, String devSn, ProtectGroupReplica firstUninfectedReplica) {
        this.replicaId = replicaId;
        this.devSn = devSn;
        this.firstUninfectedReplica = firstUninfectedReplica;
    }

    @Override
    public BatchOperationResult call() {
        BatchOperationResult result = new BatchOperationResult();
        String lockKey = this.replicaId + "AntiBlackmailSnapshotReplica";
        if (!AntiBlackmailResourceLockUtil.tryLock(lockKey)) {
            this.addFailRes(this.replicaId, 1677929494L, new String[]{this.replicaId}, result);
            logger.error((Object)"Delete snapshot error, replica is using by other program, replicaId: %s", new Object[]{this.replicaId});
            return result;
        }
        this.dealDelete(this.replicaId, this.firstUninfectedReplica, result, this.devSn);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealDelete(String replicaId, ProtectGroupReplica first, BatchOperationResult result, String devSn) {
        boolean isSuccess = true;
        try {
            ProtectGroupReplica replica = ((IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class)).queryProtectGroupReplicaById(replicaId);
            if (VerifyUtil.isEmpty((Object)replica)) {
                this.addFailRes(replicaId, 1073948521L, null, result);
                logger.error((Object)"Delete snapshot error, replica not exist, replicaId: %s", new Object[]{replicaId});
                isSuccess = false;
                return;
            }
            if (!AntiBlackmailSnapshotDeleteService.preAddOneTaskNum()) {
                this.addFailRes(replicaId, 1073948522L, new String[]{String.valueOf(512)}, result);
                logger.error((Object)"Delete snapshot error, back delete task exceed limit, replicaId: %s", new Object[]{replicaId});
                isSuccess = false;
                return;
            }
            if (!VerifyUtil.isEmpty((Object)first) && replicaId.equals(first.getId())) {
                this.addFailResAndDecreaseOne(replicaId, 1073948523L, null, result);
                logger.error((Object)"Delete snapshot error, replica is newest uninfected, replicaId: %s", new Object[]{replicaId});
                isSuccess = false;
                return;
            }
            if (this.isDetectionStatusRunning(replica)) {
                logger.error((Object)"Delete snapshot error, replica is in detecting, replicaId: %s", new Object[]{replicaId});
                this.addFailResAndDecreaseOne(replicaId, 1073948524L, null, result);
                isSuccess = false;
                return;
            }
            if (replica.getType() == 11) {
                isSuccess = this.doDeleteAndSetResult(devSn, replica, replicaId, result);
                return;
            }
            if (AntiBlackmailUtil.checkSecureSnapshotCanBeDelete(devSn, replica)) {
                logger.error((Object)"Delete snapshot error, replica exists secure snapshot, replicaId: %s", new Object[]{replicaId});
                this.addFailResAndDecreaseOne(replicaId, 1073948526L, null, result);
                isSuccess = false;
            } else {
                isSuccess = this.doDeleteAndSetResult(devSn, replica, replicaId, result);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Delete snapshot error, replica exists secure snapshot, replicaId: %s", new Object[]{replicaId});
            isSuccess = false;
        }
        finally {
            if (!isSuccess) {
                this.unlockRes(replicaId);
            }
        }
    }

    private void unlockRes(String replicaId) {
        AntiBlackmailResourceLockUtil.unlockRes(replicaId + "AntiBlackmailSnapshotReplica");
    }

    private boolean isDetectionStatusRunning(ProtectGroupReplica replica) {
        return replica.getDetectionStatus() == AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum.SCANNING.getValue();
    }

    private boolean doDeleteAndSetResult(String devSn, ProtectGroupReplica replica, String replicaId, BatchOperationResult result) {
        IAntiBlackmailSnapshotManager snapshotManager = AntiBlackmailSnapshotManagerProxy.getInstance().getSnapshotManager(devSn);
        if (!this.doDeleteSnapshot(devSn, replica, snapshotManager)) {
            logger.error((Object)"Delete snapshot error, send delete task to PM fail, replicaId: %s", new Object[]{replicaId});
            this.addFailResAndDecreaseOne(replicaId, 1073948525L, null, result);
            return false;
        }
        this.addSuccessRes(replicaId, result);
        return true;
    }

    private boolean doDeleteSnapshot(String devSn, ProtectGroupReplica replica, IAntiBlackmailSnapshotManager snapshotManager) {
        HashSet<ProtectObjectReplica> replicaSet = new HashSet<ProtectObjectReplica>();
        ArrayList<String> successIds = new ArrayList<String>();
        replica.getReplicas().stream().filter(poReplica -> !VerifyUtil.isEmpty((Object)poReplica)).forEach(poReplica -> this.doDeleteSnapshotBySnapshotId(devSn, snapshotManager, (Set<ProtectObjectReplica>)replicaSet, (List<String>)successIds, (ProtectObjectReplica)poReplica));
        if (replicaSet.size() > 0) {
            AntiBlackmailUtil.updateReplica(replica.getId(), 3, replicaSet);
            return false;
        }
        AntiBlackmailUtil.buildBackTaskAndAddToCache(devSn, replica, successIds, true);
        AntiBlackmailUtil.updateReplica(replica.getId(), 4, replicaSet);
        return true;
    }

    private void doDeleteSnapshotBySnapshotId(String devSn, IAntiBlackmailSnapshotManager snapshotManager, Set<ProtectObjectReplica> replicaSet, List<String> successIds, ProtectObjectReplica poReplica) {
        Set storageReplicaList = poReplica.getStorageInfos();
        storageReplicaList.stream().filter(storageInfo -> !VerifyUtil.isEmpty((Object)storageInfo)).forEach(storageInfo -> {
            if (!(storageInfo instanceof LocalStorageReplica)) {
                return;
            }
            LocalStorageReplica storageReplica = (LocalStorageReplica)storageInfo;
            String snapshotUuid = storageReplica.getSnapshotName();
            OperationResult operationResult = snapshotManager.deleteSpecificSnapshot(devSn, snapshotUuid);
            if (operationResult.isSuccess()) {
                successIds.add(snapshotUuid);
                return;
            }
            if (!VerifyUtil.isEmpty((String)operationResult.getErrorCode()) && operationResult.getErrorCode().equals(String.valueOf(1677929217L))) {
                logger.info((Object)"Snapshot(%s) has already been deleted in ProtectManager.", new Object[]{snapshotUuid});
            } else {
                replicaSet.add(poReplica);
            }
        });
    }

    private void addFailRes(String replicaId, long errorCode, String[] detailParam, BatchOperationResult result) {
        BatchOperation batchOperation = new BatchOperation();
        batchOperation.setExtTargetId((Object)replicaId);
        batchOperation.setErrorCode(errorCode);
        batchOperation.setDetailParam(detailParam);
        result.setFailCount(result.getFailCount() + 1);
        result.setTotalCount(result.getTotalCount() + 1);
        result.getResult().add(batchOperation);
    }

    private void addFailResAndDecreaseOne(String replicaId, long errorCode, String[] detailParam, BatchOperationResult result) {
        this.addFailRes(replicaId, errorCode, detailParam, result);
        AntiBlackmailSnapshotDeleteService.taskNumDecreaseOne();
    }

    private void addSuccessRes(String replicaId, BatchOperationResult result) {
        BatchOperation batchOperation = new BatchOperation();
        batchOperation.setExtTargetId((Object)replicaId);
        result.setSucceedCount(result.getSucceedCount() + 1);
        result.setTotalCount(result.getTotalCount() + 1);
        result.getResult().add(batchOperation);
    }
}

