/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.replica;

import com.huawei.ism.array.sdk.model.FusionStorageUnit;
import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.StringEscapeUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.anti.blackmail.util.AntiBlackmailResourceLockUtil;
import com.huawei.ism.drm.anti.blackmail.util.AntiBlackmailUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.DrmStorageUtil;
import com.huawei.ism.drm.constant.AntiBlackMailEnumDefine;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.constant.ReplicaMountStatus;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.protection.framework.service.group.refinement.QueryProtectGroupRefineService;
import com.huawei.ism.drm.protection.framework.service.replica.DeleteAntiBlackmailReplicaTask;
import com.huawei.ism.drm.protection.framework.service.replica.factory.IReplicaFactory;
import com.huawei.ism.drm.protection.framework.service.replica.factory.ReplicaFactoryManager;
import com.huawei.ism.drm.protection.framework.service.task.CloneReplicaTask;
import com.huawei.ism.drm.protection.framework.service.task.DeleteReplicaTask;
import com.huawei.ism.drm.protection.framework.template.factory.ReplicaBuilderFactory;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.protection.template.sdk.service.IReplicaBuilder;
import com.huawei.ism.drm.recovery.framework.task.CreateMountReplicaPlanTask;
import com.huawei.ism.drm.recovery.framework.task.MountBackTaskHandler;
import com.huawei.ism.drm.recovery.framework.task.UmountReplicaTask;
import com.huawei.ism.drm.recovery.sdk.model.MountConfiguration;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotScheduleManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotScheduleManager;
import com.huawei.ism.drm.storage.util.SnapshotScheduleUtil;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.ReplicaUtil;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.TimeUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

@Service(Name="com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService", Desc="", Interface=IReplicaService.class)
public class ReplicaServiceImpl
extends BaseService
implements IReplicaService {
    private static Log logger = LogFactory.getInstance(ReplicaServiceImpl.class);
    private ReplicaBuilderFactory replicaBuilderFactory = ReplicaBuilderFactory.getInstance();
    private IBaseDao<Object, Serializable> baseDao;

    public void setBaseDao(IBaseDao<Object, Serializable> baseDao) {
        this.baseDao = baseDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProtectGroupReplica> queryProtectGroupReplicaByGroup(String groupId, String orderBy, boolean isAsc, List<QueryCondition> props) {
        Session session;
        List<Object> result;
        block11: {
            if (VerifyUtil.isEmpty((String)groupId)) {
                logger.error((Object)"getting ProtectGroupReplica is error because groupId is empty", 90160758786896L);
                throw new LegoCheckedException(1073947393L);
            }
            if (VerifyUtil.isEmpty((String)orderBy)) {
                orderBy = "name";
            }
            if (null == props) {
                props = new ArrayList<QueryCondition>();
            }
            List criterionList = this.baseDao.translatePropsToCriterions(props);
            result = new ArrayList<ProtectGroupReplica>();
            session = null;
            try {
                session = this.baseDao.getHibernateTemplate().getSessionFactory().openSession();
                Criteria criteria = session.createCriteria(ProtectGroupReplica.class);
                for (Criterion criterion : criterionList) {
                    criteria.add(criterion);
                }
                if (isAsc) {
                    criteria.addOrder(Order.asc((String)orderBy));
                } else {
                    criteria.addOrder(Order.desc((String)orderBy));
                }
                criteria.createAlias("pg", "pg").add((Criterion)Restrictions.eq((String)"pg.pgId", (Object)groupId));
                result = criteria.list();
                if (VerifyUtil.isEmpty(result)) break block11;
                for (ProtectGroupReplica protectGroupReplica : result) {
                    Hibernate.initialize((Object)protectGroupReplica.getReplicas());
                }
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("Failed to query replicas!" + ExceptionUtil.getErrorMessage((Throwable)e)));
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return result;
    }

    public Page pagedQueryProtectGroupReplicaByGroup(String groupId, int pageNo, int pageSize, String orderBy, boolean isAsc, List<QueryCondition> props) {
        List<ProtectGroupReplica> pgReplicas = this.queryProtectGroupReplicaByGroup(groupId, orderBy, isAsc, props);
        Page result = Page.createPage((int)pageNo, (int)pageSize, pgReplicas);
        List tempList = (List)result.getResult();
        for (ProtectGroupReplica tempReplica : tempList) {
            this.updateProductSiteName(tempReplica.getPg());
        }
        return result;
    }

    public void updatePrtectGroupReplicaStatus(String replicaPgId, Integer status) {
        if (VerifyUtil.isEmpty((String)replicaPgId)) {
            logger.debug((Object)"replicaPgId is null,not update PrtectGroupReplicaStatus.");
            return;
        }
        ProtectGroupReplica pgReplica = (ProtectGroupReplica)this.baseDao.getHibernateTemplate().get(ProtectGroupReplica.class, (Serializable)((Object)replicaPgId));
        if (null != pgReplica && null != DrmEnumDefine.REPLICA_STATUS.getType((int)status)) {
            pgReplica.setStatus(status.intValue());
            this.updateProtectGroupReplica(pgReplica);
        }
    }

    private void updateProductSiteName(ProtectGroup protectGroup) {
        String siteServiceName = "DRM_Base/" + ISiteService.class.getName();
        ISiteService siteService = (ISiteService)ServiceContext.getInstance().lookup(siteServiceName);
        if (VerifyUtil.isEmpty((Object)siteService)) {
            logger.error((Object)"can't get siteService: serviceName=%s", new Object[]{siteServiceName});
            throw new LegoCheckedException(102410L, siteServiceName);
        }
        String productSiteName = "--";
        Site site = siteService.getSiteById(protectGroup.getProductSiteId());
        if (!VerifyUtil.isEmpty((Object)site)) {
            productSiteName = site.getName();
        }
        protectGroup.setProductSiteName(productSiteName);
    }

    public List<ProtectGroupReplica> queryProtectGroupReplicaByGroup(String groupId, String orderBy, boolean isAsc) {
        return this.queryProtectGroupReplicaByGroup(groupId, orderBy, isAsc, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProtectGroupReplica> queryReductionProtectGroupReplicaByGroup(String groupId, String orderBy, boolean isAsc) {
        Session session;
        List<ProtectGroupReplica> pgReplicas;
        block5: {
            if (VerifyUtil.isEmpty((String)groupId)) {
                logger.error((Object)"groupId empty", 90160758786989L);
                throw new LegoCheckedException(1073947393L);
            }
            pgReplicas = null;
            session = null;
            try {
                session = this.baseDao.getHibernateTemplate().getSessionFactory().openSession();
                pgReplicas = new ArrayList<ProtectGroupReplica>();
                StringBuilder querSQL = new StringBuilder();
                querSQL.append("select pgr.ID, pgr.NAME, pgr.TIME_STAMP, pgr.REPLICATYPE, pgr.REPLICASTATUS, pgr.REPLICAINDEX, pgr.RECSITEID,pgr.PROARRAYID, pgr.RECARRAYID, pgr.PROTECTLOCATION, pgr.PGID, pgr.MOUNTSTATUS, pgr.MOUNTEDHOST, pgr.GENERATION, pgr.ACCESSLEVEL, pgr.POREPLICAMATEDATA, pgr.DEADLINE_TIME_STAMP, pgr.REPLICA_ACTIVE_PERIOD, pgr.scheduleId, pg.POTYPE from ti_protectgroupreplica pgr, ti_protectgroup as pg where pgr.pgid=:pgId and pgr.pgid = pg.pgid");
                this.addOrder(querSQL, orderBy, isAsc);
                NativeQuery query = session.createSQLQuery(querSQL.toString());
                query.setString("pgId", groupId);
                List results = query.list();
                if (VerifyUtil.isEmpty((Collection)results)) break block5;
                pgReplicas = this.constructProtectGroupReplicas(results);
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("Failed to query replicas!" + ExceptionUtil.getErrorMessage((Throwable)e)));
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return pgReplicas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProtectGroupReplica> queryProtectGroupReplicaByGroup(String groupId, String orderBy, boolean isAsc, boolean needStorageIds) {
        Session session;
        List<ProtectGroupReplica> pgReplicas;
        block7: {
            if (VerifyUtil.isEmpty((String)groupId)) {
                logger.error((Object)"groupId empty", 90160758786989L);
                throw new LegoCheckedException(1073947393L);
            }
            pgReplicas = null;
            session = null;
            try {
                session = this.baseDao.getHibernateTemplate().getSessionFactory().openSession();
                pgReplicas = new ArrayList<ProtectGroupReplica>();
                StringBuilder querSQL = new StringBuilder();
                querSQL.append("select pgr.ID, pgr.NAME, pgr.TIME_STAMP, pgr.REPLICATYPE, pgr.REPLICASTATUS, pgr.REPLICAINDEX, pgr.RECSITEID,pgr.PROARRAYID, pgr.RECARRAYID, pgr.PROTECTLOCATION, pgr.PGID, pgr.MOUNTSTATUS, pgr.MOUNTEDHOST, pgr.GENERATION, pgr.ACCESSLEVEL, pgr.POREPLICAMATEDATA, pgr.DEADLINE_TIME_STAMP, pgr.REPLICA_ACTIVE_PERIOD, pgr.scheduleId, pg.POTYPE, pgr.DETECTIONSTATUS from ti_protectgroupreplica pgr, ti_protectgroup as pg where pgr.pgid=:pgId and pgr.pgid = pg.pgid");
                this.addOrder(querSQL, orderBy, isAsc);
                NativeQuery query = session.createSQLQuery(querSQL.toString());
                query.setString("pgId", groupId);
                List results = query.list();
                if (!VerifyUtil.isEmpty((Collection)results)) {
                    pgReplicas = this.constructProtectGroupReplicas(results);
                    this.setReplicaProps(pgReplicas);
                }
                if (!needStorageIds) break block7;
                for (ProtectGroupReplica pgr : pgReplicas) {
                    String storageIds = ReplicaUtil.getReplicaStorageIds((ProtectGroupReplica)pgr);
                    pgr.addProperty("StorageIds", storageIds);
                }
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("Failed to query replicas!" + ExceptionUtil.getErrorMessage((Throwable)e)));
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return pgReplicas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setReplicaProps(List<ProtectGroupReplica> pgReplicas) {
        if (VerifyUtil.isEmpty(pgReplicas)) {
            return;
        }
        ArrayList<String> replicaIdList = new ArrayList<String>();
        for (ProtectGroupReplica protectGroupReplica : pgReplicas) {
            replicaIdList.add(protectGroupReplica.getId());
        }
        HashMap<String, Map<String, String>> replicaPropMap = new HashMap<String, Map<String, String>>();
        Session session = null;
        try {
            session = this.baseDao.getHibernateTemplate().getSessionFactory().openSession();
            StringBuilder querSQL = new StringBuilder();
            querSQL.append("select ID,PROPNAME,PROPVALUE from ti_protectgroupreplica_prop");
            if (!VerifyUtil.isEmpty(replicaIdList)) {
                querSQL.append(" where ID in (");
                for (int i = 0; i < replicaIdList.size(); ++i) {
                    String poid = (String)replicaIdList.get(i);
                    querSQL.append("'" + StringEscapeUtil.escapeSql((String)poid) + "'");
                    if (i >= replicaIdList.size() - 1) continue;
                    querSQL.append(",");
                }
                querSQL.append(")");
            }
            NativeQuery query = session.createSQLQuery(querSQL.toString());
            List results = query.list();
            DrmStorageUtil.setPropMap(replicaPropMap, results);
        }
        catch (Exception e) {
            try {
                logger.error((Object)("Failed to query queryReplicaProps!" + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        for (ProtectGroupReplica protectGroupReplica : pgReplicas) {
            Map props = (Map)replicaPropMap.get(protectGroupReplica.getId());
            if (null == props) continue;
            protectGroupReplica.setProps(props);
            this.addSpeedEnabledToProp(protectGroupReplica);
        }
    }

    protected List<ProtectGroupReplica> constructProtectGroupReplicas(List<?> result) {
        ArrayList<ProtectGroupReplica> pgReplicas = new ArrayList<ProtectGroupReplica>();
        for (Object object : result) {
            Object[] values;
            if (!(object instanceof Object[]) || 21 != (values = (Object[])object).length) continue;
            ProtectGroupReplica pgReplica = new ProtectGroupReplica();
            pgReplica.setId(CommUtil.convertToString((Object)values[0]));
            pgReplica.setName(CommUtil.convertToString((Object)values[1]));
            pgReplica.setTimeStamp(CommUtil.convertToString((Object)values[2]));
            pgReplica.setType(CommUtil.convertToInteger((Object)values[3]).intValue());
            pgReplica.setStatus(CommUtil.convertToInteger((Object)values[4]).intValue());
            pgReplica.setIndex(CommUtil.convertToInteger((Object)values[5]).intValue());
            pgReplica.setRecoverySite(CommUtil.convertToString((Object)values[6]));
            pgReplica.setProductArray(CommUtil.convertToString((Object)values[7]));
            pgReplica.setRecoveryArray(CommUtil.convertToString((Object)values[8]));
            pgReplica.setProtectLocation(CommUtil.convertToInteger((Object)values[9]).intValue());
            pgReplica.setMountStatus(CommUtil.convertToInteger((Object)values[11]));
            pgReplica.setMountedHost(CommUtil.convertToString((Object)values[12]));
            pgReplica.setGeneration(CommUtil.convertToInteger((Object)values[13]));
            pgReplica.setAccessLevel(CommUtil.convertToInteger((Object)values[14]));
            pgReplica.setPoReplicaMateData(CommUtil.convertToString((Object)values[15]));
            pgReplica.setDeadlineTimeStamp(CommUtil.convertToString((Object)values[16]));
            pgReplica.setReplicaActivePeriod(CommUtil.convertToString((Object)values[17]));
            pgReplica.setScheduleId(CommUtil.convertToString((Object)values[18]));
            ProtectGroup pg = new ProtectGroup();
            pg.setPoType(CommUtil.convertToInteger((Object)values[19]).intValue());
            pgReplica.setPg(pg);
            pgReplica.setDetectionStatus(CommUtil.convertToInteger((Object)values[20]).intValue());
            pgReplicas.add(pgReplica);
        }
        return pgReplicas;
    }

    private void addOrder(StringBuilder hql, String field, boolean asc) {
        if (field != null && field.matches("\\w+")) {
            hql.append(" order by ").append(field).append(asc ? " asc" : " desc");
        }
    }

    private void addSpeedEnabledToProp(ProtectGroupReplica replica) {
        String deviceType = ((IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class)).getStorageType(replica.getStorageDeviceId());
        replica.getProps().put("speedEnabled", FusionStorageUnit.class.getName().equals(deviceType) ? "0" : "1");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateProtectGroupReplica(ProtectGroupReplica protectGroupReplica) {
        if (VerifyUtil.isEmpty((Object)protectGroupReplica)) {
            logger.warn((Object)"param:protectGroupReplica is empty!");
            return;
        }
        Session session = null;
        try {
            String sql = "update ti_protectgroupreplica set name=?,time_stamp=?,replicastatus=?,replicaindex=? WHERE ID=?";
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            session.beginTransaction();
            NativeQuery query = session.createSQLQuery(sql);
            query.setString(0, protectGroupReplica.getName());
            query.setParameter(1, (Object)protectGroupReplica.getTimeStamp());
            query.setInteger(2, protectGroupReplica.getStatus());
            query.setInteger(3, protectGroupReplica.getIndex());
            query.setString(4, protectGroupReplica.getId());
            int updateResult = query.executeUpdate();
            session.getTransaction().commit();
            if (1 != updateResult) {
                logger.error((Object)("Update protectGroupReplica failed!ptId(" + protectGroupReplica.getId() + ")"));
                throw new LegoCheckedException(-1L);
            }
        }
        catch (LegoCheckedException le) {
            try {
                DBOperationUtil.rollbackSession(session);
                logger.error((Object)("failed to update protectGroupReplica of ptId(" + protectGroupReplica.getId() + ")."), (Throwable)le);
                throw le;
                catch (Exception e) {
                    DBOperationUtil.rollbackSession(session);
                    logger.error((Object)("failed to update protectGroupReplica of ptId(" + protectGroupReplica.getId() + ")."), (Throwable)e);
                    throw new LegoCheckedException(-1L, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtectGroupReplica queryProtectGroupReplicaById(String replicaId) {
        Session session;
        ProtectGroupReplica replica;
        block7: {
            replica = null;
            if (VerifyUtil.isEmpty((String)replicaId)) {
                logger.error((Object)"getting ProtectGroupReplica is error because groupId is empty", 90160758786896L);
                return replica;
            }
            replica = SnapshotScheduleUtil.getProtectGroupReplica(replicaId);
            if (null != replica) {
                return replica;
            }
            session = null;
            try {
                boolean isVasa;
                Iterator iterator;
                session = this.baseDao.getHibernateTemplate().getSessionFactory().openSession();
                Criteria criteria = session.createCriteria(ProtectGroupReplica.class);
                criteria.add((Criterion)Restrictions.eq((String)"id", (Object)replicaId));
                List queryResult = criteria.list();
                if (!VerifyUtil.isEmpty((Collection)queryResult) && (iterator = queryResult.iterator()).hasNext()) {
                    ProtectGroupReplica pgReplica = (ProtectGroupReplica)iterator.next();
                    Hibernate.initialize((Object)pgReplica.getReplicas());
                    replica = pgReplica;
                }
                if (!(isVasa = LegoConfig.getInstance().getBoolean("VASA", Boolean.valueOf(false)).booleanValue())) break block7;
                String storageIds = ReplicaUtil.getReplicaStorageIds((ProtectGroupReplica)replica);
                replica.addProperty("StorageIds", storageIds);
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("Failed to query replica!" + ExceptionUtil.getErrorMessage((Throwable)e)));
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return replica;
    }

    public void deleteProtectGroupReplicaById(String replicaId) {
        ProtectGroupReplica replica = new ProtectGroupReplica();
        replica.setId(replicaId);
        this.deleteProtectGroupReplicaFromDBById(Stream.of(replica).collect(Collectors.toList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> deleteProtectGroupReplicaFromDBById(List<ProtectGroupReplica> replicas) {
        Session session;
        ArrayList<String> failReplicaIds;
        block5: {
            failReplicaIds = new ArrayList<String>();
            List replicaIds = replicas.stream().map(r -> r.getId()).collect(Collectors.toList());
            if (VerifyUtil.isEmpty(replicas)) {
                logger.error((Object)"replicaIds is empty");
                return null;
            }
            session = null;
            Transaction transation = null;
            try {
                session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                if (null == session) break block5;
                transation = session.beginTransaction();
                Query hql = session.createQuery("delete ProtectGroupReplica a where a.id in (:id) ");
                hql.setParameterList("id", replicaIds);
                hql.executeUpdate();
                transation.commit();
            }
            catch (Exception e) {
                try {
                    DBOperationUtil.rollbackSession(session);
                    failReplicaIds.addAll(replicaIds);
                    logger.error((Object)("delete new replica error," + ExceptionUtil.getErrorMessage((Throwable)e)));
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return failReplicaIds;
    }

    public List<ProtectObject> getProtectObjectListByReplicaId(String replicaId) {
        ProtectGroupReplica replica = this.queryProtectGroupReplicaById(replicaId);
        if (null == replica) {
            logger.error((Object)("the replica is not exist, replicaId: " + replicaId));
            throw new LegoCheckedException(205L);
        }
        Set poReplicaSet = replica.getReplicas();
        if (null == poReplicaSet) {
            logger.error((Object)("the poReplicaSet is not exist, replicaId: " + replicaId));
            throw new LegoCheckedException(205L);
        }
        ArrayList<ProtectObject> result = new ArrayList<ProtectObject>();
        for (ProtectObjectReplica poReplica : poReplicaSet) {
            ProtectObject po = poReplica.getProtectObject();
            if (null == po) {
                po = this.findProtectObject(poReplica.getPgReplica().getPg(), poReplica.getPoId());
            }
            if (null == po) continue;
            result.add(po);
        }
        return result;
    }

    private ProtectObject findProtectObject(ProtectGroup pg, String poId) {
        for (ProtectObject po : pg.getPolist()) {
            if (!po.getUuid().equals(poId)) continue;
            return po;
        }
        ProtectObject protectObject = new ProtectObject();
        protectObject.setName("--");
        protectObject.setUuid(poId);
        protectObject.setPoType(pg.getPoType());
        protectObject.setProtectGroup(pg);
        return protectObject;
    }

    public void saveOrUpdateReplica(final ProtectGroupReplica replica) {
        TransactionCallback transactionCallback = new TransactionCallback(){

            public Object doInTransaction(TransactionStatus tstatus) {
                try {
                    CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)replica);
                }
                catch (Exception e) {
                    if (null != tstatus) {
                        tstatus.setRollbackOnly();
                    }
                    logger.error((Object)("save or update replica error,replica name: " + replica.getName() + "and message is " + ExceptionUtil.getErrorMessage((Throwable)e)));
                }
                return null;
            }
        };
        CommonDAOLocator.getBaseDao().getTransactionTemplate().execute(transactionCallback);
    }

    public void mountReplica(User user, String protectGroupId, String replicaId, String mountConfigs) {
        MountConfiguration mountConfiguration = (MountConfiguration)JSONObject.toBean((String)mountConfigs, MountConfiguration.class);
        if (VerifyUtil.isEmpty((Object)mountConfiguration)) {
            logger.error((Object)"the mountConfiguration is null");
            throw new LegoCheckedException(1073947394L);
        }
        ProtectGroupReplica srcReplica = this.getProtectGroupReplica(protectGroupId, replicaId);
        this.verifyReplica(srcReplica);
        srcReplica.addProperty("mountConfigs", mountConfigs);
        String mountHost = mountConfiguration.getHostOrGroupSn();
        if (VerifyUtil.isEmpty((String)mountHost)) {
            logger.error((Object)"mountHost is null");
            throw new LegoCheckedException(1073947393L);
        }
        int replicaType = srcReplica.getType();
        int configTargetReplicaType = mountConfiguration.getTargetReplicaType();
        if (configTargetReplicaType != -1 && 101 != replicaType) {
            if (configTargetReplicaType == 5) {
                String errorMsg = "Clone replica is not supported in the current version";
                logger.error((Object)errorMsg);
                throw new LegoCheckedException(1073947393L, errorMsg);
            }
            CloneReplicaTask task = new CloneReplicaTask(user, srcReplica, true, mountConfiguration);
            MountBackTaskHandler.getInstance().submitTask(task);
        } else {
            if (Integer.valueOf(ReplicaMountStatus.MOUNTED.getStatus()).equals(srcReplica.getMountStatus()) || Integer.valueOf(ReplicaMountStatus.UMOUNT_FAILED.getStatus()).equals(srcReplica.getMountStatus())) {
                logger.error((Object)("srcReplica is not valid: " + srcReplica.getId()));
                throw new LegoCheckedException(1073948693L);
            }
            if (srcReplica.isStorageSnapshotReplica() && !Integer.valueOf(2).equals(srcReplica.getGeneration())) {
                logger.error((Object)"not second generation copy");
                long errorCode = 1073948254L;
                throw new LegoCheckedException(errorCode);
            }
            CreateMountReplicaPlanTask task = new CreateMountReplicaPlanTask(srcReplica, mountHost, user, mountConfiguration);
            MountBackTaskHandler.getInstance().submitTask(task);
        }
    }

    public void unmountReplica(User user, String protectGroupId, String replicaId, boolean deleteReplica) {
        ProtectGroupReplica srcReplica = this.getProtectGroupReplica(protectGroupId, replicaId);
        if (!(Integer.valueOf(ReplicaMountStatus.MOUNTED.getStatus()).equals(srcReplica.getMountStatus()) || Integer.valueOf(ReplicaMountStatus.UMOUNT_FAILED.getStatus()).equals(srcReplica.getMountStatus()) || Integer.valueOf(ReplicaMountStatus.MOUNT_FAILED.getStatus()).equals(srcReplica.getMountStatus()))) {
            logger.error((Object)"srcReplica is not valid. replicaId:[%s], status:[%s]", new Object[]{srcReplica.getId(), srcReplica.getMountStatus()});
            throw new LegoCheckedException(1073948693L);
        }
        UmountReplicaTask task = new UmountReplicaTask(srcReplica, user, deleteReplica);
        BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
    }

    public long cloneReplica(User user, String protectGroupId, String replicaId, boolean isNeedMount, String mountConfigs) {
        MountConfiguration mountConfiguration = null;
        if (isNeedMount) {
            mountConfiguration = (MountConfiguration)JSONObject.toBean((String)mountConfigs, MountConfiguration.class);
        }
        ProtectGroupReplica srcReplica = this.getProtectGroupReplica(protectGroupId, replicaId);
        this.verifyReplica(srcReplica);
        CloneReplicaTask task = new CloneReplicaTask(user, srcReplica, isNeedMount, mountConfiguration);
        return MountBackTaskHandler.getInstance().submitTask(task);
    }

    public long deleteProtectGroupReplicaById(User user, String protectGroupId, String replicaId) {
        RecoveryPlan plan;
        ProtectGroupReplica deleteReplica = this.getProtectGroupReplica(protectGroupId, replicaId);
        if (deleteReplica.isBackUpReplica()) {
            return -1L;
        }
        if (!Integer.valueOf(2).equals(deleteReplica.getGeneration())) {
            logger.error((Object)"not second generation copy");
            throw new LegoCheckedException(1073948254L);
        }
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(ReplicaMountStatus.MOUNTED.getStatus());
        set.add(ReplicaMountStatus.MOUNT_FAILED.getStatus());
        set.add(ReplicaMountStatus.MOUNT_FAILED.getStatus());
        set.add(ReplicaMountStatus.MOUNTING.getStatus());
        set.add(ReplicaMountStatus.UMOUNTING.getStatus());
        if (set.contains(deleteReplica.getMountStatus())) {
            logger.error((Object)("The current status is not allowed." + deleteReplica.getMountStatus()));
            throw new LegoCheckedException(1073948693L);
        }
        ProtectGroup pg = (ProtectGroup)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ProtectGroup.class, (Serializable)((Object)protectGroupId));
        String planId = deleteReplica.getProperty("planId");
        IRecoveryPlanService rpService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        if (!VerifyUtil.isEmpty((String)planId) && null != (plan = rpService.getRecoveryPlan(planId, false, false))) {
            logger.error((Object)"The current status is used by MountPlan.");
            throw new LegoCheckedException(1073947476L, new String[]{plan.getName()});
        }
        ArrayList<ProtectGroupReplica> toDelete = new ArrayList<ProtectGroupReplica>();
        toDelete.add(deleteReplica);
        DeleteReplicaTask task = new DeleteReplicaTask(user, pg, toDelete);
        return MountBackTaskHandler.getInstance().submitTask(task);
    }

    public List<ProtectGroupReplica> querySecondProtectGroupReplica(String protectGroupId, Schedule schedule, Integer pageNum, Integer pageSize, Long startTime, Long endTime) {
        logger.debug((Object)("start querySecondProtectGroupReplica for:" + protectGroupId));
        ProtectGroup protectGroup = QueryProtectGroupRefineService.getInstance().getProtectGroupByID(protectGroupId, true);
        ArrayList<ProtectGroupReplica> replicas = new ArrayList<ProtectGroupReplica>();
        Set protectObjectList = protectGroup.getPolist();
        if (null == protectObjectList || protectObjectList.isEmpty()) {
            return replicas;
        }
        IReplicaBuilder builder = this.replicaBuilderFactory.getTemplateByType(protectGroup.getTemplate().getType());
        Map devSns = builder.getProtectedDeviceSn(protectGroup);
        if (!SnapshotScheduleUtil.isExistsSecondSchedule(schedule)) {
            return replicas;
        }
        String devSn = (String)devSns.get(schedule.getProtectLocation());
        IStorageSnapshotScheduleManager scheduleManager = StorageSnapshotScheduleManagerProxy.getInstance().getStorageSnapshotMgrByDevId(devSn, schedule.getProtectedType());
        HashMap<String, String> conditions = new HashMap<String, String>();
        conditions.put("pageNum", String.valueOf(pageNum));
        conditions.put("pageSize", String.valueOf(pageSize));
        conditions.put("startTime", String.valueOf(startTime));
        conditions.put("endTime", String.valueOf(endTime));
        replicas.addAll(scheduleManager.getProtectGroupReplica(protectGroup, devSn, schedule, conditions));
        for (ProtectGroupReplica replica : replicas) {
            replica.addProperty("isSecond", "true");
            SnapshotScheduleUtil.putProtectGroupReplica(replica);
        }
        logger.debug((Object)"end querySecondProtectGroupReplica for: %s, replicas' size is %d.", new Object[]{protectGroupId, replicas.size()});
        return replicas;
    }

    public List<ProtectLocationPath> getProtectLocationPath(ProtectGroup pg) {
        List<ProtectLocationPath> results = new ArrayList<ProtectLocationPath>();
        if (2 == pg.getTemplate().getType()) {
            ProtectLocationPath path = new ProtectLocationPath();
            path.setProtectLocation(DrmEnumDefine.PROTECT_LOCATION.PL_A.getValue());
            path.setProtectedSiteId(pg.getProductSiteId());
            results.add(path);
        } else if (19 == pg.getTemplate().getType()) {
            results = this.getHyperMetroSnapShotPath(pg, results);
        } else if (PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE.contains(pg.getTemplate().getType())) {
            ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
            ProtectGroupReplica replica = pg.getAnyoneReplicationReplica();
            if (replica == null) {
                logger.error((Object)"can't get replica from protect group: pgId=%s", new Object[]{pg.getUuid()});
                return results;
            }
            ProtectLocationPath locationPath = new ProtectLocationPath();
            String localDevSn = replica.getProductArray();
            locationPath.setProtectLocation(DrmEnumDefine.PROTECT_LOCATION.PL_A.getValue());
            String localSiteId = siteService.getSiteByDeviceSn(localDevSn).getSiteId();
            locationPath.setProtectedSiteId(localSiteId);
            results.add(locationPath);
            ProtectLocationPath remotePath = new ProtectLocationPath();
            String remoteDevSn = replica.getRecoveryArray();
            remotePath.setProtectLocation(DrmEnumDefine.PROTECT_LOCATION.PL_A_B.getValue());
            String remoteSiteId = siteService.getSiteByDeviceSn(remoteDevSn).getSiteId();
            remotePath.setProtectedSiteId(remoteSiteId);
            results.add(remotePath);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dealMisreport(String protectGroupId, String replicaId) {
        logger.info((Object)"Lock replica(id: %s) for misreport deal.", new Object[]{replicaId});
        String lockKey = replicaId + "AntiBlackmailSnapshotReplica";
        if (!AntiBlackmailResourceLockUtil.tryLock(lockKey)) {
            logger.info((Object)"Replica is using by other program, replica id: %s.", new Object[]{replicaId});
            throw new LegoCheckedException(1677929494L, new String[]{replicaId});
        }
        try {
            ProtectGroup protectGroup = this.checkProtectGroupExists(protectGroupId);
            ProtectGroupReplica replica = this.checkMisreportDealParam(protectGroup, protectGroupId, replicaId);
            int detectionStatus = replica.getDetectionStatus();
            if (detectionStatus != AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum.PARTIALLY_INFECTED.getValue() && detectionStatus != AntiBlackMailEnumDefine.ReplicaDetectionStatusEnum.ALL_INFECTED.getValue()) {
                logger.error((Object)"The status of replica does not support current operation, status: %s, replica name: %s", new Object[]{detectionStatus, replica.getName()});
                throw new LegoCheckedException(1073947393L);
            }
            AntiBlackmailUtil.dealMisreportSnapshot(protectGroup, replica);
        }
        catch (Throwable throwable) {
            logger.info((Object)"Unlock replica(id: %s) for misreport deal.", new Object[]{replicaId});
            AntiBlackmailResourceLockUtil.unlockRes(lockKey);
            throw throwable;
        }
        logger.info((Object)"Unlock replica(id: %s) for misreport deal.", new Object[]{replicaId});
        AntiBlackmailResourceLockUtil.unlockRes(lockKey);
    }

    public BatchOperationResult deleteProtectGroupReplicas(String protectGroupId, Set<String> replicaIds) {
        if (replicaIds.size() > 50) {
            logger.error((Object)"Too many replicas to be delete, protectGroupId: %s", new Object[]{protectGroupId});
            throw new LegoCheckedException(1073948520L, new String[]{String.valueOf(50)});
        }
        List<ProtectGroupReplica> replicas = this.queryProtectGroupReplicaByGroup(protectGroupId, "TIME_STAMP", false, true);
        ProtectGroupReplica firstUninfectedReplica = AntiBlackmailUtil.findFirstUninfectedReplica(replicas);
        ProtectGroup pg = QueryProtectGroupRefineService.getInstance().getProtectGroupByID(protectGroupId, false);
        String devSn = pg.getPoProviderSN();
        return this.getBatchOperationResult(replicaIds, firstUninfectedReplica, devSn);
    }

    private BatchOperationResult getBatchOperationResult(Set<String> replicaIds, ProtectGroupReplica firstUninfectedReplica, String devSn) {
        long start = System.currentTimeMillis();
        logger.info((Object)"Start to send delete replica task, start time: %s", new Object[]{TimeUtil.toLocalString((long)start)});
        ArrayList<DeleteAntiBlackmailReplicaTask> tasks = new ArrayList<DeleteAntiBlackmailReplicaTask>();
        for (String replicaId : replicaIds) {
            tasks.add(new DeleteAntiBlackmailReplicaTask(replicaId, devSn, firstUninfectedReplica));
        }
        List resultList = ExecutionService.batchSubmit(tasks, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_CONTINUE, (int)0, (int)20);
        BatchOperationResult result = new BatchOperationResult();
        long end = System.currentTimeMillis();
        logger.info((Object)"End to send delete replica task, end time: %s, total cost: %sS", new Object[]{TimeUtil.toLocalString((long)end), String.valueOf((end - start) / 1000L)});
        this.dealResult(result, resultList);
        return result;
    }

    private void dealResult(BatchOperationResult result, List<BatchOperationResult> resultList) {
        if (resultList.size() == 0) {
            return;
        }
        for (BatchOperationResult partResult : resultList) {
            result.getResult().addAll(partResult.getResult());
            result.setFailCount(result.getFailCount() + partResult.getFailCount());
            result.setTotalCount(result.getTotalCount() + partResult.getTotalCount());
            result.setSucceedCount(result.getSucceedCount() + partResult.getSucceedCount());
        }
    }

    private List<ProtectLocationPath> getHyperMetroSnapShotPath(ProtectGroup pg, List<ProtectLocationPath> results) {
        for (Schedule schdule : pg.getTemplate().getSchedules()) {
            ProtectLocationPath path = new ProtectLocationPath();
            path.setProtectLocation(schdule.getProtectLocation());
            path.setProtectedSiteId(schdule.getSourceSiteId());
            results.add(path);
        }
        return results;
    }

    public Integer querySecondProtectGroupReplicaCount(String protectGroupId, Schedule schedule, Long startTime, Long endTime) {
        logger.debug((Object)("start querySecondProtectGroupReplica for:" + protectGroupId));
        Integer totalCount = 0;
        ProtectGroup protectGroup = QueryProtectGroupRefineService.getInstance().getProtectGroupByID(protectGroupId, true);
        IReplicaBuilder builder = this.replicaBuilderFactory.getTemplateByType(protectGroup.getTemplate().getType());
        if (!SnapshotScheduleUtil.isExistsSecondSchedule(schedule)) {
            return totalCount;
        }
        Map devSns = builder.getProtectedDeviceSn(protectGroup);
        String devSn = (String)devSns.get(schedule.getProtectLocation());
        IStorageSnapshotScheduleManager scheduleManager = StorageSnapshotScheduleManagerProxy.getInstance().getStorageSnapshotMgrByDevId(devSn, schedule.getProtectedType());
        HashMap<String, String> conditions = new HashMap<String, String>();
        conditions.put("startTime", String.valueOf(startTime));
        conditions.put("endTime", String.valueOf(endTime));
        totalCount = scheduleManager.getProtectGroupReplicaCount(protectGroup, devSn, conditions);
        return totalCount;
    }

    public String getDeviceId(ProtectGroupReplica replica) {
        return replica.getStorageDeviceId();
    }

    private void verifyReplica(ProtectGroupReplica srcReplica) {
        if (1 != srcReplica.getStatus()) {
            logger.error((Object)("srcReplica is not valid: " + srcReplica.getId()));
            throw new LegoCheckedException(1073948459L);
        }
        ReplicaFactoryManager manager = ReplicaFactoryManager.getInstance();
        IReplicaFactory factory = manager.getReplicaFactory(srcReplica.getType());
        if (!factory.validReplica(srcReplica, true)) {
            logger.error((Object)("srcReplica is not valid: " + srcReplica.getId()));
            throw new LegoCheckedException(1073948459L);
        }
    }

    private ProtectGroupReplica getProtectGroupReplica(String protectGroupId, String replicaId) {
        ProtectGroupReplica srcReplica = this.queryProtectGroupReplicaById(replicaId);
        if (VerifyUtil.isEmpty((Object)srcReplica)) {
            srcReplica = SnapshotScheduleUtil.getProtectGroupReplica(replicaId);
        }
        if (null == srcReplica) {
            String errorMsg = "The replica[%s] of protect group[%s] is not exists!";
            errorMsg = String.format(errorMsg, replicaId, protectGroupId);
            logger.error((Object)errorMsg);
            throw new LegoCheckedException(1073947394L, errorMsg);
        }
        if (null == srcReplica.getPg() || !protectGroupId.equals(srcReplica.getPg().getUuid())) {
            String errorMsg = "The input protect group Id[%s] parameter is not the group id in replica[%s]";
            errorMsg = String.format(errorMsg, protectGroupId, replicaId);
            logger.error((Object)errorMsg);
            throw new LegoCheckedException(1073947393L, errorMsg);
        }
        return srcReplica;
    }

    private ProtectGroup checkProtectGroupExists(String protectGroupId) {
        ProtectGroup protectGroup = QueryProtectGroupRefineService.getInstance().getProtectGroupByID(protectGroupId, true);
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            logger.error((Object)"There is no protect group with id: %s.", new Object[]{protectGroupId});
            throw new LegoCheckedException(2117645L);
        }
        return protectGroup;
    }

    private ProtectGroupReplica checkMisreportDealParam(ProtectGroup protectGroup, String protectGroupId, String replicaId) {
        if (protectGroup.getTemplate().getType() != 46) {
            logger.error((Object)"The policy template of protect group(name: %s) is not meet.", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroupReplica replica = this.getProtectGroupReplica(protectGroupId, replicaId);
        if (VerifyUtil.isEmpty((Object)replica)) {
            logger.error((Object)"Replica with id(%s) is not found in protect group(name: %s).", new Object[]{replicaId, protectGroup.getName()});
            throw new LegoCheckedException(2117645L);
        }
        if (!replica.isStorageSnapshotReplica()) {
            logger.error((Object)"Replica(name: %s) is not a snapshot replica.", new Object[]{replica.getName()});
            throw new LegoCheckedException(1073947393L);
        }
        return replica;
    }
}

